/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import java.util.ArrayList;
import java.util.List;

class CurveFit {
    private static final int MAXPOINTS = 1000;

    CurveFit() {
    }

    static void fitCurve(ASCoordinate[] d, int nPts, double error, List<ASCoordinate> bez) {
        ASCoordinate tHat1 = CurveFit.computeLeftTangent(d, 0);
        ASCoordinate tHat2 = CurveFit.computeRightTangent(d, nPts - 1);
        if (d != null && nPts >= 0) {
            CurveFit.fitCubic(d, 0, nPts - 1, tHat1, tHat2, error, bez);
        }
    }

    private static double computeMaxError(ASCoordinate[] d, int first, int last, List<ASCoordinate> bezCurve, double[] u, int[] splitPoint) {
        splitPoint[0] = (last - first + 1) / 2;
        double maxDist = 0.0;
        for (int i = first + 1; i < last; ++i) {
            ASCoordinate P = CurveFit.evaluateBezier(3, bezCurve, u[i - first]);
            ASCoordinate v = CurveFit.v2SubII(P, d[i]);
            double dist = v.x() * v.x() + v.y() * v.y();
            if (!(dist >= maxDist)) continue;
            maxDist = dist;
            splitPoint[0] = i;
        }
        return maxDist;
    }

    private static ASCoordinate evaluateBezier(int degree, List<ASCoordinate> V, double t) {
        int i;
        ASCoordinate[] Vtemp = new ASCoordinate[degree + 1];
        for (i = 0; i <= degree; ++i) {
            Vtemp[i] = V.get(i);
        }
        for (i = 1; i <= degree; ++i) {
            for (int j = 0; j <= degree - i; ++j) {
                Vtemp[j] = new ASCoordinate((1.0 - t) * Vtemp[j].x() + t * Vtemp[j + 1].x(), (1.0 - t) * Vtemp[j].y() + t * Vtemp[j + 1].y());
            }
        }
        ASCoordinate Q = Vtemp[0];
        return Q;
    }

    private static void fitCubic(ASCoordinate[] d, int first, int last, ASCoordinate tHat1, ASCoordinate tHat2, double error, List<ASCoordinate> bez) {
        List<ASCoordinate> bezCurve = bez;
        int[] splitPoint = new int[1];
        int maxIterations = 4;
        double iterationError = error * error;
        int nPts = last - first + 1;
        if (nPts == 2) {
            double dist = d[first].distanceTo(d[last]) / 3.0;
            CurveFit.addToBezierCurve(bezCurve, d, first, last, tHat1, tHat2, dist, dist);
            return;
        }
        double[] u = CurveFit.chordLengthParameterize(d, first, last);
        CurveFit.generateBezier(d, first, last, u, tHat1, tHat2, bezCurve);
        double maxError = CurveFit.computeMaxError(d, first, last, bezCurve, u, splitPoint);
        if (maxError < error) {
            return;
        }
        if (maxError < iterationError) {
            for (int i = 0; i < maxIterations; ++i) {
                double[] uPrime = CurveFit.reparameterize(d, first, last, u, bezCurve);
                bezCurve.clear();
                CurveFit.generateBezier(d, first, last, uPrime, tHat1, tHat2, bezCurve);
                maxError = CurveFit.computeMaxError(d, first, last, bezCurve, uPrime, splitPoint);
                if (maxError < error) {
                    return;
                }
                u = uPrime;
            }
        }
        bezCurve.clear();
        ASCoordinate tHatCenter = CurveFit.computeCenterTangent(d, splitPoint[0]);
        ArrayList<ASCoordinate> subBezierCurve = new ArrayList<ASCoordinate>();
        CurveFit.fitCubic(d, first, splitPoint[0], tHat1, tHatCenter, error, subBezierCurve);
        bezCurve.addAll(subBezierCurve);
        subBezierCurve.clear();
        tHatCenter = CurveFit.v2Negate(tHatCenter);
        CurveFit.fitCubic(d, splitPoint[0], last, tHatCenter, tHat2, error, subBezierCurve);
        bezCurve.addAll(subBezierCurve);
    }

    private static ASCoordinate computeCenterTangent(ASCoordinate[] d, int center) {
        ASCoordinate V12 = CurveFit.v2SubII(d[center - 1], d[center]);
        ASCoordinate V22 = CurveFit.v2SubII(d[center], d[center + 1]);
        ASCoordinate tHatCenter = new ASCoordinate((V12.x() + V22.x()) / 2.0, (V12.y() + V22.y()) / 2.0);
        tHatCenter = CurveFit.v2Normalize(tHatCenter);
        return tHatCenter;
    }

    private static double[] reparameterize(ASCoordinate[] d, int first, int last, double[] u, List<ASCoordinate> bezCurve) {
        int nPts = last - first + 1;
        double[] uPrime = new double[nPts];
        for (int i = first; i <= last; ++i) {
            uPrime[i - first] = CurveFit.newtonRaphsonRootFind(bezCurve, d[i], u[i - first]);
        }
        return uPrime;
    }

    private static double newtonRaphsonRootFind(List<ASCoordinate> Q, ASCoordinate P, double u) {
        int i;
        ArrayList<ASCoordinate> Q1 = new ArrayList<ASCoordinate>();
        ArrayList<ASCoordinate> Q2 = new ArrayList<ASCoordinate>();
        ASCoordinate Q_u = CurveFit.evaluateBezier(3, Q, u);
        for (i = 0; i <= 2; ++i) {
            Q1.add(new ASCoordinate((Q.get(i + 1).x() - Q.get(i).x()) * 3.0, (Q.get(i + 1).y() - Q.get(i).y()) * 3.0));
        }
        for (i = 0; i <= 1; ++i) {
            Q2.add(new ASCoordinate((((ASCoordinate)Q1.get(i + 1)).x() - ((ASCoordinate)Q1.get(i)).x()) * 2.0, (((ASCoordinate)Q1.get(i + 1)).y() - ((ASCoordinate)Q1.get(i)).y()) * 2.0));
        }
        ASCoordinate Q1_u = CurveFit.evaluateBezier(2, Q1, u);
        ASCoordinate Q2_u = CurveFit.evaluateBezier(1, Q2, u);
        double numerator = (Q_u.x() - P.x()) * Q1_u.x() + (Q_u.y() - P.y()) * Q1_u.y();
        double denominator = Q1_u.x() * Q1_u.x() + Q1_u.y() * Q1_u.y() + (Q_u.x() - P.x()) * Q2_u.x() + (Q_u.y() - P.y()) * Q2_u.y();
        double uPrime = u - numerator / denominator;
        return uPrime;
    }

    private static double B0(double u) {
        double tmp = 1.0 - u;
        return tmp * tmp * tmp;
    }

    private static double B1(double u) {
        double tmp = 1.0 - u;
        return 3.0 * u * tmp * tmp;
    }

    private static double B2(double u) {
        double tmp = 1.0 - u;
        return 3.0 * u * u * tmp;
    }

    private static double B3(double u) {
        return u * u * u;
    }

    private static void generateBezier(ASCoordinate[] d, int first, int last, double[] uPrime, ASCoordinate tHat1, ASCoordinate tHat2, List<ASCoordinate> bezCurve) {
        double alpha_r;
        double alpha_l;
        int i;
        ASCoordinate[][] A = new ASCoordinate[1000][2];
        double[][] C = new double[2][2];
        double[] X = new double[2];
        int nPts = last - first + 1;
        for (i = 0; i < nPts; ++i) {
            ASCoordinate v1 = tHat1;
            ASCoordinate v2 = tHat2;
            v1 = CurveFit.v2Scale(v1, CurveFit.B1(uPrime[i]));
            v2 = CurveFit.v2Scale(v2, CurveFit.B2(uPrime[i]));
            A[i][0] = v1;
            A[i][1] = v2;
        }
        C[0][0] = 0.0;
        C[0][1] = 0.0;
        C[1][0] = 0.0;
        C[1][1] = 0.0;
        X[0] = 0.0;
        X[1] = 0.0;
        for (i = 0; i < nPts; ++i) {
            double[] dArray = C[0];
            dArray[0] = dArray[0] + CurveFit.v2Dot(A[i][0], A[i][0]);
            double[] dArray2 = C[0];
            dArray2[1] = dArray2[1] + CurveFit.v2Dot(A[i][0], A[i][1]);
            C[1][0] = C[0][1];
            double[] dArray3 = C[1];
            dArray3[1] = dArray3[1] + CurveFit.v2Dot(A[i][1], A[i][1]);
            ASCoordinate tmp = CurveFit.v2SubII(d[first + i], CurveFit.v2AddII(CurveFit.v2ScaleII(d[first], CurveFit.B0(uPrime[i])), CurveFit.v2AddII(CurveFit.v2ScaleII(d[first], CurveFit.B1(uPrime[i])), CurveFit.v2AddII(CurveFit.v2ScaleII(d[last], CurveFit.B2(uPrime[i])), CurveFit.v2ScaleII(d[last], CurveFit.B3(uPrime[i]))))));
            X[0] = X[0] + CurveFit.v2Dot(A[i][0], tmp);
            X[1] = X[1] + CurveFit.v2Dot(A[i][1], tmp);
        }
        double det_C0_C1 = C[0][0] * C[1][1] - C[1][0] * C[0][1];
        double det_C0_X = C[0][0] * X[1] - C[0][1] * X[0];
        double det_X_C1 = X[0] * C[1][1] - X[1] * C[0][1];
        if (det_C0_C1 == 0.0) {
            det_C0_C1 = C[0][0] * C[1][1] * 1.0E-11;
        }
        if (det_C0_C1 == 0.0) {
            alpha_l = 0.0;
            alpha_r = 0.0;
        } else {
            alpha_l = det_X_C1 / det_C0_C1;
            alpha_r = det_C0_X / det_C0_C1;
        }
        if (alpha_l > 20.0 || alpha_r > 20.0) {
            double dist = d[first].distanceTo(d[last]) / 3.0;
            CurveFit.addToBezierCurve(bezCurve, d, first, last, tHat1, tHat2, dist, dist);
            return;
        }
        if (alpha_l < 0.0 || alpha_r < 0.0) {
            double dist = d[first].distanceTo(d[last]) / 3.0;
            CurveFit.addToBezierCurve(bezCurve, d, first, last, tHat1, tHat2, dist, dist);
            return;
        }
        CurveFit.addToBezierCurve(bezCurve, d, first, last, tHat1, tHat2, alpha_l, alpha_r);
    }

    private static void addToBezierCurve(List<ASCoordinate> bezCurve, ASCoordinate[] d, int first, int last, ASCoordinate tHat1, ASCoordinate tHat2, double dist1, double dist2) {
        ASCoordinate tHat1Scaled = CurveFit.v2Scale(tHat1, dist1);
        ASCoordinate tHat2Scaled = CurveFit.v2Scale(tHat2, dist2);
        bezCurve.add(d[first]);
        bezCurve.add(new ASCoordinate(d[first].x() + tHat1Scaled.x(), d[first].y() + tHat1Scaled.y()));
        bezCurve.add(new ASCoordinate(d[last].x() + tHat2Scaled.x(), d[last].y() + tHat2Scaled.y()));
        bezCurve.add(d[last]);
    }

    private static double[] chordLengthParameterize(ASCoordinate[] d, int first, int last) {
        int i;
        double[] u = new double[last - first + 1];
        u[0] = 0.0;
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first - 1] + d[i].distanceTo(d[i - 1]);
        }
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first] / u[last - first];
        }
        return u;
    }

    private static ASCoordinate computeLeftTangent(ASCoordinate[] d, int end) {
        ASCoordinate tHat1 = CurveFit.v2SubII(d[end + 1], d[end]);
        tHat1 = CurveFit.v2Normalize(tHat1);
        return tHat1;
    }

    private static ASCoordinate computeRightTangent(ASCoordinate[] d, int end) {
        ASCoordinate tHat2 = CurveFit.v2SubII(d[end - 1], d[end]);
        tHat2 = CurveFit.v2Normalize(tHat2);
        return tHat2;
    }

    private static ASCoordinate v2Negate(ASCoordinate a) {
        return new ASCoordinate(-a.x(), -a.y());
    }

    private static double v2Dot(ASCoordinate a, ASCoordinate b) {
        return a.x() * b.x() + a.y() * b.y();
    }

    private static ASCoordinate v2ScaleII(ASCoordinate a, double s) {
        return new ASCoordinate(a.x() * s, a.y() * s);
    }

    private static ASCoordinate v2AddII(ASCoordinate a, ASCoordinate b) {
        return new ASCoordinate(a.x() + b.x(), a.y() + b.y());
    }

    private static ASCoordinate v2Scale(ASCoordinate a, double newlen) {
        double len = CurveFit.v2Length(a);
        if (len != 0.0) {
            return new ASCoordinate(a.x() * newlen / len, a.y() * newlen / len);
        }
        return a;
    }

    private static ASCoordinate v2SubII(ASCoordinate a, ASCoordinate b) {
        return new ASCoordinate(a.x() - b.x(), a.y() - b.y());
    }

    private static ASCoordinate v2Normalize(ASCoordinate a) {
        double len = CurveFit.v2Length(a);
        if (len != 0.0) {
            return new ASCoordinate(a.x() / len, a.y() / len);
        }
        return a;
    }

    private static double v2Length(ASCoordinate a) {
        return Math.sqrt(a.x() * a.x() + a.y() * a.y());
    }
}

