/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFVertices;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.CloudUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PolygonAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationPolygon> {
    PolygonAnnotApGenerator() {
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationPolygon annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix(fm.geta(), fm.getb(), fm.getc(), fm.getd(), fm.getx(), fm.gety()));
        }
        this.writer.writeGraphicsInfo(annot, true, annot.getColor(), annot.getInteriorColor(), annot.getOpacity(), null);
        PDFBorderEffects borderEffects = annot.getBorderEffects();
        PDFVertices v = annot.getVertices();
        if (v.size() >= 2) {
            ASName style;
            double cloudIntensity = borderEffects != null ? borderEffects.getIntensity() : 0.0;
            ASName aSName = style = borderEffects != null ? borderEffects.getStyle() : ASName.k_S;
            if (style == ASName.k_C && cloudIntensity > 0.0) {
                ArrayList<ASCoordinate> fpVector = new ArrayList<ASCoordinate>();
                for (int i = 0; i < v.size(); i += 2) {
                    fpVector.add(new ASCoordinate(((PDFCosNumeric)v.get(i)).doubleValue(), ((PDFCosNumeric)v.get(i + 1)).doubleValue()));
                }
                List<AnnotationAppearanceGenerator.Arc> vArc = CloudUtils.cloudifyPolyLine(cloudIntensity, this.writer.lineWidth == 0.0 ? 0.001 : this.writer.lineWidth, fpVector);
                Iterator<AnnotationAppearanceGenerator.Arc> itr = vArc.iterator();
                AnnotationAppearanceGenerator.Arc iArc = null;
                boolean first = true;
                while (itr.hasNext()) {
                    iArc = itr.next();
                    this.writer.arcto(iArc.m_center.x(), iArc.m_center.y(), iArc.m_radius, iArc.t2 - 0.39269908169872414, iArc.t1, true, first);
                    this.writer.arcto(iArc.m_center.x(), iArc.m_center.y(), iArc.m_radius, iArc.t2 - 0.39269908169872414, iArc.t2, false, false);
                    first = false;
                }
            } else {
                this.writer.moveTo(((PDFCosNumeric)v.get(0)).doubleValue(), ((PDFCosNumeric)v.get(1)).doubleValue());
                for (int i = 2; i < v.size(); i += 2) {
                    this.writer.lineTo(((PDFCosNumeric)v.get(i)).doubleValue(), ((PDFCosNumeric)v.get(i + 1)).doubleValue());
                }
            }
            this.writer.contentWriter.write(InstructionFactory.newClosePath());
            this.writer.fillStroke(this.writer.fill, this.writer.stroke);
        }
        PDFRectangle rect = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rect, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rect, null);
            this.createAndSetAppearance(annot, rect);
        }
    }
}

