/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;

public class DocModAnalysisStatus {
    int status = 0;
    PDFSignature signature;
    public static final int InvalidRecipientSignature = 1;
    public static final int InvalidMDP = 2;
    public static final int InvalidFieldMDP = 4;
    public static final int A9FormModified = 8;

    public DocModAnalysisStatus(int status, PDFSignature signature) {
        this.status = status;
        this.signature = signature;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean valid() {
        return !this.invalidRecipientSignature() && !this.invalidMDP() && !this.invalidFieldMDP();
    }

    public boolean invalidRecipientSignature() {
        return this.statusBitSet(1L);
    }

    public boolean invalidMDP() {
        return this.statusBitSet(2L);
    }

    public boolean invalidFieldMDP() {
        return this.statusBitSet(4L);
    }

    public boolean A9FormModified() {
        return this.statusBitSet(8L);
    }

    public boolean A8FormModified() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return this.valid() && (!SignatureUtils.coversEntireDocument(this.signature) || this.signature.getPDFDocument().isDirty());
    }

    public boolean group1UpdatePresent() {
        return !this.A9FormModified() && this.valid();
    }

    public void appendStatus(long status) {
        this.status = (int)((long)this.status | status);
    }

    boolean statusBitSet(long checkStatus) {
        return ((long)this.status & checkStatus) == checkStatus;
    }

    public String toString() {
        StringBuilder resultBuf = new StringBuilder(182);
        if (this.signature == null) {
            return resultBuf.append("No signature present").toString();
        }
        resultBuf.append("\nDoc Mod Analysis results");
        resultBuf.append("\n \tOverall Status - ").append(this.valid() ? " valid " : " invalid ");
        resultBuf.append("\n \tRecipientSignature  - ").append(this.invalidRecipientSignature() ? " invalid " : " valid ");
        resultBuf.append("\n \tMDPSignature  - ").append(this.invalidMDP() ? " invalid " : " valid ");
        resultBuf.append("\n \tMDP+Signature  - ").append(this.invalidFieldMDP() ? " invalid " : " valid ");
        resultBuf.append("\n \tA9 Form Modified  - ").append(this.A9FormModified() ? " yes " : " no ");
        return resultBuf.toString();
    }
}

