/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.PKCS7SignerInfo;
import com.adobe.internal.pdftoolkit.services.digsig.RevocationInfo;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.PKCS7Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class PKCS7SignatureParser {
    byte[] contentBytes;
    PKCS7Parser asn1Parser;

    public PKCS7SignatureParser(byte[] sigBytes) throws PDFSignatureException {
        this.contentBytes = sigBytes;
        this.asn1Parser = new PKCS7Parser(this.contentBytes);
    }

    public byte[] getTimeStampToken() throws PDFSignatureException {
        byte[] timeStampToken = null;
        Vector signers = this.asn1Parser.getSigners();
        if (signers != null) {
            for (int i = 0; i < signers.size(); ++i) {
                PKCS7SignerInfo info = (PKCS7SignerInfo)signers.get(i);
                timeStampToken = this.asn1Parser.getTimeStampAttribute(info.getUnauthenticatedAttrs());
            }
        }
        return timeStampToken;
    }

    public RevocationInfo getEmbeddedRevocationInformation() throws PDFSignatureException {
        Vector signers = this.asn1Parser.getSigners();
        if (signers != null && !signers.isEmpty()) {
            PKCS7SignerInfo info = (PKCS7SignerInfo)signers.get(0);
            return this.asn1Parser.getRevocationInfoAttribute(info.getAuthenticatedAttrs());
        }
        return null;
    }

    public List getCertificates() {
        return new ArrayList(this.asn1Parser.getCerts());
    }

    public List getCRLS() {
        return new ArrayList(this.asn1Parser.getCrls());
    }

    public List getSigners() {
        return new ArrayList(this.asn1Parser.getSigners());
    }

    public List getDigestIDS() {
        return new ArrayList(this.asn1Parser.getDigestIDs());
    }

    public int getVersion() {
        return this.asn1Parser.getVersion();
    }
}

