/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFlags;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMProcessor;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.Field;

public class SignatureFieldFactory {
    private static final String DEFAULT_SIGNATURENAME = "SignatureField";
    private static final String INVISIBLE_SIGNATURE_LOCATION_SOM = "$template.#subform";
    private static final String INVISIBLE_SIGNATURE_LOCATION_SOM_FORM = "$form.#subform";
    private static final String INVISIBLE_SIGNATURE_NAME_LEADING = "$template.#subform..";

    public static SignatureFieldInterface createSignatureField(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return SignatureFieldFactory.createSignatureField(page, annotRect, parent, PDFRotation.ROTATE_0.getValue());
    }

    public static SignatureFieldInterface createSignatureField(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent, int annotRotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return SignatureFieldFactory.createSignatureField(page, annotRect, parent, PDFRotation.getInstance(annotRotationAngle), null);
    }

    public static SignatureFieldInterface createSignatureField(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent, PDFRotation annotRotationAngle, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be specified for the new signature field.");
        }
        try {
            if (SignatureFieldFactory.needsXFAProcessing(page, annotRect, parent)) {
                Field xfaField = SignatureFieldFactory.createXFASignatureField(page, DEFAULT_SIGNATURENAME, true);
                if (xfaField != null) {
                    return new SignatureFieldXFA(page.getPDFDocument(), xfaField);
                }
            } else {
                PDFFieldSignature sigField = SignatureFieldFactory.initPDFSignatureField(page, annotRect, parent, da);
                if (sigField != null) {
                    sigField.setRotationAngle(annotRotationAngle);
                    return new SignatureFieldPDF(sigField);
                }
            }
            return null;
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException("InvalidXML exception encountered when adding a signature field to the XFA document", e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidParameterException("Configuration exception encountered when adding a signature field to the XFA document", e);
        }
    }

    public static SignatureFieldInterface createSignatureField(PDFPage page, PDFRectangle annotRect, String qualifiedFieldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return SignatureFieldFactory.createSignatureField(page, annotRect, qualifiedFieldName, PDFRotation.ROTATE_0.getValue());
    }

    public static SignatureFieldInterface createSignatureField(PDFPage page, PDFRectangle annotRect, String qualifiedFieldName, int annotRotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return SignatureFieldFactory.createSignatureField(page, annotRect, qualifiedFieldName, PDFRotation.getInstance(annotRotationAngle), null);
    }

    public static SignatureFieldInterface createSignatureField(PDFPage page, PDFRectangle annotRect, String qualifiedFieldName, PDFRotation annotRotationAngle, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be specified for the new signature field.");
        }
        boolean useUnicodeEncoding = false;
        PDFInteractiveForm iform = page.getPDFDocument().requireCatalog().procureInteractiveForm();
        PDFDocument.PDFDocumentType docType = XFAService.getDocumentType(page.getPDFDocument());
        if (docType.isDynamic()) {
            useUnicodeEncoding = true;
        }
        PDFFieldNode parent = PDFFieldUtils.procureIntermediateFieldNodes(qualifiedFieldName, useUnicodeEncoding, iform);
        try {
            if (SignatureFieldFactory.needsXFAProcessing(page, annotRect, parent)) {
                boolean autoName = false;
                if (qualifiedFieldName == null) {
                    qualifiedFieldName = DEFAULT_SIGNATURENAME;
                    autoName = true;
                } else {
                    SignatureFieldFactory.enforceXFANameChecks(qualifiedFieldName);
                }
                Field xfaField = SignatureFieldFactory.createXFASignatureField(page, qualifiedFieldName, autoName);
                if (xfaField != null) {
                    return new SignatureFieldXFA(page.getPDFDocument(), xfaField);
                }
            } else {
                String[] partialNames = qualifiedFieldName != null ? qualifiedFieldName.split("\\.") : new String[]{};
                int terminalFieldNameIndex = -1;
                for (int i = 0; i < partialNames.length; ++i) {
                    if (partialNames[i] == null || partialNames[i].equals("")) continue;
                    terminalFieldNameIndex = i;
                }
                String sigFieldName = terminalFieldNameIndex > -1 ? partialNames[terminalFieldNameIndex] : null;
                PDFFieldSignature sigField = SignatureFieldFactory.initPDFSignatureFieldWithName(page, annotRect, parent, sigFieldName, useUnicodeEncoding, da);
                if (sigField != null) {
                    sigField.setRotationAngle(annotRotationAngle);
                    return new SignatureFieldPDF(sigField);
                }
            }
            return null;
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException("InvalidXML exception encountered when adding a signature field to the XFA document", e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidParameterException("Configuration exception encountered when adding a signature field to the XFA document", e);
        }
    }

    private static boolean needsXFAProcessing(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        int BOILER_PLATE_PAGEINDEX = 0;
        PDFDocument.PDFDocumentType docType = XFAService.getDocumentType(page.getPDFDocument());
        if (docType == PDFDocument.PDFDocumentType.StaticShellXFA) {
            return true;
        }
        if (docType.isDynamic()) {
            if (SignatureFieldFactory.isSigAnnotInvisible(annotRect)) {
                if (page.getIndex() != BOILER_PLATE_PAGEINDEX) {
                    throw new PDFInvalidParameterException("All XFA signatures have to be created only on the boiler plate page");
                }
                PDFCatalog cat = page.getPDFDocument().requireCatalog();
                PDFInteractiveForm form = cat.getInteractiveForm();
                if (!PDFUtil.isPDFCosObjectRefEqual(parent, form)) {
                    throw new PDFInvalidParameterException("The parent node for invisible XFA signatures should always be the root node");
                }
                return true;
            }
            throw new PDFInvalidParameterException("Only invisible signatures can be created on dynamic XFA documents");
        }
        return false;
    }

    private static boolean isSigAnnotInvisible(PDFRectangle annotRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return annotRect.llx() == 0.0 && annotRect.lly() == 0.0 && annotRect.urx() == 0.0 && annotRect.ury() == 0.0;
    }

    private static void enforceXFANameChecks(String qualifiedFieldName) throws PDFInvalidParameterException {
        if (qualifiedFieldName != null && qualifiedFieldName.indexOf(46) != -1 && qualifiedFieldName.indexOf(91) != -1 && qualifiedFieldName.indexOf(93) != -1 && qualifiedFieldName.indexOf("..") != -1 && qualifiedFieldName.indexOf(42) != -1) {
            throw new PDFInvalidParameterException("Fully qualified field names like " + qualifiedFieldName + " cannot be provided for invisible XFA signature creation");
        }
    }

    private static Field createXFASignatureField(PDFPage page, String signatureFieldName, boolean autoName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        PDFDocument pdfDoc = page.getPDFDocument();
        if (!autoName && SignatureFieldFactory.isSignatureFieldNamePresent(pdfDoc, signatureFieldName)) {
            throw new PDFInvalidParameterException("SignatureField with base name = " + signatureFieldName + " is present in the XFA");
        }
        XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
        return SignatureFieldFactory.addFieldInXFA(signatureFieldName, xfaDOM.getTemplateModel(), xfaDOM.getFormModel());
    }

    private static Field addFieldInXFA(String baseSignatureFieldName, TemplateModel mTemplateModel, FormModel mFormModel) throws PDFIOException, PDFInvalidXMLException, PDFCosParseException, PDFSecurityException {
        if (mTemplateModel == null) {
            throw new PDFInvalidXMLException("Unable to get TemplateModel from the XFA.");
        }
        String fieldName = XFADOMProcessor.generateIndexedSignatureFieldName((String)baseSignatureFieldName, (TemplateModel)mTemplateModel);
        if (fieldName.lastIndexOf(91) != -1) {
            fieldName = fieldName.substring(0, fieldName.lastIndexOf(91));
        }
        String nameAttrValue = fieldName;
        Field fieldElement = (Field)mTemplateModel.createElement(XFA.FIELDTAG, nameAttrValue);
        fieldElement.setAttribute(1076494337, XFA.PRESENCETAG);
        fieldElement.setAttribute(new StringAttr("w", "0"), XFA.WTAG);
        fieldElement.setAttribute(new StringAttr("h", "0"), XFA.HTAG);
        Element uiElement = mTemplateModel.createElement(XFA.UITAG, null);
        fieldElement.appendChild(uiElement, false);
        Element signatureElement = mTemplateModel.createElement(XFA.SIGNATURETAG, null);
        uiElement.appendChild(signatureElement, false);
        Element fontElement = mTemplateModel.createElement(XFA.FONTTAG, null);
        fontElement.setAttribute(new StringAttr("typeface", "Myriad Pro"), XFA.TYPEFACETAG);
        fieldElement.appendChild(fontElement, false);
        Element bindElement = mTemplateModel.createElement(XFA.BINDTAG, null);
        bindElement.setAttribute(0x1F0000, XFA.MATCHTAG);
        fieldElement.appendChild(bindElement, false);
        Container signatureParent = (Container)mTemplateModel.resolveNode(INVISIBLE_SIGNATURE_LOCATION_SOM, false, false, false);
        if (signatureParent != null) {
            signatureParent.appendChild(fieldElement, false);
        }
        Field formNode = fieldElement;
        if (mFormModel != null) {
            formNode = (Field)mFormModel.createElement(XFA.FIELDTAG, nameAttrValue);
            Container formParent = (Container)mFormModel.resolveNode(INVISIBLE_SIGNATURE_LOCATION_SOM_FORM, false, false, false);
            if (formParent != null) {
                formParent.appendChild(formNode, false);
            }
            formNode.setProto(fieldElement);
        }
        return formNode;
    }

    private static PDFFieldSignature initPDFSignatureField(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        boolean useUnicodeEncoding = false;
        CosDictionary cosObject = PDFCosUtils.newCosDictionary(page.getPDFDocument());
        PDFFieldSignature sigField = PDFFieldSignature.getInstance(cosObject);
        SignatureFieldFactory.initializePDFSignatureField(page, annotRect, parent, null, useUnicodeEncoding, da, sigField);
        return sigField;
    }

    static PDFFieldSignature initPDFSignatureFieldWithName(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent, String qualifiedName, boolean useUnicodeEncoding, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String sigFieldName = null;
        if (qualifiedName != null) {
            sigFieldName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        }
        CosDictionary cosObject = PDFCosUtils.newCosDictionary(page.getPDFDocument());
        PDFFieldSignature sigField = PDFFieldSignature.getInstance(cosObject);
        SignatureFieldFactory.initializePDFSignatureField(page, annotRect, parent, sigFieldName, useUnicodeEncoding, da, sigField);
        return sigField;
    }

    private static void initializePDFSignatureField(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent, String partialName, boolean useUnicodeEncoding, PDFDefaultAppearance da, PDFFieldSignature sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annot rectangle must be provided for the signature's annotation.");
        }
        sigField.setDictionaryNameValue(ASName.k_FT, ASName.k_Sig);
        if (annotRect.hasNonZeroDimensions() && !page.getMediaBox().intersects(annotRect)) {
            throw new PDFInvalidParameterException("The supplied annotation rectangle is completely outside the page's media box");
        }
        sigField.init(parent, partialName, DEFAULT_SIGNATURENAME, da, useUnicodeEncoding);
        PDFDocument pdfDoc = page.getPDFDocument();
        PDFAnnotationWidget sigAnnot = PDFAnnotationWidget.getInstance(sigField.getCosObject());
        try {
            sigAnnot.getCosDictionary().put(ASName.k_Type, ASName.k_Annot);
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException("The PDF document to be signed is invalid", e);
        }
        catch (PDFIOException e) {
            throw new PDFIOException("IO exception with the PDF document to be signed", e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSecurityException("Security exception with the PDF document to be signed", e);
        }
        sigAnnot.setSubtype(ASName.k_Widget);
        sigAnnot.setRect(annotRect);
        sigAnnot.setPage(page);
        sigAnnot.setFlags(4);
        PDFAnnotationList annots = page.getAnnotationList();
        if (annots == null) {
            annots = PDFAnnotationList.newInstance(pdfDoc);
            page.setAnnotationList(annots);
        }
        annots.add(sigAnnot);
        SignatureFlags.signatureFieldAdded((PDFDocument)pdfDoc);
    }

    public static boolean isSignatureFieldNamePresent(PDFDocument pdfDoc, String baseSignatureFieldName) throws PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException, PDFInvalidDocumentException {
        if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.Acroform) {
            throw new PDFInvalidParameterException("XFA not found. Input file is an Acroform Document");
        }
        if (baseSignatureFieldName.indexOf(91) != baseSignatureFieldName.lastIndexOf(91)) {
            throw new PDFInvalidParameterException("The given signature field name " + baseSignatureFieldName + "  contains more than one occurence of [. We cannot check the XFA for it's occurence");
        }
        String fieldExpression = INVISIBLE_SIGNATURE_NAME_LEADING + baseSignatureFieldName;
        XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
        Model xfaModel = xfaDOM.getFormModel();
        if (xfaModel == null) {
            xfaModel = xfaDOM.getTemplateModel();
        }
        return xfaModel.resolveNode(fieldExpression, false, true, false) != null;
    }
}

