/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFLegalAttestation;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureUtils;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersDocMDP;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUB1;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUR;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURAnnots;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURDocument;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUREmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURForm;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUsageRight;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.DocSignatureFieldIterator;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldFactory;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsDocMDP;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsDocumentTimeStamp;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsUR;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureValidationStatus;
import com.adobe.internal.pdftoolkit.services.digsig.SigningStatus;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.FormModelWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFADigSigWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFlags;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMProcessor;
import com.adobe.xfa.template.containers.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SignatureManager {
    private final PDFDocument pdfDoc;
    public static final int MAX_SUPPORTED_SV_VERSION = 3;

    private SignatureManager(PDFDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
    }

    public static SignatureManager newInstance(PDFDocument pdfDoc) {
        if (pdfDoc == null) {
            return null;
        }
        return new SignatureManager(pdfDoc);
    }

    public boolean hasSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getDocSignatureFieldIterator();
        return iter.hasNext();
    }

    public Iterator<SignatureFieldInterface> getDocSignatureFieldIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            DocSignatureFieldIterator sigIter = new DocSignatureFieldIterator();
            return sigIter.getIterator(this.pdfDoc);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public Iterator<SignatureFieldInterface> getPDFSignatureFieldIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new DocSignatureFieldIterator().getAcroformIterator(this.pdfDoc);
    }

    public boolean hasDocumentTimeStampSignatures() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            if (!sigField.isSigned() || !SignatureUtils.isDocumentTimeStampSignature(sigField.getPDFField().getPDFFieldSignature().getSignature())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCADESSignatures() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            if (!sigField.isSigned() || !SignatureUtils.isCADESSignature(sigField.getPDFField().getPDFFieldSignature().getSignature())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSignedSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            if (!sigField.isSigned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnsignedSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getDocSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            if (sigField.isSigned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecipientSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            PDFSignature signature;
            SignatureFieldInterface sigField = iter.next();
            if (!sigField.isSigned() || !SignatureUtils.isRecipientSignature(signature = sigField.getPDFField().getPDFFieldSignature().getSignature())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAuthorSignatureField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCertifiedSignatureField() != null;
    }

    public SignatureFieldInterface getCertifiedSignatureField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            if (!sigField.isSigned() || !SignatureUtils.isAuthorSignature(sigField.getPDFField().getPDFFieldSignature().getSignature())) continue;
            return sigField;
        }
        return null;
    }

    public PDFSignature getCertificationSignature() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject docMDP;
        PDFPermissions pdfPerms = this.pdfDoc.requireCatalog().getPermissions();
        if (pdfPerms != null && (docMDP = pdfPerms.getDictionaryCosObjectValue(ASName.k_DocMDP)) != null) {
            return PDFSignature.getInstance(docMDP);
        }
        return null;
    }

    public void removeCertifiedSignatureField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        SignatureFieldInterface sigField = null;
        while (iter.hasNext()) {
            PDFSignature signature;
            sigField = iter.next();
            if (!sigField.isSigned() || !SignatureUtils.isAuthorSignature(signature = sigField.getPDFField().getPDFFieldSignature().getSignature())) continue;
            try {
                this.unsignSignatureField(sigField);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
            iter.remove();
        }
        PDFPermissions perms = this.pdfDoc.requireCatalog().getPermissions();
        if (perms != null) {
            perms.setDocMDP(null);
        }
    }

    public PDFDocMDPPermissions getPDFDocMDPPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSignature docMDPSignature = this.getCertificationSignature();
        if (docMDPSignature != null) {
            return this.getPDFDocMDPPermissions(docMDPSignature);
        }
        return null;
    }

    private PDFDocMDPPermissions getPDFDocMDPPermissions(PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocMDPPermissions perms = null;
        PDFSignatureReferenceList refList = signature.getSignatureReferences();
        if (refList != null) {
            for (PDFSignatureReference ref : refList) {
                PDFTransformParameters tp = ref.getPDFTransformParameters();
                if (!(tp instanceof PDFTransformParametersDocMDP)) continue;
                perms = ((PDFTransformParametersDocMDP)tp).getPermissions();
                break;
            }
        }
        return perms;
    }

    public boolean hasUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureUtils.hasUsageRights(this.pdfDoc);
    }

    public boolean hasUsageRights(String transformMethod) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureUtils.hasUsageRights(this.pdfDoc, transformMethod);
    }

    public PDFTransformParametersUR getDocumentUsageRights(String transformMethod) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureUtils.getDocumentUsageRights(this.pdfDoc, transformMethod);
    }

    public void removeUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeUB1Rights();
        PDFPermissions perms = this.pdfDoc.requireCatalog().getPermissions();
        if (perms != null) {
            perms.setUR(null);
            perms.setUR3(null);
            this.updateSignatureTrackersAfterUnsignOrRemove(true);
        }
    }

    public void removeUsageRights(String transformMethod) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms;
        if (this.hasUB1Rights() && transformMethod.equals(PDFSignature.k_UB1.asString(true))) {
            this.removeUB1Rights();
        }
        if ((perms = this.pdfDoc.requireCatalog().getPermissions()) != null) {
            if (transformMethod.equals(PDFSignature.k_UR.asString(true))) {
                perms.setUR(null);
            }
            if (transformMethod.equals(PDFSignature.k_UR3.asString(true))) {
                perms.setUR3(null);
            }
            this.updateSignatureTrackersAfterUnsignOrRemove(true);
        }
    }

    public boolean hasPermissionsSignature() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureUtils.hasPermissionsSignature(this.pdfDoc);
    }

    boolean hasUB1Rights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary rightsDict;
        PDFViewerPreferences viewerPrefs = this.pdfDoc.requireCatalog().getViewerPreferences();
        return viewerPrefs != null && (rightsDict = viewerPrefs.getRights()) != null;
    }

    PDFTransformParametersUB1 getUB1Rights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureUtils.getUB1Rights(this.pdfDoc);
    }

    void removeUB1Rights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFViewerPreferences viewerPrefs = this.pdfDoc.requireCatalog().getViewerPreferences();
        if (viewerPrefs != null) {
            viewerPrefs.removeRights();
        }
    }

    public void removeAllSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.removeAndFlattenAllSignatureFields(false);
        }
        catch (PDFException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public void flattenAllSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        try {
            this.removeAndFlattenAllSignatureFields(true);
        }
        catch (PDFException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    private void removeAndFlattenAllSignatureFields(boolean flatten) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFConfigurationException {
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface currentSigField = iter.next();
            if (flatten) {
                SignatureUtils.addSignatureFieldAppearanceToPageContentStream(currentSigField, this.pdfDoc);
            }
            if (currentSigField.isSigned()) {
                this.unsignSignatureField(currentSigField);
            }
            iter.remove();
        }
        SignatureFlags.signatureFieldUnsignedOrSignatureRemoved((PDFDocument)this.pdfDoc);
        this.cleanResources();
    }

    void removeSignatureField(XFADigSigWorkFlow workFlow, boolean cleanResources, boolean removeSigFieldFromFieldTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        SignatureFieldPDF sigFieldPDF = sigField.getPDFField();
        if (sigFieldPDF == null) {
            return;
        }
        PDFDocument pdfDoc = sigField.getPDFDocument();
        PDFFieldSignature pdfField = sigFieldPDF.getPDFFieldSignature();
        SignatureManager sigMgr = SignatureManager.newInstance(pdfDoc);
        if (removeSigFieldFromFieldTree) {
            PDFFieldNode parentNode = pdfField.getParent();
            if (parentNode != null) {
                parentNode.removeChild(pdfField);
            } else {
                sigField.getPDFDocument().requireCatalog().procureInteractiveForm().removeChild(pdfField);
            }
        }
        PDFAnnotationIterator annotIter = sigFieldPDF.getPDFFieldSignature().getAnnotationsIterator();
        while (annotIter.hasNext()) {
            PDFFieldUtils.removeAnnotation(annotIter.next());
        }
        if (sigField.isSigned()) {
            PDFCatalog catalog;
            PDFPermissions pdfPerms;
            SignatureUtils.clearFieldLocks(pdfField, this.pdfDoc, workFlow.isFormModelWorkFlow());
            PDFSignature signature = pdfField.getSignature();
            if (SignatureUtils.isAuthorSignature(signature) && (pdfPerms = (catalog = pdfDoc.requireCatalog()).getPermissions()) != null) {
                pdfPerms.setDocMDP(null);
                if (pdfPerms.getDocMDP() == null && pdfPerms.getUR() == null && pdfPerms.getUR3() == null) {
                    catalog.setPermissions(null);
                }
                catalog.removeLegalAttestation();
            }
        }
        if (cleanResources) {
            SignatureFlags.signatureFieldUnsignedOrSignatureRemoved((PDFDocument)pdfDoc);
            sigMgr.cleanResources();
        }
    }

    public void flattenSignatureField(SignatureFieldInterface sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFConfigurationException {
        this.flattenSignatureFieldAPIWrapper((XFADigSigWorkFlow)new FormModelWorkFlow(sigField));
    }

    private void flattenSignatureFieldAPIWrapper(XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFConfigurationException {
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        SignatureUtils.addSignatureFieldAppearanceToPageContentStream(sigField, this.pdfDoc);
        this.removeSignatureField(workFlow, false, false);
        PDFFieldNode currentNode = sigField.getPDFField().getPDFFieldSignature();
        PDFFieldNode parentNode = null;
        while ((parentNode = currentNode.getParent()) != null) {
            if (parentNode.getChildren().size() == 1) {
                parentNode.removeChildren();
                currentNode = parentNode;
                continue;
            }
            parentNode.removeChild(currentNode);
            break;
        }
        if (parentNode == null) {
            sigField.getPDFDocument().requireCatalog().procureInteractiveForm().removeChild(currentNode);
        }
    }

    private void unsignSignatureFieldAPIWrapper(XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        if (sigField == null) {
            return;
        }
        SignatureUtils.enforceSigFieldOnPDFDoc(sigField, this.pdfDoc);
        if (sigField.isSigned()) {
            PDFPermissions perms;
            PDFFieldSignature pdfSigField = sigField.getPDFField().getPDFFieldSignature();
            if (SignatureUtils.isAuthorSignature(pdfSigField.getSignature()) && (perms = this.pdfDoc.requireCatalog().getPermissions()) != null) {
                perms.setDocMDP(null);
            }
            SignatureUtils.clearFieldLocks(pdfSigField, this.pdfDoc, workFlow.isFormModelWorkFlow());
            pdfSigField.setSignature(null);
            PDFAnnotationIterator annotIter = pdfSigField.getAnnotationsIterator();
            while (annotIter.hasNext()) {
                PDFAnnotation annot = annotIter.next();
                annot.removeAppearance();
                annot.setFlags(4);
            }
            if (sigField.isReadOnly()) {
                pdfSigField.setFlags(pdfSigField.getFlags() & 0xFFFFFFFE);
            }
            this.updateSignatureTrackersAfterUnsignOrRemove(false);
            this.cleanResources();
        }
    }

    public void unsignSignatureField(SignatureFieldInterface sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.unsignSignatureFieldAPIWrapper((XFADigSigWorkFlow)new FormModelWorkFlow(sigField));
    }

    public void unsignAllPDFSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.pdfDoc == null) {
            return;
        }
        PDFInteractiveForm iform = this.pdfDoc.getInteractiveForm();
        if (iform == null) {
            return;
        }
        Iterator<SignatureFieldInterface> iter = this.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            this.unsignSignatureField(sigField);
        }
    }

    public SigningStatus sign(SignatureFieldInterface sigField, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        return this.sign(sigField, null, credentials, byteWriter, sigServiceProvider);
    }

    public SigningStatus sign(SignatureFieldInterface sigField, Credentials credentials, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        return this.sign(sigField, credentials, byteWriter, null);
    }

    public SigningStatus sign(SignatureFieldInterface sigField, SignatureOptions sigOptions, Credentials credentials, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        return this.sign(sigField, sigOptions, credentials, byteWriter, null);
    }

    public void applyDocumentTimeStampSignature(SignatureOptionsDocumentTimeStamp sigOptions, SignatureServiceProvider sigServiceProvider, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, PDFConfigurationException, PDFSignatureException, PDFUnableToCompleteOperationException {
        if (sigOptions == null) {
            sigOptions = SignatureOptionsDocumentTimeStamp.newInstance();
        }
        sigOptions.setSigningType(SigningUtils.SigningType.DocumentTimeStamp);
        SignatureFieldInterface sigField = SignatureFieldFactory.createSignatureField(this.pdfDoc.requirePages().getPage(0), PDFRectangle.newInstance(this.pdfDoc, 0.0, 0.0, 0.0, 0.0), this.pdfDoc.requireCatalog().procureInteractiveForm());
        SigningUtils.doSigning((XFADigSigWorkFlow)new FormModelWorkFlow(sigField), (SignatureOptions)sigOptions, null, (ByteWriter)byteWriter, (SignatureServiceProvider)sigServiceProvider, (PDFDocument)this.pdfDoc, null);
    }

    public SigningStatus sign(SignatureFieldInterface sigField, SignatureOptions sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        return this.signWrapperAPI((XFADigSigWorkFlow)new FormModelWorkFlow(sigField), sigOptions, credentials, byteWriter, sigServiceProvider);
    }

    private SigningStatus signWrapperAPI(XFADigSigWorkFlow workFlow, SignatureOptions sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        sigOptions = SigningUtils.performPreSignValidations((XFADigSigWorkFlow)workFlow, (Credentials)credentials, (SignatureOptions)sigOptions, (SigningUtils.SigningType)SigningUtils.SigningType.OrdinarySigning);
        try {
            return SigningUtils.doSigning((XFADigSigWorkFlow)workFlow, (SignatureOptions)sigOptions, (Credentials)credentials, (ByteWriter)byteWriter, (SignatureServiceProvider)sigServiceProvider, (PDFDocument)this.pdfDoc, null);
        }
        catch (PDFSignatureException e) {
            throw new PDFInvalidParameterException("Exception encountered when applying the signature", e);
        }
    }

    public SigningStatus signWithCADESDetached(SignatureFieldInterface sigField, SignatureOptionsCADES sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        if (sigOptions == null) {
            sigOptions = SignatureOptionsCADES.newInstance();
        }
        sigOptions.setSigningType(SigningUtils.SigningType.CADESDetachedSigning);
        return this.sign(sigField, sigOptions, credentials, byteWriter, sigServiceProvider);
    }

    public SigningStatus certify(SignatureFieldInterface sigField, Credentials credentials, ByteWriter byteWriter) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        return this.certify(sigField, credentials, byteWriter, null);
    }

    public SigningStatus certify(SignatureFieldInterface sigField, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        return this.certify(sigField, null, credentials, byteWriter, sigServiceProvider);
    }

    public SigningStatus certify(SignatureFieldInterface sigField, SignatureOptionsDocMDP sigOptions, Credentials credentials, ByteWriter byteWriter) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        return this.certify(sigField, sigOptions, credentials, byteWriter, null);
    }

    public SigningStatus certify(SignatureFieldInterface sigField, SignatureOptionsDocMDP sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        return this.certifyWrapperAPI((XFADigSigWorkFlow)new FormModelWorkFlow(sigField), sigOptions, credentials, byteWriter, sigServiceProvider);
    }

    private SigningStatus certifyWrapperAPI(XFADigSigWorkFlow workFlow, SignatureOptionsDocMDP sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        sigOptions = (SignatureOptionsDocMDP)SigningUtils.performPreSignValidations((XFADigSigWorkFlow)workFlow, (Credentials)credentials, (SignatureOptions)sigOptions, (SigningUtils.SigningType)SigningUtils.SigningType.OrdinaryCertification);
        try {
            return SigningUtils.doSigning((XFADigSigWorkFlow)workFlow, (SignatureOptions)sigOptions, (Credentials)credentials, (ByteWriter)byteWriter, (SignatureServiceProvider)sigServiceProvider, (PDFDocument)this.pdfDoc, null);
        }
        catch (PDFSignatureException e) {
            throw new PDFInvalidParameterException("Exception encountered when applying the signature", e);
        }
    }

    public SigningStatus certifyWithCADESDetached(SignatureFieldInterface sigField, SignatureOptionsCADES sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (sigOptions == null) {
            sigOptions = SignatureOptionsCADES.newInstance();
        }
        sigOptions.setSigningType(SigningUtils.SigningType.CADESDetachedCertification);
        return this.certify(sigField, sigOptions, credentials, byteWriter, sigServiceProvider);
    }

    public void applyUsageRights(PDFURDocument[] documentRights, PDFURAnnots[] annotRights, PDFUREmbeddedFiles[] embeddedFileRights, PDFURForm[] formRights, PDFURSignature[] signatureRights, String message, boolean restrictPermissions, SignatureOptionsUR sigOptions, Credentials credentials, ByteWriter byteWriter) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        this.applyUsageRights(documentRights, annotRights, embeddedFileRights, formRights, signatureRights, message, restrictPermissions, sigOptions, credentials, byteWriter, null);
    }

    public void applyUsageRights(PDFURDocument[] documentRights, PDFURAnnots[] annotRights, PDFUREmbeddedFiles[] embeddedFileRights, PDFURForm[] formRights, PDFURSignature[] signatureRights, String message, boolean restrictPermissions, SignatureOptionsUR sigOptions, Credentials credentials, ByteWriter byteWriter, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (credentials == null) {
            throw new PDFInvalidParameterException("Applying usage rights requires credentials.");
        }
        if (!SigningUtils.isSupportedCredentialType((Credentials)credentials)) {
            throw new PDFInvalidParameterException("Applying usage rights does not support this credential type.");
        }
        PDFInteractiveForm iform = this.pdfDoc.requireCatalog().getInteractiveForm();
        if (iform != null && iform.getNeedAppearances()) {
            throw new PDFInvalidDocumentException("Appearances need to be generated before ubiquitizing the file and the NeedAppearances flag turned off.");
        }
        if (this.hasUsageRights()) {
            throw new PDFInvalidParameterException("Document already has usage rights.");
        }
        iform = this.pdfDoc.requireCatalog().procureInteractiveForm();
        iform.procureChildren();
        boolean rightsSpecified = false;
        PDFUsageRight[][] urArrays = new PDFUsageRight[][]{documentRights, annotRights, embeddedFileRights, formRights, signatureRights};
        block2: for (int i = 0; i < urArrays.length && !rightsSpecified; ++i) {
            PDFUsageRight[] urs = urArrays[i];
            if (urs == null) continue;
            for (int j = 0; j < urs.length; ++j) {
                if (urs[j] == null) continue;
                rightsSpecified = true;
                continue block2;
            }
        }
        if (!rightsSpecified) {
            throw new PDFInvalidParameterException("At least one non-null usage right must be specified.");
        }
        if (sigOptions == null) {
            sigOptions = SignatureOptionsUR.newInstance();
        }
        sigOptions.setSigningType(SigningUtils.SigningType.UsageRights);
        PDFTransformParametersUR transformParamsUR = SignatureUtils.createURTransform(documentRights, annotRights, embeddedFileRights, formRights, signatureRights, message, restrictPermissions, this.pdfDoc);
        try {
            SigningUtils.doSigning((XFADigSigWorkFlow)new FormModelWorkFlow(this.pdfDoc), (SignatureOptions)sigOptions, (Credentials)credentials, (ByteWriter)byteWriter, (SignatureServiceProvider)sigServiceProvider, (PDFDocument)this.pdfDoc, (Object)transformParamsUR);
        }
        catch (PDFSignatureException e) {
            throw new PDFInvalidParameterException("Exception encountered when applying the signature", e);
        }
    }

    private void updatePerms() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasPermissionsSignature()) {
            PDFCatalog catalog = this.pdfDoc.requireCatalog();
            catalog.setPermissions(null);
        }
    }

    private void updateLegal() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms;
        PDFCatalog catalog = this.pdfDoc.requireCatalog();
        PDFLegalAttestation attest = catalog.getLegalAttestation();
        if (attest != null && ((perms = this.pdfDoc.requireCatalog().getPermissions()) == null || perms != null && perms.getDocMDP() == null)) {
            catalog.removeLegalAttestation();
        }
    }

    private void updateSignatureTrackersAfterUnsignOrRemove(boolean onlyUBRemoved) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.updatePerms();
        if (!onlyUBRemoved) {
            this.updateLegal();
        }
        SignatureFlags.signatureFieldUnsignedOrSignatureRemoved((PDFDocument)this.pdfDoc);
    }

    private void cleanResources() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (!this.hasSignatureFields()) {
            SignatureUtils.removeXObjects(this.pdfDoc);
        }
    }

    public static List getSigHandlerNames() {
        return Arrays.asList(PDFSignature.k_Adobe_PPKLite.asString(true));
    }

    public static int getSupportedSeedValueVersion() {
        return 3;
    }

    public static List getSupportedSubFilters(String handler) throws PDFInvalidParameterException {
        if (handler.equals(PDFSignature.k_Adobe_PPKLite.asString(true))) {
            return Arrays.asList(PDFSignature.k_adbe_x509_rsa_sha1.asString(true), PDFSignature.k_adbe_pkcs7_sha1.asString(true), PDFSignature.k_adbe_pkcs7_detached.asString(true), PDFSignature.k_ETSI_CADES_detached.asString(true), PDFSignature.k_ETSI_RFC3161.asString(true));
        }
        throw new PDFInvalidParameterException("Signature Handler with name " + handler + " is not supported");
    }

    public boolean isRestoreStateValuePermitted() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        XFADOMProcessor xfaProcessor = new XFADOMProcessor(this.pdfDoc);
        String attrValue = xfaProcessor.getRestoreStateAttrValue();
        if (attrValue == null) {
            return true;
        }
        return !"auto".equals(attrValue);
    }

    public boolean canCertifyXFADocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        boolean canCertify = true;
        PDFInteractiveForm iform = this.pdfDoc.getInteractiveForm();
        if (iform == null) {
            throw new PDFInvalidParameterException("The supplied document does not contain an acroform dictionary");
        }
        if (!iform.hasXFA()) {
            throw new PDFInvalidParameterException("The supplied document does not contain an XFA entry in it's acroform dictionary");
        }
        XFADOMProcessor xfaProcessor = new XFADOMProcessor(this.pdfDoc);
        if (!this.isRestoreStateValuePermitted()) {
            canCertify = false;
        }
        if (!xfaProcessor.canCertifySubmitTarget()) {
            canCertify = false;
        }
        if (!xfaProcessor.isServerFormStateValuePermitted()) {
            canCertify = false;
        }
        return canCertify;
    }

    public boolean canValidateCertifiedXFADocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFInteractiveForm iform = this.pdfDoc.getInteractiveForm();
        if (iform == null) {
            throw new PDFInvalidParameterException("The supplied document does not contain an acroform dictionary");
        }
        if (!iform.hasXFA()) {
            throw new PDFInvalidParameterException("The supplied document does not contain an XFA entry in it's acroform dictionary");
        }
        if (!this.isDocCertified()) {
            return false;
        }
        XFADOMProcessor xfaProcessor = new XFADOMProcessor(this.pdfDoc);
        if (!xfaProcessor.canValidateSubmitTargets()) {
            return false;
        }
        return xfaProcessor.isServerFormStateValuePermitted();
    }

    public boolean isDocCertified() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms = this.pdfDoc.requireCatalog().getPermissions();
        if (perms == null) {
            return false;
        }
        return perms.getDocMDP() != null;
    }

    public HashSet getXFASignatureFieldNames(PDFDocument pdfDoc, boolean visibleFields) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<String> signatureNames = null;
        List<Field> sigFields = XFAUtils.enumerateXFASignatureFields(pdfDoc);
        if (sigFields != null) {
            signatureNames = new HashSet<String>(sigFields.size());
            for (int fInd = 0; fInd < sigFields.size(); ++fInd) {
                Field sigField = sigFields.get(fInd);
                if (visibleFields) {
                    if (!new SignatureFieldXFA(pdfDoc, sigField).isVisible()) continue;
                    signatureNames.add(SOMExpressionUtils.trimSomExpression((String)sigField.getSOMExpression()));
                    continue;
                }
                if (new SignatureFieldXFA(pdfDoc, sigField).isVisible()) continue;
                signatureNames.add(SOMExpressionUtils.trimSomExpression((String)sigField.getSOMExpression()));
            }
        }
        return signatureNames;
    }

    public static PDFDocument getSignedVersion(ByteReader outputDocByteReader, PDFOpenOptions pdfOpenOptions, SignatureFieldInterface sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFDocument signedDocument = null;
        PDFSignature signature = null;
        if (sigField != null && sigField.isSigned()) {
            signature = sigField.getPDFField().getPDFFieldSignature().getSignature();
        }
        if (signature == null) {
            throw new PDFInvalidParameterException("The supplied signature field is not signed. Cannot get the signed version.");
        }
        if (outputDocByteReader == null) {
            throw new PDFInvalidParameterException("Null ByteReader supplied. Cannot instantiate the signed document version.");
        }
        if (pdfOpenOptions == null) {
            throw new PDFInvalidParameterException("No PDFOpenOptions supplied that can be used to instantiate the signed document version.");
        }
        long eof = signature.getCosObject().getObjEOF();
        pdfOpenOptions.setEofValue(eof);
        signedDocument = PDFDocument.newInstance(outputDocByteReader, pdfOpenOptions);
        return signedDocument;
    }

    public PDFTransformParametersUR getPDFTransformParametersUR(PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureUtils.getPDFTransformParametersUR(this.pdfDoc, signature);
    }

    public static SignatureValidationStatus validate(SignatureFieldInterface sigField, SignatureOptions signatureOptions, SignatureServiceProvider sigServiceProvider) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFSignatureException {
        if (sigField == null) {
            throw new PDFInvalidParameterException("sigField parameter can not be null");
        }
        return SignatureUtils.validate((XFADigSigWorkFlow)new FormModelWorkFlow(sigField), null, signatureOptions, sigServiceProvider);
    }

    public List<SignatureFieldInterface> fetchSignatureField(String sigFieldName, boolean acroformOnly) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isPartialName = false;
        if (!sigFieldName.contains(".")) {
            isPartialName = true;
        }
        if (XFAService.getDocumentType(this.pdfDoc).isXFA() && !isPartialName) {
            sigFieldName = XFAPlugin.getSOMExpressionForFormFieldImplementation(this.pdfDoc, sigFieldName);
        }
        Iterator<SignatureFieldInterface> itr = null;
        itr = acroformOnly ? this.getPDFSignatureFieldIterator() : this.getDocSignatureFieldIterator();
        SignatureFieldInterface sigField = null;
        ArrayList<SignatureFieldInterface> signatureFields = new ArrayList<SignatureFieldInterface>();
        String[] partialNames = null;
        while (itr.hasNext()) {
            sigField = itr.next();
            if (isPartialName) {
                partialNames = sigField.getQualifiedName().split("\\.");
                if (!partialNames[partialNames.length - 1].equals(sigFieldName)) continue;
                signatureFields.add(sigField);
                continue;
            }
            if (!sigField.getQualifiedName().equals(sigFieldName)) continue;
            signatureFields.add(sigField);
            break;
        }
        return signatureFields;
    }
}

