/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorder;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.LinkParams;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Link
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Link.class", (HashMap)new HashMap<String, Function>(1){
        private static final long serialVersionUID = 1L;
        {
            this.put("setAction", new Function(Link.class, "setAction", Param.Type.Object, LinkParams.setAction, 1, false, false));
        }
    }, (HashMap)new HashMap<String, Property>(4){
        private static final long serialVersionUID = 1L;
        {
            this.put("highlightMode", new Property(Link.class, "highlightMode", "getHighlightMode", "setHighlightMode", LinkParams.highlightMode, false, false));
            this.put("borderColor", new Property(Link.class, "borderColor", "getBorderColor", "setBorderColor", LinkParams.borderColor, false, false));
            this.put("borderWidth", new Property(Link.class, "borderWidth", "getBorderWidth", "setBorderWidth", LinkParams.borderWidth, false, false));
            this.put("rect", new Property(Link.class, "rect", "getRect", "setRect", LinkParams.rect, false, false));
        }
    });
    private static final long serialVersionUID = 1637666695819416980L;
    PDFAnnotationLink linkAnnot;
    static final String className = "Link";

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public Link() {
    }

    public Link(Object o) {
        if (o instanceof PDFAnnotationLink) {
            this.linkAnnot = (PDFAnnotationLink)o;
        }
    }

    public String getClassName() {
        return className;
    }

    public double[] getBorderColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.linkAnnot.getColor();
    }

    public void setBorderColor(Object value) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            double[] arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, (Context)Context.getCurrentContext());
            for (int i = 1; i < fromJS.length; ++i) {
                arr1[i - 1] = (Double)fromJS[i];
            }
            this.linkAnnot.setColor(arr1);
        }
    }

    public double getBorderWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.linkAnnot.getBorder().getWidth();
    }

    public void setBorderWidth(Double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorder border = this.linkAnnot.procureBorder();
        this.linkAnnot.setBorder(border);
        border.setWidth(value);
        this.linkAnnot.setBorder(border);
    }

    public String getHighlightMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.linkAnnot.getHighlight();
    }

    public void setHighlightMode(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.linkAnnot.setHighlight(value);
    }

    public double[] getRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.linkAnnot.getRect().getValues();
    }

    public void setRect(Object value) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            double[] arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, (Context)Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = ((Number)fromJS[i]).doubleValue();
            }
            this.linkAnnot.setRect(arr1[0], arr1[1], arr1[2], arr1[3]);
        }
    }

    public void setAction(String script) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.linkAnnot.setAction(PDFActionJavaScript.newInstance(this.linkAnnot.getPDFDocument(), PDFText.newInstance(this.linkAnnot.getPDFDocument(), script)));
    }

    public PDFAnnotationLink getLinkAnnot() {
        return this.linkAnnot;
    }

    public void setLinkAnnot(PDFAnnotationLink linkAnnot) {
        this.linkAnnot = linkAnnot;
    }
}

