/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCIntentList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsage;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.JSStateListener;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.OCGParams;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class OCG
extends ESObject
implements Comparable<OCG> {
    protected static final ScriptTable scriptTable = new ScriptTable("OCG.class", (HashMap)new HashMap<String, Function>(5){
        private static final long serialVersionUID = 1L;
        {
            this.put("getIntent", new Function(OCG.class, "getIntent", Param.Type.Object, null, 0, false, false));
            this.put("setAction", new Function(OCG.class, "setAction", Param.Type.Object, OCGParams.setAction, 1, false, false));
            this.put("setIntent", new Function(OCG.class, "setIntent", Param.Type.Object, OCGParams.setIntent, 1, false, false));
            this.put("toString", new Function(OCG.class, "toString", Param.Type.Object, null, 0, false, false));
            this.put("valueOf", new Function(OCG.class, "valueOf", Param.Type.Object, null, 0, false, false));
        }
    }, (HashMap)new HashMap<String, Property>(5){
        private static final long serialVersionUID = 1L;
        {
            this.put("state", new Property(OCG.class, "state", "getState", "setState", OCGParams.state, false, false));
            this.put("name", new Property(OCG.class, "name", "getName", "setName", OCGParams.name, false, false));
            this.put("locked", new Property(OCG.class, "locked", "getLocked", "setLocked", OCGParams.locked, false, false));
            this.put("initState", new Property(OCG.class, "initState", "getInitState", "setInitState", OCGParams.initState, false, false));
            this.put("constants", new Property(OCG.class, "constants", "getConstants", null, null, false, false));
        }
    });
    private static final long serialVersionUID = -7097666992707194688L;
    static final String className = "OCG";
    private PDFOCGroup ocGroup = null;

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public String getClassName() {
        return className;
    }

    public Object getConstants() {
        if (this.ocGroup != null) {
            Scriptable scope = this.getParentScope();
            return scope.get("Constants", scope);
        }
        return Undefined.instance;
    }

    public Object getInitState() {
        if (this.ocGroup != null) {
            try {
                PDFOCProperties properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
                if (properties != null) {
                    OCManager ocMgr = OCManager.newInstance(properties);
                    return ocMgr.isVisible(this.ocGroup);
                }
            }
            catch (PDFInvalidDocumentException e) {
                throw new IllegalArgumentException("PDF document is invalid", e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return Undefined.instance;
    }

    public void setInitState(Object value) {
        if (this.ocGroup != null) {
            Boolean inValue = (Boolean)Context.jsToJava(value, Boolean.class);
            try {
                PDFOCProperties properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
                if (properties != null) {
                    OCManager ocMgr = OCManager.newInstance(properties);
                    ocMgr.setInitialState(this.ocGroup, inValue);
                }
            }
            catch (PDFInvalidDocumentException e) {
                throw new IllegalArgumentException("PDF document is invalid", e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object getLocked() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray groupArr;
        PDFOCConfig config;
        PDFOCProperties properties;
        if (this.ocGroup != null && (properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties()) != null && (config = properties.getDefaultOCConfigDict()) != null && (groupArr = config.getLocked()) != null) {
            return groupArr.contains(this.ocGroup);
        }
        return false;
    }

    public void setLocked(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.ocGroup != null) {
            PDFOCConfig pConfig;
            Boolean lock = (Boolean)Context.jsToJava(value, Boolean.class);
            PDFOCProperties ocgProperties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
            if (ocgProperties != null && (pConfig = ocgProperties.getDefaultOCConfigDict()) != null) {
                PDFOCGroupArray groupArr = pConfig.getLocked();
                if (lock.booleanValue()) {
                    if (groupArr != null) {
                        groupArr.add(this.ocGroup);
                    } else {
                        pConfig.setLocked(PDFOCGroupArray.newInstance(this.ocGroup.getPDFDocument(), this.ocGroup));
                    }
                } else {
                    pConfig.getLocked();
                    if (groupArr != null) {
                        groupArr.remove(this.ocGroup);
                    }
                }
            }
        }
    }

    public Object getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.ocGroup != null) {
            return this.ocGroup.getName();
        }
        return Undefined.instance;
    }

    public void setName(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.ocGroup != null) {
            String name = (String)Context.jsToJava(value, String.class);
            this.ocGroup.setName(name);
        }
    }

    public Object getState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.ocGroup != null) {
            JSStateListener listener = (JSStateListener)this.ocGroup.getPDFDocument().getListenerRegistry().getListener(JSStateListener.class);
            PDFOCUsage usage = this.ocGroup.getUsage();
            ASName view = null;
            if (usage != null) {
                view = usage.getView();
            }
            if (listener != null) {
                OCManager ocMgr;
                JSStateListener.OCGS ocgs = listener.ocgMap.get(this.ocGroup.getCosObject().getObjNum());
                if (ocgs != null) {
                    return ocgs.state;
                }
                PDFOCProperties properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
                if (properties != null && (ocMgr = OCManager.newInstance(properties)) != null) {
                    ocgs = new JSStateListener.OCGS();
                    listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                    ocgs.state = ocMgr.isVisible(this.ocGroup);
                    return ocgs.state;
                }
            } else {
                OCManager ocMgr;
                if (view != null) {
                    listener = new JSStateListener();
                    JSStateListener.OCGS ocgs = new JSStateListener.OCGS();
                    listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                    ocgs.state = view.asString().equalsIgnoreCase("ON");
                    return ocgs.state;
                }
                listener = new JSStateListener();
                this.ocGroup.getPDFDocument().getListenerRegistry().registerListener(JSStateListener.class, listener);
                PDFOCProperties properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
                if (properties != null && (ocMgr = OCManager.newInstance(properties)) != null) {
                    JSStateListener.OCGS ocgs = new JSStateListener.OCGS();
                    listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                    listener.ocgMap.get((Object)Integer.valueOf((int)this.ocGroup.getCosObject().getObjNum())).state = ocMgr.isVisible(this.ocGroup);
                    return ocgs.state;
                }
            }
        }
        return Undefined.instance;
    }

    public void setState(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.ocGroup != null) {
            Boolean inValue = (Boolean)Context.jsToJava(value, Boolean.class);
            JSStateListener listener = (JSStateListener)this.ocGroup.getPDFDocument().getListenerRegistry().getListener(JSStateListener.class);
            if (listener != null) {
                JSStateListener.OCGS ocgs = listener.ocgMap.get(this.ocGroup.getCosObject().getObjNum());
                if (ocgs != null) {
                    JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(((Doc)((Object)this.getParentScope())).getActiveDocument());
                    for (int i = 0; i < ocgs.expressions.size(); ++i) {
                        try {
                            jsHandler.eval(ocgs.expressions.get(i));
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                } else {
                    ocgs = new JSStateListener.OCGS();
                    listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                }
                ocgs.state = (boolean)inValue;
            } else {
                listener = new JSStateListener();
                this.ocGroup.getPDFDocument().getListenerRegistry().registerListener(JSStateListener.class, listener);
                PDFOCProperties properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
                OCManager ocMgr = OCManager.newInstance(properties);
                if (ocMgr != null) {
                    JSStateListener.OCGS ocgs = new JSStateListener.OCGS();
                    ocgs.state = inValue;
                    listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                }
            }
        }
    }

    public Object getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.ocGroup != null) {
            PDFOCIntentList intentList = this.ocGroup.getIntent();
            if (intentList != null) {
                ArrayList<String> arr = new ArrayList<String>();
                Iterator iter = intentList.iterator();
                while (iter.hasNext()) {
                    String intentName = ((ASName)iter.next()).asString();
                    arr.add(intentName);
                }
                if (!arr.isEmpty()) {
                    return arr;
                }
            }
            return ASName.k_View.asString();
        }
        return Undefined.instance;
    }

    public void setAction(Object expression) {
        if (this.ocGroup != null) {
            JSStateListener listener = (JSStateListener)this.ocGroup.getPDFDocument().getListenerRegistry().getListener(JSStateListener.class);
            String jstoEval = (String)Context.jsToJava(expression, String.class);
            if (listener != null) {
                JSStateListener.OCGS ocgs = listener.ocgMap.get(this.ocGroup.getCosObject().getObjNum());
                if (ocgs == null) {
                    ocgs = new JSStateListener.OCGS();
                    listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                }
                ocgs.expressions.add(jstoEval);
            } else {
                listener = new JSStateListener();
                this.ocGroup.getPDFDocument().getListenerRegistry().registerListener(JSStateListener.class, listener);
                try {
                    PDFOCProperties properties = this.ocGroup.getPDFDocument().requireCatalog().getOCProperties();
                    OCManager ocMgr = OCManager.newInstance(properties);
                    if (ocMgr != null) {
                        JSStateListener.OCGS ocgs = new JSStateListener.OCGS();
                        listener.ocgMap.put(this.ocGroup.getCosObject().getObjNum(), ocgs);
                        listener.ocgMap.get((Object)Integer.valueOf((int)this.ocGroup.getCosObject().getObjNum())).expressions.add(jstoEval);
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    throw new IllegalArgumentException("PDF document is invalid", e);
                }
                catch (PDFIOException e) {
                    throw new RuntimeException(e);
                }
                catch (PDFSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void setIntent(Object fields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        if (this.ocGroup != null && fields instanceof NativeArray) {
            NativeArray arr = (NativeArray)fields;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, (Context)Context.getCurrentContext());
            PDFOCIntentList intentList = PDFOCIntentList.newInstance(this.ocGroup.getPDFDocument());
            this.ocGroup.setDictionaryValue(ASName.k_Intent, intentList);
            if (fromJS != null && fromJS.length > 0) {
                for (int i = 0; i < fromJS.length; ++i) {
                    ASName intent = ASName.create((String)fromJS[i]);
                    if (intentList.contains(intent)) continue;
                    this.ocGroup.addIntent(intent);
                }
            } else {
                this.ocGroup.getCosDictionary().remove(ASName.k_Intent);
            }
        }
    }

    public String toString() {
        if (this.ocGroup != null) {
            return this.ocGroup.toString();
        }
        return null;
    }

    public Object valueOf() {
        if (this.ocGroup != null) {
            return this.ocGroup.toString();
        }
        return Undefined.instance;
    }

    PDFOCGroup getOcGroup() {
        return this.ocGroup;
    }

    void setOcGroup(PDFOCGroup ocGroup) {
        this.ocGroup = ocGroup;
    }

    @Override
    public int compareTo(OCG ocg) {
        try {
            PDFOCGroup group = ocg.getOcGroup();
            if (this.ocGroup != null && group != null) {
                return this.ocGroup.getName().compareTo(group.getName());
            }
            throw new RuntimeException("Can not compare null Object");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

