/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.services.javascript.Certificate;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class Rights
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Rights.class", (HashMap)new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, (HashMap)new HashMap<String, Property>(2){
        private static final long serialVersionUID = 1L;
        {
            this.put("mode", new Property(Rights.class, "mode", "getMode", null, null, false, false));
            this.put("rights", new Property(Rights.class, "rights", "getRights", null, null, false, false));
        }
    });
    private static final long serialVersionUID = -2117863893708325589L;
    private static final int bitFormFillInAndSave = 128;
    private static final int bitFormImportExport = 64;
    private static final int bitFormAddDelete = 32;
    private static final int bitSubmitStandalone = 16;
    private static final int bitSpawnTemplate = 8;
    private static final int bitSigning = 4;
    private static final int bitAnnotModify = 2;
    private static final int bitAnnotImportExport = 1;
    private static final int bitBarcodePlaintext = 128;
    private static final int bitAnnotOnline = 64;
    private static final int bitFormOnline = 32;
    private static final int bitEFModify = 16;
    static final String className = "Rights";
    private static final int bitProductionMode = 1;
    private int deploymentMode = 0;
    private List<String> valList = new ArrayList<String>();

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public String getClassName() {
        return className;
    }

    public Object getMode() {
        if (this.isEvaluationMode()) {
            return "Evaluation";
        }
        if (this.isProductionMode()) {
            return "Production";
        }
        return Undefined.instance;
    }

    public Object getRights() {
        return Context.getCurrentContext().newArray(this.getParentScope(), this.valList.toArray());
    }

    void setupRights(byte[] extensionValue) {
        byte[] subrights = null;
        this.deploymentMode = 0;
        if (extensionValue != null) {
            int length = 0;
            block5: for (int i = 4; i < extensionValue.length; ++i) {
                length = Certificate.toInt(extensionValue[i + 1]);
                switch (extensionValue[i]) {
                    case 2: {
                        i += length + 1;
                        continue block5;
                    }
                    case 3: {
                        int j;
                        subrights = new byte[length - 1];
                        i += 2;
                        for (j = 0; j < subrights.length; ++j) {
                            subrights[j] = extensionValue[i + j + 1];
                        }
                        i += subrights.length;
                        continue block5;
                    }
                    case 10: {
                        int j;
                        for (j = 0; j < length; ++j) {
                            this.deploymentMode = this.deploymentMode << 8 | extensionValue[i + j + 1];
                        }
                        i += length + 1;
                    }
                }
            }
            this.setOIDs(subrights);
        }
    }

    private void setOIDs(byte[] oids) {
        boolean isFormFillInAndSave = false;
        if ((oids[0] & 0x80) != 0) {
            this.valList.add("FormFillInAndSave");
            isFormFillInAndSave = true;
        }
        if ((oids[0] & 0x40) != 0) {
            this.valList.add("FormImportExport");
        }
        if ((oids[0] & 0x20) != 0) {
            this.valList.add("FormAddDelete");
        }
        if ((oids[0] & 0x10) != 0) {
            this.valList.add("SubmitStandalone");
        }
        if ((oids[0] & 8) != 0) {
            this.valList.add("SpawnTemplate");
        }
        if ((oids[0] & 4) != 0) {
            this.valList.add("Signing");
        }
        if ((oids[0] & 2) != 0) {
            this.valList.add("AnnotModify");
        }
        if ((oids[0] & 1) != 0) {
            this.valList.add("AnnotImportExport");
        }
        if (oids.length > 1) {
            if ((oids[1] & 0x80) != 0) {
                this.valList.add("BarcodePlaintext");
                if (!isFormFillInAndSave) {
                    this.valList.add("FormFillInAndSave");
                }
            }
            if ((oids[1] & 0x40) != 0) {
                this.valList.add("AnnotOnline");
            }
            if ((oids[1] & 0x20) != 0) {
                this.valList.add("FormOnline");
            }
            if ((oids[1] & 0x10) != 0) {
                this.valList.add("EFModify");
            }
        }
    }

    private boolean isEvaluationMode() {
        return (this.deploymentMode & 1) != 1;
    }

    private boolean isProductionMode() {
        return (this.deploymentMode & 1) == 1;
    }
}

