/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureClassMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPCatalogInfo;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPContentRegion;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPFlow;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPFlowsTree;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPMasterPagesTree;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPPageInfo;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.editablepdf.PDFWPXObjectInfo;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMAcroForms;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMStructure;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PMMEditablePDF {
    private static final ASName[] specialXObjectKeys = new ASName[]{PDFWPFlow.k_Flow, ASName.k_StructTreeRoot, ASName.k_ClassMap};
    private static final ASName[] specialFlowKeys = new ASName[]{ASName.k_Name, ASName.k_F, ASName.k_ClassMap};
    private static final ASName[] specialRegionKeys = new ASName[]{ASName.k_F, ASName.k_N, ASName.k_V, ASName.k_P, ASName.k_O};
    private PDFDocument mTargetDoc;
    private Set<PDFPage> mPagesToProcess;
    private boolean mDeletedPages;
    private Map<String, String> mFlowsMapping = null;
    private Map<PDFWPFlow, PDFWPFlow> mClonedFlows = null;
    private Map<PDFXObject, PDFXObject> mClonedXObjects = null;
    private Map<PDFPage, PDFPage> mClonedPages = null;
    private Map<ASName, ASName> mReplacedClasses = null;
    private Map<PDFWPContentRegion, PDFWPContentRegion> mClonedRegions = null;
    private Map<PDFWPXObjectInfo, PDFWPXObjectInfo> mClonedXObjectsInfo = null;
    private String mSuffix = null;
    private PDFWPFlowsTree mTargetFlows = null;
    private CosCloneMgr mCloneHandler = null;

    PMMEditablePDF(PDFDocument pdfDoc, List<PDFPage> deletedPages) {
        this.mTargetDoc = pdfDoc;
        this.mPagesToProcess = new HashSet<PDFPage>(deletedPages);
        this.mDeletedPages = true;
    }

    PMMEditablePDF(PDFDocument pdfDoc, CosCloneMgr cloneMgr, Map<PDFPage, PDFPage> clonedPages, Map<PDFXObject, PDFXObject> clonedXObjects, Map<ASName, ASName> replacedClasses) {
        this.mTargetDoc = pdfDoc;
        this.mCloneHandler = cloneMgr;
        this.mClonedPages = clonedPages;
        this.mPagesToProcess = clonedPages.keySet();
        this.mDeletedPages = false;
        this.mClonedXObjects = clonedXObjects;
        this.mReplacedClasses = replacedClasses;
    }

    void deletePrivateInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFWPCatalogInfo catalogInfo = PDFWPCatalogInfo.getInstance(this.mTargetDoc);
        if (catalogInfo == null) {
            return;
        }
        PDFWPFlowsTree flows = catalogInfo.getFlows();
        if (flows == null) {
            return;
        }
        Iterator<PDFTree.Entry> flowsIter = flows.iterator();
        while (flowsIter.hasNext()) {
            PDFWPFlow curFlow = (PDFWPFlow)flowsIter.next().getValue();
            PDFWPContentRegion firstRegion = curFlow.getFirstRegion();
            if (firstRegion == null) continue;
            PDFWPContentRegion realFirst = this.getRealRegion(firstRegion, true);
            if (realFirst == null) {
                flowsIter.remove();
                continue;
            }
            PDFWPContentRegion curRegion = realFirst.requireNextRegion();
            while (!PDFUtil.isPDFCosObjectRefEqual(curRegion, realFirst)) {
                if (this.mPagesToProcess.contains(curRegion.getPage()) == this.mDeletedPages) {
                    PDFWPContentRegion previous = curRegion.requirePreviousRegion();
                    PDFWPContentRegion next = curRegion.requireNextRegion();
                    previous.setNextRegion(next);
                    next.setPreviousRegion(previous);
                    curRegion = previous;
                }
                curRegion = curRegion.requireNextRegion();
            }
            curFlow.setFirstRegion(realFirst);
        }
    }

    void mergeWBPieceInfo(PDFDocument srcDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFInteractiveForm targetAcroForm;
        PDFWPFlowsTree srcFlows;
        PDFWPCatalogInfo srcCatalogInfo = PDFWPCatalogInfo.getInstance(srcDoc);
        if (srcCatalogInfo == null) {
            return;
        }
        PDFWPCatalogInfo mTargetCatalogInfo = PDFWPCatalogInfo.getInstance(this.mTargetDoc);
        if (mTargetCatalogInfo == null) {
            mTargetCatalogInfo = PDFWPCatalogInfo.newInstance(this.mTargetDoc, srcCatalogInfo.getVersion());
        }
        if ((srcFlows = srcCatalogInfo.getFlows()) != null) {
            this.mTargetFlows = mTargetCatalogInfo.getFlows();
            this.mSuffix = this.getSuffix(this.mTargetFlows);
        }
        this.mFlowsMapping = new HashMap<String, String>(100);
        this.mClonedFlows = new HashMap<PDFWPFlow, PDFWPFlow>(100);
        this.mClonedRegions = new HashMap<PDFWPContentRegion, PDFWPContentRegion>(100);
        this.mClonedXObjectsInfo = new HashMap<PDFWPXObjectInfo, PDFWPXObjectInfo>(100);
        for (PDFXObject srcXObject : this.mClonedXObjects.keySet()) {
            if (!(srcXObject instanceof PDFXObjectForm)) continue;
            PDFXObjectForm srcForm = (PDFXObjectForm)srcXObject;
            PDFXObjectForm targetForm = (PDFXObjectForm)this.mClonedXObjects.get(srcForm);
            PDFWPXObjectInfo srcXObjInfo = PDFWPXObjectInfo.getInstance(srcForm);
            if (srcXObjInfo == null) continue;
            PDFWPXObjectInfo clonedXObjInfo = this.cloneXObjectInfo(srcFlows, srcXObjInfo);
            clonedXObjInfo.setXObjectInfo(targetForm, srcForm);
        }
        for (PDFPage srcPage : this.mClonedPages.keySet()) {
            PDFWPPageInfo srcInfo = PDFWPPageInfo.getInstance(srcPage);
            if (srcInfo == null) continue;
            PDFWPPageInfo targetInfo = PDFWPPageInfo.newInstance(this.mTargetDoc);
            PDFStructureClassMap srcClasses = srcInfo.getClassMap();
            PDFPage targetPage = this.mClonedPages.get(srcPage);
            if (srcClasses != null) {
                PDFStructureClassMap targetClasses = PDFStructureClassMap.newInstance(this.mTargetDoc);
                PMMStructure.cloneClassMap(this.mCloneHandler, srcClasses, targetClasses, this.mReplacedClasses);
                targetInfo.setClassMap(targetClasses);
            }
            targetInfo.setPageInfo(targetPage, srcPage);
        }
        if (this.mTargetFlows != null) {
            mTargetCatalogInfo.setFlows(this.mTargetFlows);
        }
        mTargetCatalogInfo.setMasterPages(PDFWPMasterPagesTree.newInstance(this.mTargetDoc));
        mTargetCatalogInfo.setCatalogInfo(this.mTargetDoc, srcDoc);
        PDFInteractiveForm srcAcroForm = srcDoc.getInteractiveForm();
        if (srcAcroForm != null && (targetAcroForm = this.mTargetDoc.getInteractiveForm()) == null) {
            targetAcroForm = PMMAcroForms.startAcroForm(srcDoc, this.mTargetDoc, this.mCloneHandler, null);
            this.mTargetDoc.setInteractiveForm(targetAcroForm);
        }
    }

    private PDFWPXObjectInfo cloneXObjectInfo(PDFWPFlowsTree srcFlows, PDFWPXObjectInfo srcInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFStructureClassMap srcClasses;
        if (srcInfo == null) {
            return null;
        }
        PDFWPXObjectInfo clonedInfo = this.mClonedXObjectsInfo.get(srcInfo);
        if (clonedInfo != null) {
            return clonedInfo;
        }
        clonedInfo = PDFWPXObjectInfo.getInstance(CosUtils.cloneOrdinaryKeys(this.mTargetDoc.getCosDocument(), this.mCloneHandler, srcInfo.getCosDictionary(), specialXObjectKeys));
        this.mClonedXObjectsInfo.put(srcInfo, clonedInfo);
        String srcFlowName = srcInfo.getFlowName();
        if (srcFlowName != null) {
            if (srcFlows == null) {
                throw new PDFInvalidDocumentException("Flow " + srcFlowName + " is not defined");
            }
            PDFWPFlow srcFlow = (PDFWPFlow)srcFlows.getEntry(new ASString(srcFlowName));
            if (srcFlow == null) {
                throw new PDFInvalidDocumentException("Flow " + srcFlowName + " is not defined");
            }
            PDFWPFlow targetFlow = this.cloneFlow(srcFlow);
            clonedInfo.setFlowName(targetFlow.getName());
        }
        if ((srcClasses = srcInfo.getClassMap()) != null) {
            PDFStructureClassMap targetClasses = PDFStructureClassMap.newInstance(this.mTargetDoc);
            PMMStructure.cloneClassMap(this.mCloneHandler, srcClasses, targetClasses, this.mReplacedClasses);
            clonedInfo.setClassMap(targetClasses);
        }
        return clonedInfo;
    }

    private PDFWPFlow cloneFlow(PDFWPFlow srcFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (srcFlow == null) {
            return null;
        }
        PDFWPContentRegion srcFirstRegion = this.getRealRegion(srcFlow.getFirstRegion(), true);
        if (srcFirstRegion == null) {
            return null;
        }
        PDFWPFlow clonedFlow = this.mClonedFlows.get(srcFlow);
        if (clonedFlow == null) {
            String srcFlowName;
            String targetFlowName;
            clonedFlow = PDFWPFlow.getInstance(CosUtils.cloneOrdinaryKeys(this.mTargetDoc.getCosDocument(), this.mCloneHandler, srcFlow.getCosDictionary(), specialFlowKeys));
            this.mClonedFlows.put(srcFlow, clonedFlow);
            clonedFlow.setFirstRegion(this.cloneRegion(srcFirstRegion));
            if (this.mTargetFlows == null) {
                this.mTargetFlows = PDFWPFlowsTree.newInstance(this.mTargetDoc);
            }
            if ((targetFlowName = this.mFlowsMapping.get(srcFlowName = srcFlow.getName())) == null) {
                targetFlowName = srcFlowName;
                if (this.mSuffix != null && this.mTargetFlows.getEntry(new ASString(targetFlowName)) != null) {
                    targetFlowName = targetFlowName + this.mSuffix;
                    this.mFlowsMapping.put(srcFlowName, targetFlowName);
                }
            }
            clonedFlow.setName(targetFlowName);
            PDFStructureClassMap srcClasses = srcFlow.getClassMap();
            if (srcClasses != null) {
                PDFStructureClassMap targetClasses = PDFStructureClassMap.newInstance(this.mTargetDoc);
                PMMStructure.cloneClassMap(this.mCloneHandler, srcClasses, targetClasses, this.mReplacedClasses);
                clonedFlow.setClassMap(targetClasses);
            }
            this.mTargetFlows.addEntry(new ASString(targetFlowName), clonedFlow);
        }
        return clonedFlow;
    }

    private PDFWPContentRegion cloneRegion(PDFWPContentRegion srcRegion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (srcRegion == null) {
            return null;
        }
        PDFWPContentRegion clonedRegion = this.mClonedRegions.get(srcRegion);
        if (clonedRegion == null) {
            clonedRegion = PDFWPContentRegion.getInstance(CosUtils.cloneOrdinaryKeys(this.mTargetDoc.getCosDocument(), this.mCloneHandler, srcRegion.getCosDictionary(), specialRegionKeys));
            this.mClonedRegions.put(srcRegion, clonedRegion);
            clonedRegion.setFlow(this.cloneFlow(srcRegion.getFlow()));
            clonedRegion.setNextRegion(this.cloneRegion(this.getRealRegion(srcRegion.requireNextRegion(), true)));
            if (clonedRegion.getNextRegion() == null) {
                clonedRegion.setNextRegion(clonedRegion);
            }
            clonedRegion.setPreviousRegion(this.cloneRegion(this.getRealRegion(srcRegion.requirePreviousRegion(), false)));
            if (clonedRegion.getPreviousRegion() == null) {
                clonedRegion.setPreviousRegion(clonedRegion);
            }
            clonedRegion.setPage(this.mClonedPages.get(srcRegion.requirePage()));
            clonedRegion.requirePage();
            clonedRegion.setFormXObject((PDFXObjectForm)this.mClonedXObjects.get(srcRegion.requireFormXObject()));
        }
        return clonedRegion;
    }

    private String getSuffix(PDFNameTree nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (nameTree == null) {
            return null;
        }
        int suffix = 0;
        Iterator nameIter = nameTree.keyIterator();
        while (nameIter.hasNext()) {
            ASString curName = (ASString)nameIter.next();
            int suffixStart = curName.lastIndexOf(46);
            if (suffixStart < 0 || suffixStart >= curName.getBytes().length - 2 || curName.getBytes()[suffixStart + 1] != 65) continue;
            ASString suffixStr = curName.substring(suffixStart + 2);
            try {
                suffix = Math.max(suffix, Integer.parseInt(new String(suffixStr.getBytes(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not supported.", e);
            }
            catch (Exception exp) {
            }
        }
        return suffix == 0 ? null : 111 + String.valueOf(suffix + 1);
    }

    private PDFWPContentRegion getRealRegion(PDFWPContentRegion first, boolean forward) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFWPFlow flow = first.getFlow();
        PDFWPContentRegion curRegion = first;
        do {
            if (this.mPagesToProcess.contains(curRegion.getPage()) == this.mDeletedPages) continue;
            curRegion.setFlow(flow);
            return curRegion;
        } while ((curRegion = forward ? curRegion.requireNextRegion() : curRegion.requirePreviousRegion()) != first);
        return null;
    }
}

