/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public final class PMMPageTransformations {
    private ASMatrix matrix = ASMatrix.createIdentityMatrix();
    private double rotationAngle = 0.0;

    public void translate(double x, double y) {
        this.matrix = this.matrix.translate(x, y);
    }

    public void scale(double x, double y) throws PDFInvalidParameterException {
        if (x <= 0.0 || y <= 0.0) {
            throw new PDFInvalidParameterException("Invalid non-positive page transformation scale parameter");
        }
        this.matrix = this.matrix.scale(x, y);
    }

    public void rotate(PDFRotation pdfRotation) {
        double r = Math.toRadians(pdfRotation.getValue());
        this.matrix = this.matrix.rotate(r);
        this.rotationAngle += r;
        this.rotationAngle %= Math.PI * 2;
    }

    public void transform(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            return;
        }
        this.transformPageContent(page, this.matrix);
        this.transformAnnotations(page, this.matrix);
    }

    void transformPageContent(PDFPage page, ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ModifiableContent content = ModifiableContent.newInstance(page);
        ContentWriter contentWriter = ContentWriter.newInstance(content);
        ContentModifier.modifyCurrentTransformationMatrix(contentWriter, content.getResources(), matrix);
        Content newContents = contentWriter.close();
        if (newContents != null) {
            page.setContents(newContents.getContents());
            page.setResources(newContents.getResources());
        }
    }

    void transformAnnotations(PDFPage page, ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFAnnotationList pageAnnots = page.getAnnotationList();
        if (pageAnnots == null) {
            return;
        }
        PDFAnnotationIterator annotsIterator = pageAnnots.iterator();
        while (annotsIterator.hasNext()) {
            PDFAnnotation annot = annotsIterator.next();
            annot.transform(matrix, this.rotationAngle);
        }
    }
}

