/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;

public class PDFPageUtils {
    public static void repairPageTree(PDFDocument input) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageUtils.repairNode(input.requirePages());
    }

    private static void repairNode(PDFPageTreeNode currPageNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeList childPageNodesList = PDFPageTreeList.getInstance(currPageNode.getDictionaryCosObjectValue(ASName.k_Kids));
        if (childPageNodesList != null) {
            for (PDFPageTreeNode currChildPageNode : childPageNodesList) {
                if (PDFPageTreeNode.getInstance(currChildPageNode.getDictionaryCosObjectValue(ASName.k_Parent)) != currPageNode) {
                    currChildPageNode.setDictionaryValue(ASName.k_Parent, currPageNode);
                }
                PDFPageUtils.repairNode(currChildPageNode);
            }
        }
    }
}

