/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAExternalSchemas;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAOCConversionMode;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;

public class PDFAConversionOptions
extends PDFAValidationOptions {
    private PDFFilterList lzwReplacementFilterList;
    private PDFFilterList jpxReplacementFilterList;
    private PDFFilterList defaultSubstituteFilterList;
    private ASName inlineImageLZWReplacementFilter;
    private ASDictionary inlineImageLZWReplacementFilterDecodeParams;
    private boolean updatePDFAMetadataOnPartialConversion;
    private PDFAOCConversionMode ocConversionMode = PDFAOCConversionMode.DoNotConvertOptionalContent;
    private ASName ocUsageAppEvent = ASName.k_View;
    private PDFOutputIntent pdfaOutputIntent;
    private boolean overWritePDFAOutputIntent;
    private boolean removeIllegalAnnotations;
    private boolean removeInvisibleNonStandardAnnots;
    private boolean removeHiddenAnnots;
    private boolean removeNoViewAnnots;
    private boolean overrideAnnotationFlags;
    private PDFColorSpace defaultRGBColorSpace;
    private PDFColorSpace defaultCMYKColorSpace;
    private PDFColorSpace defaultGrayColorSpace;
    private boolean removeIllegalActions;
    private boolean removeIllegalAdditionalActions;
    private boolean removeNonNormalAnnotAppearances;
    private boolean removeXFA;
    private boolean removeJavaScriptNameTree;
    private boolean removeEmbeddedFilesNameTree;
    private boolean removeIllegalInterpolation;
    private PDFRenderingIntent renderingIntent;
    private boolean removeImageAlternates;
    private boolean removeXObjectOPI;
    private boolean removeFormXObjectPS;
    private boolean removeReferenceXObjects;
    private boolean removePostScriptXObjects;
    private boolean removeTransferFunctions;
    private boolean shouldEmbedFonts;
    private PDFAExternalSchemas externalSchemas;
    private boolean removeTransparentGroupDict;
    private boolean fallbackToRaster;
    private int resolution;
    private static final int DEFAULT_RESOLUTION = 2;
    private static final int MIN_RESOLUTION = 1;
    private static final int MAX_RESOLUTION = 3;

    public boolean isFallbackToRaster() {
        return this.fallbackToRaster;
    }

    public int getResolution() {
        if (this.isFallbackToRaster()) {
            return this.resolution;
        }
        return -1;
    }

    public void setFallbackToRaster(boolean fallbackToRaster) {
        this.fallbackToRaster = fallbackToRaster;
        this.resolution = 2;
    }

    public void setFallbackToRaster(boolean fallbackToRaster, int resolution) {
        this.fallbackToRaster = fallbackToRaster;
        if (resolution >= 1 && resolution <= 3) {
            this.resolution = resolution;
        } else {
            this.setFallbackToRaster(fallbackToRaster);
        }
    }

    public PDFFilterList getLZWReplacementFilterList() {
        return this.lzwReplacementFilterList;
    }

    public void setLZWReplacementFilterList(PDFFilterList lzwReplacementFilterList) {
        this.lzwReplacementFilterList = lzwReplacementFilterList;
    }

    public PDFFilterList getJPXDecodeReplacementFilterList() {
        return this.jpxReplacementFilterList;
    }

    public void setJPXDecodeReplacementFilterList(PDFFilterList jpxReplacementFilterList) {
        this.jpxReplacementFilterList = jpxReplacementFilterList;
    }

    public PDFFilterList getDefaultSubstituteFilterList() {
        return this.defaultSubstituteFilterList;
    }

    public void setDefaultSubstituteFilterList(PDFFilterList filterList) {
        this.defaultSubstituteFilterList = filterList;
    }

    public void setInlineImageLZWReplacementFilter(ASName newFilter, ASDictionary newDecodeParams) {
        this.inlineImageLZWReplacementFilter = newFilter;
        this.inlineImageLZWReplacementFilterDecodeParams = newDecodeParams;
    }

    public ASName getInlineImageLZWReplacementFilter() {
        return this.inlineImageLZWReplacementFilter;
    }

    public ASDictionary getInlineImageLZWReplacementFilterDecodeParams() {
        return this.inlineImageLZWReplacementFilterDecodeParams;
    }

    public void setUpdatePDFAMetadataOnPartialConversion(boolean update) {
        this.updatePDFAMetadataOnPartialConversion = update;
    }

    public boolean getUpdatePDFAMetadataOnPartialConversion() {
        return this.updatePDFAMetadataOnPartialConversion;
    }

    public boolean getRemoveOptionalContent() {
        return this.ocConversionMode != PDFAOCConversionMode.DoNotConvertOptionalContent;
    }

    public void setOCConversionMode(PDFAOCConversionMode ocConversionMode, ASName ocUsageAppEvent) {
        this.ocConversionMode = ocConversionMode;
        this.ocUsageAppEvent = ocUsageAppEvent != null ? ocUsageAppEvent : ASName.k_View;
    }

    public PDFAOCConversionMode getOCConversionMode() {
        return this.ocConversionMode;
    }

    public ASName getOCUsageAppEvent() {
        return this.ocUsageAppEvent;
    }

    public void setRemoveXFA(boolean remove) {
        this.removeXFA = remove;
    }

    public boolean getRemoveXFA() {
        return this.removeXFA;
    }

    public void setRemoveJavaScriptNameTree(boolean remove) {
        this.removeJavaScriptNameTree = remove;
    }

    public boolean getRemoveJavaScriptNameTree() {
        return this.removeJavaScriptNameTree;
    }

    public void setRemoveEmbeddedFilesNameTree(boolean remove) {
        this.removeEmbeddedFilesNameTree = remove;
    }

    public boolean getRemoveEmbeddedFilesNameTree() {
        return this.removeEmbeddedFilesNameTree;
    }

    public void setPDFAOutputIntent(PDFOutputIntent pdfaOutputIntent, boolean overWritePDFAOutputIntent) {
        this.pdfaOutputIntent = pdfaOutputIntent;
        this.overWritePDFAOutputIntent = overWritePDFAOutputIntent;
    }

    public PDFOutputIntent getPDFAOutputIntent() {
        return this.pdfaOutputIntent;
    }

    public boolean overWritePDFAOutputIntentSet() {
        return this.overWritePDFAOutputIntent;
    }

    public void setRemoveIllegalAnnotations(boolean removeIllegalAnnotations) {
        this.removeIllegalAnnotations = removeIllegalAnnotations;
    }

    public boolean getRemoveIllegalAnnotations() {
        return this.removeIllegalAnnotations;
    }

    public void setRemoveInvisibleNonStandardAnnots(boolean removeInvisibleNonStandardAnnots) {
        this.removeInvisibleNonStandardAnnots = removeInvisibleNonStandardAnnots;
    }

    public boolean getRemoveInvisibleNonStandardAnnots() {
        return this.removeInvisibleNonStandardAnnots;
    }

    public void setRemoveHiddenAnnots(boolean removeHiddenAnnots) {
        this.removeHiddenAnnots = removeHiddenAnnots;
    }

    public boolean getRemoveHiddenAnnots() {
        return this.removeHiddenAnnots;
    }

    public void setRemoveNoViewAnnots(boolean removeNoViewAnnots) {
        this.removeNoViewAnnots = removeNoViewAnnots;
    }

    public boolean getRemoveNoViewAnnots() {
        return this.removeNoViewAnnots;
    }

    public void setOverrideAnnotationFlags(boolean overrideAnnotationFlags) {
        this.overrideAnnotationFlags = overrideAnnotationFlags;
    }

    public boolean getOverrideAnnotationFlags() {
        return this.overrideAnnotationFlags;
    }

    public void setDefaultColorSpaces(PDFColorSpace defaultRGB, PDFColorSpace defaultCMYK, PDFColorSpace defaultGray) {
        this.defaultRGBColorSpace = defaultRGB;
        this.defaultCMYKColorSpace = defaultCMYK;
        this.defaultGrayColorSpace = defaultGray;
    }

    public PDFColorSpace getDefaultRGBColorSpace() {
        return this.defaultRGBColorSpace;
    }

    public PDFColorSpace getDefaultCMYKColorSpace() {
        return this.defaultCMYKColorSpace;
    }

    public PDFColorSpace getDefaultGrayColorSpace() {
        return this.defaultGrayColorSpace;
    }

    public void setRemoveIllegalActions(boolean remove) {
        this.removeIllegalActions = remove;
    }

    public boolean getRemoveIllegalActions() {
        return this.removeIllegalActions;
    }

    public void setRemoveIllegalAdditionalActions(boolean remove) {
        this.removeIllegalAdditionalActions = remove;
    }

    public boolean getRemoveIllegalAdditionalActions() {
        return this.removeIllegalAdditionalActions;
    }

    public void setRemoveNonNormalAnnotAppearances(boolean remove) {
        this.removeNonNormalAnnotAppearances = remove;
    }

    public boolean getRemoveNonNormalAnnotApperances() {
        return this.removeNonNormalAnnotAppearances;
    }

    public void setRemoveIllegalInterpolation(boolean remove) {
        this.removeIllegalInterpolation = remove;
    }

    public boolean getRemoveIllegalInterpolation() {
        return this.removeIllegalInterpolation;
    }

    public void setOverrideRenderingIntent(PDFRenderingIntent ri) {
        this.renderingIntent = ri;
    }

    public PDFRenderingIntent getOverrideRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRemoveImageAlternates(boolean remove) {
        this.removeImageAlternates = remove;
    }

    public boolean getRemoveImageAlternates() {
        return this.removeImageAlternates;
    }

    public void setRemoveXObjectOPI(boolean remove) {
        this.removeXObjectOPI = remove;
    }

    public boolean getRemoveXObjectOPI() {
        return this.removeXObjectOPI;
    }

    public void setRemoveFormXObjectPSData(boolean remove) {
        this.removeFormXObjectPS = remove;
    }

    public boolean getRemoveFormXObjectPSData() {
        return this.removeFormXObjectPS;
    }

    public void setRemoveReferenceXObjects(boolean remove) {
        this.removeReferenceXObjects = remove;
    }

    public boolean getRemoveReferenceXObjects() {
        return this.removeReferenceXObjects;
    }

    public void setRemovePostScriptXObjects(boolean remove) {
        this.removePostScriptXObjects = remove;
    }

    public boolean getRemovePostScriptXObjects() {
        return this.removePostScriptXObjects;
    }

    public void setRemoveTransferFunctions(boolean remove) {
        this.removeTransferFunctions = remove;
    }

    public boolean getRemoveTransferFunctions() {
        return this.removeTransferFunctions;
    }

    public void setShouldEmbedFonts(boolean shouldEmbedFonts) {
        this.shouldEmbedFonts = shouldEmbedFonts;
    }

    public boolean getShouldEmbedFonts() {
        return this.shouldEmbedFonts;
    }

    public PDFAExternalSchemas getExternalSchemas() {
        return this.externalSchemas;
    }

    public void setExternalSchemas(PDFAExternalSchemas externalSchemas) {
        this.externalSchemas = externalSchemas;
    }

    public boolean isRemoveTransparentGroupDict() {
        return this.removeTransparentGroupDict;
    }

    public void setRemoveTransparentGroupDict(boolean removeTransparentGroupDict) {
        this.removeTransparentGroupDict = removeTransparentGroupDict;
    }
}

