/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFACatalogErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetCatalog
extends PDFAErrorSet {
    public PDFAErrorSetCatalog() {
        super(PDFACatalogErrorCode.class);
    }

    public PDFAErrorSetCatalog(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean openActionNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.openActionNotAllowed);
    }

    public boolean additionalActionsNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.additionalActionsNotAllowed);
    }

    public boolean optionalContentNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.optionalContentNotAllowed);
    }

    public boolean namedEmbeddedFilesNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.namedEmbeddedFilesNotAllowed);
    }

    public boolean certifyingSignatureNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.certifyingSignatureNotAllowed);
    }

    public boolean xfaNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.xfaNotAllowed);
    }

    public boolean namedJavaScriptsNotAllowed() {
        return this.errorCodeSet(PDFACatalogErrorCode.namedJavaScriptsNotAllowed);
    }

    public boolean actionLaunchPresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionLaunchNotAllowed);
    }

    public boolean actionSoundPresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionSoundNotAllowed);
    }

    public boolean actionMoviePresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionMovieNotAllowed);
    }

    public boolean actionResetFormNotPresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionResetFormNotAllowed);
    }

    public boolean actionImportDataPresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionImportDataNotAllowed);
    }

    public boolean actionJavaScriptPresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionJavaScriptNotAllowed);
    }

    public boolean actionSetStatePresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionSetStateNotAllowed);
    }

    public boolean actionNoOpPresent() {
        return this.errorCodeSet(PDFACatalogErrorCode.actionNoOpNotAllowed);
    }

    public boolean nullPageAsDestination() {
        return this.errorCodeSet(PDFACatalogErrorCode.nullPageAsDestination);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFACatalogErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.openActionNotAllowed()) {
            violations.add("open action not allowed");
        }
        if (this.actionLaunchPresent()) {
            violations.add("action launch not allowed");
        }
        if (this.actionSoundPresent()) {
            violations.add("action sound not allowed");
        }
        if (this.actionMoviePresent()) {
            violations.add("action movie not allowed");
        }
        if (this.actionResetFormNotPresent()) {
            violations.add("action resetform not allowed");
        }
        if (this.actionImportDataPresent()) {
            violations.add("action import data not allowed");
        }
        if (this.actionJavaScriptPresent()) {
            violations.add("action javascript not allowed");
        }
        if (this.actionSetStatePresent()) {
            violations.add("action set state not allowed");
        }
        if (this.actionNoOpPresent()) {
            violations.add("action no-op not allowed");
        }
        if (this.additionalActionsNotAllowed()) {
            violations.add("additional actions not allowed");
        }
        if (this.optionalContentNotAllowed()) {
            violations.add("optional content not allowed");
        }
        if (this.namedEmbeddedFilesNotAllowed()) {
            violations.add("named embedded files not allowed");
        }
        if (this.certifyingSignatureNotAllowed()) {
            violations.add("certifying signatures not allowed");
        }
        if (this.xfaNotAllowed()) {
            violations.add("xfa not allowed");
        }
        if (this.namedJavaScriptsNotAllowed()) {
            violations.add("named javascripts not allowed");
        }
        if (this.nullPageAsDestination()) {
            violations.add("destination for action specifies invalid page");
        }
        return super.toString() + " " + violations;
    }
}

