/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.FactoryInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.ShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterAxialShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentImageItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentPathItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentTextItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterCoonsPatchMeshesShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDisplayArea;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterFunctionBasedShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterRadialShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterShadingPattern;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTilingPattern;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterXobject;

class RasterFactory
implements FactoryInterface<RasterGraphicsState, RasterTextState, RasterContentItem, RasterDisplayArea> {
    private int currentID = 0;

    RasterFactory() {
    }

    @Override
    public int getCurrentID() {
        return this.currentID++;
    }

    @Override
    public RasterDisplayArea createDisplayArea(double[] bBox) {
        return new RasterDisplayArea(bBox);
    }

    public RasterContentPathItem createContentPathItem(RasterGraphicsState gState) {
        return new RasterContentPathItem(gState, this.currentID++);
    }

    public RasterContentImageItem createContentImageItem(RasterGraphicsState gState) {
        return new RasterContentImageItem(gState, this.currentID++);
    }

    public RasterContentTextItem createContentTextItem(RasterGraphicsState gState, RasterTextState tState) {
        return new RasterContentTextItem(gState, tState, this.currentID++);
    }

    @Override
    public RasterGraphicsState createGraphicsState() {
        return new RasterGraphicsState();
    }

    @Override
    public XObject<RasterGraphicsState, RasterTextState, RasterContentItem> createXObject(RasterGraphicsState graphicsState) {
        return new RasterXobject(graphicsState, this.currentID++);
    }

    @Override
    public TilingPattern<RasterGraphicsState, RasterTextState, RasterContentItem> createTilingPattern(RasterGraphicsState graphicsState) {
        return new RasterTilingPattern(graphicsState, this.currentID++);
    }

    public ShadingPattern<RasterGraphicsState, RasterTextState, RasterContentItem> createShadingPattern(RasterGraphicsState graphicsState) {
        return new RasterShadingPattern(graphicsState, this.currentID++);
    }

    @Override
    public RasterTextState createTextState() {
        return new RasterTextState();
    }

    @Override
    public ShadingPattern<RasterGraphicsState, RasterTextState, RasterContentItem> createShadingPattern(RasterGraphicsState graphicsState, ShadingPattern.ShadingType shadingType) {
        switch (shadingType) {
            case Axial: {
                return new RasterAxialShading(graphicsState, this.currentID++);
            }
            case Radial: {
                return new RasterRadialShading(graphicsState, this.currentID++);
            }
            case FunctionBased: {
                return new RasterFunctionBasedShading(graphicsState, this.currentID++);
            }
            case CoonsPatchMeshes: {
                try {
                    Class.forName("java.awt.geom.Path2D");
                    return new RasterCoonsPatchMeshesShading(graphicsState, this.currentID++);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            case FreeFormGouraudShadedTriangleMeshes: {
                break;
            }
            case LatticeFormGouraudShadedTriangleMeshes: {
                break;
            }
        }
        return null;
    }
}

