/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

class RasterUtils {
    RasterUtils() {
    }

    static int sat(int red, int green, int blue) {
        return Math.max(Math.max(red, green), blue) - Math.min(Math.min(red, green), blue);
    }

    static int lum(int red, int green, int blue) {
        return (int)Math.round((0.3 * new Double(red) + 0.59 * new Double(green) + 0.11 * new Double(blue)) * 255.0);
    }

    static double RGBToLuminance(double red, double green, double blue) {
        return (int)(red * 4915.0 + green * 9667.0 + blue * 1802.0 + 8192.0) >> 14;
    }

    static double[] ClipColor(double ioR, double ioG, double ioB, double lum) {
        double wMax;
        int maxColor = 255;
        double[] result = new double[3];
        double red = ioR;
        double green = ioG;
        double blue = ioB;
        double wMin = Math.min(Math.min(red, green), blue);
        if (wMin < 0.0) {
            wMin = lum - wMin;
            red = lum + (red - lum) * lum / wMin;
            green = lum + (green - lum) * lum / wMin;
            blue = lum + (blue - lum) * lum / wMin;
        }
        if ((wMax = Math.max(Math.max(red, green), blue)) > (double)maxColor) {
            red = lum + (red - lum) * ((double)maxColor - lum) / (wMax -= lum);
            green = lum + (green - lum) * ((double)maxColor - lum) / wMax;
            blue = lum + (blue - lum) * ((double)maxColor - lum) / wMax;
        }
        result[0] = red;
        result[1] = green;
        result[2] = blue;
        return result;
    }

    static double[] SetGap(double[] dstColor, double gap, int maxIndex, int midIndex, int minIndex) {
        int n = midIndex;
        dstColor[n] = dstColor[n] - dstColor[minIndex];
        int n2 = maxIndex;
        dstColor[n2] = dstColor[n2] - dstColor[minIndex];
        if (dstColor[maxIndex] != 0.0) {
            dstColor[midIndex] = dstColor[midIndex] * gap / dstColor[maxIndex];
            dstColor[maxIndex] = gap;
        }
        dstColor[minIndex] = 0.0;
        return dstColor;
    }
}

