/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rcg.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextBodyAttributes;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextEmptyLineReplacer;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHrefToSpanConverter;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextRedundantSpaceRemover;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextRootTagCorrector;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class RichTextHandler {
    private static final String BODY_START = "<body";
    private static final String XML_START = "<?xml";
    private static final String XML_PROCESS = "<?xml version=\"1.0\"?>";
    private static final String NAMESPACES_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String BODY_XFA = "http://www.xfa.org/schema/xfa-data/1.0/";
    private static final String BODY_URI = "http://www.w3.org/1999/xhtml";
    private static final String BODY_NAME = "body";
    private static final String PARA_NAME = "p";
    private static HashMap<Integer, HashMap<String, String>> spanSet = new HashMap();
    private static final String XHTML_BODYTAG = "http://www.w3.org/1999/xhtmlbody";
    private static final String XHTML_PARATAG = "http://www.w3.org/1999/xhtmlp";
    private static final String TEXTKEY = "text";
    private static final String SPANTAG = "span";
    private static final String XHTML_SPANTAG = "http://www.w3.org/1999/xhtmlspan";
    public static final String TEXTALIGNKEY = "text-align";
    private static int index = 0;
    private static HashMap<String, String> style = new HashMap();
    private static final BodyAttributesDefinitions[] bodyAttributes = new BodyAttributesDefinitions[]{new BodyAttributesDefinitions("", "xmlns", "", "CDATA", "http://www.w3.org/1999/xhtml"), new BodyAttributesDefinitions("http://www.w3.org/1999/xhtml", "xfa", "APIVersion", "CDATA", "Acroform:2.2"), new BodyAttributesDefinitions("http://www.w3.org/1999/xhtml", "xfa", "spec", "CDATA", "2.1"), new BodyAttributesDefinitions("http://www.w3.org/1999/xhtml", "xmlns", ":xfa", "CDATA", "http://www.xfa.org/schema/xfa-data/1.0/")};
    private ByteArrayOutputStream mFakeOutput = null;
    private String mRawContent = null;
    private boolean isBodyStyleNull = false;
    private static final String PARANUMBER = "paraNumber";
    public static final String FONTFAMILY = "font-family";
    public static final String TEXT = "text";
    public static final String UNDERLINE = "underline";
    public static final String FONTSIZE = "font-size";
    private static final String TEXTSIZE = "textSize";
    public static final String COLOR = "color";
    private static final String TEXTCOLOR = "textColor";
    private static final String SUPERSCRIPT = "superscript";
    private static final String SUBSCRIPT = "subscript";
    private static final String STRIKETHROUGH = "strikethrough";
    public static final String FONTWEIGHT = "font-weight";
    private static final String FONTSTYLE = "fontStyle";
    private static final String FONTSTRETCH = "fontStretch";
    private static final String TEXTALIGN = "text-align";
    public static final String LINETHROUGH = "line-through";
    private static final String ALIGNMENT = "alignment";
    public static final String UNDERLINELINETHROUGH = "underline line-through";
    public static final String SUPERSCRIPTVALUE = "+0.0pt";
    public static final String SUBSCRIPTVALUE = "-0.0pt";
    public static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String CENTER = "center";
    public static final String NORMAL = "normal";
    public static final String FONTSTRETCHKEY = "font-stretch";
    public static final String FONTSTYLEKEY = "font-style";
    public static final String TEXTDECORATION = "text-decoration";
    public static final String VERTICALALIGN = "vertical-align";
    private static final String SANSSERIF = "sans-serif";
    private static final String FONTWEIGHTNORMAL = "400";
    private static final String BLACK = "#000000";
    private static final String DEFAULTFONT = "12.0";
    private static final Pattern PARA_PATTERN = Pattern.compile("(<p[^>]*>.*?</p>)");
    private static final Pattern BODY_PATTERN = Pattern.compile("<body[^>]*?/>");

    public static String removeXMLPrefix(String richText) {
        if (richText == null) {
            return null;
        }
        int xmlStart = richText.indexOf(XML_START);
        if (xmlStart >= 0) {
            int bodyStart = richText.indexOf(60, xmlStart + 1);
            richText = richText.substring(bodyStart);
        }
        richText = XML_PROCESS + richText;
        return richText;
    }

    public String getRawContent(String richText) {
        if (richText == null) {
            return null;
        }
        this.mFakeOutput = new ByteArrayOutputStream();
        CopyRichText richTextProcessor = new CopyRichText(richText);
        try {
            ServicesUtil.transformToXML((XMLReader)richTextProcessor, null, (OutputStream)this.mFakeOutput);
        }
        catch (Exception exp) {
            return null;
        }
        this.mRawContent = richTextProcessor.getRawContent();
        return this.mRawContent;
    }

    public String getRawContent() {
        return this.mRawContent;
    }

    public String getRichText(String richText) {
        if (richText == null) {
            return null;
        }
        int bodyStart = richText.indexOf(BODY_START);
        if (bodyStart < 0) {
            return null;
        }
        this.getRawContent(richText);
        try {
            return this.mFakeOutput.toString("UTF-8");
        }
        catch (UnsupportedEncodingException exp) {
            throw new RuntimeException("encoding not supported.", exp);
        }
    }

    public static String getRichTextForValue(PDFField pdfField, char passwordChar, boolean isXFAProcessed, AppearanceAttributes appearanceAttributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ArrayList values = null;
        if (pdfField instanceof PDFFieldText) {
            values = pdfField.getValueList();
            if (!isXFAProcessed && pdfField.getPDFDocument().getInteractiveForm().dictionaryContains(ASName.k_XFA) && values == null) {
                values = pdfField.getDefaultValueList();
            }
            if (values != null) {
                ArrayList parsedValues = new ArrayList();
                for (int idx = 0; idx < values.size(); ++idx) {
                    String value = (String)values.get(idx);
                    if (value == null || value.length() <= 0) continue;
                    RichTextHandler.parseMultilineText(parsedValues, value);
                }
                if (parsedValues.isEmpty()) {
                    return null;
                }
                values = parsedValues;
                if (((PDFFieldText)pdfField).isPassword()) {
                    ArrayList<String> maskedValues = new ArrayList<String>();
                    for (int idx = 0; idx < values.size(); ++idx) {
                        String value = (String)values.get(idx);
                        if (value == null || value.length() <= 0) continue;
                        char[] mask = new char[value.length()];
                        Arrays.fill(mask, passwordChar);
                        maskedValues.add(new String(mask));
                    }
                    if (maskedValues.isEmpty()) {
                        return null;
                    }
                    values = maskedValues;
                }
            }
        } else if (pdfField instanceof PDFFieldChoice) {
            ArrayList arrayList = values = ((PDFFieldChoice)pdfField).isComboBox() ? RichTextHandler.getValueForComboBox((PDFFieldChoice)pdfField) : ((PDFFieldChoice)pdfField).getOptionList();
        }
        if (appearanceAttributes != null) {
            appearanceAttributes.setRawValuesList(values);
        }
        if (values == null) {
            return null;
        }
        return RichTextHandler.convertString2RichText(values);
    }

    public static String getRichTextForValue(PDFField pdfField, char passwordChar, boolean isXFAProcessed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return RichTextHandler.getRichTextForValue(pdfField, passwordChar, isXFAProcessed, null);
    }

    private static void parseMultilineText(List values, String value) {
        String[] multiValues = value.split("(\n\r)|(\r\n)|[\n\r]");
        values.addAll(Arrays.asList(multiValues));
    }

    public static String convertString2RichText(List simpleStrings) throws PDFInvalidParameterException {
        if (simpleStrings == null || simpleStrings.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        int sizeOfSimpleStrings = simpleStrings.size();
        for (int i = 0; i < sizeOfSimpleStrings; ++i) {
            if (simpleStrings.get(i) instanceof List) {
                List subList = (List)simpleStrings.get(i);
                for (String tempString : subList) {
                    if (tempString == null || tempString.equals("")) continue;
                    sb.append(tempString);
                    break;
                }
                if (sb.length() == 0) continue;
                break;
            }
            String tempString = (String)simpleStrings.get(i);
            if (tempString == null || tempString.equals("")) continue;
            sb.append(tempString);
        }
        if (sb.length() == 0) {
            return null;
        }
        CreateRichText richTextBlob = new CreateRichText(simpleStrings);
        ByteArrayOutputStream richTextXML = new ByteArrayOutputStream();
        try {
            richTextBlob.setFeature(NAMESPACES_PREFIXES, true);
            richTextBlob.setFeature(NAMESPACES, true);
            ServicesUtil.transformToXML((XMLReader)richTextBlob, null, (OutputStream)richTextXML);
            String richText = richTextXML.toString("UTF-8");
            return RichTextHandler.removeXMLPrefix(richText);
        }
        catch (PDFInvalidXMLException exp) {
            throw new PDFInvalidParameterException("Unable to build XML from the text.", exp);
        }
        catch (UnsupportedEncodingException exue) {
            throw new RuntimeException("UTF8 encoding is not supported.", exue);
        }
    }

    private static List getValueForComboBox(PDFFieldChoice field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<String> valueList = null;
        if (field.isComboBox()) {
            String value = null;
            if (!field.hasIndexArray()) {
                if (field.getValueList() != null && field.getValueList().size() > 0) {
                    if (field.getValueList().size() > 1) {
                        throw new PDFInvalidDocumentException("There are " + field.getIndexArray().length + " values selected for comb box " + field.getQualifiedName());
                    }
                    if (field.getOptionList() != null && field.getOptionList().size() > 0) {
                        try {
                            value = PDFFieldUtils.getSelectedNameForChoiceField((String)field.getValueList().get(0), field.getOptionList(), field.getQualifiedName());
                            if (value == null) {
                                return null;
                            }
                        }
                        catch (PDFInvalidDocumentException e) {
                            value = (String)field.getValueList().get(0);
                        }
                    }
                }
            } else if (field.getIndexArray() != null) {
                int[] indexArray = null;
                if (field.getIndexArray().length != 1) {
                    throw new PDFInvalidDocumentException("There are " + field.getIndexArray().length + " values selected for comb box " + field.getQualifiedName());
                }
                indexArray = field.getIndexArray();
                if (indexArray.length > 0 && field.getOptionList() != null && field.getOptionList().size() > 0) {
                    int idxSelection = indexArray[0];
                    List options = field.getOptionList();
                    if (options.size() > idxSelection) {
                        value = PDFFieldUtils.getValueFromOptions(field.getOptionList().get(idxSelection), field.getQualifiedName());
                    } else if (options.get(0) instanceof ArrayList) {
                        options = (ArrayList)options.get(0);
                        value = PDFFieldUtils.getValueFromOptions(options.get(idxSelection), field.getQualifiedName());
                    }
                }
            }
            if (value != null) {
                valueList = new ArrayList<String>();
                valueList.add(value);
            }
        }
        return valueList;
    }

    private StringBuilder createSpanEntry(HashMap<String, String> spanMapParams, StringBuilder spanArray, HashMap<String, String> bodyStyle, StringBuilder listValue) {
        if (spanMapParams != null && !spanMapParams.isEmpty()) {
            boolean isColon = false;
            spanArray.append("<span style=\"");
            String fontFamilyValue = spanMapParams.get(FONTFAMILY);
            if (fontFamilyValue == null) {
                fontFamilyValue = bodyStyle.get(FONTFAMILY);
                if (fontFamilyValue != null) {
                    spanArray = this.fillSpanArray(spanArray, isColon, FONTFAMILY, fontFamilyValue);
                    isColon = true;
                }
            } else {
                String bodyFontFamily = bodyStyle.get(FONTFAMILY);
                if (bodyFontFamily.equals(fontFamilyValue)) {
                    spanArray = this.fillSpanArray(spanArray, isColon, FONTFAMILY, fontFamilyValue);
                    isColon = true;
                }
            }
            Set<Map.Entry<String, String>> spanEntrySet = spanMapParams.entrySet();
            Iterator<Map.Entry<String, String>> spaniterator = spanEntrySet.iterator();
            String text = null;
            while (spaniterator.hasNext()) {
                Map.Entry<String, String> entry = spaniterator.next();
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.equals(PARANUMBER)) continue;
                if (key.equalsIgnoreCase("text")) {
                    String bodyText = bodyStyle.get("text");
                    if (bodyText != null && bodyText.equalsIgnoreCase(value)) {
                        text = bodyText;
                        continue;
                    }
                    text = value;
                    continue;
                }
                if (bodyStyle.containsKey(key) && bodyStyle.get(key).equals(value)) continue;
                if (key.equalsIgnoreCase("text-align")) {
                    if (!value.equalsIgnoreCase(LEFT) && !value.equalsIgnoreCase(RIGHT) && !value.equalsIgnoreCase(CENTER)) continue;
                    spanArray = this.fillSpanArray(spanArray, isColon, key, value);
                    isColon = true;
                    continue;
                }
                spanArray = this.fillSpanArray(spanArray, isColon, key, value);
                isColon = true;
            }
            spanArray.append("\">");
            if (text != null) {
                spanArray.append(text);
                listValue.append(text);
            }
            spanArray.append("</span>");
        }
        return spanArray;
    }

    public HashMap<String, String> convertIntoSpanMap(HashMap<String, String> spanMapParams) {
        HashMap currentSpanMap = new HashMap();
        currentSpanMap.putAll(spanMapParams);
        Set spanEntrySet = currentSpanMap.entrySet();
        Iterator spanIterator = spanEntrySet.iterator();
        Boolean subscript = null;
        Boolean superscript = null;
        Boolean strikethrough = null;
        Boolean underline = null;
        while (spanIterator.hasNext()) {
            Map.Entry entry = spanIterator.next();
            if (entry == null) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.equalsIgnoreCase("text")) {
                spanMapParams.remove(key);
            }
            if (key.equalsIgnoreCase(ALIGNMENT)) {
                spanMapParams.put("text-align", value);
                continue;
            }
            if (key.equalsIgnoreCase(FONTFAMILY)) {
                spanMapParams.put(FONTFAMILY, value);
                continue;
            }
            if (key.equalsIgnoreCase(FONTSTRETCH)) {
                spanMapParams.put(FONTSTRETCH, value);
                continue;
            }
            if (key.equalsIgnoreCase(FONTSTYLE)) {
                spanMapParams.put(FONTSTYLE, value);
                continue;
            }
            if (key.equalsIgnoreCase(FONTWEIGHT)) {
                spanMapParams.put(FONTWEIGHT, value);
                continue;
            }
            if (key.equalsIgnoreCase(STRIKETHROUGH)) {
                if (value.contains(LINETHROUGH)) {
                    strikethrough = true;
                    continue;
                }
                strikethrough = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase(SUBSCRIPT)) {
                subscript = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase(SUPERSCRIPT)) {
                superscript = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase(TEXTCOLOR)) {
                String[] colorArray = value.split(",");
                StringBuilder builder = new StringBuilder("#");
                for (int i = 1; i <= 3; ++i) {
                    Double component = Double.valueOf(colorArray[i]) * 255.0;
                    String hexValue = Integer.toString(component.intValue(), 16).toUpperCase();
                    if (hexValue.length() < 2) {
                        builder.append("0");
                    }
                    builder.append(hexValue);
                }
                value = builder.toString();
                spanMapParams.put(COLOR, value);
                continue;
            }
            if (key.equalsIgnoreCase(TEXTSIZE)) {
                value = value + "pt";
                spanMapParams.put(FONTSIZE, value);
                continue;
            }
            if (!key.equalsIgnoreCase(UNDERLINE)) continue;
            if (value.contains(UNDERLINE)) {
                underline = true;
                continue;
            }
            underline = Boolean.valueOf(value);
        }
        spanMapParams = ServicesUtil.finalizeSpanMap(spanMapParams, strikethrough, underline, superscript, subscript);
        return spanMapParams;
    }

    private StringBuilder fillSpanArray(StringBuilder spanArray, boolean isColon, String key, String value) {
        if (isColon) {
            spanArray.append(";");
        }
        spanArray.append(key + ":" + value);
        return spanArray;
    }

    public String createRichValue(HashMap<Integer, HashMap<String, String>> richValueMap, HashMap<String, String> bodyStyle, StringBuilder listValue, String richText) {
        if (richValueMap != null && !richValueMap.isEmpty()) {
            StringBuilder spanArray = new StringBuilder("");
            StringBuilder style = new StringBuilder(" style=\"");
            if (this.isBodyStyleNull) {
                style = this.createBodyStyle(bodyStyle, style);
            }
            for (int i = 0; i < richValueMap.size(); ++i) {
                HashMap<String, String> spanMapParams = richValueMap.get(i);
                if (spanMapParams == null) continue;
                if (spanMapParams.get(PARANUMBER) == null) {
                    spanMapParams.put(PARANUMBER, String.valueOf(0));
                }
                if (Integer.valueOf(spanMapParams.get(PARANUMBER)) > 0) {
                    spanArray.append("</p><p dir=\"ltr\">");
                    spanMapParams.put(PARANUMBER, String.valueOf(0));
                }
                if (spanMapParams.isEmpty() || Integer.valueOf(spanMapParams.get(PARANUMBER)) != 0) continue;
                spanArray = this.createSpanEntry(spanMapParams, spanArray, bodyStyle, listValue);
            }
            spanArray.append("</p></body>");
            if (richText != null) {
                if (this.isBodyStyleNull) {
                    int body = richText.indexOf(62, richText.indexOf(BODY_START));
                    return richText.substring(0, body) + style + "><p dir=\"ltr\">" + spanArray.toString();
                }
                int startIndex = richText.indexOf(">", richText.indexOf("<p") + 1) + 1;
                return richText.substring(0, startIndex) + spanArray.toString();
            }
        }
        return null;
    }

    private StringBuilder createBodyStyle(HashMap<String, String> bodyStyle, StringBuilder style) {
        bodyStyle = this.setDefaultStyle(bodyStyle);
        Set<Map.Entry<String, String>> spanEntrySet = bodyStyle.entrySet();
        Iterator<Map.Entry<String, String>> spaniterator = spanEntrySet.iterator();
        boolean isColon = false;
        while (spaniterator.hasNext()) {
            Map.Entry<String, String> entry = spaniterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals(PARANUMBER) || key.equals("text")) continue;
            style = this.fillSpanArray(style, isColon, key, value);
            isColon = true;
        }
        return style.append("\"");
    }

    private HashMap<String, String> setDefaultStyle(HashMap<String, String> bodyStyle) {
        if (bodyStyle != null) {
            if (bodyStyle.get("text-align") == null) {
                bodyStyle.put("text-align", LEFT);
            }
            if (bodyStyle.get(FONTFAMILY) == null) {
                bodyStyle.put(FONTFAMILY, SANSSERIF);
            } else if (bodyStyle.get(FONTFAMILY).contains(",")) {
                bodyStyle.put(FONTFAMILY, bodyStyle.get(FONTFAMILY) + "," + SANSSERIF);
            }
            if (bodyStyle.get(FONTSTRETCHKEY) == null) {
                bodyStyle.put(FONTSTRETCHKEY, NORMAL);
            }
            if (bodyStyle.get(FONTSTYLEKEY) == null) {
                bodyStyle.put(FONTSTYLEKEY, NORMAL);
            }
            if (bodyStyle.get(FONTWEIGHT) == null) {
                bodyStyle.put(FONTWEIGHT, FONTWEIGHTNORMAL);
            }
            if (bodyStyle.get(COLOR) == null) {
                bodyStyle.put(COLOR, BLACK);
            }
            if (bodyStyle.get(FONTSIZE) == null) {
                bodyStyle.put(FONTSIZE, DEFAULTFONT);
            }
        }
        return bodyStyle;
    }

    public static String removeFirstNParaNodesFromRichText(int n, String richText) {
        Matcher m = PARA_PATTERN.matcher(richText);
        StringBuffer sb = new StringBuffer();
        for (int count = 0; m.find() && count < n; ++count) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processRichTextString(String richText) throws PDFIOException, PDFInvalidParameterException {
        String modifiedRichText = richText;
        modifiedRichText = modifiedRichText.replaceAll("<br>", "<br/>");
        modifiedRichText = modifiedRichText.replaceAll("</br>", "");
        modifiedRichText = modifiedRichText.replaceAll("&#13;", "<br/>");
        StringReader richTextReader = new StringReader(modifiedRichText);
        StringWriter richTextWriter = new StringWriter();
        try {
            StreamResult result = new StreamResult(richTextWriter);
            XMLFilter[] filters = new XMLFilter[]{RichTextRootTagCorrector.getInstance(), RichTextHrefToSpanConverter.getInstance(), RichTextRedundantSpaceRemover.getInstance(), RichTextEmptyLineReplacer.getInstance()};
            Source inputSource = XMLUtils.createSource(new InputSource(richTextReader), filters);
            XMLUtils.transformToXML(inputSource, result, true);
            modifiedRichText = richTextWriter.toString();
            modifiedRichText = modifiedRichText.replaceAll("<div([^>]*)>", "<p$1>");
            modifiedRichText = modifiedRichText.replaceAll("</div>", "</p>");
            Matcher m = PARA_PATTERN.matcher(modifiedRichText);
            if (!m.find()) {
                Matcher body_matcher = BODY_PATTERN.matcher(modifiedRichText);
                if (body_matcher.find()) {
                    modifiedRichText = modifiedRichText.replaceFirst("(<body[^>]*?)/>", "$1></body>");
                }
                modifiedRichText = modifiedRichText.replaceFirst("(<body[^>]*>)", "$1<p>");
                modifiedRichText = modifiedRichText.replace("</body>", "</p></body>");
            }
            String string = modifiedRichText;
            return string;
        }
        catch (SAXException e) {
            throw new PDFInvalidParameterException("Error processing Rich Text XML : " + richText, e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidParameterException("Error processing Rich Text XML : " + richText, e);
        }
        finally {
            try {
                richTextReader.close();
            }
            finally {
                try {
                    richTextWriter.close();
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
        }
    }

    public class SpanStyleHandler
    extends DefaultHandler {
        private StringBuilder input = null;
        private boolean requireBuffer = false;
        private String body = null;
        private boolean isPara = false;
        private boolean isSpan = false;
        private HashMap<String, String> span = new HashMap();
        private boolean isMultiLine = false;
        private int paraCount = 0;
        private boolean isSpanMapSet = false;

        public HashMap<String, String> getStyle() {
            return style;
        }

        public HashMap<Integer, HashMap<String, String>> getStyleSet(String richText) {
            try {
                if (richText != null) {
                    SAXParser sp = XMLUtils.getNonValidatingSaxParser();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(richText.getBytes());
                    spanSet.clear();
                    this.span.clear();
                    index = 0;
                    RichTextHandler.this.isBodyStyleNull = false;
                    sp.parse((InputStream)inputStream, (DefaultHandler)new SpanStyleHandler());
                }
                return spanSet;
            }
            catch (SAXException se) {
                throw new RuntimeException("A parsing error occurred. rich text isn't a valid input", se);
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException("Issues in parser configuration", pce);
            }
            catch (IOException ie) {
                throw new RuntimeException("Exception in accessing xml input files", ie);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.requireBuffer = false;
            if (this.input != null && this.isPara && !this.isSpan) {
                this.span.put("text", this.input.toString());
                if (!this.isMultiLine && !this.isSpanMapSet) {
                    this.setSpanMap();
                }
            }
            this.isSpanMapSet = false;
            if (qName.equals(RichTextHandler.PARA_NAME) || qName.equalsIgnoreCase(RichTextHandler.XHTML_PARATAG)) {
                this.isPara = true;
                if (this.paraCount > 0) {
                    this.isMultiLine = true;
                }
                this.span.put(RichTextHandler.PARANUMBER, String.valueOf(this.paraCount++));
                if (this.setSpanMap(attributes)) {
                    HashMap<String, String> currentStyle = new HashMap<String, String>();
                    currentStyle.putAll(this.span);
                    style = currentStyle;
                }
            } else if (qName.equalsIgnoreCase(RichTextHandler.BODY_NAME) || qName.equalsIgnoreCase(RichTextHandler.XHTML_BODYTAG)) {
                if (!this.isPara) {
                    this.body = attributes.getValue("style");
                    if (this.body == null) {
                        RichTextHandler.this.isBodyStyleNull = true;
                    }
                    if (this.setSpanMap(attributes)) {
                        HashMap<String, String> currentStyle = new HashMap<String, String>();
                        currentStyle.putAll(this.span);
                        style = currentStyle;
                    }
                }
            } else if (qName.equalsIgnoreCase(RichTextHandler.SPANTAG) || qName.equalsIgnoreCase(RichTextHandler.XHTML_SPANTAG)) {
                this.span = new HashMap();
                --this.paraCount;
                this.span.put(RichTextHandler.PARANUMBER, String.valueOf(this.paraCount++));
                this.span.putAll(style);
                this.setSpanMap(attributes);
                this.isSpan = true;
            }
            if (this.isPara && this.input != null && !this.isSpan && this.input != null && !this.isMultiLine) {
                this.span.put("text", this.input.toString());
                this.setSpanMap();
            }
        }

        private void setStyleMap(HashMap<String, String> currentStyle) {
            if (!this.isMultiLine || spanSet.isEmpty()) {
                if (currentStyle != null && !currentStyle.isEmpty()) {
                    style = currentStyle;
                }
            } else {
                HashMap<String, String> bodyStyle = new HashMap();
                if (currentStyle != null && !currentStyle.isEmpty()) {
                    bodyStyle = currentStyle;
                }
                for (int i = 0; i < spanSet.size(); ++i) {
                    HashMap styleMap = (HashMap)spanSet.get(i);
                    bodyStyle = this.calculateIntersection(styleMap, bodyStyle);
                }
                style = bodyStyle;
            }
        }

        private HashMap<String, String> calculateIntersection(HashMap<String, String> styleMapOne, HashMap<String, String> StyleMapTwo) {
            if (styleMapOne != null && StyleMapTwo != null && !styleMapOne.isEmpty() && !StyleMapTwo.isEmpty()) {
                HashMap<String, String> bodyStyleMap = new HashMap<String, String>();
                Set<Map.Entry<String, String>> entrySetOne = styleMapOne.entrySet();
                for (Map.Entry<String, String> entry : entrySetOne) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    String comprableValue = StyleMapTwo.get(key);
                    if (comprableValue == null || !comprableValue.equals(value)) continue;
                    bodyStyleMap.put(key, value);
                }
                return bodyStyleMap;
            }
            if (styleMapOne == null || styleMapOne.isEmpty()) {
                return StyleMapTwo;
            }
            if (StyleMapTwo == null || StyleMapTwo.isEmpty()) {
                return styleMapOne;
            }
            return null;
        }

        private boolean setSpanMap(Attributes attributes) {
            this.body = attributes.getValue("style");
            if (this.body != null) {
                String[] values = this.body.split(";");
                for (int i = 0; i < values.length; ++i) {
                    String[] properties = values[i].split(":");
                    if (properties[0].equalsIgnoreCase("text-align")) {
                        if (!properties[1].equalsIgnoreCase(RichTextHandler.LEFT) && !properties[1].equalsIgnoreCase(RichTextHandler.RIGHT) && !properties[1].equalsIgnoreCase(RichTextHandler.CENTER)) continue;
                        this.span.put(properties[0], properties[1].toLowerCase());
                        continue;
                    }
                    this.span.put(properties[0], properties[1]);
                }
                return true;
            }
            return false;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.requireBuffer = false;
            if (this.isPara && this.input != null) {
                this.span.put("text", this.input.toString());
                if (this.isMultiLine) {
                    this.setSpanMap();
                }
            }
            if (qName.equalsIgnoreCase(RichTextHandler.BODY_NAME) || qName.equalsIgnoreCase(RichTextHandler.XHTML_BODYTAG)) {
                if (spanSet.isEmpty()) {
                    this.setSpanMap();
                } else if (this.isMultiLine) {
                    this.setStyleMap(null);
                }
            } else if (qName.equals(RichTextHandler.PARA_NAME) || qName.equalsIgnoreCase(RichTextHandler.XHTML_PARATAG)) {
                this.isPara = false;
                if (this.input != null) {
                    this.span.put("text", this.input.toString());
                }
                if (spanSet.isEmpty()) {
                    this.setSpanMap();
                    this.span.clear();
                }
            } else if (qName.equalsIgnoreCase(RichTextHandler.SPANTAG) || qName.equalsIgnoreCase(RichTextHandler.XHTML_SPANTAG)) {
                this.isSpan = false;
                this.setSpanMap();
                this.isSpanMapSet = true;
            }
        }

        private void setSpanMap() {
            HashMap<String, String> currentSpan = new HashMap<String, String>();
            currentSpan.putAll(this.span);
            spanSet.put(index, currentSpan);
            index++;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String tempVal = new String(ch, start, length);
            this.input = this.requireBuffer ? this.input.append(tempVal) : new StringBuilder(tempVal);
        }
    }

    private static class CopyRichText
    implements XMLReader {
        private String mRichText;
        private String mRawText;
        ContentHandler mHandler;

        public CopyRichText(String richText) {
            this.mRichText = richText;
            this.mRawText = null;
        }

        public String getRawContent() {
            return this.mRawText;
        }

        @Override
        public void parse(String systemId) {
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.mHandler;
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.mHandler = handler;
        }

        @Override
        public DTDHandler getDTDHandler() {
            return null;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
        }

        @Override
        public EntityResolver getEntityResolver() {
            return null;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
        }

        @Override
        public void parse(InputSource input) {
            XMLUtils.CopyString2Blob richContentHandler = new XMLUtils.CopyString2Blob(this.getContentHandler(), new RichTextBodyAttributes());
            try {
                richContentHandler.copyBlob(this.mRichText);
            }
            catch (Exception exp) {
                this.mRawText = null;
            }
            this.mRawText = richContentHandler.getRawContent();
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }
    }

    private static class CreateRichText
    implements XMLReader {
        private List mContent = null;
        ContentHandler mHandler;

        private CreateRichText(List content) {
            this.mContent = content;
        }

        @Override
        public void parse(String systemId) {
        }

        @Override
        public boolean getFeature(String name) {
            return false;
        }

        @Override
        public void setFeature(String name, boolean value) {
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.mHandler;
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.mHandler = handler;
        }

        @Override
        public DTDHandler getDTDHandler() {
            return null;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
        }

        @Override
        public EntityResolver getEntityResolver() {
            return null;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
        }

        @Override
        public void parse(InputSource input) throws SAXException {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.startDocument();
            AttributesImpl bodyAttrs = new AttributesImpl();
            AttributesImpl emptyAttrs = new AttributesImpl();
            for (int attrInd = 0; attrInd < bodyAttributes.length; ++attrInd) {
                bodyAttrs.addAttribute(bodyAttributes[attrInd].getURI(), bodyAttributes[attrInd].getName(), bodyAttributes[attrInd].getPrefix() + bodyAttributes[attrInd].getName(), bodyAttributes[attrInd].getType(), bodyAttributes[attrInd].getValue());
            }
            if (this.mContent == null) {
                return;
            }
            Iterator contentIter = this.mContent.iterator();
            if (contentIter == null) {
                return;
            }
            this.mHandler.startElement(RichTextHandler.BODY_URI, RichTextHandler.BODY_NAME, RichTextHandler.BODY_NAME, bodyAttrs);
            while (contentIter.hasNext()) {
                Object content = contentIter.next();
                if (!(content instanceof String) && !(content instanceof ArrayList)) continue;
                String curLine = null;
                if (content instanceof String) {
                    curLine = (String)content;
                }
                if (content instanceof ArrayList) {
                    if (((ArrayList)content).size() == 1) {
                        curLine = (String)((ArrayList)content).get(0);
                    }
                    if (((ArrayList)content).size() == 2) {
                        curLine = (String)((ArrayList)content).get(1);
                    }
                }
                if (curLine == null) continue;
                this.mHandler.startElement("", RichTextHandler.PARA_NAME, RichTextHandler.PARA_NAME, emptyAttrs);
                char[] charArray = XMLUtils.convertStringToXMLString(curLine).toCharArray();
                this.mHandler.characters(charArray, 0, charArray.length);
                this.mHandler.endElement("", RichTextHandler.PARA_NAME, RichTextHandler.PARA_NAME);
            }
            this.mHandler.endElement(RichTextHandler.BODY_URI, RichTextHandler.BODY_NAME, RichTextHandler.BODY_NAME);
            this.mHandler.endDocument();
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }
    }

    private static class BodyAttributesDefinitions {
        private String mURI;
        private String mPrefix;
        private String mName;
        private String mType;
        private String mValue;

        private BodyAttributesDefinitions(String uri, String prefix, String name, String type, String value) {
            this.mURI = uri;
            this.mPrefix = prefix;
            this.mName = name;
            this.mType = type;
            this.mValue = value;
        }

        String getURI() {
            return this.mURI;
        }

        String getPrefix() {
            return this.mPrefix;
        }

        String getName() {
            return this.mName;
        }

        String getType() {
            return this.mType;
        }

        String getValue() {
            return this.mValue;
        }
    }
}

