/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.pdfParser.ContentStreamParser;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFConversionOptions;
import com.adobe.internal.pdftoolkit.services.swf.SWFDisplayArea;
import com.adobe.internal.pdftoolkit.services.swf.SWFDocument;
import com.adobe.internal.pdftoolkit.services.swf.SWFGraphicsState;
import com.adobe.internal.pdftoolkit.services.swf.SWFTextState;
import java.io.IOException;

public class PDFToSWFConverter {
    public static void toSWF(PDFPage page, PDFFontSet pdfFontSet, SWFConversionOptions conversionOptions, ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        if (conversionOptions == null) {
            conversionOptions = new SWFConversionOptions();
        }
        if (page == null) {
            throw new PDFInvalidParameterException("PDF page can not be null.");
        }
        if (pdfFontSet == null) {
            throw new PDFInvalidParameterException("PDF font set can not be null.");
        }
        SWFDocument swfDoc = new SWFDocument(page.getPDFDocument(), conversionOptions.getVersion());
        ContentStreamParser<SWFGraphicsState, SWFContentItem, SWFTextState, SWFDisplayArea> csParser = new ContentStreamParser<SWFGraphicsState, SWFContentItem, SWFTextState, SWFDisplayArea>(swfDoc, pdfFontSet, conversionOptions.getImagesDownsamplingFactors(), false, null, false);
        SWFDisplayArea displayArea = csParser.processObjectsInPage(page, conversionOptions.getWidth(), conversionOptions.getHeight(), false);
        swfDoc.serializeDisplayArea(displayArea, byteWriter);
    }
}

