/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf;

import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentPathItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFDocumentContext;
import com.adobe.internal.pdftoolkit.services.swf.SWFGraphicsState;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFSprite;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFUtils;
import com.adobe.internal.pdftoolkit.services.swf.utils.ShapeHelper;
import com.adobe.internal.pdftoolkit.services.swf.utils.TypeHelper;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineTag;
import flash.swf.types.FillStyle;
import flash.swf.types.LineStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

class SWFContentPathItem
extends ContentPathItem<SWFGraphicsState>
implements SWFContentItem {
    SWFContentPathItem(SWFGraphicsState graphicsState, int id) {
        super(graphicsState, id);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        boolean fill = this.getPathPaintingType().isFill();
        boolean stroke = this.getPathPaintingType().isStroke();
        if (this.getTransformationMatrix() != null) {
            AffineTransform matrix = new AffineTransform(this.getTransformationMatrix().getValues());
            this.getPath().transform(matrix);
        }
        if (fill) {
            if (((SWFGraphicsState)this.getGState()).getFillTilingPatternName() != null) {
                this.fillWithPattern((SWFDocumentContext)context);
            } else if (stroke && ((SWFGraphicsState)this.getGState()).getStrokeTilingPatternName() == null) {
                this.paintWithColor(fill, stroke, context);
                stroke = false;
            } else {
                this.paintWithColor(fill, false, context);
            }
            fill = false;
        }
        if (stroke) {
            if (((SWFGraphicsState)this.getGState()).getStrokeTilingPatternName() != null) {
                this.strokeWithPattern((SWFDocumentContext)context);
            } else {
                this.paintWithColor(false, stroke, context);
            }
            stroke = false;
        }
    }

    private void paintWithColor(boolean fill, boolean stroke, DocumentContext context) {
        if (!fill && !stroke) {
            return;
        }
        super.writeToDisplayArea(context);
        String pathStr = SWFUtils.getPathString((GeneralPath)this.getPath(), (double)((SWFDocumentContext)context).getPageHeight());
        List shapeRecords = ShapeHelper.path((String)pathStr, (boolean)fill);
        SWFUtils.placeObject((DefineTag)this.createDefineShape(shapeRecords, fill, stroke), null, (SWFSprite)((SWFDocumentContext)context).getDefineSprite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillWithPattern(SWFDocumentContext context) {
        Area origClipPath = ((SWFGraphicsState)this.getGState()).getClipPath();
        try {
            Area currentClipPath = new Area(((SWFGraphicsState)this.getGState()).getClipPath());
            currentClipPath.intersect(new Area(this.getPath()));
            ((SWFGraphicsState)this.getGState()).setClipPath(currentClipPath);
            super.writeToDisplayArea(context);
            this.paintWithPattern(context);
        }
        finally {
            ((SWFGraphicsState)this.getGState()).setClipPath(origClipPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strokeWithPattern(SWFDocumentContext context) {
        Area origClipPath = ((SWFGraphicsState)this.getGState()).getClipPath();
        String fillTilingPatternName = ((SWFGraphicsState)this.getGState()).getFillTilingPatternName();
        try {
            Area clipPath = new Area(new BasicStroke((float)((SWFGraphicsState)this.getGState()).getLineWidth(), ((SWFGraphicsState)this.getGState()).getLineCap().getValue(), ((SWFGraphicsState)this.getGState()).getLineJoin().getValue()).createStrokedShape(this.getPath()));
            ((SWFGraphicsState)this.getGState()).setClipPath(clipPath);
            super.writeToDisplayArea(context);
            ((SWFGraphicsState)this.getGState()).setFillTilingPatternName(((SWFGraphicsState)this.getGState()).getStrokeTilingPatternName());
            this.setPath(new GeneralPath(clipPath), this.getPathPaintingType());
            this.paintWithPattern(context);
        }
        finally {
            ((SWFGraphicsState)this.getGState()).setClipPath(origClipPath);
            ((SWFGraphicsState)this.getGState()).setFillTilingPatternName(fillTilingPatternName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWithPattern(SWFDocumentContext context) {
        SWFSprite oldSprite = context.getDefineSprite();
        TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> tilingPattern = ((SWFGraphicsState)this.getGState()).getLoadedTilingPatterns().get(((SWFGraphicsState)this.getGState()).getFillTilingPatternName());
        Rectangle2D patternVirtualRect = ((GraphicsState)tilingPattern.getGState()).getClipPath().getBounds2D();
        SWFSprite patternSprite = context.getPatternDefineSprite(((SWFGraphicsState)this.getGState()).getFillTilingPatternName());
        if (patternSprite == null) {
            patternSprite = SWFUtils.createDefineSprite((String)"Pattern");
            context.setPatternDefineSprite(((SWFGraphicsState)this.getGState()).getFillTilingPatternName(), patternSprite);
            try {
                context.setDefineSprite(patternSprite);
                tilingPattern.writeToDisplayArea(context);
            }
            finally {
                context.setDefineSprite(oldSprite);
            }
        }
        Rectangle2D virtualRect = this.getPath().getBounds2D();
        int[] posBounds = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        double[] clipBounds = GraphicsUtils.getClipBounds(tilingPattern, virtualRect, patternVirtualRect, posBounds);
        for (int i = posBounds[1]; i < posBounds[3]; ++i) {
            for (int j = posBounds[0]; j < posBounds[2]; ++j) {
                double[] XY = GraphicsUtils.placeCell(j, i, tilingPattern);
                if (!(XY[0] >= clipBounds[0]) || !(XY[1] >= clipBounds[1]) || !(XY[0] <= clipBounds[2]) || !(XY[1] <= clipBounds[3])) continue;
                Matrix matrix = new Matrix();
                matrix.translateY = (int)Math.rint(SWFUtils.toTwips((double)(-(XY[1] + tilingPattern.getPhase()[1]))));
                matrix.translateX = (int)Math.rint(SWFUtils.toTwips((double)(XY[0] + tilingPattern.getPhase()[0])));
                matrix.setScale(1.0, 1.0);
                SWFUtils.placeObject((DefineTag)patternSprite.getDefineSprite(), (Matrix)matrix, (SWFSprite)oldSprite);
            }
        }
    }

    private DefineShape createDefineShape(List<ShapeRecord> shapeRecords, boolean fill, boolean stroke) {
        Rect shapeBounds;
        Rect edgeBounds = ShapeHelper.getBounds(shapeRecords, null, (boolean)stroke, (double)((SWFGraphicsState)this.getGState()).getMiterLimit());
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.shapeRecords = shapeRecords;
        int lineStyleIndex = !stroke ? 0 : 1;
        int fillStyle0Index = !fill ? 0 : 1;
        int fillStyle1Index = 0;
        ShapeHelper.setStyles(shapeRecords, (int)lineStyleIndex, (int)fillStyle0Index, (int)fillStyle1Index, (boolean)false);
        if (fill) {
            FillStyle fillStyle = this.createSolidColorFillStyle();
            sws.fillstyles = new ArrayList(1);
            sws.fillstyles.add(fillStyle);
        }
        if (stroke) {
            LineStyle ls = this.createGenericLineStyle();
            shapeBounds = ShapeHelper.getBounds(shapeRecords, (LineStyle)ls, (boolean)stroke, (double)((SWFGraphicsState)this.getGState()).getMiterLimit());
            LineStyle lineStyle = this.createSolidColorLineStyle();
            sws.linestyles = new ArrayList();
            sws.linestyles.add(lineStyle);
        } else {
            shapeBounds = edgeBounds;
        }
        DefineShape defineShape4 = new DefineShape(83);
        defineShape4.shapeWithStyle = sws;
        defineShape4.bounds = shapeBounds;
        defineShape4.edgeBounds = edgeBounds;
        if (fill) {
            defineShape4.usesFillWindingRule = !this.getPathPaintingType().isOddEven();
        }
        return defineShape4;
    }

    private LineStyle createSolidColorLineStyle() {
        LineStyle ls = this.createGenericLineStyle();
        ls.color = this.createStrokeColor();
        return ls;
    }

    private LineStyle createGenericLineStyle() {
        int startCapStyle;
        LineStyle ls = new LineStyle();
        ls.width = (int)StrictMath.rint(((SWFGraphicsState)this.getGState()).getLineWidth() * 20.0);
        int flags = 0;
        int endCapStyle = startCapStyle = ((SWFGraphicsState)this.getGState()).getLineCap().ordinal();
        int jointStyle = ((SWFGraphicsState)this.getGState()).getLineJoin().ordinal();
        flags |= jointStyle << 4;
        flags |= startCapStyle << 6;
        flags |= endCapStyle << 8;
        if (jointStyle == 2) {
            ls.miterLimit = TypeHelper.fixed8((double)((SWFGraphicsState)this.getGState()).getMiterLimit());
        }
        ls.flags = flags;
        return ls;
    }

    private FillStyle createSolidColorFillStyle() {
        FillStyle fs = new FillStyle();
        fs.color = this.createFillColor();
        fs.type = 0;
        return fs;
    }

    private int createFillColor() {
        return GraphicsUtils.toARGB(((SWFGraphicsState)this.getGState()).getFillColorValues(), ((SWFGraphicsState)this.getGState()).getNonStrokeAlpha());
    }

    private int createStrokeColor() {
        return GraphicsUtils.toARGB(((SWFGraphicsState)this.getGState()).getStrokeColorValues(), ((SWFGraphicsState)this.getGState()).getStrokeAlpha());
    }
}

