/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.StatefulOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ActualText;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterIDGenerator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GStateStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.MarkedContentObject;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ProcessingState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StatefulContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObject;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObjectList;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.TEXObjectProcessingFunction;
import java.awt.geom.IllegalPathStateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class TEContentStreamHandler
extends StatefulOperatorHandler {
    ArrayList textObjectListsArray;
    ProcessingState processState = ProcessingState.PAGE_DESCRIPTION_LEVEL;
    private MarkedContentObject currentMCObj;
    private int IN_STRUCTURED_CONTENT = 0;
    private HashMap<Integer, MarkedContentObject> mcObjects;
    boolean isStructuredPDF = false;
    private static final String OC = "oc";
    private static final String NO_OC = "no_oc";
    private Stack<PDFOCObject> ocContentStack;
    private Stack<String> ocGroupOperatorStack;
    private Stack<TextObject> textObjectStack;
    private boolean ignoreErrors;
    private List<PDFOCObject> referenceOCGroups;
    private boolean ignoreBackgroundContent;
    private boolean extractMarkedContentObjects;
    private TextObjectList textObjects = new TextObjectList(this.ignoreErrors);
    private boolean ignoreArtifact = false;
    private boolean inArtifact = false;
    private ContentStreamProcessor streamProcessor;
    private boolean honourClipPath;
    private ActualText actualText;

    public void setHonourClipPath(boolean honourClipPath) {
        this.honourClipPath = honourClipPath;
    }

    public void setReferenceOCGroups(List<PDFOCObject> referenceOCGroups) {
        this.referenceOCGroups = referenceOCGroups;
    }

    public void setIgnoreBackgroundContent(boolean ignoreBackgroundContent) {
        this.ignoreBackgroundContent = ignoreBackgroundContent;
    }

    public boolean isIgnoreArtifact() {
        return this.ignoreArtifact;
    }

    public void setIgnoreArtifact(boolean ignoreArtifact) {
        this.ignoreArtifact = ignoreArtifact;
    }

    public TEContentStreamHandler(PDFFontSet fontSet, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fontSet = fontSet;
        this.fontCache = new HashMap();
        this.cosToFontMap = new HashMap();
        this.ocContentStack = new Stack();
        this.ocGroupOperatorStack = new Stack();
        this.textObjectStack = new Stack();
        this.streamProcessor = new StatefulContentStreamProcessor(this);
        this.ignoreErrors = ignoreErrors;
        super.setIgnoreErrors(ignoreErrors);
    }

    private void init(ASRectangle clipRect, PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.textObjectListsArray = new ArrayList(1);
        this.mcObjects = new HashMap();
        this.processState = ProcessingState.PAGE_DESCRIPTION_LEVEL;
        GState gstate = null;
        ASMatrix matrix = null;
        PDFRotation rotation = this.currentPage.getRotation();
        if (rotation != null && rotation != PDFRotation.ROTATE_0) {
            matrix = ContentUtil.computeMatrixFromBox(this.currentPage);
            clipRect = clipRect.transform(matrix);
        }
        gstate = this.honourClipPath ? new GState(clipRect) : new GState();
        if (matrix != null) {
            gstate.setCTM(matrix);
        }
        this.gStateStack = new GStateStack<GState>(gstate);
        this.xobjectsCycleDetector = XObjectsCycleDetector.getInstance(document);
        this.currentTextObj = null;
    }

    public List<TextObjectList> extractTextObjects(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharacterIDGenerator.getInstance(page.getPDFDocument()).resetCharacterID();
        this.currentPage = page;
        ASRectangle rect = ContentUtil.getPageCropBox(page);
        this.init(rect, page.getPDFDocument());
        Content content = ContentUtil.getContent(false, page);
        TextObjectList textObjects = this.extractTextObjects(content);
        this.textObjectListsArray.add(textObjects);
        return this.textObjectListsArray;
    }

    public HashMap<Integer, MarkedContentObject> extractMarkedContentObjects(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CharacterIDGenerator.getInstance(page.getPDFDocument()).resetCharacterID();
        this.currentPage = page;
        this.isStructuredPDF = true;
        ASRectangle rect = ContentUtil.getPageCropBox(page);
        this.init(rect, page.getPDFDocument());
        Content content = ContentUtil.getContent(false, page);
        HashMap<Integer, MarkedContentObject> marcedObjects = this.extractMarkedContentObjects(content);
        return marcedObjects;
    }

    TextObjectList extractTextObjects(PDFXObjectForm xObjectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content content = ContentUtil.getContent(false, xObjectForm, null);
        return this.extractTextObjects(content);
    }

    HashMap<Integer, MarkedContentObject> extractMarkedContentObjects(PDFXObjectForm xObjectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content content = ContentUtil.getContent(false, xObjectForm, null);
        return this.extractMarkedContentObjects(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<Integer, MarkedContentObject> extractMarkedContentObjects(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (content != null) {
            this.contentStack.push(content);
            ContentReader reader = null;
            Instruction instruction = null;
            try {
                reader = ContentReader.newInstance(content);
                while (reader.hasNext()) {
                    try {
                        instruction = reader.next();
                        this.streamProcessor.process(instruction);
                        if (instruction.getOperator() == ASName.k_BDC) {
                            if (this.currentMCObj == null) continue;
                            this.currentTextObj = new TextObject(this.currentPage.getPDFDocument(), this.ignoreErrors);
                            this.currentMCObj.addTextObject(this.currentTextObj);
                            this.textObjectStack.push(this.currentTextObj);
                            continue;
                        }
                        if (instruction.getOperator() == ASName.k_BT) {
                            this.textObjectStack.push(this.currentTextObj);
                            continue;
                        }
                        if (instruction.getOperator() != ASName.k_ET && instruction.getOperator() != ASName.k_EMC) continue;
                        if (!this.textObjectStack.isEmpty()) {
                            this.textObjectStack.pop();
                        }
                        if (!this.textObjectStack.isEmpty()) {
                            this.currentTextObj = this.textObjectStack.peek();
                            continue;
                        }
                        this.currentTextObj = null;
                    }
                    finally {
                        try {
                            if (instruction == null) continue;
                            instruction.close();
                        }
                        catch (PDFIOException e) {}
                    }
                }
            }
            catch (PDFCosParseException e) {
                HashMap<Integer, MarkedContentObject> hashMap = this.mcObjects;
                return hashMap;
            }
            catch (PDFInvalidContentException e) {
                HashMap<Integer, MarkedContentObject> hashMap = this.mcObjects;
                return hashMap;
            }
            finally {
                this.contentStack.pop();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
        }
        return this.mcObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextObjectList extractTextObjects(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextObjectList textObjects = new TextObjectList(this.ignoreErrors);
        if (content != null) {
            this.contentStack.push(content);
            ContentReader reader = null;
            try {
                reader = ContentReader.newInstance(content);
                while (reader.hasNext()) {
                    Instruction instruction = reader.next();
                    this.streamProcessor.process(instruction);
                    if (instruction.getOperator() == ASName.k_ET) {
                        TextObject textObject = this.getCurrentTextObject();
                        if (this.currentMCObj != null && this.isStructuredPDF) {
                            this.currentMCObj.addTextObject(this.getCurrentTextObject());
                        } else {
                            textObjects.add(textObject);
                        }
                    }
                    if (instruction.getOperator() != ASName.k_EMC) continue;
                    if (this.currentMCObj != null && this.isStructuredPDF) {
                        this.mcObjects.put(this.currentMCObj.getMcid(), this.currentMCObj);
                    }
                    if (this.processState != ProcessingState.PAGE_DESCRIPTION_LEVEL) continue;
                    this.currentMCObj = null;
                }
            }
            catch (IllegalPathStateException e) {
                TextObjectList textObjectList = textObjects;
                return textObjectList;
            }
            catch (PDFCosParseException e) {
                TextObjectList textObjectList = textObjects;
                return textObjectList;
            }
            catch (PDFIOException e) {
                TextObjectList textObjectList = textObjects;
                return textObjectList;
            }
            catch (PDFInvalidContentException e) {
                TextObjectList textObjectList = textObjects;
                return textObjectList;
            }
            catch (PDFInvalidDocumentException e) {
                TextObjectList textObjectList = textObjects;
                return textObjectList;
            }
            catch (PDFRuntimeException e) {
                TextObjectList textObjectList = textObjects;
                return textObjectList;
            }
            finally {
                this.contentStack.pop();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
        }
        return textObjects;
    }

    ProcessingState getState() {
        return this.processState;
    }

    boolean isStatePageDescriptionLevel() {
        return this.processState == ProcessingState.PAGE_DESCRIPTION_LEVEL;
    }

    boolean isStateTextObject() {
        return this.processState == ProcessingState.TEXT_OBJECT;
    }

    boolean isStatePathObject() {
        return this.processState == ProcessingState.PATH_OBJECT;
    }

    boolean isStateClippingPathObject() {
        return this.processState == ProcessingState.CLIPPING_PATH_OBJECT;
    }

    boolean isStateInlineImageObject() {
        return this.processState == ProcessingState.INLINE_IMAGE_OBJECT;
    }

    @Override
    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pushGState();
    }

    @Override
    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.popGState();
    }

    private boolean toAddTextRun(PDFOCObject ocObject) {
        if (this.ignoreBackgroundContent) {
            if (ocObject == null) {
                return false;
            }
            return this.referenceOCGroups == null || this.referenceOCGroups.contains(ocObject);
        }
        return ocObject == null || this.referenceOCGroups == null || this.referenceOCGroups.contains(ocObject);
    }

    @Override
    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCObject group;
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        PDFOCObject pDFOCObject = group = this.ocContentStack.isEmpty() ? null : this.ocContentStack.peek();
        if (this.inArtifact && !this.ignoreArtifact) {
            this.getGState().setOcGroup(group);
            if (this.toAddTextRun(group)) {
                this.currentTextObj.addTextRun(string, this.getGState(), this.actualText);
            }
        } else if (!this.inArtifact) {
            this.getGState().setOcGroup(group);
            if (this.toAddTextRun(group)) {
                this.currentTextObj.addTextRun(string, this.getGState(), this.actualText);
            }
        } else if (this.inArtifact && this.ignoreArtifact) {
            this.inArtifact = false;
        }
    }

    @Override
    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.TStar(null);
        this.Tj(string, null);
    }

    @Override
    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.Tw(wordSpacing, null);
        this.Tc(charSpacing, null);
        PDFOCObject group = this.ocContentStack.isEmpty() ? null : this.ocContentStack.peek();
        this.getGState().setOcGroup(group);
        if (this.toAddTextRun(group)) {
            this.currentTextObj.addTextRun(string, this.getGState(), this.actualText);
        }
    }

    @Override
    public void TJ(ASArray tjArray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        PDFOCObject group = this.ocContentStack.isEmpty() ? null : this.ocContentStack.peek();
        this.getGState().setOcGroup(group);
        if (this.toAddTextRun(group)) {
            this.currentTextObj.addTextRun(tjArray, this.getGState(), this.actualText);
        }
    }

    @Override
    public TextState getTextState() {
        return this.getGState().getTextState();
    }

    @Override
    public TextObject getCurrentTextObject() {
        return this.currentTextObj;
    }

    @Override
    public void m(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.m(x, y, instruction);
    }

    @Override
    public void l(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.l(x, y, instruction);
    }

    @Override
    public void c(double x1, double y1, double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.c(x1, y1, x2, y2, x3, y3, instruction);
    }

    @Override
    public void v(double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.v(x2, y2, x3, y3, instruction);
    }

    @Override
    public void y(double x1, double y1, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.y(x1, y1, x3, y3, instruction);
    }

    @Override
    public void h(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.h(instruction);
    }

    @Override
    public void re(double x, double y, double width, double height, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.re(x, y, width, height, instruction);
    }

    @Override
    public void S(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.S(instruction);
    }

    @Override
    public void s(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.s(instruction);
    }

    @Override
    public void f(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.f(instruction);
    }

    @Override
    public void fStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.fStar(instruction);
    }

    @Override
    public void B(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.B(instruction);
    }

    @Override
    public void BStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.BStar(instruction);
    }

    @Override
    public void b(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.b(instruction);
    }

    @Override
    public void bStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.bStar(instruction);
    }

    @Override
    public void n(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (!this.honourClipPath) {
            return;
        }
        super.n(instruction);
    }

    @Override
    public void W(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.W(instruction);
    }

    @Override
    public void WStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.honourClipPath) {
            return;
        }
        super.WStar(instruction);
    }

    @Override
    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TEXObjectProcessingFunction function = new TEXObjectProcessingFunction(this, this.ocContentStack);
        this.processXObject(name, instruction, function);
    }

    @Override
    public void BDC(ASName tag, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.processState = ProcessingState.MARKED_CONTENT_OBJECT;
        ++this.IN_STRUCTURED_CONTENT;
        CosDictionary properties = this.getResources().getDictionaryDictionaryValue(ASName.k_Properties);
        if (tag == ASName.k_OC) {
            PDFOCObject item = PDFOCObject.getInstance(properties.getCosDictionary(name));
            this.ocContentStack.push(item);
            this.ocGroupOperatorStack.push(OC);
        } else {
            this.ocGroupOperatorStack.push(NO_OC);
        }
    }

    @Override
    public void BDC(ASName tag, ASDictionary properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isPropertyNotEmpty;
        boolean bl = isPropertyNotEmpty = properties != null && !properties.isEmpty();
        if (isPropertyNotEmpty && properties.containsKey(ASName.k_ActualText)) {
            try {
                ASString actualTextString = properties.getString(ASName.k_ActualText);
                if (actualTextString != null) {
                    this.actualText = new ActualText(actualTextString.toString());
                }
            }
            catch (PDFUnableToCompleteOperationException e) {
                // empty catch block
            }
        }
        this.ocGroupOperatorStack.push(NO_OC);
        if (this.processState != ProcessingState.MARKED_CONTENT_OBJECT && this.processState != ProcessingState.TEXT_OBJECT || this.IN_STRUCTURED_CONTENT == 0) {
            this.processState = ProcessingState.MARKED_CONTENT_OBJECT;
        }
        ++this.IN_STRUCTURED_CONTENT;
        ASNumber mcid = (ASNumber)(!isPropertyNotEmpty ? null : properties.get(ASName.k_MCID));
        if (mcid != null) {
            this.currentMCObj = new MarkedContentObject(this.ignoreErrors);
            this.currentMCObj.setMcid(mcid.intValue());
        }
        if (tag != null && tag.toString().substring(1).equalsIgnoreCase("Artifact")) {
            this.inArtifact = true;
        }
    }

    @Override
    public void BMC(ASName tag, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ocGroupOperatorStack.push(NO_OC);
    }

    @Override
    public void EMC(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String op = null;
        if (!this.ocGroupOperatorStack.isEmpty()) {
            op = this.ocGroupOperatorStack.pop();
        }
        this.actualText = null;
        if (OC.equals(op)) {
            this.ocContentStack.pop();
        }
        if (this.IN_STRUCTURED_CONTENT != 0) {
            --this.IN_STRUCTURED_CONTENT;
        } else {
            this.processState = ProcessingState.PAGE_DESCRIPTION_LEVEL;
        }
        if (this.currentMCObj != null && this.isStructuredPDF) {
            this.mcObjects.put(this.currentMCObj.getMcid(), this.currentMCObj);
        }
        if (this.processState == ProcessingState.PAGE_DESCRIPTION_LEVEL) {
            this.currentMCObj = null;
        }
    }

    @Override
    public void ET(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.processState != ProcessingState.PAGE_DESCRIPTION_LEVEL) {
            TextObject textObject = this.getCurrentTextObject();
            this.textObjects.add(textObject);
            if (this.currentMCObj != null && this.isStructuredPDF) {
                TextObjectList textObjectsList = this.currentMCObj.getTextObjects();
                Iterator textObjListIter = textObjectsList.iterator();
                while (textObjListIter.hasNext()) {
                    TextObject curTextObject = (TextObject)textObjListIter.next();
                    if (!this.getCurrentTextObject().equals(curTextObject)) continue;
                    return;
                }
                this.currentMCObj.addTextObject(this.getCurrentTextObject());
            } else if (!this.extractMarkedContentObjects) {
                this.textObjects.add(textObject);
            }
        }
    }

    public HashMap<Integer, MarkedContentObject> getMcObjects() {
        return this.mcObjects;
    }

    public TextObjectList getTextObjects() {
        return this.textObjects;
    }

    public void setStructuredPDF(boolean isStructuredPDF) {
        this.isStructuredPDF = isStructuredPDF;
    }
}

