/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectProcessingFunction;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ProcessingState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObjectList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.TEContentStreamHandler;
import java.util.Stack;

class TEXObjectProcessingFunction
implements XObjectProcessingFunction {
    private TEContentStreamHandler teContentStreamHandler;
    private Stack<PDFOCObject> ocContentStack;

    public TEXObjectProcessingFunction(TEContentStreamHandler teContentStreamHandler, Stack<PDFOCObject> ocContentStack) {
        this.teContentStreamHandler = teContentStreamHandler;
        this.ocContentStack = ocContentStack;
    }

    @Override
    public void process(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xObject instanceof PDFXObjectForm) {
            PDFXObjectForm xObjectForm = (PDFXObjectForm)xObject;
            PDFOCObject oc = xObjectForm.getOCObject();
            if (oc != null) {
                this.ocContentStack.push(oc);
            }
            if (xObjectForm.getMatrix() != null) {
                ASMatrix xObjectTM = new ASMatrix(xObjectForm.getMatrix());
                GState gState = this.teContentStreamHandler.getGState();
                gState.setCTM(xObjectTM.concat(gState.getCTM()));
            }
            if (this.teContentStreamHandler.isStructuredPDF && this.teContentStreamHandler.processState == ProcessingState.MARKED_CONTENT_OBJECT) {
                this.teContentStreamHandler.extractMarkedContentObjects(xObjectForm);
            } else {
                TextObjectList textObjects = this.teContentStreamHandler.extractTextObjects(xObjectForm);
                this.teContentStreamHandler.textObjectListsArray.add(textObjects);
            }
            if (oc != null) {
                this.ocContentStack.pop();
            }
        }
    }
}

