/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xbm;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFBookmark;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

final class PDF2XMLBookmarksReader
implements XMLReader {
    XPDFContentHandler ch;
    boolean namespacePrefixes = false;
    private final PDFBookmark first;
    private final ArrayList<?> emitOnly;
    private static final String NAMESPACES_URI = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_URI = "http://xml.org/sax/features/namespace-prefixes";

    public PDF2XMLBookmarksReader(PDFBookmark first) {
        this.first = first;
        this.emitOnly = null;
    }

    public PDF2XMLBookmarksReader(PDFBookmark first, List<?> emitOnly) {
        this.first = first;
        this.emitOnly = new ArrayList(emitOnly);
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXException {
        if (this.ch == null) {
            throw new SAXException("No content handler");
        }
        try {
            this.ch.startDocument();
            this.ch.startRootElement("Bookmarks", this.namespacePrefixes);
            this.walk(this.first, this.emitOnly);
            this.ch.endElement("Bookmarks");
            this.ch.endDocument();
        }
        catch (PDFException e) {
            throw new SAXException("PDFException while generating bookmarks", e);
        }
    }

    private void walk(PDFBookmark b, List<?> emitOnly) throws PDFException, SAXException {
        if (b == null) {
            return;
        }
        if (emitOnly == null || emitOnly != null && emitOnly.contains(b.getTitle())) {
            new XPDFBookmark(b).toXPDF(this.ch, "Bookmark");
        } else {
            this.walk(b.getFirstKid(), emitOnly);
        }
        this.walk(b.getNext(), emitOnly);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.ch = new XPDFContentHandler(handler, "http://ns.adobe.com/pdf/bookmarks", "1.0");
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.ch.getContentHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (NAMESPACES_URI.equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException(NAMESPACES_URI);
            }
        } else if (NAMESPACE_PREFIXES_URI.equals(name)) {
            this.namespacePrefixes = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException {
        if (NAMESPACES_URI.equals(name)) {
            return true;
        }
        if (NAMESPACE_PREFIXES_URI.equals(name)) {
            return this.namespacePrefixes;
        }
        throw new SAXNotRecognizedException(name);
    }
}

