/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xdp;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.NullOutputStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.Base64Engine;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFObject;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLElementCopier;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

class XDP2PDFProcessor {
    private static final String XDP_PREAMBLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xfa generator=\"AdobeDesigner_V7.1\" APIVersion=\"2.4.5277.0\"?>\n<xdp:xdp xmlns:xdp=\"http://ns.adobe.com/xdp/\" timeStamp=\"2006-12-11T15:41:27Z\" uuid=\"498435c1-4a47-4d72-9c6f-75e966555df6\">\n";
    private static final String XDP_POSTAMBLE = "</xdp:xdp>";
    private static final XMLElement XDPElement = new XMLElement("http://ns.adobe.com/xdp/", "xdp", true);
    private static final XMLElement PDFElement = new XFAService.XFAElement("http://ns.adobe.com/xdp/pdf/", "pdf", true);
    private static final XMLElement ChunkElement = new XFAService.XFAElement("http://ns.adobe.com/xdp/pdf/", "chunk", true);
    private static final XMLElement DocumentElement = new XFAService.XFAElement("http://ns.adobe.com/xdp/pdf/", "document", true);
    private static final XMLElement XFDFElement = new XFAService.XFAElement("http://ns.adobe.com/xfdf/", "xfdf", true);
    private static final XMLElement XFDFAnnotsElement = new XFAService.XFAElement("http://ns.adobe.com/xfdf/", "annots", true);

    private XDP2PDFProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PDFDocument processXDP2PDF(ByteReader xdpByteReader, ByteWriter byteWriter, PDFOpenOptions options, boolean importAllXFA) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        PDFDocument pdfDocument;
        InputByteStream xdpIBS = null;
        InputStream xdpStream = null;
        StreamManager streamManager = null;
        OutputByteStream pdfOBS = null;
        try {
            streamManager = StreamManager.newInstance(options.getByteWriterFactory(), byteWriter);
            pdfOBS = streamManager.getOutputByteStream(byteWriter);
            SkippingOutputStream pdfStream = pdfOBS.toOutputStream();
            xdpIBS = streamManager.getInputByteStream(xdpByteReader);
            xdpStream = xdpIBS.toInputStream();
            Map xfaElements = XDP2PDFProcessor.preprocessXDP(xdpStream, pdfStream);
            ByteWriter byteReader = byteWriter;
            byteWriter = null;
            if (byteReader.length() == 0L) {
                throw new PDFInvalidXMLException("Required PDF element missing from XDP");
            }
            pdfDocument = PDFDocument.newInstance(byteReader, options);
            XDP2PDFProcessor.importFromXDP(pdfDocument, xdpIBS, xfaElements, importAllXFA);
        }
        catch (IOException e) {
            throw new PDFIOException("IO exception while reading input XDP file.", e);
        }
        catch (SAXParseException e) {
            throw new PDFInvalidXMLException("Input XDP is not valid.", e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("General SAX error while processing input XDP.", e);
        }
        catch (TransformerException e) {
            throw new PDFConfigurationException("General SAX error while processing input XDP.", e);
        }
        finally {
            try {
                try {
                    if (xdpIBS != null) {
                        xdpIBS.close();
                    }
                }
                finally {
                    try {
                        if (xdpStream != null) {
                            xdpStream.close();
                        }
                    }
                    finally {
                        try {
                            if (pdfOBS != null) {
                                pdfOBS.close();
                            }
                        }
                        finally {
                            if (streamManager != null) {
                                streamManager.close(true);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return pdfDocument;
    }

    static void importXDP2PDF(PDFDocument pdfDocument, InputByteStream xdpIBS, boolean importAllXFA) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        InputStream xdpStream = null;
        try {
            xdpStream = xdpIBS.toInputStream();
            Map xfaElements = XDP2PDFProcessor.preprocessXDP(xdpStream, null);
            XDP2PDFProcessor.importFromXDP(pdfDocument, xdpIBS, xfaElements, importAllXFA);
        }
        catch (IOException e) {
            throw new PDFIOException("IO error with the XDP stream.", e);
        }
        catch (SAXParseException e) {
            throw new PDFInvalidXMLException("Input XDP is not valid.", e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("General SAX error while processing input XDP.", e);
        }
        catch (TransformerException e) {
            throw new PDFConfigurationException("General SAX error while processing input XDP.", e);
        }
        finally {
            if (xdpStream != null) {
                try {
                    xdpStream.close();
                }
                catch (IOException e) {
                    throw new PDFIOException("IO error with the XDP stream.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map preprocessXDP(InputStream xdpStream, OutputStream pdfStream) throws SAXException, TransformerException, IOException {
        FirstPass firstPass = null;
        try (OutputStream base64OS = null;){
            if (pdfStream != null) {
                base64OS = new Base64Engine.OutputDecodeStream(pdfStream);
            }
            firstPass = new FirstPass(base64OS);
            XMLUtils.applyXMLFilter(new InputSource(xdpStream), firstPass, new StreamResult(new NullOutputStream()), false);
            Map<XMLElement, Boolean> map = firstPass.getXFAElements();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFromXDP(PDFDocument pdfDocument, InputByteStream xdpStream, Map xfaElements, boolean importAllXFA) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFConfigurationException, SAXException {
        boolean ensuredXFAExists = false;
        for (Map.Entry entry : xfaElements.entrySet()) {
            InputStream xfaStream;
            XFAService.XFAElement element = (XFAService.XFAElement)entry.getKey();
            if (XFDFElement.equals(element) || PDFElement.equals(element)) continue;
            if (XFDFAnnotsElement.equals(element)) {
                XFDFObject.deleteAnnotations((PDFDocument)pdfDocument);
                if (!Boolean.TRUE.equals(entry.getValue())) continue;
                xdpStream.seek(0L);
                xfaStream = null;
                try {
                    xfaStream = xdpStream.toInputStream();
                    XFDFObject.importAnnotations((InputStream)xfaStream, (PDFDocument)pdfDocument);
                    continue;
                }
                finally {
                    xfaStream.close();
                    continue;
                }
            }
            if (!importAllXFA && !XFAService.XFAElement.DATASETS.equals(element)) continue;
            if (!ensuredXFAExists) {
                XDP2PDFProcessor.ensureXFAExists(pdfDocument);
                ensuredXFAExists = true;
            }
            xdpStream.seek(0L);
            xfaStream = null;
            try {
                xfaStream = xdpStream.toInputStream();
                Source xfaSource = XMLUtils.createSource(new InputSource(xfaStream), new XMLElementCopier(element, true));
                XFAService.importElement(pdfDocument, element, xfaSource);
            }
            finally {
                xfaStream.close();
            }
        }
    }

    private static void ensureXFAExists(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFInvalidXMLException {
        PDFInteractiveForm form = pdfDocument.getInteractiveForm();
        if (form == null) {
            PDFFieldList pdfFields = PDFFieldList.newInstance(pdfDocument);
            form = PDFInteractiveForm.newInstance(pdfDocument, pdfFields);
            pdfDocument.setInteractiveForm(form);
        }
        if (!form.hasXFA()) {
            try {
                PDFXFAArray xfaArray = PDFXFAArray.newInstance(pdfDocument);
                byte[] data = XDP_PREAMBLE.getBytes("UTF-8");
                ByteArrayInputStream xdpStream = new ByteArrayInputStream(data);
                PDFStream stream = PDFStream.newInstance(pdfDocument);
                stream.setStreamData(xdpStream);
                if ((long)data.length >= 15L) {
                    stream.setOutputFilter(ASName.k_FlateDecode);
                }
                xfaArray.insert(0, PDFXFAArray.PREAMBLE, stream);
                data = XDP_POSTAMBLE.getBytes("UTF-8");
                xdpStream = new ByteArrayInputStream(data);
                stream = PDFStream.newInstance(pdfDocument);
                stream.setStreamData(xdpStream);
                if ((long)data.length >= 15L) {
                    stream.setOutputFilter(ASName.k_FlateDecode);
                }
                xfaArray.insert(1, PDFXFAArray.POSTAMBLE, stream);
                form.setXFA(xfaArray);
                pdfDocument.setToSaveVersion(PDFVersion.v1_7);
                pdfDocument.requireCatalog().setNeedsRendering(true);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding is not supported.", e);
            }
        }
    }

    private static class FirstPass
    extends XMLFilterImpl {
        private int nestingLevel = 0;
        private int xdpLevel = -1;
        private Map<XMLElement, Boolean> xfaElements = new LinkedHashMap<XMLElement, Boolean>();
        private XMLElement inElement;
        private boolean inDocumentElement;
        private boolean inPDFElement;
        private boolean inChunkElement;
        private final OutputStream chunkStream;
        private byte[] conversionBuffer = new byte[4096];

        FirstPass(OutputStream chunkStream) {
            this.chunkStream = chunkStream;
        }

        public Map<XMLElement, Boolean> getXFAElements() {
            return this.xfaElements;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            ++this.nestingLevel;
            if (this.inElement != null && this.xfaElements.containsKey(this.inElement)) {
                this.xfaElements.put(this.inElement, Boolean.TRUE);
            }
            if (XDPElement.matches(uri, localName) && this.xdpLevel == -1) {
                this.xdpLevel = this.nestingLevel;
            }
            if (this.nestingLevel == this.xdpLevel + 1) {
                XFAService.XFAElement xfaElement = XFAService.XFAElement.findElement(uri, localName);
                if (xfaElement == null) {
                    xfaElement = new XFAService.XFAElement(uri, localName, true);
                }
                this.inElement = xfaElement;
                this.xfaElements.put(xfaElement, Boolean.FALSE);
            }
            if (PDFElement.matches(uri, localName)) {
                this.inPDFElement = true;
            } else if (this.inPDFElement && DocumentElement.matches(uri, localName)) {
                this.inDocumentElement = true;
            } else if (this.inDocumentElement && ChunkElement.matches(uri, localName)) {
                this.inChunkElement = true;
            } else if (XFDFAnnotsElement.matches(uri, localName)) {
                this.inElement = XFDFAnnotsElement;
                this.xfaElements.put(XFDFAnnotsElement, Boolean.FALSE);
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inChunkElement && this.chunkStream != null) {
                while (length > 0) {
                    int blen = Math.min(length, this.conversionBuffer.length);
                    for (int i = 0; i < blen; ++i) {
                        this.conversionBuffer[i] = (byte)ch[start++];
                    }
                    try {
                        this.chunkStream.write(this.conversionBuffer, 0, blen);
                    }
                    catch (IOException e) {
                        throw new SAXException("Trouble decoding Base64 encoded chunk of XDP file.", e);
                    }
                    length -= blen;
                }
            } else if (this.inElement != null && this.xfaElements.containsKey(this.inElement)) {
                this.xfaElements.put(this.inElement, Boolean.TRUE);
            }
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (PDFElement.matches(uri, localName)) {
                this.inPDFElement = false;
            } else if (this.inDocumentElement && DocumentElement.matches(uri, localName)) {
                this.inDocumentElement = false;
            } else if (this.inChunkElement && ChunkElement.matches(uri, localName)) {
                this.inChunkElement = false;
                try {
                    this.chunkStream.close();
                }
                catch (IOException e) {
                    throw new SAXException("Trouble decoding Base64 encoded chunk of XDP file.", e);
                }
            } else if (this.inElement != null && this.inElement.matches(uri, localName)) {
                this.inElement = null;
            }
            --this.nestingLevel;
            super.endElement(uri, localName, qName);
        }
    }
}

