/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class XFAElementContentFinder
extends DefaultHandler {
    private ArrayList elements;
    private int size;
    private int elementInd;
    private String currentElement;
    private String searchValue;
    private boolean foundAll;
    private boolean contentFound;
    private boolean done;
    StringBuilder elementValue = null;

    XFAElementContentFinder(ArrayList elements, String value) {
        this.elements = elements;
        this.size = elements.size();
        this.elementInd = 0;
        this.foundAll = false;
        this.contentFound = false;
        boolean bl = this.done = this.elementInd >= this.size;
        if (!this.done) {
            this.currentElement = (String)elements.get(this.elementInd);
        }
        this.searchValue = value;
    }

    boolean foundAll() {
        return this.foundAll;
    }

    boolean findContent() {
        return this.contentFound;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String valueString;
        if (this.foundAll && !this.done && !(valueString = new String(ch, start, length)).trim().equals("")) {
            this.elementValue.append(valueString);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.done && localName.equalsIgnoreCase(this.currentElement)) {
            this.elementValue = new StringBuilder(10);
            if (!this.foundAll && this.elementInd >= 0 && this.elementInd < this.size) {
                if (this.elementInd == this.size - 1) {
                    this.foundAll = true;
                } else {
                    this.currentElement = (String)this.elements.get(++this.elementInd);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equalsIgnoreCase(this.currentElement)) {
            if (!this.foundAll && !this.done) {
                --this.elementInd;
                if (this.elementInd >= 0) {
                    this.currentElement = (String)this.elements.get(this.elementInd++);
                }
                this.foundAll = false;
            }
            if (this.foundAll && !this.done) {
                if (this.searchValue != null) {
                    this.contentFound = this.searchValue.equalsIgnoreCase(this.elementValue.toString());
                }
                this.done = true;
            }
        }
    }
}

