/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMProcessor;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFACaption;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.XFA;
import com.adobe.xfa.layout.BoxModelLayout;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.Margins;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;
import java.io.OutputStream;
import java.util.List;

public class XFAUtils {
    public static final String[] g_packets_CommentsAndDefault = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "localeSet", "dataDescription"};
    private static final String INVISIBLE_SIGNATURE_LOCATION_SOM = "$template.#subform";
    private static final String INVISIBLE_SIGNATURE_NAME_LEADING = "$template.#subform..";

    private XFAUtils() {
    }

    public static void saveXFA(PDFDocument pdfDoc) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFAUtils.saveXFA(pdfDoc, null);
    }

    public static void saveXFA(PDFDocument pdfDoc, OutputStream xmlStream) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFADOMProcessor xfaDOMProcessor = new XFADOMProcessor(pdfDoc);
        xfaDOMProcessor.serialize(xmlStream, XFADOMService.getXFAProcessingOptions(pdfDoc));
    }

    public static boolean isSignatureFieldInGoodPosition(PDFDocument pdfDoc, Field sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sigField == null) {
            return false;
        }
        Element fieldNode = sigField.getXFAParent();
        if (fieldNode == null) {
            return false;
        }
        while (fieldNode != null) {
            Attribute attr;
            Element elem = fieldNode.peekElement(XFA.OCCURTAG, false, 0);
            if (elem != null && (attr = elem.getAttribute(XFA.MAXTAG, true, false)) != null && (Integer.valueOf(attr.getAttrValue()) == -1 || Integer.valueOf(attr.getAttrValue()) > 1)) {
                return false;
            }
            fieldNode = fieldNode.getXFAParent();
        }
        return true;
    }

    public static Field getXFASignatureField(PDFDocument pdfDoc, String somExpression) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            List<Field> sigFields = XFAUtils.enumerateXFASignatureFields(pdfDoc);
            return XFAInternalUtils.iterateAndSearchField(sigFields, (String)somExpression);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("No XFA field with som expression " + somExpression + " exists in the XFA", e);
        }
    }

    public static List<Field> enumerateXFASignatureFields(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(pdfDoc).isXFA()) {
            String SIGNATURE_FIELD = "ui.signature";
            XFADOMProcessor xfaDOMProcessor = new XFADOMProcessor(pdfDoc);
            return xfaDOMProcessor.getFieldsFromFormDOM(SIGNATURE_FIELD);
        }
        return null;
    }

    public static Element getFontElement(Field xfaField, boolean resolveProtos) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Element fontElement = null;
        if (xfaField == null) {
            throw new PDFInvalidParameterException("Null field provided. Cannot extract font information");
        }
        try {
            boolean bPeek = true;
            if (resolveProtos) {
                bPeek = false;
            }
            fontElement = xfaField.getElement(XFA.FONTTAG, bPeek, 0, true, false);
            return fontElement;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public static String getLocale(Field sigField, String ambientLocale) {
        LcLocale oLocale;
        String sLocale = null;
        if (sigField.isInstalledLocaleAmbient()) {
            if (ambientLocale != null) {
                sLocale = ambientLocale;
            }
        } else {
            sLocale = sigField.getInstalledLocale();
        }
        if (!(oLocale = new LcLocale(sLocale)).isValid()) {
            oLocale = new LcLocale("en_US");
        }
        return oLocale.getName();
    }

    public static String getAttributeValue(Element xfaElement, String attributeName) throws PDFInvalidParameterException {
        try {
            int numAttrs = xfaElement.getNumAttrs();
            for (int i = 0; i < numAttrs; ++i) {
                if (!xfaElement.getAttrName(i).equals(attributeName)) continue;
                return xfaElement.getAttrVal(i);
            }
            return null;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public static void removeField(PDFDocument pdfDoc, Field field) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
            TemplateModel template = xfaDOM.getTemplateModel();
            if (template == null) {
                throw new PDFInvalidParameterException("Template model not present");
            }
            field.remove();
            XFAInternalUtils.markXFADOMDirty((XFADOM)xfaDOM);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public static ASRectangle getWidgetBoundingBox(BoxModelLayout fieldModel, XFACaption caption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fieldModel == null) {
            return null;
        }
        Rect nominalExtent = fieldModel.getNominalExtent();
        Margins nominalMargin = fieldModel.getNominalExtentMargins();
        ASRectangle widgetBounds = new ASRectangle(XFAUtils.unitspan2PDF(nominalExtent.left()) + XFAUtils.unitspan2PDF(nominalMargin.marginLeft()), XFAUtils.unitspan2PDF(nominalExtent.bottom()) - XFAUtils.unitspan2PDF(nominalMargin.marginBottom()), XFAUtils.unitspan2PDF(nominalExtent.right()) - XFAUtils.unitspan2PDF(nominalMargin.marginRight()), XFAUtils.unitspan2PDF(nominalExtent.top()) + XFAUtils.unitspan2PDF(nominalMargin.marginTop())).normalized();
        XFACaption.Placement placement = caption.getPlacement();
        UnitSpan reserve = caption.getReserve();
        double widgetReserve = XFAUtils.unitspan2PDF(reserve);
        if (placement == XFACaption.Placement.INLINE) {
            throw new PDFUnsupportedFeatureException("A placement of inline is not supported for signature fields");
        }
        if (placement == XFACaption.Placement.LEFT) {
            widgetBounds = new ASRectangle(widgetBounds.left() + widgetReserve, widgetBounds.bottom(), widgetBounds.right(), widgetBounds.top());
        } else if (placement == XFACaption.Placement.RIGHT) {
            widgetBounds = new ASRectangle(widgetBounds.left(), widgetBounds.bottom(), widgetBounds.right() - widgetReserve, widgetBounds.top());
        } else if (placement == XFACaption.Placement.TOP) {
            widgetBounds = new ASRectangle(widgetBounds.left(), widgetBounds.bottom(), widgetBounds.right(), widgetBounds.top() - widgetReserve);
        } else if (placement == XFACaption.Placement.BOTTOM) {
            widgetBounds = new ASRectangle(widgetBounds.left(), widgetBounds.bottom() + widgetReserve, widgetBounds.right(), widgetBounds.top());
        }
        return widgetBounds;
    }

    private static double unitspan2PDF(UnitSpan u) {
        return 72.0 * ((double)u.value() / (double)u.unitsPerInch());
    }

    public static String generateUniqueQualifiedName(String qualifiedName, PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFConfigurationException, PDFInvalidParameterException {
        if (qualifiedName == null || fieldNode == null) {
            return null;
        }
        if (qualifiedName.length() == 0) {
            throw new PDFInvalidParameterException("An empty qualified name is not allowed");
        }
        PDFInteractiveForm iform = fieldNode.getPDFDocument().requireCatalog().procureInteractiveForm();
        if (XFAUtils.isXFAProcessingRequired(fieldNode.getPDFDocument())) {
            if (qualifiedName.indexOf(46) != -1) {
                qualifiedName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
            }
            if (qualifiedName != null && XFAUtils.sigNamePresentInXFA(qualifiedName, iform.getPDFDocument())) {
                return XFAUtils.generateNextXFAFieldName(qualifiedName, iform.getPDFDocument());
            }
            return qualifiedName;
        }
        String currentQualifiedName = fieldNode.getQualifiedName();
        if (currentQualifiedName != null && currentQualifiedName.equals(qualifiedName)) {
            return qualifiedName;
        }
        String[] nodeFullFieldNames = new String[]{qualifiedName};
        String[] allFullFieldNames = PDFFieldUtils.getFullyQualifiedFieldNames(iform);
        if (qualifiedName != null && PDFFieldUtils.qualifiedNamesConflict(nodeFullFieldNames, allFullFieldNames)) {
            return PDFFieldUtils.createNewQualifiedName(fieldNode.getParent(), qualifiedName);
        }
        return qualifiedName;
    }

    private static boolean isXFAProcessingRequired(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        return XFAService.getDocumentType(pdfDoc).isXFA();
    }

    private static boolean sigNamePresentInXFA(String baseSignatureFieldName, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        if (baseSignatureFieldName.indexOf(91) != baseSignatureFieldName.lastIndexOf(91)) {
            throw new PDFInvalidParameterException("The given signature field name " + baseSignatureFieldName + "  contains more than one occurence of [. We cannot check the XFA for it's occurence");
        }
        boolean sigFieldExists = true;
        String fieldExpression = INVISIBLE_SIGNATURE_NAME_LEADING + baseSignatureFieldName;
        XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
        TemplateModel templateModel = xfaDOM.getTemplateModel();
        if (templateModel != null && templateModel.resolveNode(fieldExpression, false, true, false) == null) {
            sigFieldExists = false;
        }
        return sigFieldExists;
    }

    private static String generateNextXFAFieldName(String sigFieldName, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
        return SOMExpressionUtils.computeSOMName((String)INVISIBLE_SIGNATURE_LOCATION_SOM, (TemplateModel)xfaDOM.getTemplateModel()) + "." + XFADOMProcessor.generateIndexedSignatureFieldName((String)sigFieldName, (TemplateModel)xfaDOM.getTemplateModel());
    }
}

