/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.XFAChangeLogger;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.XFAValidationContext;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.PDDoc2CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAIteratorAction;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.Manifest;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.NodeListFilter;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormManifest;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.service.canonicalize.Canonicalize;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Peer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldMDP {
    private PDFDocument pdfDoc;
    private SignatureFieldXFA sigField;
    private Element manifestNode;
    final XFAIteratorAction<List<Node>> populateFieldNodes = new XFAIteratorAction<List<Node>>(){

        public void action(Node node, List<Node> list) {
            list.add(node);
        }
    };
    public final XFAIteratorAction<List<String>> populateFieldNames = new XFAIteratorAction<List<String>>(){

        public void action(Node item, List<String> data) {
            List<String> aExcludedFields;
            TemplateModel template = TemplateModel.getTemplateModel(item.getModel().getAppModel(), false);
            if (template != null && (aExcludedFields = data) != null && (FieldMDP.this.isTemplateField(item) || FieldMDP.this.isTemplateExclGroup(item))) {
                String sSOMExpression = item.getSOMExpression(template, false);
                assert (sSOMExpression.length() > 0);
                if (sSOMExpression.length() > 0) {
                    aExcludedFields.add(sSOMExpression);
                }
            }
        }
    };
    final XFAIteratorAction<List<Node>> lockPermsOnFieldNodes = new XFAIteratorAction<List<Node>>(){

        public void action(Node node, List<Node> list) {
            FieldMDP.this.lockPermsOnFieldNodes(node);
        }
    };
    final XFAIteratorAction<List<Node>> lockAccessOnFieldNodes = new XFAIteratorAction<List<Node>>(){

        public void action(Node node, List<Node> list) {
            FieldMDP.this.lockAccessOnFieldNodes(node);
        }
    };
    final XFAIteratorAction<List<Node>> unlockPermsOnFieldNodes = new XFAIteratorAction<List<Node>>(){

        public void action(Node node, List<Node> list) {
            FieldMDP.this.unlockPermsOnFieldNodes(node);
        }
    };
    final XFAIteratorAction<List<Node>> unlockAccessOnFieldNodes = new XFAIteratorAction<List<Node>>(){

        public void action(Node node, List<Node> list) {
            FieldMDP.this.unlockAccessOnFieldNodes(node);
        }
    };
    final XFAIteratorAction<List<FieldReferenceInfo>> checkReferenceOnFieldNodes = new XFAIteratorAction<List<FieldReferenceInfo>>(){

        public void action(Node node, List<FieldReferenceInfo> list) {
            FieldMDP.isReferenced(node, list);
        }
    };
    private PDFDocument currentPDFDocument;
    private SignatureFieldInterface currentSignatureField;
    private SignatureFieldInterface rollbackSignatureField;
    private CosDocument rollbackCosDocument;
    private PDFDocument rollbackPDFDocument;
    private XFAChangeLogger fieldMDPChangeLogger;
    private Node currentManifestNode = null;
    private Node rollbackManifestNode = null;
    private Field currentXFASignatureField = null;
    private Field rollbackXFASignatureField = null;
    private static boolean debug = false;

    public Element getManifestNode() {
        return this.manifestNode;
    }

    public FieldMDP(PDFDocument pdfDoc, SignatureFieldInterface sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidDocumentException("PDF Document provided is null");
        }
        if (sigField == null) {
            throw new PDFInvalidDocumentException("Signature Field provided is null");
        }
        this.sigField = sigField.getXFAField();
        if (this.sigField == null) {
            throw new PDFInvalidDocumentException("XFA Signature Field found is null");
        }
        this.pdfDoc = pdfDoc;
        this.manifestNode = this.getManifestNode(this.sigField.getXFAFieldSignature());
    }

    public FieldMDP(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this(pdfDoc, new SignatureFieldXFA(pdfDoc, xfaField));
    }

    public List<String> applyFieldMDP(boolean isLockCertifyingField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int i;
        SigFieldLock sigFieldLock = this.sigField.getFieldLock();
        List<Node> fieldsToBeLocked = null;
        Field xfaField = this.sigField.getXFAFieldSignature();
        if (xfaField instanceof FormField) {
            xfaField = (Field)xfaField.getProto();
        }
        if (sigFieldLock != null) {
            PDFFieldAction action = sigFieldLock.getFieldAction();
            fieldsToBeLocked = this.getFieldsToBeLocked(action);
            if (!(action != PDFFieldAction.Include && action != PDFFieldAction.Exclude || fieldsToBeLocked != null && !fieldsToBeLocked.isEmpty())) {
                throw new PDFInvalidDocumentException("Field lock action is " + (Object)((Object)action) + " but the fields list to be locked is " + (fieldsToBeLocked == null ? "null." : "empty."));
            }
            if (debug && fieldsToBeLocked != null) {
                int siz = fieldsToBeLocked.size();
                System.out.println("Total No. of fields" + siz);
                for (i = 0; i < siz; ++i) {
                    System.out.println("Field :- " + fieldsToBeLocked.get(i));
                }
            }
            if (isLockCertifyingField) {
                Node sigNode;
                boolean isFieldAdded = this.generateXFAFieldMDPMarkup();
                if (!isFieldAdded && XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA && action == PDFFieldAction.Include) {
                    List<String> fieldList = sigFieldLock.getFieldList();
                    boolean isModified = false;
                    if (!fieldList.contains(xfaField.getSOMExpression())) {
                        fieldList.add(xfaField.getSOMExpression());
                        isModified = true;
                    }
                    if (isModified) {
                        sigFieldLock.setFieldList(fieldList);
                        this.sigField.setFieldLock(sigFieldLock);
                    }
                }
                if (!fieldsToBeLocked.contains(sigNode = xfaField.resolveNode(xfaField.getSOMExpression()))) {
                    fieldsToBeLocked.add(sigNode);
                }
            }
        } else if (isLockCertifyingField) {
            ArrayList<String> fieldList = new ArrayList<String>(1);
            fieldList.add(xfaField.getSOMExpression());
            SigFieldLock fieldLock = new SigFieldLock(PDFFieldAction.Include, fieldList, null);
            this.sigField.setFieldLock(fieldLock);
            Node sigNode = xfaField.resolveNode(xfaField.getSOMExpression());
            fieldsToBeLocked = new ArrayList<Node>();
            fieldsToBeLocked.add(sigNode);
        }
        ArrayList<String> lockedFieldNames = new ArrayList<String>(fieldsToBeLocked.size());
        int totalFields = fieldsToBeLocked.size();
        if (XFADOMService.getXFADOMFromCache(this.pdfDoc).formModelExists() || isLockCertifyingField) {
            for (i = 0; i < totalFields; ++i) {
                Node fieldNode = fieldsToBeLocked.get(i);
                this.lockAccessOnFieldNodes(fieldNode);
                lockedFieldNames.add(SOMExpressionUtils.trimSomExpression((String)fieldNode.getSOMExpression()));
            }
        } else {
            for (i = 0; i < totalFields; ++i) {
                Node fieldNode = fieldsToBeLocked.get(i);
                lockedFieldNames.add(SOMExpressionUtils.trimSomExpression((String)fieldNode.getSOMExpression()));
            }
        }
        return lockedFieldNames;
    }

    public void removeFieldMDP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SigFieldLock sigFieldLock = this.sigField.getFieldLock();
        List<Node> fieldsLocked = null;
        if (sigFieldLock != null) {
            PDFFieldAction action = sigFieldLock.getFieldAction();
            fieldsLocked = this.getFieldsToBeLocked(action);
        }
        if (fieldsLocked != null) {
            for (int i = 0; i < fieldsLocked.size(); ++i) {
                Node fieldNode = fieldsLocked.get(i);
                this.unlockAccessOnFieldNodes(fieldNode);
            }
        }
    }

    private List<Node> getFieldsToBeLocked(PDFFieldAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.manifestNode != null) {
            ArrayList fieldsToBeLocked = new ArrayList();
            if (action == PDFFieldAction.Include) {
                return this.resolveFormReferencesInclude(this.populateFieldNodes, fieldsToBeLocked);
            }
            if (action == PDFFieldAction.Exclude) {
                return this.resolveFormReferencesExclude(this.populateFieldNodes, fieldsToBeLocked, this.populateFieldNames);
            }
            if (action == PDFFieldAction.All) {
                return this.resolveFormReferencesAll(this.populateFieldNodes, fieldsToBeLocked);
            }
        }
        return null;
    }

    private Element getManifestNode(Field signatureField) throws PDFInvalidDocumentException {
        Element uiNode = signatureField.peekElement(XFA.UITAG, false, 0);
        if (uiNode == null) {
            return null;
        }
        Element signatureNode = (Element)uiNode.getOneOfChild(true, false);
        if (signatureNode == null) {
            return null;
        }
        String attribute = signatureNode.getAttribute(XFA.TYPETAG).getAttrValue();
        if (attribute == null || !attribute.equalsIgnoreCase("PDF1.6") && !attribute.equalsIgnoreCase("PDF1.3")) {
            throw new PDFInvalidDocumentException("Field MDP is only supported for version 1.6 and above. Version found :- " + attribute);
        }
        Element manifestNode = signatureNode.peekElement(XFA.MANIFESTTAG, false, 0);
        if (manifestNode == null) {
            return null;
        }
        if (manifestNode instanceof FormManifest) {
            FormManifest oFormManifest = (FormManifest)manifestNode;
            manifestNode = oFormManifest.getProto();
        }
        return manifestNode;
    }

    private List<Node> expandResolvedNode(Node item) {
        ArrayList<Node> referencedNodes = new ArrayList<Node>();
        if (this.isTemplateField(item) || this.isTemplateExclGroup(item)) {
            referencedNodes.add(item);
        }
        ManifestExclusionFilter filter = new ManifestExclusionFilter(null);
        filter.filterNodes(item, 0, referencedNodes);
        return referencedNodes;
    }

    private boolean isTemplateField(Node node) {
        return node instanceof Field && !(node instanceof FormField);
    }

    private boolean isTemplateExclGroup(Node node) {
        return node instanceof ExclGroup && !(node instanceof FormExclGroup);
    }

    private <T> List<T> extractFormNodes(XFAIteratorAction<List<T>> populateFieldNodes, List<T> data, Node templateNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (templateNode.getModel() != null && (this.isTemplateField(templateNode) || this.isTemplateExclGroup(templateNode))) {
            ProtoableNode protoable = (ProtoableNode)templateNode;
            int nProtoedIndex = 0;
            ProtoableNode protoed = protoable.getProtoed(nProtoedIndex);
            while (protoed != null) {
                if (protoed.getModel() != null && (protoed instanceof FormField || protoed instanceof FormExclGroup)) {
                    boolean bValid = true;
                    if (XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
                        CPDField cpdField;
                        CPDFields cpdFields;
                        bValid = false;
                        String somExpr = protoed.getSOMExpression();
                        if (somExpr != null && somExpr.length() > 0 && (cpdFields = PDDoc2CPDFields.GetCPDFieldsFromPDDoc((PDFDocument)this.pdfDoc, (boolean)true)) != null && (cpdField = cpdFields.getCPDField(somExpr = SOMExpressionUtils.trimSomExpression((String)somExpr))) != null) {
                            bValid = true;
                        }
                    }
                    if (bValid) {
                        populateFieldNodes.action((Node)protoed, data);
                    }
                }
                protoed = protoable.getProtoed(++nProtoedIndex);
            }
        }
        return data;
    }

    private void lockAccessOnFieldNodes(Node fieldNode) {
        if (fieldNode != null && ((Element)fieldNode).getAttribute(XFA.ACCESSTAG).getAttrValue().equalsIgnoreCase(EnumAttr.getString(65537))) {
            ((Element)fieldNode).setAttribute(65538, XFA.ACCESSTAG);
        }
    }

    private void unlockAccessOnFieldNodes(Node fieldNode) {
        ProtoableNode pNode;
        if (fieldNode != null && !this.isFieldStillProtected(fieldNode) && fieldNode instanceof FormField && (pNode = ((ProtoableNode)fieldNode).getProto()) != null) {
            Attribute templateAttibute = pNode.getAttribute(XFA.ACCESSTAG);
            Attribute formAttibute = ((ProtoableNode)fieldNode).getAttribute(XFA.ACCESSTAG);
            if (formAttibute != templateAttibute) {
                ((Element)fieldNode).setAttribute(templateAttibute, XFA.ACCESSTAG);
            }
        }
    }

    private void lockPermsOnFieldNodes(Node fieldNode) {
        if (fieldNode != null) {
            FormDataListener dListener = FieldMDP.getSignatureFieldDataListener(fieldNode);
            if (dListener != null) {
                dListener.deafen();
            }
            if (!fieldNode.isPermsLockSet()) {
                fieldNode.setPermsLock(true);
            }
            if (dListener != null) {
                dListener.unDeafen();
            }
        }
    }

    private void unlockPermsOnFieldNodes(Node fieldNode) {
        if (fieldNode != null && !this.isFieldStillProtected(fieldNode)) {
            FormDataListener dListener = FieldMDP.getSignatureFieldDataListener(fieldNode);
            if (dListener != null) {
                dListener.deafen();
            }
            if (fieldNode.isPermsLockSet()) {
                fieldNode.setPermsLock(false);
            }
            if (dListener != null) {
                dListener.unDeafen();
            }
        }
    }

    public boolean getXFAFieldMDPFieldData(Document dataBuffer, int nBufferlen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Canonicalize c;
        List<Node> nodeList = this.getXFAFieldMDPFieldDataNodes();
        boolean bLegacy_V32_Canonicalization = true;
        XFADOM xfaDOM = XFADOMService.getXFADOMFromCache(this.pdfDoc);
        if (xfaDOM != null && xfaDOM.getAppModel() != null) {
            bLegacy_V32_Canonicalization = xfaDOM.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V32_CANONICALIZATION);
        }
        return (dataBuffer = (c = new Canonicalize(bLegacy_V32_Canonicalization)).canonicalize(nodeList, 2, null)) != null;
    }

    private List<Node> getXFAFieldMDPFieldDataNodes() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.manifestNode == null) {
            return null;
        }
        String action = this.manifestNode.getAttribute(XFA.ACTIONTAG).getAttrValue();
        if (action == null) {
            return null;
        }
        if (action.equalsIgnoreCase("include")) {
            return this.resolveFormReferencesInclude(this.populateFieldNodes, new ArrayList());
        }
        if (action.equalsIgnoreCase("exclude")) {
            return this.resolveFormReferencesExclude(this.populateFieldNodes, new ArrayList(), this.populateFieldNames);
        }
        if (action.equalsIgnoreCase("all")) {
            return this.resolveFormReferencesAll(this.populateFieldNodes, new ArrayList());
        }
        throw new PDFInvalidDocumentException("Field Action is of invalid type");
    }

    public boolean getXFAFieldMDPRule(Document dataBuffer, int nBufferLen) throws PDFInvalidDocumentException {
        if (this.manifestNode != null) {
            ProtoableNode pNode;
            Element oManifestNode = this.manifestNode;
            if (oManifestNode instanceof FormManifest && (pNode = ((ProtoableNode)oManifestNode).getProto()) != null) {
                oManifestNode = pNode;
            }
            if (oManifestNode != null) {
                Peer p = oManifestNode.getPeer(0);
                if (p == null) {
                    throw new PDFInvalidDocumentException("Manifest is Invalid. Peer found null");
                }
                Canonicalize canon = new Canonicalize(oManifestNode, false, true);
                canon.canonicalize(2, null);
                return true;
            }
        }
        return false;
    }

    public Element getXFAFieldMDPRuleNode() {
        return this.manifestNode;
    }

    private boolean isXFAFieldReferenced(Node fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.manifestNode == null || fieldNode == null) {
            return false;
        }
        String action = this.manifestNode.getAttribute(XFA.ACTIONTAG).getAttrValue();
        if (action == null) {
            return false;
        }
        FieldReferenceInfo refNode = new FieldReferenceInfo(fieldNode);
        ArrayList<FieldReferenceInfo> nodeList = new ArrayList<FieldReferenceInfo>();
        nodeList.add(refNode);
        if (action.equalsIgnoreCase("include")) {
            this.resolveFormReferencesInclude(this.checkReferenceOnFieldNodes, nodeList);
        } else if (action.equalsIgnoreCase("exclude")) {
            this.resolveFormReferencesExclude(this.checkReferenceOnFieldNodes, nodeList, this.populateFieldNames);
        } else if (action.equalsIgnoreCase("all")) {
            this.resolveFormReferencesAll(this.checkReferenceOnFieldNodes, nodeList);
        } else {
            throw new PDFInvalidDocumentException("Field Action is of invalid type");
        }
        refNode = (FieldReferenceInfo)nodeList.get(0);
        return refNode.isReferenced;
    }

    private static void isReferenced(Node fieldNode, List<FieldReferenceInfo> list) {
        if (fieldNode == null || list == null || list.isEmpty()) {
            return;
        }
        FieldReferenceInfo fieldRefInfo = list.get(0);
        if (fieldNode.getSOMExpression().equalsIgnoreCase(fieldRefInfo.xfaNode.getSOMExpression())) {
            fieldRefInfo.setIsNodeReferenced(true);
        }
    }

    private static FormDataListener getSignatureFieldDataListener(Node fieldNode) {
        if (fieldNode instanceof FormField) {
            Element uiNode = ((FormField)fieldNode).peekElement(XFA.UITAG, false, 0);
            if (uiNode == null) {
                return null;
            }
            if (uiNode.defaultElement() == XFA.SIGNATURETAG && (uiNode.getAttribute(XFA.TYPETAG).getAttrValue().equalsIgnoreCase("PDF1.6") || uiNode.getAttribute(XFA.TYPETAG).getAttrValue().equalsIgnoreCase("PDF1.3"))) {
                Peer peer = fieldNode.getPeer(0);
                int peerCount = 0;
                while (peer != null) {
                    if (peer instanceof FormDataListener) {
                        return (FormDataListener)peer;
                    }
                    peer = fieldNode.getPeer(++peerCount);
                }
            }
        }
        return null;
    }

    private boolean generateXFAFieldMDPMarkup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Element oRef;
        Element textElement;
        TemplateModel template = TemplateModel.getTemplateModel(this.manifestNode.getModel().getAppModel(), false);
        if (template == null) {
            return false;
        }
        if (template.getCurrentVersion() < 25) {
            return false;
        }
        if (!(this.manifestNode instanceof FormManifest)) {
            return false;
        }
        ProtoableNode pNode = (ProtoableNode)this.manifestNode;
        ProtoableNode templateNode = pNode.getProto();
        if (templateNode == null) {
            return false;
        }
        Element uiNode = templateNode.peekElement(XFA.UITAG, false, 0);
        if (uiNode == null) {
            return false;
        }
        Element signatureNode = (Element)uiNode.getOneOfChild(true, false);
        if (signatureNode == null) {
            return false;
        }
        Element manifestSigNode = signatureNode.peekElement(XFA.MANIFESTTAG, false, 0);
        if (manifestSigNode != null) {
            if (!XFAService.getDocumentType(this.pdfDoc).isDynamic()) {
                return false;
            }
            String action = this.manifestNode.getAttribute(XFA.ACTIONTAG).getAttrValue();
            if (action == null || !action.equalsIgnoreCase("include")) {
                return false;
            }
            manifestSigNode.getAttribute(XFA.REFTAG);
            for (Node child = manifestSigNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                TextNode childNode;
                if (child.getClassTag() != XFA.REFTAG || (childNode = ((Element)child).getText(true, false, false)) == null || !childNode.getValue().equalsIgnoreCase(templateNode.getSOMExpression())) continue;
                return true;
            }
        } else {
            manifestSigNode = template.createElement("manifest");
            signatureNode.appendChild(manifestSigNode);
        }
        if (!signatureNode.getAttribute(XFA.TYPETAG).getAttrValue().equalsIgnoreCase("PDF1.6")) {
            signatureNode.setAttribute(-2141716479, XFA.TYPETAG);
        }
        if ((textElement = (oRef = template.createElement("ref")).getElement(XFA.TEXTNODETAG, 0)) != null) {
            textElement.setName(templateNode.getSOMExpression());
        }
        if (manifestSigNode instanceof FormManifest) {
            ProtoableNode protoableManifest = (ProtoableNode)manifestSigNode;
            ProtoableNode oProto = protoableManifest.getProto();
            if (oProto != null) {
                oProto.appendChild(oRef);
                protoableManifest.reResolveProto(true);
            } else {
                manifestSigNode.appendChild(oRef);
            }
        } else {
            manifestSigNode.appendChild(oRef);
        }
        return true;
    }

    private boolean isFieldStillProtected(Node formNode) {
        if (formNode instanceof FormField || formNode instanceof FormExclGroup) {
            try {
                SignatureFieldInterface sigField;
                FieldReferenceInfo fieldRefInfo = new FieldReferenceInfo(formNode);
                fieldRefInfo.setIsNodeReferenced(false);
                SignatureManager sigMgr = SignatureManager.newInstance(this.pdfDoc);
                Iterator<SignatureFieldInterface> sigIter = sigMgr.getPDFSignatureFieldIterator();
                while (sigIter.hasNext() && this.isFieldProtected(sigField = sigIter.next(), fieldRefInfo)) {
                }
                return fieldRefInfo.getIsNodeReferenced();
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException(e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private boolean isFieldProtected(SignatureFieldInterface sigField, FieldReferenceInfo fieldRefInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        FieldMDP fieldMDP;
        if (sigField == null || fieldRefInfo == null) {
            return true;
        }
        if (!sigField.isSigned()) {
            return true;
        }
        SignatureFieldXFA xfaField = sigField.getXFAField();
        if (xfaField != null && !xfaField.getQualifiedName().equalsIgnoreCase(this.sigField.getQualifiedName()) && (fieldMDP = new FieldMDP(this.pdfDoc, sigField)).isXFAFieldMDPSignature(fieldMDP.manifestNode) && fieldMDP.isXFAFieldReferenced(fieldRefInfo.xfaNode)) {
            fieldRefInfo.setIsNodeReferenced(true);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void protectXFAFieldMDPFields(ProtectOperationType protectOperation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String action;
        if (this.manifestNode == null || (action = this.manifestNode.getAttribute(XFA.ACTIONTAG).getAttrValue()) == null) return;
        if (protectOperation.lockAccess()) {
            if (action.equalsIgnoreCase("include")) {
                this.resolveFormReferencesInclude(this.lockAccessOnFieldNodes, null);
            } else if (action.equalsIgnoreCase("exclude")) {
                this.resolveFormReferencesExclude(this.lockAccessOnFieldNodes, null, this.populateFieldNames);
            } else {
                if (!action.equalsIgnoreCase("all")) throw new PDFInvalidParameterException("InvalidManifest encountered during FieldMDP validation");
                this.resolveFormReferencesAll(this.lockAccessOnFieldNodes, null);
            }
        } else if (protectOperation.unlockAccess()) {
            if (action.equalsIgnoreCase("include")) {
                this.resolveFormReferencesInclude(this.unlockAccessOnFieldNodes, null);
            } else if (action.equalsIgnoreCase("exclude")) {
                this.resolveFormReferencesExclude(this.unlockAccessOnFieldNodes, null, this.populateFieldNames);
            } else {
                if (!action.equalsIgnoreCase("all")) throw new PDFInvalidParameterException("InvalidManifest encountered during FieldMDP validation");
                this.resolveFormReferencesAll(this.unlockAccessOnFieldNodes, null);
            }
        }
        if (protectOperation.lockPerms()) {
            if (action.equalsIgnoreCase("include")) {
                this.resolveFormReferencesInclude(this.lockPermsOnFieldNodes, null);
                return;
            } else if (action.equalsIgnoreCase("exclude")) {
                this.resolveFormReferencesExclude(this.lockPermsOnFieldNodes, null, this.populateFieldNames);
                return;
            } else {
                if (!action.equalsIgnoreCase("all")) throw new PDFInvalidParameterException("InvalidManifest encountered during FieldMDP validation");
                this.resolveFormReferencesAll(this.lockPermsOnFieldNodes, null);
            }
            return;
        } else {
            if (!protectOperation.unlockPerms()) return;
            if (action.equalsIgnoreCase("include")) {
                this.resolveFormReferencesInclude(this.unlockPermsOnFieldNodes, null);
                return;
            } else if (action.equalsIgnoreCase("exclude")) {
                this.resolveFormReferencesExclude(this.unlockPermsOnFieldNodes, null, this.populateFieldNames);
                return;
            } else {
                if (!action.equalsIgnoreCase("all")) throw new PDFInvalidParameterException("InvalidManifest encountered during FieldMDP validation");
                this.resolveFormReferencesAll(this.unlockPermsOnFieldNodes, null);
            }
        }
    }

    private <T> List<T> resolveFormReferencesAll(XFAIteratorAction<List<T>> populateFieldNodes, List<T> data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TemplateModel template;
        if (debug) {
            System.out.println("Manifest rule - all");
        }
        if ((template = TemplateModel.getTemplateModel(this.manifestNode.getModel().getAppModel(), false)) != null) {
            ManifestExclusionFilter filter = new ManifestExclusionFilter(null);
            List<Node> nodeList = filter.filterNodes(template);
            int nLength = nodeList.size();
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                Node node = nodeList.get(nIndex);
                if (data == null || data != null && XFADOMService.isFormDomCreated(this.pdfDoc)) {
                    this.extractFormNodes(populateFieldNodes, data, node);
                    continue;
                }
                if (data == null) continue;
                populateFieldNodes.action(node, data);
            }
        }
        return data;
    }

    private <T> List<T> resolveFormReferencesExclude(XFAIteratorAction<List<T>> populateFieldNodes, List<T> data, XFAIteratorAction<List<String>> populateFieldNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TemplateModel template;
        if (debug) {
            System.out.println("Manifest rule - exclude");
        }
        if ((template = TemplateModel.getTemplateModel(this.manifestNode.getModel().getAppModel(), false)) != null) {
            ArrayList<String> aExcludedFields = new ArrayList<String>();
            this.resolveTemplateReferencesInclude(populateFieldNames, aExcludedFields, this.manifestNode);
            ManifestExclusionFilter filter = new ManifestExclusionFilter(aExcludedFields);
            List<Node> nodeList = filter.filterNodes(template);
            int nLength = nodeList.size();
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                Node node = nodeList.get(nIndex);
                if (data == null || data != null && XFADOMService.isFormDomCreated(this.pdfDoc)) {
                    this.extractFormNodes(populateFieldNodes, data, node);
                    continue;
                }
                if (data == null) continue;
                populateFieldNodes.action(node, data);
            }
        }
        return data;
    }

    private <T> List<T> resolveFormReferencesInclude(XFAIteratorAction<List<T>> populateFieldNodes, List<T> data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        NodeList referencedNodes;
        if (debug) {
            System.out.println("Manifest rule - include");
        }
        if ((referencedNodes = ((Manifest)this.manifestNode).doEvaluate()) == null || referencedNodes.length() == 0) {
            return null;
        }
        int nNumReferencedNodes = referencedNodes.length();
        for (int nReferencedNodeIndex = 0; nReferencedNodeIndex < nNumReferencedNodes; ++nReferencedNodeIndex) {
            Obj referencedNode = referencedNodes.item(nReferencedNodeIndex);
            if (!(referencedNode instanceof Node)) continue;
            List<Node> expandedNodes = this.expandResolvedNode((Node)referencedNode);
            int nNumExpandedNodes = expandedNodes.size();
            for (int nExpandedNodeIndex = 0; nExpandedNodeIndex < nNumExpandedNodes; ++nExpandedNodeIndex) {
                Node expandedNode = expandedNodes.get(nExpandedNodeIndex);
                if (data == null || data != null && XFADOMService.isFormDomCreated(this.pdfDoc)) {
                    this.extractFormNodes(populateFieldNodes, data, expandedNode);
                    continue;
                }
                populateFieldNodes.action(expandedNode, data);
            }
        }
        return data;
    }

    public <T> List<T> resolveTemplateReferencesInclude(XFAIteratorAction<List<T>> iteratorAction, List<T> data, Node manifestNode) {
        NodeList referencedNodes = ((Manifest)manifestNode).doEvaluate();
        if (referencedNodes == null) {
            return data;
        }
        int nNumReferencedNodes = referencedNodes.length();
        for (int nReferencedNodeIndex = 0; nReferencedNodeIndex < nNumReferencedNodes; ++nReferencedNodeIndex) {
            Obj referencedNode = referencedNodes.item(nReferencedNodeIndex);
            if (!(referencedNode instanceof Node)) continue;
            List<Node> expandedNodes = this.expandResolvedNode((Node)referencedNode);
            int nNumExpandedNodes = expandedNodes.size();
            for (int nExpandedNodeIndex = 0; nExpandedNodeIndex < nNumExpandedNodes; ++nExpandedNodeIndex) {
                Node expandedNode = expandedNodes.get(nExpandedNodeIndex);
                iteratorAction.action(expandedNode, data);
            }
        }
        return data;
    }

    private void initializeXFAFieldMDPVerifier(XFAValidationContext xfaValidationContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        this.setCurrentPDFDocument(this.pdfDoc);
        this.currentSignatureField = this.sigField;
        if (xfaValidationContext == null) {
            try {
                xfaValidationContext = new XFAValidationContext((SignatureFieldInterface)this.sigField, null, DocModAnalyzerParams.DocModAnalysisMode.MDPAllowDefaultPlusComments, false);
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFInvalidParameterException(e);
            }
        }
        this.setRollbackCosDocument(xfaValidationContext.getRollbackCosDoc());
        this.rollbackPDFDocument = xfaValidationContext.getRollbackPDFDoc();
        this.rollbackSignatureField = this.locateSignatureField(this.currentSignatureField.getQualifiedName());
        this.fieldMDPChangeLogger = null;
        if (debug) {
            this.fieldMDPChangeLogger = xfaValidationContext.getSigValidateOptions().getXFAChangeLogger();
            if (xfaValidationContext.getSigValidateOptions().XFAChangeRecordingEnabled()) {
                this.fieldMDPChangeLogger.enableChangeLogging();
            }
        }
    }

    public boolean doFieldMDPAnalysis(XFAValidationContext xfaValidationContext) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.initializeXFAFieldMDPVerifier(xfaValidationContext);
        boolean result = false;
        this.initXFASignatureFields(xfaValidationContext);
        this.initManifestNodes();
        if (!this.isXFAFieldMDPSignature(this.currentManifestNode) && !this.isXFAFieldMDPSignature(this.rollbackManifestNode)) {
            return true;
        }
        if (this.isXFAFieldMDPSignature(this.currentManifestNode) && this.isXFAFieldMDPSignature(this.rollbackManifestNode)) {
            if (this.CompareXFAFieldMDPRulesImplementation() && this.CompareXFAFieldMDPFieldsDataImplementation()) {
                result = true;
                if (debug) {
                    System.out.println("FieldMDP valid");
                }
            } else if (debug) {
                System.out.println("FieldMDP invalid");
            }
        }
        return result;
    }

    public void setRollbackCosDocument(CosDocument rollbackCosDocument) {
        this.rollbackCosDocument = rollbackCosDocument;
    }

    public CosDocument getRollbackCosDocument() {
        return this.rollbackCosDocument;
    }

    public void setCurrentPDFDocument(PDFDocument currentPDFDocument) {
        this.currentPDFDocument = currentPDFDocument;
    }

    public PDFDocument getCurrentPDFDocument() {
        return this.currentPDFDocument;
    }

    private SignatureFieldInterface locateSignatureField(String sigFieldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldNode[] fieldNodes = PDFFieldUtils.searchFields(new String[]{sigFieldName}, this.rollbackPDFDocument);
        if (fieldNodes != null) {
            for (int i = 0; i < fieldNodes.length; ++i) {
                if (!(fieldNodes[i] instanceof PDFFieldSignature)) continue;
                return SigningUtils.getSignatureFieldInterface((PDFFieldSignature)PDFFieldSignature.getInstance(fieldNodes[i].getCosObject()));
            }
        }
        return null;
    }

    private void initXFASignatureFields(XFAValidationContext xfaValidationContext) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.currentXFASignatureField = XFAUtils.getXFASignatureField(this.currentPDFDocument, this.currentSignatureField.getQualifiedName());
        this.rollbackXFASignatureField = XFAInternalUtils.getXFASignatureField((XFADOM)new RollbackXFADOM(xfaValidationContext.getRollbackPDFDoc(), xfaValidationContext.getRollbackXFADocument()), (String)this.rollbackSignatureField.getQualifiedName());
    }

    private void initManifestNodes() throws PDFInvalidDocumentException {
        this.currentManifestNode = this.getManifestNode(this.currentXFASignatureField);
        this.rollbackManifestNode = this.getManifestNode(this.rollbackXFASignatureField);
    }

    private boolean isXFAFieldMDPSignature(Node manifestNode) {
        return manifestNode != null;
    }

    boolean CompareXFAFieldMDPRulesImplementation() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.currentXFASignatureField == null || this.rollbackXFASignatureField == null) {
                return false;
            }
            if (this.currentManifestNode == null || this.rollbackManifestNode == null) {
                return false;
            }
            return this.currentManifestNode.compareVersions(this.rollbackManifestNode, this.fieldMDPChangeLogger, null);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException("Could not compare versions for field mdp", e);
        }
    }

    boolean CompareXFAFieldMDPFieldsDataImplementation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            boolean bResult = false;
            if (this.currentXFASignatureField == null || this.rollbackXFASignatureField == null) {
                return false;
            }
            this.manifestNode = (Element)this.rollbackManifestNode;
            List<Node> rollbackNodeList = this.getXFAFieldMDPFieldDataNodes(this.rollbackManifestNode);
            this.manifestNode = (Element)this.currentManifestNode;
            List<Node> currentNodeList = this.getXFAFieldMDPFieldDataNodes(this.currentManifestNode);
            if (debug) {
                int i;
                if (currentNodeList != null) {
                    for (i = 0; i < currentNodeList.size(); ++i) {
                        System.out.println("CurrentNodeList : " + currentNodeList.get(i).getSOMExpression());
                    }
                } else {
                    System.out.println("Null current field mdp node list obtained");
                }
                if (rollbackNodeList != null) {
                    for (i = 0; i < rollbackNodeList.size(); ++i) {
                        System.out.println("Rollback Node List: " + rollbackNodeList.get(i).getSOMExpression());
                    }
                } else {
                    System.out.println("Null rollback field mdp node list obtained");
                }
            }
            if (currentNodeList != null && rollbackNodeList != null && currentNodeList.size() == rollbackNodeList.size()) {
                bResult = true;
                for (int nIndex = 0; nIndex < currentNodeList.size(); ++nIndex) {
                    if (currentNodeList.get(nIndex).compareVersions(rollbackNodeList.get(nIndex), this.fieldMDPChangeLogger, null)) continue;
                    bResult = false;
                    break;
                }
            }
            return bResult;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException("Could not compare versions for field mdp", e);
        }
    }

    private List<Node> getXFAFieldMDPFieldDataNodes(Node manifestNode) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String action = ((Element)manifestNode).getAttribute(XFA.ACTIONTAG).getAttrValue();
        if (action.equalsIgnoreCase("include")) {
            return this.resolveFormReferencesInclude(this.populateFieldNodes, new ArrayList());
        }
        if (action.equalsIgnoreCase("exclude")) {
            return this.resolveFormReferencesExclude(this.populateFieldNodes, new ArrayList(), this.populateFieldNames);
        }
        if (action.equalsIgnoreCase("all")) {
            return this.resolveFormReferencesAll(this.populateFieldNodes, new ArrayList());
        }
        throw new PDFInvalidParameterException("InvalidManifest encountered during FieldMDP validation");
    }

    public static final class FieldReferenceInfo {
        private Node xfaNode;
        private boolean isReferenced;

        protected FieldReferenceInfo(Node xfaNode) {
            this.xfaNode = xfaNode;
        }

        protected Node getNode() {
            return this.xfaNode;
        }

        protected boolean getIsNodeReferenced() {
            return this.isReferenced;
        }

        protected void setIsNodeReferenced(boolean flag) {
            this.isReferenced = flag;
        }
    }

    public final class ManifestExclusionFilter
    extends NodeListFilter {
        private final List<String> mExcludedFields;

        public ManifestExclusionFilter(List<String> excludedFields) {
            this.mExcludedFields = excludedFields;
        }

        @Override
        public boolean accept(Node node) {
            if (node != null && (FieldMDP.this.isTemplateField(node) || FieldMDP.this.isTemplateExclGroup(node))) {
                if (this.mExcludedFields == null) {
                    return true;
                }
                String sSOMExpression = node.getSOMExpression(node.getModel(), false);
                if (sSOMExpression.length() > 0) {
                    int nSize = this.mExcludedFields.size();
                    for (int nIndex = 0; nIndex < nSize; ++nIndex) {
                        if (!sSOMExpression.equals(this.mExcludedFields.get(nIndex))) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static class ProtectOperationType {
        private int operations = 0;
        private static final int LockAccess = 1;
        private static final int UnlockAccess = 2;
        private static final int LockPerms = 4;
        private static final int UnlockPerms = 8;

        public ProtectOperationType(int operations) {
            this.operations = operations;
        }

        boolean lockAccess() {
            return this.statusBitSet(1L);
        }

        boolean lockPerms() {
            return this.statusBitSet(4L);
        }

        boolean unlockAccess() {
            return this.statusBitSet(2L);
        }

        boolean unlockPerms() {
            return this.statusBitSet(8L);
        }

        boolean statusBitSet(long checkBit) {
            return ((long)this.operations & checkBit) == checkBit;
        }
    }

    private static class RollbackXFADOM
    extends XFADOM {
        public RollbackXFADOM(PDFDocument pdfDoc, Document doc) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.pdfDocument = pdfDoc;
            this.appModel = doc.getAppModel();
            this.templateModel = TemplateModel.getTemplateModel(this.appModel, false);
            this.configurationModel = ConfigurationModel.getConfigurationModel(this.appModel, false);
            this.dataModel = DataModel.getDataModel(this.appModel, false, false);
            this.formModel = FormModel.getFormModel(this.appModel, false);
        }
    }
}

