/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfatext;

import com.adobe.internal.agm.AGMColor;
import com.adobe.internal.agm.AGMColorSpace;
import com.adobe.internal.agm.AGMGState;
import com.adobe.internal.agm.AGMLineCapStyle;
import com.adobe.internal.agm.AGMLineDashPattern;

public class RenderXFARuleGState
implements AGMGState {
    private double pvt_redFactor;
    private double pvt_greenFactor;
    private double pvt_blueFactor;
    private double pvt_opacityFactor;
    private double pvt_ruleThickness;
    private String pvt_ruleStyle;

    public RenderXFARuleGState(double in_redFactor, double in_greenFactor, double in_blueFactor, double in_opacityFactor, double in_ruleThickness, String in_ruleStyle) {
        this.pvt_redFactor = in_redFactor;
        this.pvt_greenFactor = in_greenFactor;
        this.pvt_blueFactor = in_blueFactor;
        this.pvt_opacityFactor = in_opacityFactor;
        this.pvt_ruleThickness = in_ruleThickness;
        this.pvt_ruleStyle = in_ruleStyle;
    }

    @Override
    public boolean hasLineWidth() {
        return true;
    }

    @Override
    public double getLineWidth() {
        return this.pvt_ruleThickness;
    }

    @Override
    public boolean hasLineDashPattern() {
        return !this.pvt_ruleStyle.equalsIgnoreCase("solid");
    }

    @Override
    public AGMLineDashPattern getLineDashPattern() {
        if (this.pvt_ruleStyle.equalsIgnoreCase("solid")) {
            return new AGMLineDashPattern();
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dotted")) {
            double[] pattern = new double[]{0.0, 5.0};
            return new AGMLineDashPattern(pattern, 0);
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dashed")) {
            double[] pattern = new double[]{10.0, 5.0};
            return new AGMLineDashPattern(pattern, 0);
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dot-dashed")) {
            double[] pattern = new double[]{0.0, 5.0, 10.0, 5.0};
            return new AGMLineDashPattern(pattern, 0);
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dot-dot-dashed")) {
            double[] pattern = new double[]{0.0, 5.0, 0.0, 5.0, 10.0, 5.0};
            return new AGMLineDashPattern(pattern, 0);
        }
        return new AGMLineDashPattern();
    }

    @Override
    public boolean hasLineCapStyle() {
        return !this.pvt_ruleStyle.equalsIgnoreCase("solid");
    }

    @Override
    public AGMLineCapStyle getLineCapStyle() {
        if (this.pvt_ruleStyle.equalsIgnoreCase("solid")) {
            return AGMLineCapStyle.BUTT_CAP;
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dotted")) {
            return AGMLineCapStyle.ROUND_CAP;
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dashed")) {
            return AGMLineCapStyle.ROUND_CAP;
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dot-dashed")) {
            return AGMLineCapStyle.ROUND_CAP;
        }
        if (this.pvt_ruleStyle.equalsIgnoreCase("dot-dot-dashed")) {
            return AGMLineCapStyle.ROUND_CAP;
        }
        return AGMLineCapStyle.BUTT_CAP;
    }

    @Override
    public boolean hasStrokeColor() {
        return true;
    }

    @Override
    public AGMColor getStrokeColor() {
        double[] var_RGBArray = new double[]{this.pvt_redFactor, this.pvt_greenFactor, this.pvt_blueFactor, this.pvt_opacityFactor};
        AGMColor var_newAGMColor = new AGMColor(var_RGBArray, AGMColorSpace.DeviceRGB);
        return var_newAGMColor;
    }

    @Override
    public boolean hasFillColor() {
        return false;
    }

    @Override
    public AGMColor getFillColor() {
        return null;
    }
}

