/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.PDF2XFDFAnnotationsReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.xml.sax.XMLReader;

public class XFDFService {
    private XFDFService() {
    }

    public static void exportAnnotations(PDFDocument pdfDocument, OutputStream xmlStream) throws PDFInvalidXMLException {
        XFDFObject.exportAnnotations((PDFDocument)pdfDocument, (OutputStream)xmlStream);
    }

    public static void exportAnnotations(PDFDocument pdfDocument, OutputStream xmlStream, PDFAnnotationRotationEnum rotationType) throws PDFInvalidXMLException {
        XFDFObject.exportAnnotations((PDFDocument)pdfDocument, (OutputStream)xmlStream, (PDFAnnotationRotationEnum)rotationType);
    }

    public static void exportAnnotations(PDFAnnotationList annotsList, OutputStream xmlStream) throws PDFInvalidXMLException {
        ServicesUtil.transformToXML((XMLReader)new PDF2XFDFAnnotationsReader(annotsList), null, (OutputStream)xmlStream);
    }

    public static void importAnnotations(PDFDocument pdfDocument, InputStream inputXML) throws PDFInvalidXMLException, PDFIOException, PDFConfigurationException {
        XFDFObject.importAnnotations((InputStream)inputXML, (PDFDocument)pdfDocument);
    }

    public static void deleteAnnotations(PDFDocument pdfDocument) throws PDFException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFDFObject.deleteAnnotations((PDFDocument)pdfDocument);
    }

    public static void exportFormData(PDFDocument pdfDocument, OutputStream xmlStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm forms = pdfDocument.getInteractiveForm();
        try {
            XFDFObject.exportFormData((PDFInteractiveForm)forms, (OutputStream)xmlStream);
        }
        catch (PDFInvalidXMLException e) {
            throw new RuntimeException("Invalid XML Generated.", e);
        }
    }

    public static void importFormData(PDFDocument pdfDocument, InputStream inputXML) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException {
        PDFInteractiveForm forms = pdfDocument.getInteractiveForm();
        XFDFObject.importFormData((InputStream)inputXML, (PDFInteractiveForm)forms);
    }

    public static void importFormData(PDFDocument pdfDocument, InputStream inputXML, PDFFontSet fontSet, Locale locale, boolean importIntoLockedFields) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException {
        PDFInteractiveForm forms = pdfDocument.getInteractiveForm();
        XFDFObject.importFormData((InputStream)inputXML, (PDFInteractiveForm)forms, (PDFFontSet)fontSet, (Locale)locale, (boolean)importIntoLockedFields);
    }

    public static PDFAnnotation findAnnotationByName(String fName, PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument pdfDocument = annot.getPDFDocument();
        PDFPageTree pages = pdfDocument.requirePages();
        for (int pageIdx = 0; pageIdx < pages.getNumPages(); ++pageIdx) {
            PDFPage pdfPage = pdfDocument.requirePages().getPage(pageIdx);
            PDFAnnotationList annotations = pdfPage.getAnnotationList();
            if (annotations == null) {
                return null;
            }
            PDFAnnotationIterator annotIterator = annotations.iterator();
            while (annotIterator.hasNext()) {
                PDFAnnotation pdfAnnotation = annotIterator.next();
                String name = pdfAnnotation.getName();
                if (name == null || !name.equalsIgnoreCase(fName)) continue;
                return pdfAnnotation;
            }
        }
        return null;
    }
}

