/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.pdftoolkit.services.xmp.Metadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface DocumentMetadata
extends Metadata {
    public static final SynchronizationSource SYNCHRONIZATION_SOURCE_XMP = new SynchronizationSource("xmp");
    public static final SynchronizationSource SYNCHRONIZATION_SOURCE_DOCINFO = new SynchronizationSource("doc info");
    public static final SynchronizationSource SYNCHRONIZATION_SOURCE_EQUAL = new SynchronizationSource("equal");
    public static final SynchronizationSource SYNCHRONIZATION_SOURCE_NEW = new SynchronizationSource("new");

    public SynchronizationSource getInitialSynchronizationSource();

    public DocInfoConformanceState initialDocInfoConformanceState();

    public static final class DocInfoConformanceState {
        private Map<DocInfoEntry, EntryConformanceState> conformanceState;
        private boolean xmpExists;
        private boolean docInfoExists;

        DocInfoConformanceState(boolean xmpExists, boolean docInfoExists) {
            this.xmpExists = xmpExists;
            this.docInfoExists = docInfoExists;
            this.conformanceState = new HashMap<DocInfoEntry, EntryConformanceState>();
            for (DocInfoEntry entry : DocInfoEntry.values()) {
                this.conformanceState.put(entry, new EntryConformanceState());
            }
        }

        public EntryConformanceState getEntryConformanceState(DocInfoEntry entry) {
            return this.conformanceState.get((Object)entry);
        }

        protected boolean doesEntryConform(DocInfoEntry entry) {
            if (!this.docInfoExists) {
                return true;
            }
            if (!this.xmpExists) {
                return false;
            }
            return this.conformanceState.get((Object)entry).conforms();
        }

        public boolean docInfoExists() {
            return this.docInfoExists;
        }

        public boolean xmpExists() {
            return this.xmpExists;
        }

        public Map<DocInfoEntry, EntryConformanceState> getConformance() {
            return Collections.unmodifiableMap(this.conformanceState);
        }

        public boolean everythingConforms() {
            if (this.docInfoExists && !this.xmpExists) {
                return false;
            }
            if (!this.docInfoExists && this.xmpExists) {
                return true;
            }
            for (DocInfoEntry entry : DocInfoEntry.values()) {
                if (this.doesEntryConform(entry)) continue;
                return false;
            }
            return true;
        }

        public boolean authorConforms() {
            return this.doesEntryConform(DocInfoEntry.AUTHOR);
        }

        public boolean creationDateConforms() {
            return this.doesEntryConform(DocInfoEntry.CREATION_DATE);
        }

        public boolean creatorConforms() {
            return this.doesEntryConform(DocInfoEntry.CREATOR);
        }

        public boolean customPropertiesConform() {
            return this.doesEntryConform(DocInfoEntry.CUSTOM_PROPERTIES);
        }

        public boolean keywordsMatch() {
            return this.doesEntryConform(DocInfoEntry.KEYWORDS);
        }

        public boolean modificationDateConforms() {
            return this.doesEntryConform(DocInfoEntry.MODIFICATION_DATE);
        }

        public boolean producerConforms() {
            return this.doesEntryConform(DocInfoEntry.PRODUCER);
        }

        public boolean subjectConforms() {
            return this.doesEntryConform(DocInfoEntry.SUBJECT);
        }

        public boolean titleConforms() {
            return this.doesEntryConform(DocInfoEntry.TITLE);
        }

        public boolean trappedConforms() {
            return this.doesEntryConform(DocInfoEntry.TRAPPED);
        }

        public static final class EntryConformanceState {
            private boolean docInfoEntryExists;
            private boolean xmpEntryExists;
            private boolean bothEqual;
            private boolean error;

            protected EntryConformanceState() {
            }

            protected void setDocInfoEntryExists(boolean exists) {
                this.docInfoEntryExists = exists;
            }

            public boolean getDocInfoEntryExists() {
                return this.docInfoEntryExists;
            }

            protected void setXMPEntryExists(boolean exists) {
                this.xmpEntryExists = exists;
            }

            public boolean getXMPEntryExists() {
                return this.xmpEntryExists;
            }

            protected void setBothEqual(boolean equal) {
                this.bothEqual = equal;
            }

            public boolean getBothEqual() {
                return this.bothEqual;
            }

            protected void setError(boolean error) {
                this.error = error;
            }

            public boolean getError() {
                return this.error;
            }

            public boolean conforms() {
                return this.bothEqual && !this.error;
            }

            public String toString() {
                return "Doc Info exists = " + this.docInfoEntryExists + ", XMP exists = " + this.xmpEntryExists + ", equal = " + this.bothEqual + ", error = " + this.error;
            }
        }

        public static enum DocInfoEntry {
            TITLE("title"),
            AUTHOR("author"),
            SUBJECT("subject"),
            KEYWORDS("keywords"),
            CREATOR("creator"),
            PRODUCER("producer"),
            TRAPPED("trapped"),
            CREATION_DATE("creation date"),
            MODIFICATION_DATE("modification date"),
            CUSTOM_PROPERTIES("custom properties");

            private final String name;

            private DocInfoEntry(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static final class SynchronizationSource {
        private final String source;

        private SynchronizationSource(String source) {
            this.source = source;
        }

        public String toString() {
            return this.source;
        }
    }
}

