/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLCopierBase;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XMLFinder
extends XMLCopierBase {
    private static final boolean DEBUG = false;
    private final XMLSearchPath searchPath;
    private int matchedPosition = -1;
    private int lastMatchDepth = 0;
    private boolean inMatchElementOpen = false;
    private boolean inMatchElementClose = false;
    private boolean useForSchemaInserting = false;
    private static final String RDF_URL = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDF_DESC = "Description";
    private Stack<Integer> elementsToSkipDepths = new Stack();

    public XMLFinder(XMLSearchPath searchPath, boolean beginCopying) {
        super(beginCopying);
        this.searchPath = searchPath;
    }

    public XMLFinder(XMLSearchPath searchPath, boolean beginCopying, boolean useForSchemaInserting) {
        super(beginCopying);
        this.searchPath = searchPath;
        this.useForSchemaInserting = useForSchemaInserting;
    }

    public XMLFinder(XMLReader parent, XMLSearchPath searchPath, boolean beginCopying) {
        super(parent, beginCopying);
        this.searchPath = searchPath;
    }

    @Override
    protected int preElementStart(String namespaceURI, String simpleName) throws SAXException {
        return this.processState(namespaceURI, simpleName, 1);
    }

    @Override
    protected int postElementEnd(String namespaceURI, String simpleName) throws SAXException {
        return this.processState(namespaceURI, simpleName, 8);
    }

    @Override
    protected int postElementStart(String namespaceURI, String simpleName) throws SAXException {
        return this.processState(namespaceURI, simpleName, 2);
    }

    @Override
    protected int preElementEnd(String namespaceURI, String simpleName) throws SAXException {
        return this.processState(namespaceURI, simpleName, 4);
    }

    private int processState(String namespaceURI, String simpleName, int findState) throws SAXException {
        int retValue = -1;
        switch (findState) {
            case 1: {
                XMLElement attemptElement;
                if (this.lastMatchDepth + 1 != this.xmlTreeDepth) break;
                XMLElement matchedElement = this.matchedPosition < 0 ? null : this.searchPath.getElement(this.matchedPosition);
                int matchedCount = matchedElement == null ? -1 : this.searchPath.getElementsMatched(this.matchedPosition);
                XMLElement xMLElement = attemptElement = this.matchedPosition > this.searchPath.pathSize() - 2 ? null : this.searchPath.getElement(this.matchedPosition + 1);
                if (matchedElement == XMLSearchPath.WILDCARD_ONE_OR_MORE && matchedCount > 0 || matchedElement == XMLSearchPath.WILDCARD_ZERO_OR_MORE) {
                    if (attemptElement != null && attemptElement.matches(namespaceURI, simpleName)) {
                        this.lastMatchDepth = this.xmlTreeDepth;
                        ++this.matchedPosition;
                        this.searchPath.incrementElementsMatched(this.matchedPosition);
                    } else {
                        this.lastMatchDepth = this.xmlTreeDepth;
                        this.searchPath.incrementElementsMatched(this.matchedPosition);
                    }
                    if (this.matchedPosition != this.searchPath.pathSize() - 1) break;
                    if (this.searchPath.flagSet(findState)) {
                        retValue = this.found(namespaceURI, simpleName, findState);
                    }
                    this.inMatchElementOpen = true;
                    break;
                }
                if (matchedElement == XMLSearchPath.WILDCARD_ONE_OR_MORE) {
                    this.lastMatchDepth = this.xmlTreeDepth;
                    this.searchPath.incrementElementsMatched(this.matchedPosition);
                    if (this.matchedPosition != this.searchPath.pathSize() - 1) break;
                    if (this.searchPath.flagSet(findState)) {
                        retValue = this.found(namespaceURI, simpleName, findState);
                    }
                    this.inMatchElementOpen = true;
                    break;
                }
                if (attemptElement == null || !attemptElement.matches(namespaceURI, simpleName)) break;
                this.lastMatchDepth = this.xmlTreeDepth;
                ++this.matchedPosition;
                if (attemptElement == XMLSearchPath.WILDCARD_ZERO_OR_MORE) {
                    XMLElement beyondAttemptElement;
                    XMLElement xMLElement2 = beyondAttemptElement = this.matchedPosition > this.searchPath.pathSize() - 2 ? null : this.searchPath.getElement(this.matchedPosition + 1);
                    if (beyondAttemptElement != null && beyondAttemptElement.matches(namespaceURI, simpleName)) {
                        ++this.matchedPosition;
                    }
                }
                this.searchPath.incrementElementsMatched(this.matchedPosition);
                if (this.matchedPosition != this.searchPath.pathSize() - 1) break;
                if (this.searchPath.flagSet(findState)) {
                    retValue = this.found(namespaceURI, simpleName, findState);
                }
                this.inMatchElementOpen = true;
                break;
            }
            case 2: {
                if (!this.inMatchElementOpen) break;
                if (this.searchPath.flagSet(findState)) {
                    retValue = this.found(namespaceURI, simpleName, findState);
                }
                this.inMatchElementOpen = false;
                break;
            }
            case 4: {
                if (this.lastMatchDepth != this.xmlTreeDepth || this.matchedPosition < 0) break;
                if (this.matchedPosition == this.searchPath.pathSize() - 1) {
                    if (this.searchPath.flagSet(findState)) {
                        retValue = this.found(namespaceURI, simpleName, findState);
                    }
                    this.inMatchElementClose = true;
                }
                int currentMatchCount = 0;
                while (this.matchedPosition >= 0 && (currentMatchCount = this.searchPath.getElementsMatched(this.matchedPosition)) <= 0) {
                    --this.matchedPosition;
                }
                if (currentMatchCount <= 0) break;
                this.searchPath.setElementsMatched(this.matchedPosition, --currentMatchCount);
                if (currentMatchCount == 0) {
                    --this.matchedPosition;
                }
                this.lastMatchDepth = this.xmlTreeDepth - 1;
                break;
            }
            case 8: {
                if (!this.inMatchElementClose) break;
                if (this.searchPath.flagSet(findState)) {
                    retValue = this.found(namespaceURI, simpleName, findState);
                }
                this.inMatchElementClose = false;
            }
        }
        return retValue;
    }

    protected abstract int found(String var1, String var2, int var3) throws SAXException;

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (RDF_URL.equals(uri) && RDF_DESC.equals(localName) && !this.useForSchemaInserting && atts != null && atts.getLength() == 0) {
            this.elementsToSkipDepths.push(this.xmlTreeDepth);
            return;
        }
        super.startElement(uri, localName, name, atts);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!this.elementsToSkipDepths.isEmpty() && this.elementsToSkipDepths.peek() == this.xmlTreeDepth) {
            this.elementsToSkipDepths.pop();
            return;
        }
        super.endElement(uri, localName, name);
    }

    public static final class XMLSearchPath {
        private List<XMLElement> searchPath = new ArrayList<XMLElement>();
        private List<Integer> elementsMatched = null;
        private int flags;
        public static final XMLElement WILDCARD_ONE = new XMLElement(null, null);
        public static final XMLElement WILDCARD_ONE_OR_MORE = new XMLElement(null, null);
        public static final XMLElement WILDCARD_ZERO_OR_MORE = new XMLElement(null, null);
        public static final int NO_ACTION = 0;
        public static final int FIND_BEFORE_OPEN = 1;
        public static final int FIND_AFTER_OPEN = 2;
        public static final int FIND_BEFORE_CLOSE = 4;
        public static final int FIND_AFTER_CLOSE = 8;
        static final int FIND_BEFORE = 5;
        static final int FIND_AFTER = 10;
        static final int FIND_OPEN = 3;
        static final int FIND_CLOSE = 12;

        public XMLSearchPath(int flags, XMLElement[] path) {
            this.flags = flags;
            this.setSearchPath(path);
            this.elementsMatched = new ArrayList<Integer>(this.pathSize());
            for (int i = 0; i < this.searchPath.size(); ++i) {
                this.elementsMatched.add(0);
            }
        }

        public XMLSearchPath(int flags, List<XMLElement> path) {
            this.flags = flags;
            this.searchPath.addAll(path);
            this.elementsMatched = new ArrayList<Integer>(this.pathSize());
            for (int i = 0; i < this.searchPath.size(); ++i) {
                this.elementsMatched.add(0);
            }
        }

        private void setSearchPath(XMLElement[] path) {
            this.searchPath.clear();
            for (int i = 0; i < path.length; ++i) {
                this.searchPath.add(path[i]);
            }
        }

        protected XMLElement getElement(int index) {
            return this.searchPath.get(index);
        }

        public int pathSize() {
            return this.searchPath.size();
        }

        protected boolean flagSet(int flag) {
            return (this.flags & flag) == flag;
        }

        protected int getElementsMatched(int index) {
            return this.elementsMatched.get(index);
        }

        protected void setElementsMatched(int index, int matched) {
            this.elementsMatched.set(index, matched);
        }

        protected int incrementElementsMatched(int index) {
            int matchCount = this.getElementsMatched(index);
            this.setElementsMatched(index, ++matchCount);
            return matchCount;
        }

        protected int decrementElementsMatched(int index) {
            int matchCount = this.getElementsMatched(index);
            this.setElementsMatched(index, --matchCount);
            return matchCount;
        }
    }
}

