/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLNamespaceUsageCollector
extends XMLFilterImpl {
    private static final boolean DEBUG = false;
    private Map<String, XMLNamespaceUsage> namespaceMap = new HashMap<String, XMLNamespaceUsage>();

    public XMLNamespaceUsageCollector(XMLReader parent) {
        super(parent);
    }

    public XMLNamespaceUsageCollector() {
    }

    public Map<String, XMLNamespaceUsage> getNamespaceUsage() {
        return Collections.unmodifiableMap(this.namespaceMap);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        super.startElement(uri, localName, name, atts);
        XMLNamespaceUsage usage = this.namespaceMap.get(uri);
        if (usage == null) {
            usage = new XMLNamespaceUsage(uri);
            this.namespaceMap.put(uri, usage);
        }
        usage.addElement(localName);
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeURI = atts.getURI(i);
            usage = this.namespaceMap.get(attributeURI);
            if (usage == null) {
                usage = new XMLNamespaceUsage(attributeURI);
                this.namespaceMap.put(attributeURI, usage);
            }
            usage.addAttribute(atts.getLocalName(i));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        XMLNamespaceUsage usage = this.namespaceMap.get(uri);
        if (usage == null) {
            usage = new XMLNamespaceUsage(uri);
            this.namespaceMap.put(uri, usage);
        }
        usage.addPrefix(prefix);
    }
}

