/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Element;
import com.adobe.xfa.GenericAttribute;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationElementScript;
import com.adobe.xfa.ut.StringUtils;
import org.xml.sax.Attributes;

public class ConfigurationElement
extends Element {
    private static final ScriptDynamicPropObj attributeFuncScriptObj = new ScriptDynamicPropObj(10, 63){

        @Override
        public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
            return ConfigurationElement.getAttributeFunc(scriptThis, retValue, sPropertyName);
        }

        @Override
        public boolean invokeSetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
            return ConfigurationElement.setAttributeFunc(scriptThis, retValue, sPropertyName);
        }

        @Override
        public boolean hasSetter() {
            return true;
        }
    };

    public ConfigurationElement(Element parent, Node prevSibling, String uri, String lname, String qname, Attributes attr, int classTag, String className) {
        super(parent, prevSibling, uri, lname, qname, attr, classTag, className);
    }

    @Override
    protected boolean canCreateChild(boolean bIsLeaf, String aName) {
        assert (aName != null);
        int eClassTag = XFA.getTag(aName);
        if (eClassTag >= 0 && this.isValidElement(eClassTag, false)) {
            return true;
        }
        if (bIsLeaf && this.isValidElement(58, false)) {
            return true;
        }
        return !bIsLeaf && this.isValidElement(57, false);
    }

    @Override
    protected Node createChild(boolean bIsLeaf, String aName) {
        int eClassTag = XFA.getTag(aName);
        Element oNode = eClassTag >= 0 && this.isValidElement(eClassTag, false) ? this.getModel().createElement(this, null, null, aName, aName, null, 0, null) : (bIsLeaf ? this.getModel().createElement(58, aName) : this.getModel().createElement(57, aName));
        return oNode;
    }

    @Override
    protected void setClass(Element parent, int eTag) {
        if (parent != null && parent.isValidChild(eTag, 0, false, false)) {
            super.setClass(XFA.getAtom(eTag), eTag);
        }
    }

    @Override
    public String getName() {
        String sName = super.getName();
        if (StringUtils.isEmpty(sName)) {
            sName = super.getLocalName();
        }
        return sName;
    }

    @Override
    public boolean isValidAttr(int eTag, boolean bReport, String value) {
        if (super.isValidAttr(eTag, bReport, value)) {
            return true;
        }
        return this.getClassTag() == 57 || this.getClassTag() == 58;
    }

    @Override
    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        if (this.getClassTag() == 57 || this.getClassTag() == 58) {
            ScriptDynamicPropObj scriptDynamicPropObj = super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek);
            if (scriptDynamicPropObj != null) {
                return scriptDynamicPropObj;
            }
            int nAttrIdx = this.findAttr(null, sPropertyName.intern());
            if (nAttrIdx >= 0) {
                return attributeFuncScriptObj;
            }
        } else {
            return super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek);
        }
        return null;
    }

    private static boolean getAttributeFunc(Obj scriptThis, Arg retVal, String sProp) {
        if (StringUtils.isEmpty(sProp)) {
            return false;
        }
        ConfigurationElement element = (ConfigurationElement)scriptThis;
        int index = element.findAttr(null, sProp.intern());
        if (index == -1) {
            return false;
        }
        retVal.setString(element.getAttrVal(index));
        return true;
    }

    private static boolean setAttributeFunc(Obj scriptThis, Arg value, String sProp) {
        if (StringUtils.isEmpty(sProp)) {
            return false;
        }
        ConfigurationElement element = (ConfigurationElement)scriptThis;
        element.updateAttribute(new GenericAttribute(null, sProp, sProp, value.toString()));
        return true;
    }

    @Override
    public ScriptTable getScriptTable() {
        return ConfigurationElementScript.getScriptTable();
    }
}

