/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.Obj;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.FormCalcUtil;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class CalcSymbol {
    public static final int TypeError = 0;
    public static final int TypeNull = 1;
    public static final int TypeString = 2;
    public static final int TypeDouble = 3;
    public static final int TypeBuiltin = 4;
    public static final int TypeVariable = 5;
    public static final int TypeReference = 6;
    public static final int TypeParameter = 7;
    public static final int TypeFunction = 8;
    public static final int TypeAccessor = 9;
    public static final int TypeReturn = 10;
    static final int StoreTemp = 0;
    static final int StorePerm = 1;
    static final int StoreFroz = 2;
    static final int StorePrelim = 16;
    int mType;
    int mStore;
    String mName;
    Object mValue;
    Obj[] mObjs;
    int mExtra;
    CalcSymbol mNext = null;

    public CalcSymbol() {
        this.mName = null;
        this.setScope(0);
        this.setObjValue(null);
        this.mValue = null;
        this.mStore = 0;
        this.mType = 1;
    }

    public CalcSymbol(int nVal) {
        this.mName = null;
        this.setScope(0);
        this.setObjValue(null);
        this.setNumericValue(nVal);
        this.mStore = 0;
        this.mType = 3;
    }

    public CalcSymbol(double dVal) {
        this.mName = null;
        this.setScope(0);
        this.setObjValue(null);
        this.mStore = 0;
        if (CalcSymbol.isFinite(dVal)) {
            this.setNumericValue(dVal);
            this.mType = 3;
        } else {
            MsgFormat oErr = new MsgFormat(ResId.FC_ERR_ARITHMETIC);
            this.setErrorValue(oErr.toString());
            this.setLineAndError(0);
            this.mType = 0;
        }
    }

    public CalcSymbol(String sVal, boolean bIsError, int nErrorLine, int nErrorResId) {
        this.mName = null;
        this.setScope(0);
        this.setObjValue(null);
        this.setStringValue(sVal);
        this.mStore = 0;
        if (bIsError) {
            this.mType = 0;
            this.setLineAndError(CalcSymbol.encodeLineAndErrorResId(nErrorLine, nErrorResId));
        } else {
            this.mType = 2;
        }
    }

    public CalcSymbol(String sVal) {
        this.mName = null;
        this.setScope(0);
        this.setStringValue(sVal);
        this.mStore = 0;
        this.mType = 2;
    }

    public CalcSymbol(Method func) {
        this.mName = "";
        this.setScope(0);
        this.setFuncValue(func);
        this.mStore = 1;
        this.mType = 4;
    }

    public CalcSymbol(Obj oObj, String sName) {
        this.mName = null;
        this.setScope(0);
        this.mValue = null;
        this.mStore = 0;
        this.mType = 1;
        if (oObj != null) {
            if (sName != null) {
                this.mName = sName;
            }
            this.setObjValue(oObj);
            this.mType = 6;
        }
    }

    public CalcSymbol(CalcSymbol oSym) {
        this.mName = null;
        this.setScope(0);
        this.mValue = null;
        this.mStore = 0;
        this.mType = oSym.mType;
        this.assign(oSym);
    }

    CalcSymbol assign(CalcSymbol oSym) {
        this.mNext = oSym.mNext;
        this.mName = oSym.mName;
        this.mType = oSym.mType;
        switch (oSym.mType) {
            case 3: {
                this.mValue = oSym.mValue;
                break;
            }
            case 5: {
                this.setScope(oSym.getScope());
            }
            case 2: 
            case 10: {
                this.mValue = oSym.mValue;
                break;
            }
            case 9: {
                if (this.getObjs() > 0) {
                    this.setObjValue(null);
                }
                this.setObjValues(oSym.getObjValues());
                break;
            }
            case 6: {
                if (this.getObjs() > 0) {
                    this.setObjValue(null);
                }
                this.setObjValue(oSym.getObjValue());
                break;
            }
            case 0: {
                this.mValue = oSym.mValue;
                this.setLineAndError(oSym.getLineAndError());
                break;
            }
            case 8: {
                this.setCntValue(oSym.getCntValue());
                this.setAddr(oSym.getAddr());
                break;
            }
            case 7: {
                this.setIdxValue(oSym.getIdxValue());
                break;
            }
            case 4: {
                this.setFuncValue(oSym.getFuncValue());
                break;
            }
            default: {
                this.setNumericValue(0.0);
            }
        }
        this.mStore = 0;
        return this;
    }

    static void delete(CalcSymbol oSym, CalcParser oParser) {
        assert (oSym.mType == 0 || oSym.mType == 1 || oSym.mType == 2 || oSym.mType == 3 || oSym.mType == 4 || oSym.mType == 5 || oSym.mType == 6 || oSym.mType == 7 || oSym.mType == 8 || oSym.mType == 9 || oSym.mType == 10);
        if (oParser.mbDeleteOk || (oSym.mStore & 0xFFFFFFEF) == 0) {
            oSym = null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        CalcSymbol oCompare = (CalcSymbol)object;
        if (this.mType != oCompare.mType) {
            return false;
        }
        if (this.mName == null || oCompare.mName == null) {
            return false;
        }
        if (!this.mName.equals(oCompare.mName)) {
            return false;
        }
        if (this.mStore != oCompare.mStore) {
            return false;
        }
        switch (this.mType) {
            case 1: {
                return true;
            }
            case 3: {
                return this.mValue.equals(oCompare.mValue);
            }
            case 2: 
            case 10: {
                return this.mValue.equals(oCompare.mValue);
            }
            case 0: {
                return this.mValue.equals(oCompare.mValue) && this.getLineAndError() == oCompare.getLineAndError();
            }
            case 5: {
                if (this.getScope() != oCompare.getScope()) {
                    return false;
                }
                if (this.mValue == null) {
                    return oCompare.mValue == null;
                }
                if (oCompare.mValue != null) {
                    return this.mValue.equals(oCompare.mValue);
                }
                return false;
            }
            case 6: 
            case 9: {
                return this.getObjValue() == oCompare.getObjValue();
            }
            case 7: {
                return this.getIdxValue() == oCompare.getIdxValue();
            }
            case 4: {
                return this.getFuncValue() == oCompare.getFuncValue();
            }
            case 8: {
                if (this.getAddr() != oCompare.getAddr()) {
                    return false;
                }
                return this.getCntValue() == oCompare.getCntValue();
            }
        }
        assert (false);
        return false;
    }

    public int hashCode() {
        int result = this.mType;
        result = result * 31 ^ (this.mName == null ? 0 : this.mName.hashCode());
        result = result * 31 ^ this.mStore;
        result = result * 31 ^ this.mType;
        switch (this.mType) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                result = result * 31 ^ this.mValue.hashCode();
                break;
            }
            case 0: {
                result = result * 31 ^ this.mValue.hashCode();
                result = result * 31 ^ this.getLineAndError();
                break;
            }
            case 5: {
                result = result * 31 ^ this.getScope();
                result = result * 31 ^ (this.mValue == null ? 0 : this.mValue.hashCode());
                break;
            }
            case 6: 
            case 9: {
                Obj obj = this.getObjValue();
                result = result * 31 ^ (obj == null ? 0 : obj.hashCode());
                break;
            }
            case 7: {
                result = result * 31 ^ this.getIdxValue();
                break;
            }
            case 4: {
                Method method = this.getFuncValue();
                result = result * 31 ^ (method == null ? 0 : method.hashCode());
                break;
            }
            case 8: {
                result = result * 31 ^ this.getAddr();
                result = result * 31 ^ this.getCntValue();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        assert (name != null);
        this.mName = name;
    }

    public int getType() {
        return this.mType;
    }

    void setType(int eType) {
        this.mType = eType;
    }

    int getStore() {
        return this.mStore;
    }

    void setStore(int eStore) {
        this.mStore = eStore;
    }

    int getLineAndError() {
        return this.mExtra;
    }

    void setLineAndError(int nLineAndError) {
        this.mExtra = nLineAndError;
    }

    int getScope() {
        return this.mExtra;
    }

    void setScope(int nScope) {
        this.mExtra = nScope;
    }

    int getAddr() {
        return this.mExtra;
    }

    void setAddr(int nAddr) {
        this.mExtra = nAddr;
    }

    int getObjs() {
        return this.mExtra;
    }

    void setObjs(int nObjs) {
        this.mExtra = nObjs;
    }

    CalcSymbol getNext() {
        return this.mNext;
    }

    void setNext(CalcSymbol oNext) {
        this.mNext = oNext;
    }

    public Obj getObjValue() {
        return this.mObjs != null ? this.mObjs[0] : null;
    }

    Obj[] getObjValues() {
        return this.mObjs;
    }

    void setObjValue(Obj oObj) {
        this.mObjs = null;
        this.setObjs(0);
        if (oObj != null) {
            this.setObjs(1);
            this.mObjs = new Obj[this.getObjs()];
            this.mObjs[0] = oObj;
        }
    }

    void setObjValues(Obj[] oObj) {
        this.mObjs = null;
        this.setObjs(0);
        if (oObj != null) {
            this.setObjs(oObj.length);
            this.mObjs = new Obj[this.getObjs()];
            for (int i = 0; i < this.getObjs(); ++i) {
                this.mObjs[i] = oObj[i];
            }
        }
    }

    Method getFuncValue() {
        return (Method)this.mValue;
    }

    Object getFuncValue(CalcParser oParser, CalcSymbol[] oArgs) {
        block4: {
            try {
                Method func = (Method)this.mValue;
                Object[] args = new Object[]{oParser, oArgs};
                func.invoke(null, args);
            }
            catch (IllegalAccessException e) {
                assert (e != null);
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled || e != null) break block4;
                throw new AssertionError();
            }
        }
        return this.mValue;
    }

    void setFuncValue(Method oFunc) {
        this.mValue = oFunc;
    }

    int getCntValue() {
        return (Integer)this.mValue;
    }

    void setCntValue(int nCnt) {
        this.mValue = nCnt;
    }

    public int getIdxValue() {
        return (Integer)this.mValue;
    }

    void setIdxValue(int nIdx) {
        this.mValue = nIdx;
    }

    public String getStringValue() {
        return this.mType == 1 ? null : (String)this.mValue;
    }

    void setStringValue(String str) {
        this.mValue = str;
    }

    public double getNumericValue() {
        return (Double)this.mValue;
    }

    void setNumericValue(double dbl) {
        this.mValue = new Double(dbl);
    }

    public String getErrorValue(IntegerHolder oErrorLine, IntegerHolder oErrorCode) {
        if (oErrorLine != null) {
            oErrorLine.value = CalcSymbol.decodeLine(this.mExtra);
        }
        if (oErrorCode != null) {
            oErrorCode.value = CalcSymbol.decodeErrorResId(this.mExtra);
        }
        return (String)this.mValue;
    }

    void setErrorValue(String err) {
        this.mValue = err;
    }

    void setTypeToString() {
        StringBuilder sStr;
        if (this.mType == 3) {
            sStr = new StringBuilder(FormCalcUtil.dblToStr(this.getNumericValue(), 11));
            FormCalcUtil.trimZeroes(sStr);
            FormCalcUtil.trimRadix(sStr);
            FormCalcUtil.trimSign(sStr);
            this.setStringValue(sStr.toString());
            this.mType = 2;
        } else if (this.mType == 5) {
            int n = this.mType = this.mValue != null ? 2 : 1;
        }
        if (this.mType == 2 && this.isNumeric()) {
            sStr = new StringBuilder(this.getStringValue());
            FormCalcUtil.trimSign(sStr);
            this.setStringValue(sStr.toString());
        }
    }

    boolean isNumeric() {
        boolean bRetVal = false;
        switch (this.mType) {
            case 3: {
                bRetVal = true;
                break;
            }
            case 2: 
            case 5: {
                if (this.mValue == null || this.getStringValue().length() <= 0) break;
                bRetVal = FormCalcUtil.strIsNumeric(this.getStringValue());
                break;
            }
        }
        return bRetVal;
    }

    private static boolean isFinite(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    static int encodeLineAndErrorResId(int nLine, int nResId) {
        assert ((nLine & 0xFFFF) == nLine);
        assert ((nResId & 0xFFFF) == nResId);
        return nLine << 16 | nResId & 0xFFFF;
    }

    static int decodeLine(int nLineAndErrorResId) {
        return nLineAndErrorResId >> 16;
    }

    static int decodeErrorResId(int nLineAndErrorResId) {
        return nLineAndErrorResId & 0xFFFF;
    }
}

