/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget;

import com.day.cq.analytics.testandtarget.PerformanceReportItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceReport {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceReport.class);
    private List<PerformanceReportItem> items = new ArrayList<PerformanceReportItem>();
    private PerformanceReportItem totals = null;
    private String winningExperienceName = "";

    public void addItem(PerformanceReportItem item) {
        if (item == null) {
            throw new IllegalArgumentException("item may not be null");
        }
        if ("Activity Totals".equalsIgnoreCase(item.getExperienceName())) {
            this.totals = item;
        } else {
            this.items.add(item);
        }
    }

    public List<PerformanceReportItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void setWinningExperienceName(String experienceName) {
        this.winningExperienceName = experienceName;
    }

    public String getWinningExperienceName() {
        return this.winningExperienceName;
    }

    public PerformanceReportItem getTotalPerformance() {
        int conversionCount = 0;
        double engagement = 0.0;
        int engagementCount = 0;
        double engagementTotal = 0.0;
        int entryCount = 0;
        for (PerformanceReportItem item : this.items) {
            conversionCount += item.getConversionCount();
            engagementCount += item.getEngagementCount();
            engagementTotal += item.getEngagementTotal();
            entryCount += item.getEntryCount();
        }
        double d = engagement = engagementCount != 0 ? engagementTotal / (double)engagementCount : 0.0;
        if (this.totals == null) {
            this.totals = new PerformanceReportItem();
            this.totals.setEntryCount(entryCount);
            this.totals.setConversionRate((double)conversionCount / (double)entryCount);
        }
        this.totals.setConversionCount(conversionCount);
        this.totals.setEngagement(engagement);
        this.totals.setEngagementTotal(engagementTotal);
        return this.totals;
    }
}

