/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Add dam size property"})
public class AddPropertyWorkflowProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AddPropertyWorkflowProcess.class);
    private static final String JCR_CONTENT_JCR_DATA = "jcr:content/jcr:data";
    private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";
    private static final int BATCH_SIZE = 500;

    public boolean addSize(Asset asset) throws RepositoryException {
        Rendition original = asset.getOriginal();
        Resource res = asset.adaptTo(Resource.class);
        Resource metadata = res.getChild(JCR_CONTENT_METADATA);
        if (metadata == null) {
            return false;
        }
        Node metadataNode = metadata.adaptTo(Node.class);
        Node originalBinary = original.adaptTo(Node.class);
        if (originalBinary != null && metadataNode != null && originalBinary.hasProperty(JCR_CONTENT_JCR_DATA)) {
            metadataNode.setProperty("dam:size", "" + originalBinary.getProperty(JCR_CONTENT_JCR_DATA).getBinary().getSize(), 3);
            return true;
        }
        return false;
    }

    private Resource getPayloadResource(WorkItem item, Session session) {
        Resource resource = null;
        if (item.getWorkflowData().getPayloadType().equals("JCR_PATH")) {
            String path = item.getWorkflowData().getPayload().toString();
            resource = this.getResourceResolver(session).getResource(path);
        }
        return resource;
    }

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            Resource resource = this.getPayloadResource(workItem, session);
            if (null != resource) {
                if (DamUtil.isAsset(resource)) {
                    Asset asset = DamUtil.resolveToAsset(resource);
                    this.addSize(asset);
                    return;
                }
                Iterator<Asset> assetList = DamUtil.getAssets(resource);
                int count = 0;
                while (assetList.hasNext()) {
                    Asset asset = assetList.next();
                    this.addSize(asset);
                    if (++count < 500) continue;
                    count = 0;
                    session.save();
                }
            } else {
                log.error("Content root could not be resolved");
            }
        }
        catch (Exception e) {
            log.warn("unexpected error occurred during adding Property. Cause: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

