/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.renditions.RenditionMaker;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.AssetUpdate;
import com.day.cq.dam.commons.util.AssetUpdateMonitor;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.core.impl.process.CreateFPORenditionProcess;
import com.day.cq.dam.core.impl.ui.preview.FolderPreviewUpdater;
import com.day.cq.dam.core.process.CreateThumbnailProcess;
import com.day.cq.dam.core.process.CreateWebEnabledImageProcess;
import com.day.cq.dam.core.process.UpdateFolderThumbnailProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component
@Service
@Property(name="process.label", value={"Thumbnail Process"})
public class ThumbnailProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailProcess.class);
    @Reference
    private RenditionMaker renditionMaker;
    @Reference
    private FolderPreviewUpdater folderPreviewUpdater;
    @Reference
    private AssetUpdateMonitor monitor;
    private CreateThumbnailProcess thumbnailCreator = new CreateThumbnailProcess();
    private CreateWebEnabledImageProcess webEnabledImageCreator = new CreateWebEnabledImageProcess();
    private UpdateFolderThumbnailProcess folderThumbnailUpdater = new UpdateFolderThumbnailProcess();
    private CreateFPORenditionProcess fpoCreator = new CreateFPORenditionProcess();
    private static final String DAM_SCENE7FILE = "dam:scene7File";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        block13: {
            AssetUpdate update = this.monitor.startUpdate(workItem, this.getResourceResolver(workflowSession.getSession()), this);
            try {
                Asset asset = update.getAsset(new AssetUpdate.Check(){

                    @Override
                    public boolean isNullAcceptable() throws WorkflowException {
                        String wfPayload = workItem.getWorkflowData().getPayload().toString();
                        String message = "execute: cannot process thumbnails, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                        throw new WorkflowException(message);
                    }
                });
                if (asset == null) break block13;
                try {
                    boolean isScene7Video;
                    Node assetNode = asset.adaptTo(Node.class);
                    Node contentNode = assetNode.getNode("jcr:content");
                    String scene7File = asset.getMetadataValueFromJcr(DAM_SCENE7FILE) != null ? asset.getMetadataValueFromJcr(DAM_SCENE7FILE) : "";
                    boolean bl = isScene7Video = DamUtil.isVideo(asset) && !StringUtils.isEmpty(scene7File);
                    if (!isScene7Video) {
                        if (!contentNode.hasProperty("dam:manualThumbnail") || !contentNode.getProperty("dam:manualThumbnail").getBoolean()) {
                            CreateThumbnailProcess.Config createThumbnailConfig = this.thumbnailCreator.parseConfig(metaData);
                            this.thumbnailCreator.createThumbnails(asset, createThumbnailConfig, this.renditionMaker);
                        }
                        CreateWebEnabledImageProcess.Config createWebEnabledImageConfig = this.webEnabledImageCreator.parseConfig(metaData);
                        try {
                            this.webEnabledImageCreator.createWebEnabledImage(workItem, createWebEnabledImageConfig, asset, this.renditionMaker);
                        }
                        catch (RepositoryException re) {
                            throw new WorkflowException(re);
                        }
                        CreateFPORenditionProcess.Config fpoConfig = this.fpoCreator.parseConfig(metaData);
                        this.fpoCreator.createFPO(workItem, fpoConfig, asset, this.renditionMaker);
                    } else {
                        log.info("Skip to create static thumbnails/webImage for a scene7 processed video.");
                    }
                    if (!contentNode.hasProperty("dam:manualThumbnail") || !contentNode.getProperty("dam:manualThumbnail").getBoolean()) {
                        try {
                            this.folderThumbnailUpdater.updateFolderThumbnail(asset, assetNode, this.folderPreviewUpdater);
                        }
                        catch (Exception e) {
                            update.error(e);
                            log.error("Error while updating folder thumbnail of asset ", (Object)asset.getPath(), (Object)e);
                        }
                    }
                }
                catch (RepositoryException re) {
                    throw new WorkflowException(re);
                }
            }
            finally {
                update.done();
            }
        }
    }

    protected void bindRenditionMaker(RenditionMaker renditionMaker) {
        this.renditionMaker = renditionMaker;
    }

    protected void unbindRenditionMaker(RenditionMaker renditionMaker) {
        if (this.renditionMaker == renditionMaker) {
            this.renditionMaker = null;
        }
    }

    protected void bindFolderPreviewUpdater(FolderPreviewUpdater folderPreviewUpdater) {
        this.folderPreviewUpdater = folderPreviewUpdater;
    }

    protected void unbindFolderPreviewUpdater(FolderPreviewUpdater folderPreviewUpdater) {
        if (this.folderPreviewUpdater == folderPreviewUpdater) {
            this.folderPreviewUpdater = null;
        }
    }

    protected void bindMonitor(AssetUpdateMonitor assetUpdateMonitor) {
        this.monitor = assetUpdateMonitor;
    }

    protected void unbindMonitor(AssetUpdateMonitor assetUpdateMonitor) {
        if (this.monitor == assetUpdateMonitor) {
            this.monitor = null;
        }
    }
}

