/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.keynote;

import com.day.cq.dam.commons.xml.DocumentBuilderFactoryProvider;
import com.day.cq.dam.handler.standard.keynote.ElementFilter;
import com.day.cq.dam.handler.standard.keynote.KeynoteBaseSlide;
import com.day.cq.dam.handler.standard.keynote.KeynoteMasterSlide;
import com.day.cq.dam.handler.standard.keynote.KeynoteSlide;
import com.day.image.Layer;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

@Deprecated
public class KeynotePresentation {
    private static final Logger log = LoggerFactory.getLogger(KeynotePresentation.class);
    public static final String NAMESPACES_KEYNOTE2 = "http://developer.apple.com/namespaces/keynote2";
    public static final String NAMESAPCES_SF = "http://developer.apple.com/namespaces/sf";
    public static final String NAMESAPCES_SFA = "http://developer.apple.com/namespaces/sfa";
    private static final int BUFFER = 2048;
    private Document document;
    private byte[] quicklookThumbnail;
    private Map<String, ByteArrayOutputStream> thumbnails;
    private Map<String, ByteArrayOutputStream> resources;
    private int width;
    private int height;
    private List<KeynoteSlide> slides;
    private LinkedHashMap<String, KeynoteMasterSlide> masters;

    public KeynotePresentation(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
        this.thumbnails = new HashMap<String, ByteArrayOutputStream>();
        this.resources = new HashMap<String, ByteArrayOutputStream>();
        while ((entry = zis.getNextEntry()) != null) {
            this.addEntry(entry, zis);
        }
    }

    public int getWidth() {
        if (this.width < 1) {
            this.extractSize();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height < 1) {
            this.extractSize();
        }
        return this.height;
    }

    public BufferedImage getThumbnail() throws IOException {
        if (this.quicklookThumbnail != null && this.quicklookThumbnail.length != 0) {
            return new Layer(new ByteArrayInputStream(this.quicklookThumbnail)).getImage();
        }
        BufferedImage slidethumb = null;
        for (KeynoteSlide slide : this.getSlides()) {
            if (!slide.isHidden()) {
                slidethumb = slide.getThumbnail();
            }
            if (slidethumb == null) continue;
            return slidethumb;
        }
        return null;
    }

    public List<KeynoteSlide> getSlides() {
        if (this.slides == null) {
            this.extractSlides();
        }
        return new ArrayList<KeynoteSlide>(this.slides);
    }

    public void removeSlide(KeynoteSlide slide) {
        slide.removeElement();
        this.slides.remove(slide);
    }

    public void removeMaster(KeynoteMasterSlide master) {
        master.removeElement();
        this.slides.remove(master);
    }

    public void clearUnusedMasters() {
        HashSet<KeynoteMasterSlide> used = new HashSet<KeynoteMasterSlide>();
        for (KeynoteSlide slide : this.slides) {
            used.add(slide.getMaster());
        }
        for (KeynoteSlide unused : CollectionUtils.subtract(this.masters.values(), used)) {
            KeynoteMasterSlide unusedslide = (KeynoteMasterSlide)((Object)unused);
            unusedslide.removeElement();
            this.masters.values().remove(unusedslide);
        }
    }

    public void clearUnusedResources() {
        HashSet<String> used = new HashSet<String>();
        for (KeynoteBaseSlide keynoteBaseSlide : this.slides) {
            used.addAll(keynoteBaseSlide.getResources());
        }
        for (KeynoteBaseSlide keynoteBaseSlide : this.masters.values()) {
            used.addAll(keynoteBaseSlide.getResources());
        }
        for (KeynoteBaseSlide keynoteBaseSlide : CollectionUtils.subtract(this.resources.keySet(), used)) {
            this.resources.remove(keynoteBaseSlide);
        }
    }

    public void save(OutputStream out) throws IOException {
        this.clearUnusedMasters();
        this.clearUnusedResources();
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(out));
        for (String resource : this.resources.keySet()) {
            int count;
            ZipEntry entry = new ZipEntry(resource);
            ByteArrayInputStream origin = new ByteArrayInputStream(this.resources.get(resource).toByteArray());
            zos.putNextEntry(entry);
            byte[] data = new byte[2048];
            while ((count = ((InputStream)origin).read(data, 0, 2048)) != -1) {
                zos.write(data, 0, count);
            }
        }
        for (String resource : this.thumbnails.keySet()) {
            int count;
            ByteArrayOutputStream baos = this.thumbnails.get(resource);
            if (baos == null) continue;
            ZipEntry entry = new ZipEntry(resource);
            ByteArrayInputStream origin = new ByteArrayInputStream(baos.toByteArray());
            zos.putNextEntry(entry);
            byte[] data = new byte[2048];
            while ((count = ((InputStream)origin).read(data, 0, 2048)) != -1) {
                zos.write(data, 0, count);
            }
        }
        ZipEntry entry = new ZipEntry("index.apxl");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int count;
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.document), new StreamResult(baos));
            ByteArrayInputStream origin = new ByteArrayInputStream(baos.toByteArray());
            zos.putNextEntry(entry);
            byte[] data = new byte[2048];
            while ((count = ((InputStream)origin).read(data, 0, 2048)) != -1) {
                zos.write(data, 0, count);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException(e.getMessage());
        }
        zos.close();
    }

    public InputStream getResource(String path) {
        if (this.resources.containsKey(path)) {
            return new ByteArrayInputStream(this.resources.get(path).toByteArray());
        }
        if (this.thumbnails.containsKey(path)) {
            return new ByteArrayInputStream(this.thumbnails.get(path).toByteArray());
        }
        return null;
    }

    public Collection<KeynoteMasterSlide> getMasters() {
        if (this.masters == null) {
            this.extractMasters();
        }
        return new ArrayList<KeynoteMasterSlide>(this.masters.values());
    }

    public KeynoteMasterSlide getMaster(String masterid) {
        if (this.masters == null) {
            this.extractMasters();
        }
        return this.masters.get(masterid);
    }

    private void extractMasters() {
        this.masters = new LinkedHashMap();
        DocumentTraversal dt = (DocumentTraversal)((Object)this.document);
        if (dt == null) {
            log.warn("Document is null. Cannot extract masters");
        } else {
            Element next;
            NodeIterator nit = dt.createNodeIterator(this.document, 1, new ElementFilter(2).skipNodes(NAMESPACES_KEYNOTE2, "presentation", "theme-list", "theme", "master-slides").acceptNodes(NAMESPACES_KEYNOTE2, "master-slide"), true);
            while ((next = (Element)nit.nextNode()) != null) {
                KeynoteMasterSlide keynoteMasterSlide = new KeynoteMasterSlide(next, this);
                this.masters.put(keynoteMasterSlide.getId(), keynoteMasterSlide);
            }
        }
    }

    private void extractSlides() {
        this.slides = new ArrayList<KeynoteSlide>();
        DocumentTraversal dt = (DocumentTraversal)((Object)this.document);
        if (dt == null) {
            log.warn("Document is null. Cannot extract slides");
        } else {
            Element next;
            NodeIterator nit = dt.createNodeIterator(this.document, 1, new ElementFilter(2).skipNodes(NAMESPACES_KEYNOTE2, "presentation", "slide-list").acceptNodes(NAMESPACES_KEYNOTE2, "slide"), true);
            while ((next = (Element)nit.nextNode()) != null) {
                this.slides.add(new KeynoteSlide(next, this));
            }
        }
    }

    private void extractSize() {
        DocumentTraversal dt = (DocumentTraversal)((Object)this.document);
        if (dt == null) {
            log.warn("Document is null. Cannot extract size");
        } else {
            Element next;
            NodeIterator nit = dt.createNodeIterator(this.document, 1, new ElementFilter(2).skipNodes(NAMESPACES_KEYNOTE2, "presentation").acceptNodes(NAMESPACES_KEYNOTE2, "size"), true);
            while ((next = (Element)nit.nextNode()) != null) {
                this.handleSize(next);
            }
        }
    }

    private void addEntry(ZipEntry ze, ZipInputStream zis) throws IOException, SAXException, ParserConfigurationException {
        if (!ze.isDirectory()) {
            if (ze.getName().equals("index.apxl")) {
                ByteArrayOutputStream dest = this.getExtractedBytes(zis);
                DocumentBuilderFactoryProvider factoryprovider = new DocumentBuilderFactoryProvider();
                DocumentBuilderFactory documentBuilderFactory = factoryprovider.createSecureBuilderFactory(true);
                this.document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(dest.toByteArray()));
            } else if (ze.getName().equals("QuickLook/Thumbnail.jpg") || ze.getName().equals("QuickLook/Thumbnail.png")) {
                this.quicklookThumbnail = this.getExtractedBytes(zis).toByteArray();
            } else if (ze.getName().startsWith("thumbs/")) {
                this.thumbnails.put(ze.getName(), this.getExtractedBytes(zis));
            } else {
                this.resources.put(ze.getName(), this.getExtractedBytes(zis));
            }
        }
    }

    private ByteArrayOutputStream getExtractedBytes(ZipInputStream zis) throws IOException {
        int count;
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        byte[] data = new byte[2048];
        while ((count = zis.read(data, 0, 2048)) != -1) {
            dest.write(data, 0, count);
        }
        return dest;
    }

    private void handleSize(Element element) {
        this.width = Integer.parseInt(element.getAttributeNS(NAMESAPCES_SFA, "w"));
        this.height = Integer.parseInt(element.getAttributeNS(NAMESAPCES_SFA, "h"));
    }
}

