/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.msoffice.wmf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WmfDecObj {
    private static final Logger log = LoggerFactory.getLogger(WmfDecObj.class);
    static final int M_PEN = 1;
    static final int M_BRUSH = 2;
    static final int M_FONT = 3;
    static final int M_BITMAP = 4;
    static final int M_CLIP = 5;
    static final int M_PALETTE = 6;
    private Color c;
    private Font f;
    private boolean f_underl;
    private int f_orient;
    private Rectangle r;
    private int magic;
    private Image ibrush;
    private int hatch;
    private int p_style;

    WmfDecObj(Color cc, int mm) {
        this.c = cc;
        this.magic = mm;
    }

    WmfDecObj(int penattr, Color cc) {
        this.c = cc;
        this.magic = 1;
        this.p_style = penattr;
    }

    WmfDecObj(Font ff, int underlined, int orientation) {
        this.f = ff;
        this.f_underl = underlined != 0;
        this.f_orient = orientation;
        this.magic = 3;
    }

    WmfDecObj(Image ii) {
        this.ibrush = ii;
        this.c = null;
        this.magic = 2;
    }

    WmfDecObj(int hatchstyle, Color cc, Color back) {
        this.c = cc;
        this.hatch = hatchstyle;
        this.ibrush = this.createOpaqueImage(hatchstyle, cc, back);
        this.magic = 2;
    }

    WmfDecObj(int left, int top, int right, int bottom) {
        this.r = new Rectangle(left, top, right - left, bottom - top);
        this.magic = 5;
    }

    Color getColor() {
        return this.c;
    }

    Image getImage() {
        return this.ibrush;
    }

    Font getFont() {
        return this.f;
    }

    boolean isUnderlined() {
        return this.f_underl;
    }

    int getFontOrientation() {
        return this.f_orient;
    }

    int getPenStyle() {
        return this.p_style;
    }

    Rectangle getRect() {
        return this.r;
    }

    int getMagic() {
        return this.magic;
    }

    Image createOpaqueImage(int hatchstyle, Color cc, Color back) {
        Image im;
        int i;
        int[] pixels = new int[64];
        int[][] set = new int[][]{{32, 33, 34, 35, 36, 37, 38, 39}, {4, 12, 20, 28, 36, 44, 52, 60}, {0, 9, 18, 27, 36, 45, 54, 63}, {7, 14, 21, 28, 35, 42, 49, 56}, {32, 33, 34, 35, 36, 37, 38, 39, 4, 12, 20, 28, 44, 52, 60}, {0, 9, 18, 27, 36, 45, 54, 63, 7, 14, 21, 28, 35, 42, 49, 56}};
        for (i = 0; i < 64; ++i) {
            pixels[i] = Color.white.getRGB();
        }
        try {
            for (i = 0; i < set[hatchstyle].length; ++i) {
                pixels[set[hatchstyle][i]] = cc.getRGB();
            }
            MemoryImageSource mis = new MemoryImageSource(8, 8, ColorModel.getRGBdefault(), pixels, 0, 8);
            im = Toolkit.getDefaultToolkit().createImage(mis);
            log.info("*** Toolkit.getDefaultToolkit().createImage");
            mis = null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            im = null;
            log.warn("unknown hatchstyle found.");
        }
        return im;
    }
}

