/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.msoffice.wmf;

import com.day.cq.dam.handler.standard.msoffice.wmf.WmfDecDC;
import com.day.cq.dam.handler.standard.msoffice.wmf.WmfDecObj;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WmfDecoder
implements ImageProducer {
    private static final Logger log = LoggerFactory.getLogger(WmfDecoder.class);
    boolean drawCross_if_error = true;
    private int minsize = 7;
    private int top;
    private int left;
    private int siz;
    private int obj;
    private int max;
    private int res;
    private int inch;
    private WmfDecObj[] gdiObj;
    private Stack DCstack;
    private int[] rgbPixels = null;
    private short[] params;
    private int width = -1;
    private int height = -1;
    private InputStream in;
    private ColorModel cmodel = ColorModel.getRGBdefault();
    private boolean err = false;
    private boolean producing = false;
    private Vector consumers = new Vector();
    private byte[] data;
    private int factor = 1;
    private static final int META_SETBKCOLOR = 513;
    private static final int META_SETBKMODE = 258;
    private static final int META_SETMAPMODE = 259;
    private static final int META_SETROP2 = 260;
    private static final int META_SETRELABS = 261;
    private static final int META_SETPOLYFILLMODE = 262;
    private static final int META_SETSTRETCHBLTMODE = 263;
    private static final int META_SETTEXTCHAREXTRA = 264;
    private static final int META_SETTEXTCOLOR = 521;
    private static final int META_SETTEXTJUSTIFICATION = 522;
    private static final int META_SETWINDOWORG = 523;
    private static final int META_SETWINDOWEXT = 524;
    private static final int META_SETVIEWPORTORG = 525;
    private static final int META_SETVIEWPORTEXT = 526;
    private static final int META_OFFSETWINDOWORG = 527;
    private static final int META_SCALEWINDOWEXT = 1040;
    private static final int META_OFFSETVIEWPORTORG = 529;
    private static final int META_SCALEVIEWPORTEXT = 1042;
    private static final int META_LINETO = 531;
    private static final int META_MOVETO = 532;
    private static final int META_EXCLUDECLIPRECT = 1045;
    private static final int META_INTERSECTCLIPRECT = 1046;
    private static final int META_ARC = 2071;
    private static final int META_ELLIPSE = 1048;
    private static final int META_FLOODFILL = 1049;
    private static final int META_PIE = 2074;
    private static final int META_RECTANGLE = 1051;
    private static final int META_ROUNDRECT = 1564;
    private static final int META_PATBLT = 1565;
    private static final int META_SAVEDC = 30;
    private static final int META_SETPIXEL = 1055;
    private static final int META_OFFSETCLIPRGN = 544;
    private static final int META_TEXTOUT = 1313;
    private static final int META_BITBLT = 2338;
    private static final int META_STRETCHBLT = 2851;
    private static final int META_POLYGON = 804;
    private static final int META_POLYLINE = 805;
    private static final int META_ESCAPE = 1574;
    private static final int META_RESTOREDC = 295;
    private static final int META_FILLREGION = 552;
    private static final int META_FRAMEREGION = 1065;
    private static final int META_INVERTREGION = 298;
    private static final int META_PAINTREGION = 299;
    private static final int META_SELECTCLIPREGION = 300;
    private static final int META_SELECTOBJECT = 301;
    private static final int META_SETTEXTALIGN = 302;
    private static final int META_DRAWTEXT = 1583;
    private static final int META_CHORD = 2096;
    private static final int META_SETMAPPERFLAGS = 561;
    private static final int META_EXTTEXTOUT = 2610;
    private static final int META_SETDIBTODEV = 3379;
    private static final int META_SELECTPALETTE = 564;
    private static final int META_REALIZEPALETTE = 53;
    private static final int META_ANIMATEPALETTE = 1078;
    private static final int META_SETPALENTRIES = 55;
    private static final int META_POLYPOLYGON = 1336;
    private static final int META_RESIZEPALETTE = 313;
    private static final int META_DIBBITBLT = 2368;
    private static final int META_DIBSTRETCHBLT = 2881;
    private static final int META_DIBCREATEPATTERNBRUSH = 322;
    private static final int META_STRETCHDIB = 3907;
    private static final int META_EXTFLOODFILL = 1352;
    private static final int META_RESETDC = 332;
    private static final int META_STARTDOC = 333;
    private static final int META_STARTPAGE = 79;
    private static final int META_ENDPAGE = 80;
    private static final int META_ABORTDOC = 82;
    private static final int META_ENDDOC = 94;
    private static final int META_DELETEOBJECT = 496;
    private static final int META_CREATEPALETTE = 247;
    private static final int META_CREATEBRUSH = 248;
    private static final int META_CREATEPATTERNBRUSH = 505;
    private static final int META_CREATEPENINDIRECT = 762;
    private static final int META_CREATEFONTINDIRECT = 763;
    private static final int META_CREATEBRUSHINDIRECT = 764;
    private static final int META_CREATEBITMAPINDIRECT = 765;
    private static final int META_CREATEBITMAP = 1790;
    private static final int META_CREATEREGION = 1791;
    private static final int MFCOMMENT = 15;
    private static final int SRCCOPY = 0xCC0020;
    private static final int PATCOPY = 15728673;
    private static final int PATINVERT = 5898313;
    private static final int DSTINVERT = 0x550009;
    private static final int BLACKNESS = 66;
    private static final int WHITENESS = 16711778;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int TA_BASELINE = 24;
    private static final int TA_BOTTOM = 8;
    private static final int TA_CENTER = 6;
    private static final int TA_UPDATECP = 1;
    static final int TA_TOP = 0;
    static final int OPAQUE = 2;
    static final int TRANSPARENT = 1;
    static final int ETO_GRAYED = 1;
    static final int ETO_OPAQUE = 2;
    static final int ETO_CLIPPED = 4;
    static final int PS_SOLID = 0;
    static final int PS_DASH = 1;
    static final int PS_DOT = 2;
    static final int PS_DASHDOT = 3;
    static final int PS_DASHDOTDOT = 4;
    static final int PS_NULL = 5;
    static final int PS_INSIDEFRAME = 6;

    public WmfDecoder(byte[] data) {
        this.data = data;
    }

    private InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        if (log.isDebugEnabled()) {
            log.debug("addConsumer:" + ic);
        }
        if (ic != null && !this.isConsumer(ic)) {
            this.consumers.addElement(ic);
        }
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        if (log.isDebugEnabled()) {
            log.debug("startProduction:" + ic);
        }
        this.addConsumer(ic);
        if (this.rgbPixels == null) {
            try {
                this.readWmf();
            }
            catch (Exception ex) {
                this.err = true;
                this.height = -1;
                this.width = -1;
                log.error("Error while reading wmf", ex);
            }
        }
        if (!this.producing) {
            this.producing = true;
            this.sendImage();
        }
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        if (log.isDebugEnabled()) {
            log.debug("Remove:" + ic);
        }
        this.consumers.removeElement(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    private void sendImage() {
        Vector xconsumers = (Vector)this.consumers.clone();
        Enumeration e = xconsumers.elements();
        while (e.hasMoreElements()) {
            ImageConsumer ic;
            if (log.isDebugEnabled()) {
                log.debug("consumers.size:" + this.consumers.size());
            }
            if (!this.isConsumer(ic = (ImageConsumer)e.nextElement())) continue;
            if (log.isDebugEnabled()) {
                log.debug("setPixels:" + ic);
            }
            if (!this.err) {
                ic.setDimensions(this.width, this.height);
                ic.setColorModel(this.cmodel);
                ic.setHints(30);
                for (int row = 0; row < this.height; ++row) {
                    ic.setPixels(0, row, this.width, 1, this.cmodel, this.rgbPixels, row * this.width, this.width);
                }
                ic.imageComplete(3);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("IMAGEERROR");
            }
            ic.imageComplete(4);
        }
        this.producing = false;
    }

    private static void printObserverStatus(String text, int status) {
        log.info(text);
        if ((status & 0x80) > 0) {
            log.info("ABORT ");
        }
        if ((status & 0x40) > 0) {
            log.info("ERROR ");
        }
        if ((status & 0x20) > 0) {
            log.info("ALLBITS ");
        }
        if ((status & 0x10) > 0) {
            log.info("FRAMEBITS ");
        }
        if ((status & 8) > 0) {
            log.info("SOMEBITS ");
        }
        if ((status & 4) > 0) {
            log.info("PROPERTIES ");
        }
        if ((status & 2) > 0) {
            log.info("HEIGHT ");
        }
        if ((status & 1) > 0) {
            log.info("WIDTH ");
        }
        log.info("");
    }

    public Dimension getDimension() throws IOException {
        this.in = this.getStream();
        this.chkHeader(this.in, null);
        this.params = new short[this.max];
        boolean go = true;
        while (go) {
            try {
                int rdSize = this.readInt32(this.in);
                short rdFunc = this.readInt16(this.in);
                for (int i = 0; i < rdSize - 3; ++i) {
                    this.params[i] = this.readInt16(this.in);
                }
                switch (rdFunc) {
                    case 524: {
                        this.factor = this.params[0] > this.params[1] && this.params[0] > 2000 ? 4 : (this.params[1] > this.params[0] && this.params[1] > 2000 ? 4 : 1);
                        go = false;
                        return new Dimension(this.params[1] / this.factor, this.params[0] / this.factor);
                    }
                }
            }
            catch (IOException ex) {
                go = false;
            }
        }
        return new Dimension(320, 240);
    }

    private void readWmf() throws IOException, InterruptedException {
        Dimension d = this.getDimension();
        this.in = this.getStream();
        if (this.chkHeader(this.in, d)) {
            throw new IOException("WMF file format not supported");
        }
        this.DCstack = new Stack();
        this.gdiObj = new WmfDecObj[this.obj];
        this.width = d.width;
        this.height = d.height;
        log.debug("Dimension:" + d);
        BufferedImage offscreen = new BufferedImage(d.width, d.height, 1);
        Graphics g = ((Image)offscreen).getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        this.params = new short[this.max];
        WmfDecDC DC = new WmfDecDC(this.width, this.height, this.left, this.top);
        DC.gr = g;
        this.DCstack.push(DC);
        while (this.readRecord(this.in)) {
        }
        this.rgbPixels = new int[d.width * d.height];
        PixelGrabber pg = new PixelGrabber(((Image)offscreen).getSource(), 0, 0, d.width, d.height, this.rgbPixels, 0, d.width);
        pg.grabPixels();
        if (log.isDebugEnabled()) {
            WmfDecoder.printObserverStatus("PixelGrabber status: ", pg.status());
        }
        log.debug("PixelGrabber status:" + pg.status());
        g.dispose();
    }

    private boolean chkHeader(InputStream in, Dimension d) throws IOException {
        short wid = 0;
        short hig = 0;
        int sum = 0;
        int[] hdr = new int[]{-12841, -25914, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 9, 768};
        block7: for (int i = 0; i < 14; ++i) {
            short j = this.readInt16(in);
            sum ^= j;
            if (i < 3 || i > 7) {
                if (j == hdr[i] || (i += 11) == 11 && j == hdr[11]) continue;
                return true;
            }
            switch (i) {
                case 3: {
                    this.left = j;
                    continue block7;
                }
                case 4: {
                    this.top = j;
                    continue block7;
                }
                case 5: {
                    wid = j;
                    continue block7;
                }
                case 6: {
                    hig = j;
                    continue block7;
                }
                case 7: {
                    hdr[10] = sum;
                    this.res = Toolkit.getDefaultToolkit().getScreenResolution();
                    this.inch = j;
                    if (log.isDebugEnabled()) {
                        log.debug("inch:  " + this.inch);
                        log.debug("sres:  " + this.res);
                    }
                    d.width = (wid - this.left) * this.res / this.inch;
                    d.height = (hig - this.top) * this.res / this.inch;
                }
            }
        }
        log.debug("dimension: " + d);
        this.siz = this.readInt32(in);
        this.obj = this.readInt16(in);
        this.max = this.readInt32(in);
        this.readInt16(in);
        log.debug("filesize(16): " + this.siz);
        log.debug("GDI-Objects : " + this.obj);
        log.debug("max rec size: " + this.max);
        return false;
    }

    private boolean readRecord(InputStream in) {
        int i;
        short rdFunc;
        int rdSize;
        WmfDecDC DC = (WmfDecDC)this.DCstack.peek();
        Graphics g = DC.gr;
        try {
            rdSize = this.readInt32(in);
            rdFunc = this.readInt16(in);
            for (i = 0; i < rdSize - 3; ++i) {
                this.params[i] = this.readInt16(in);
            }
        }
        catch (IOException ex) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("RFunc: " + Integer.toString(rdFunc, 16));
        }
        block2 : switch (rdFunc) {
            case 531: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaLineTo");
                }
                g.setColor(DC.aktpen.getColor());
                int a = DC.ytransfer(this.params[0]);
                int b = DC.xtransfer(this.params[1]);
                g.drawLine(DC.aktXpos, DC.aktYpos, b, a);
                DC.aktXpos = b;
                DC.aktYpos = a;
                break;
            }
            case 532: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaMoveTo");
                }
                DC.aktYpos = DC.ytransfer(this.params[0]);
                DC.aktXpos = DC.xtransfer(this.params[1]);
                break;
            }
            case 1564: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaRoundRect");
                }
                int e = this.transform(this.params[0], this.minsize);
                int f = this.transform(this.params[1], this.minsize);
                int a = DC.ytransfer(this.params[2]);
                int b = DC.xtransfer(this.params[3]);
                int c = DC.ytransfer(this.params[4]);
                int d = DC.xtransfer(this.params[5]);
                if (a < c && b < d) {
                    i = a;
                    a = c;
                    c = i;
                    i = b;
                    b = d;
                    d = i;
                }
                g.setColor(DC.aktbrush.getColor());
                g.fillRoundRect(d, c, b - d - 1, a - c - 1, f, e);
                g.setColor(DC.aktpen.getColor());
                g.drawRoundRect(d, c, b - d - 1, a - c - 1, f, e);
                break;
            }
            case 1051: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaRectangle");
                }
                int a = DC.ytransfer(this.params[0]);
                int b = DC.xtransfer(this.params[1]);
                int c = DC.ytransfer(this.params[2]);
                int d = DC.xtransfer(this.params[3]);
                if (a < c && b < d) {
                    i = a;
                    a = c;
                    c = i;
                    i = b;
                    b = d;
                    d = i;
                }
                if (DC.aktbrush.getImage() != null) {
                    this.drawOpaqePattern(g, DC.aktbrush.getImage(), d, c, b, a, null);
                    log.debug("*** drawOpaqePattern");
                } else {
                    g.setColor(DC.aktbrush.getColor());
                    g.fillRect(d, c, b - d - 1, a - c - 1);
                }
                g.setColor(DC.aktpen.getColor());
                g.drawRect(d, c, b - d - 1, a - c - 1);
                break;
            }
            case 1055: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSetpixel");
                }
                Color crco = new Color(this.getLoByteVal(this.params[0]), this.getHiByteVal(this.params[0]), this.getLoByteVal(this.params[1]));
                g.setColor(crco);
                crco = null;
                int a = DC.xtransfer(this.params[3]);
                int b = DC.ytransfer(this.params[2]);
                g.drawLine(a, b, a, b);
                break;
            }
            case 804: 
            case 805: {
                if (log.isDebugEnabled()) {
                    log.debug((rdFunc == 804 ? "MetaPolygon: " : "MetaPolyLine: ") + this.params[0]);
                }
                int[] xpoints = new int[this.params[0]];
                int[] ypoints = new int[this.params[0]];
                for (i = 0; i < this.params[0]; ++i) {
                    xpoints[i] = DC.xtransfer(this.params[i * 2 + 1]);
                    ypoints[i] = DC.ytransfer(this.params[i * 2 + 2]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(Integer.toString(xpoints[i], 16) + " " + Integer.toString(ypoints[i], 16));
                }
                if (rdFunc == 804) {
                    g.setColor(DC.aktbrush.getColor());
                    g.fillPolygon(xpoints, ypoints, this.params[0]);
                    g.setColor(DC.aktpen.getColor());
                    g.drawPolygon(xpoints, ypoints, this.params[0]);
                } else {
                    g.setColor(DC.aktpen.getColor());
                    g.drawPolyline(xpoints, ypoints, this.params[0]);
                }
                xpoints = null;
                ypoints = null;
                break;
            }
            case 1336: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaPolyPolygon: " + this.params[0]);
                }
                for (i = 0; i < this.params[0]; ++i) {
                    int[] xpoints = new int[this.params[i + 1]];
                    int[] ypoints = new int[this.params[i + 1]];
                    if (log.isDebugEnabled()) {
                        log.debug("Polygon #" + i + " Pts=" + this.params[i + 1]);
                    }
                    int b = this.params[0] + 1;
                    for (int c = 0; c < i; ++c) {
                        b += this.params[c + 1] * 2;
                    }
                    for (int a = 0; a < this.params[i + 1]; ++a) {
                        xpoints[a] = DC.xtransfer(this.params[b + a * 2]);
                        ypoints[a] = DC.ytransfer(this.params[b + a * 2 + 1]);
                        if (!log.isDebugEnabled()) continue;
                        log.debug(Integer.toString(xpoints[a], 16) + " " + Integer.toString(ypoints[a], 16));
                    }
                    g.setColor(DC.aktbrush.getColor());
                    g.fillPolygon(xpoints, ypoints, this.params[i + 1]);
                    g.drawPolygon(xpoints, ypoints, this.params[i + 1]);
                }
                break;
            }
            case 1048: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaEllipse");
                }
                int a = DC.ytransfer(this.params[0]);
                int b = DC.xtransfer(this.params[1]);
                int c = DC.ytransfer(this.params[2]);
                int d = DC.xtransfer(this.params[3]);
                g.setColor(DC.aktpen.getColor());
                g.drawOval(d, c, b - d, a - c);
                g.setColor(DC.aktbrush.getColor());
                g.fillOval(d, c, b - d, a - c);
                break;
            }
            case 2071: 
            case 2074: 
            case 2096: {
                if (log.isDebugEnabled()) {
                    switch (rdFunc) {
                        case 2071: {
                            log.debug("MetaArc");
                            break;
                        }
                        case 2074: {
                            log.debug("MetaPie");
                            break;
                        }
                        case 2096: {
                            log.debug("MetaChord");
                        }
                    }
                }
                int a = DC.ytransfer(this.params[0]);
                int b = DC.xtransfer(this.params[1]);
                int c = DC.ytransfer(this.params[2]);
                int d = DC.xtransfer(this.params[3]);
                int e = DC.ytransfer(this.params[4]);
                int f = DC.xtransfer(this.params[5]);
                int k = DC.ytransfer(this.params[6]);
                int l = DC.xtransfer(this.params[7]);
                g.setColor(DC.aktpen.getColor());
                int xm = l + (f - l) / 2;
                int ym = k + (e - k) / 2;
                if (rdFunc == 2074) {
                    g.drawLine(d, c, xm, ym);
                    g.drawLine(b, a, xm, ym);
                }
                if (rdFunc == 2096) {
                    g.drawLine(d, c, b, a);
                }
                int beg = this.arcus(d - xm, c - ym);
                int arc = this.arcus(b - xm, a - ym) - beg;
                if (arc < 0) {
                    arc += 360;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Beg=" + beg + " Arc=" + arc);
                }
                g.drawArc(l, k, f - l, e - k, beg, arc);
                break;
            }
            case 496: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaDeleteObject:" + this.params[0]);
                }
                this.gdiObj[this.params[0]] = null;
                break;
            }
            case 564: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSelectPalette:" + this.params[0] + " = " + this.gdiObj[this.params[0]]);
                }
                if (this.gdiObj[this.params[0]].getMagic() == 6) {
                    DC.aktpal = this.gdiObj[this.params[0]];
                    break;
                }
                log.error(" ---- internal ERROR in MetaSelectPalette -----");
                break;
            }
            case 300: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSelectClipRegion:" + this.params[0] + " = " + this.gdiObj[this.params[0]]);
                }
                if (this.gdiObj[this.params[0]] != null && this.gdiObj[this.params[0]].getMagic() == 5) {
                    DC.aktclip = this.gdiObj[this.params[0]];
                    g.clipRect(DC.aktclip.getRect().x, DC.aktclip.getRect().y, DC.aktclip.getRect().width, DC.aktclip.getRect().height);
                    break;
                }
                log.error(" ---- internal ERROR in MetaSelectClipregion -----");
                break;
            }
            case 301: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSelectObject:" + this.params[0] + " = " + this.gdiObj[this.params[0]]);
                }
                switch (this.gdiObj[this.params[0]].getMagic()) {
                    case 1: {
                        DC.aktpen = this.gdiObj[this.params[0]];
                        break;
                    }
                    case 3: {
                        DC.aktfont = this.gdiObj[this.params[0]];
                        break;
                    }
                    case 2: {
                        DC.aktbrush = this.gdiObj[this.params[0]];
                        break;
                    }
                    case 6: {
                        DC.aktpal = this.gdiObj[this.params[0]];
                        break;
                    }
                    case 4: {
                        DC.aktbmp = this.gdiObj[this.params[0]];
                        break;
                    }
                    case 5: {
                        DC.aktclip = this.gdiObj[this.params[0]];
                        if (log.isDebugEnabled()) {
                            log.debug("Select clipping rect");
                        }
                        g.clipRect(DC.aktclip.getRect().x, DC.aktclip.getRect().y, DC.aktclip.getRect().width, DC.aktclip.getRect().height);
                    }
                }
                break;
            }
            case 762: {
                Color crco;
                if (log.isDebugEnabled()) {
                    log.debug("MetaCreatePenIndirect");
                }
                boolean error = false;
                switch (this.params[0]) {
                    case 5: {
                        crco = null;
                        log.debug("MetaCreatePenIndirect: PS_NULL");
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        log.debug("MetaCreatePenIndirect: line attribute " + this.params[0] + " ignored");
                    }
                    case 0: 
                    case 6: {
                        crco = new Color(this.getLoByteVal(this.params[3]), this.getHiByteVal(this.params[3]), this.getLoByteVal(this.params[4]));
                        break;
                    }
                    default: {
                        crco = Color.black;
                        error = true;
                    }
                }
                if (!error) {
                    this.add_handle(new WmfDecObj(0, crco));
                    if (log.isDebugEnabled()) {
                        log.debug(crco.toString());
                    }
                    crco = null;
                    short a = this.params[1];
                    short b = this.params[2];
                }
                if (!log.isDebugEnabled() && !error) break;
                for (i = 0; i < rdSize - 3; ++i) {
                    if (i >= 16) continue;
                    log.debug(Integer.toString(this.params[i], 16) + " ");
                }
                break;
            }
            case 764: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaCreateBrushIndirect: Style=" + this.params[0]);
                    this.showparams(this.params, rdSize, rdFunc);
                }
                switch (this.params[0]) {
                    case 1: {
                        Color crco = DC.aktbackgnd;
                        this.add_handle(new WmfDecObj(crco, 2));
                        if (!log.isDebugEnabled()) break block2;
                        log.debug(crco.toString());
                        break;
                    }
                    case 0: {
                        Color crco = new Color(this.getLoByteVal(this.params[1]), this.getHiByteVal(this.params[1]), this.getLoByteVal(this.params[2]));
                        this.add_handle(new WmfDecObj(crco, 2));
                        if (log.isDebugEnabled()) {
                            log.debug(crco.toString());
                        }
                        crco = null;
                        break;
                    }
                    case 2: {
                        Color crco = new Color(this.getLoByteVal(this.params[1]), this.getHiByteVal(this.params[1]), this.getLoByteVal(this.params[2]));
                        this.add_handle(new WmfDecObj(this.params[3], crco, DC.aktbackgnd));
                        if (log.isDebugEnabled()) {
                            log.debug(crco.toString());
                        }
                        crco = null;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        Color crco = Color.gray;
                        this.add_handle(new WmfDecObj(crco, 2));
                        log.debug("pattern substitution used.");
                        break;
                    }
                    default: {
                        log.warn("(bad parameter!)");
                        break;
                    }
                }
                break;
            }
            case 1791: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaCreateRegion");
                    log.debug("params[5] sub records=" + this.params[5]);
                    for (i = 0; i < rdSize - 3; ++i) {
                        log.debug(Integer.toString(this.params[i], 10) + " ");
                    }
                }
                this.add_handle(new WmfDecObj(DC.xtransfer(this.params[7]), DC.ytransfer(this.params[8]), DC.xtransfer(this.params[9]), DC.xtransfer(this.params[10])));
                break;
            }
            case 1046: {
                log.debug("MetaIntersectClipRect is experimental");
                int n = DC.ytransfer(this.params[0]);
                int m = DC.xtransfer(this.params[1]);
                int l = DC.ytransfer(this.params[2]);
                int k = DC.xtransfer(this.params[3]);
                g.clipRect(k, l, m - k, n - l);
                break;
            }
            case 763: {
                byte[] text = new byte[80];
                int j = 0;
                for (i = 0; i < rdSize - 3 - 9 && (text[2 * i] = (byte)this.getLoByteVal(this.params[i + 9])) != 0; ++i) {
                    ++j;
                    text[2 * i + 1] = (byte)this.getHiByteVal(this.params[i + 9]);
                    if (text[2 * i + 1] == 0) break;
                    ++j;
                }
                String s = new String(text, 0, 0, j);
                if (log.isDebugEnabled()) {
                    log.debug("MetaCreateFontIndirect: " + this.params[0] + " " + this.params[1] + " " + s);
                }
                if (s.startsWith("Times")) {
                    s = "TimesRoman";
                } else if (s.startsWith("Arial")) {
                    s = "Helvetica";
                } else if (s.startsWith("Courier")) {
                    s = "Courier";
                } else if (s.startsWith("MS")) {
                    s = "Dialog";
                } else if (s.startsWith("WingDings")) {
                    s = "ZapfDingbats";
                }
                short b = this.params[1];
                short c = this.params[2];
                short d = this.params[3];
                short e = this.params[4];
                short f = this.params[5];
                short k = this.params[6];
                short l = this.params[7];
                i = this.params[8];
                int a = this.transform(this.params[0], this.minsize);
                Font fo = new Font(s, (e > 500 ? 1 : 0) + (this.getLoByteVal(f) > 0 ? 2 : 0), a);
                if (log.isDebugEnabled()) {
                    log.debug(fo.toString());
                }
                this.add_handle(new WmfDecObj(fo, this.getHiByteVal(f), d));
                fo = null;
                text = null;
                break;
            }
            case 247: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaCreatePalette");
                }
                Color crco = Color.black;
                this.add_handle(new WmfDecObj(crco, 6));
                break;
            }
            case 53: {
                if (log.isDebugEnabled()) {
                    this.showparams(this.params, rdSize, rdFunc);
                }
                log.debug("MetaRealizePalette");
                break;
            }
            case 260: {
                if (!log.isDebugEnabled()) break;
                i = this.params[0];
                log.debug("MetaSetRop2: ROP code=" + Integer.toString(i, 16));
                break;
            }
            case 262: {
                if (!log.isDebugEnabled()) break;
                log.debug("MetaSetPolyFillmode:" + this.params[0]);
                break;
            }
            case 263: {
                if (!log.isDebugEnabled()) break;
                log.debug("MetaSetStretchBltMode:" + this.params[0]);
                break;
            }
            case 298: {
                if (log.isDebugEnabled()) {
                    this.showparams(this.params, rdSize, rdFunc);
                }
                log.debug("MetaInvertRegion:" + this.params[0]);
                break;
            }
            case 524: {
                DC.winextY = this.params[0];
                DC.winextX = this.params[1];
                if (!log.isDebugEnabled()) break;
                log.debug("MetaSetWindowExt:  X:" + DC.winextX + "  Y:" + DC.winextY);
                break;
            }
            case 523: {
                DC.winorgY = this.params[0];
                DC.winorgX = this.params[1];
                if (!log.isDebugEnabled()) break;
                log.debug("MetaSetWindowOrg:  X:" + DC.winorgX + "  Y:" + DC.winorgY);
                break;
            }
            case 521: {
                DC.akttextc = new Color(this.getLoByteVal(this.params[0]), this.getHiByteVal(this.params[0]), this.getLoByteVal(this.params[1]));
                if (!log.isDebugEnabled()) break;
                log.debug("MetaSetTextColor: " + DC.akttextc);
                break;
            }
            case 1313: 
            case 2610: {
                Graphics g2;
                int e;
                int n;
                int m;
                int l;
                int k;
                int d;
                int c;
                int b;
                int a;
                if (rdFunc == 2610) {
                    a = this.params[2];
                    b = DC.ytransfer(this.params[0]);
                    c = DC.xtransfer(this.params[1]);
                    d = this.params[3];
                    if (log.isDebugEnabled()) {
                        log.debug("ExtTextOut:option =" + Integer.toString(d, 16));
                    }
                    k = DC.xtransfer(this.params[4]);
                    l = DC.ytransfer(this.params[5]);
                    m = DC.xtransfer(this.params[6]);
                    n = DC.ytransfer(this.params[7]);
                    log.debug("TextAlign=" + DC.akttextalign);
                    log.debug("x  =" + c + "\ty  =" + b);
                    log.debug("rx =" + k + "\try =" + l);
                    log.debug("rw =" + (m - k) + "\trh =" + (n - l));
                    e = d == 0 ? 3 : 7;
                } else {
                    a = this.params[0];
                    b = DC.ytransfer(this.params[(a + 1) / 2 + 1]);
                    c = DC.xtransfer(this.params[(a + 1) / 2 + 2]);
                    e = 0;
                    d = 0;
                    n = 0;
                    m = 0;
                    l = 0;
                    k = 0;
                }
                if ((d & 2) != 0) {
                    g.setColor(DC.aktbackgnd);
                    g.fillRect(k, l, m - k - 1, n - l - 1);
                    if (log.isDebugEnabled()) {
                        log.debug("ExtTextOut: using OPAQUE style");
                    }
                }
                if ((d & 1) != 0) {
                    g.setColor(Color.lightGray);
                } else {
                    g.setColor(DC.akttextc);
                }
                if ((d & 4) != 0) {
                    g2 = g.create();
                    g2.clipRect(k, l, m - k - 1, n - l - 1);
                    g = g2;
                    log.debug("ExtTextOut: using clipping rect");
                } else {
                    g2 = null;
                }
                g.setFont(DC.aktfont.getFont());
                FontMetrics fm = g.getFontMetrics();
                byte[] text = new byte[a];
                for (i = 0; i < a; ++i) {
                    text[i] = i % 2 == 0 ? (byte)this.getLoByteVal(this.params[e + i / 2 + 1]) : (byte)this.getHiByteVal(this.params[e + i / 2 + 1]);
                }
                String s = new String(text);
                if (DC.aktfont.getFontOrientation() != 0) {
                    g.drawString(s, c, b);
                    log.warn("non horizontal text is not supported: " + s);
                } else {
                    if (DC.akttextalign == 0) {
                        b += DC.aktfont.getFont().getSize();
                    }
                    g.drawString(s, c, b);
                    if (DC.aktfont.isUnderlined()) {
                        g.drawLine(c, b + 2, c + fm.stringWidth(s), b + 2);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((rdFunc == 2610 ? "MetaExtTextOut: " : "MetaTextOut: ") + new String(text, 0) + " (len=" + a + ") x=" + c + " y=" + b);
                }
                text = null;
                if (g2 == null) break;
                g2.dispose();
                break;
            }
            case 259: {
                if (log.isDebugEnabled()) {
                    this.showparams(this.params, rdSize, rdFunc);
                }
                log.debug("MetaSetMapMode: " + this.params[0] + " (ignored)");
                break;
            }
            case 513: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSetBkColor");
                }
                DC.aktbackgnd = new Color(this.getLoByteVal(this.params[0]), this.getHiByteVal(this.params[0]), this.getLoByteVal(this.params[1]));
                break;
            }
            case 522: {
                if (log.isDebugEnabled()) {
                    this.showparams(this.params, rdSize, rdFunc);
                }
                if (!log.isDebugEnabled() && this.params[0] == 0 && this.params[1] == 0) break;
                log.debug("MetaSetTextJustification: " + this.params[0] + " " + this.params[1]);
                break;
            }
            case 258: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSetBkMode:" + (this.params[0] == 1 ? "TRANSPARENT" : "OPAQUE"));
                }
                DC.aktbkmode = this.params[0];
                break;
            }
            case 302: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSetTextalign: " + this.params[0]);
                }
                DC.akttextalign = this.params[0];
                break;
            }
            case 30: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaSaveDC");
                }
                try {
                    DC = (WmfDecDC)this.DCstack.push(DC.clone());
                    ++DC.slevel;
                    DC.gr = g.create();
                }
                catch (Exception ex) {
                    log.error(" ---- internal ERROR in MetaSaveDC -----");
                }
                break;
            }
            case 295: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaRestoreDC" + this.params[0]);
                }
                switch (this.params[0]) {
                    case -1: {
                        g.dispose();
                        this.DCstack.pop();
                        DC = (WmfDecDC)this.DCstack.peek();
                        break block2;
                    }
                }
                while (DC.slevel > this.params[0] && !this.DCstack.empty()) {
                    g.dispose();
                    DC = (WmfDecDC)this.DCstack.pop();
                    g = DC.gr;
                }
                break;
            }
            case 1565: {
                int e = (this.params[1] << 16) + this.params[0];
                if (log.isDebugEnabled()) {
                    log.debug("MetaPatBlt: ROP code=" + Integer.toString(e, 16));
                    log.debug(DC.aktbrush.getImage().toString());
                }
                int a = DC.ytransfer(this.params[2]);
                int b = DC.xtransfer(this.params[3]);
                int c = DC.ytransfer(this.params[4]);
                int d = DC.xtransfer(this.params[5]);
                switch (e) {
                    case 16711778: {
                        g.setColor(Color.white);
                        g.fillRect(d, c, b, a);
                        break block2;
                    }
                    case 66: {
                        g.setColor(Color.black);
                        g.fillRect(d, c, b, a);
                        break block2;
                    }
                    case 15728673: {
                        Image im = DC.aktbrush.getImage();
                        if (im != null) {
                            this.drawOpaqePattern(g, im, d, c, d + b, c + a, null);
                            log.debug("*** drawOpaqePattern");
                            break block2;
                        }
                        g.setColor(DC.aktbrush.getColor());
                        g.fillRect(d, c, b, a);
                        break block2;
                    }
                }
                log.warn("unsupported ROP code:" + Integer.toString(e, 16));
                break;
            }
            case 2851: {
                if (log.isDebugEnabled()) {
                    log.debug("MetaStretchBlt:" + rdSize);
                }
                int e = (this.params[1] << 16) + this.params[0];
                int a = DC.ytransfer(this.params[6]);
                int b = DC.xtransfer(this.params[7]);
                int c = DC.ytransfer(this.params[8]);
                int d = DC.xtransfer(this.params[9]);
                switch (e) {
                    case 16711778: {
                        g.setColor(Color.white);
                        g.fillRect(d, c, b, a);
                        break;
                    }
                    case 66: {
                        g.setColor(Color.black);
                        g.fillRect(d, c, b, a);
                        break;
                    }
                    case 0xCC0020: {
                        Image im = this.OldBitmapImage(10, this.params);
                        if (im != null) {
                            g.drawImage(im, d, c, b, a, null);
                            log.debug("*** drawImage");
                            im = null;
                            break;
                        }
                        if (!this.drawCross_if_error) break block2;
                        g.setColor(Color.black);
                        g.drawLine(0, 0, DC.xtransfer(this.params[7]), DC.ytransfer(this.params[6]));
                        g.drawLine(DC.xtransfer(this.params[7]), 0, 0, DC.ytransfer(this.params[6]));
                        break;
                    }
                    default: {
                        log.warn("unsupported ROP code:" + Integer.toString(e, 16));
                        break;
                    }
                }
                break;
            }
            case 322: {
                Image im;
                if (log.isDebugEnabled()) {
                    log.debug("MetaDibCreatePatternBrush:" + this.params[0]);
                }
                if ((im = this.DIBBitmapImage(2, this.params)) != null) {
                    this.add_handle(new WmfDecObj(im));
                    break;
                }
                log.error("Error in MetaDibCreatePatternBrush");
                break;
            }
            case 2368: 
            case 2881: 
            case 3907: {
                int k = 0;
                switch (rdFunc) {
                    case 2368: {
                        k = -2;
                        if (!log.isDebugEnabled()) break;
                        log.debug("MetaDibBitBlt");
                        break;
                    }
                    case 3907: {
                        k = 1;
                        if (!log.isDebugEnabled()) break;
                        log.debug("MetaStretchDib");
                        break;
                    }
                    case 2881: {
                        k = 0;
                        if (!log.isDebugEnabled()) break;
                        log.debug("MetaDibStretchBlt");
                    }
                }
                int a = DC.ytransfer(this.params[6 + k]);
                int b = DC.xtransfer(this.params[7 + k]);
                int c = DC.ytransfer(this.params[8 + k]);
                int d = DC.xtransfer(this.params[9 + k]);
                int e = (this.params[1] << 16) + this.params[0];
                if (log.isDebugEnabled()) {
                    log.debug("dest X= " + d);
                    log.debug("dest Y= " + c);
                    log.debug("width = " + b);
                    log.debug("height= " + a);
                }
                switch (e) {
                    case 16711778: {
                        g.setColor(Color.white);
                        g.fillRect(d, c, b, a);
                        break;
                    }
                    case 66: {
                        g.setColor(Color.black);
                        g.fillRect(d, c, b, a);
                        break;
                    }
                    case 0xCC0020: {
                        Image im = this.DIBBitmapImage(10 + k, this.params);
                        if (im != null) {
                            g.drawImage(im, d, c, b, a, null);
                            log.debug("*** drawImage");
                            im = null;
                            break;
                        }
                        if (!this.drawCross_if_error) break block2;
                        g.setColor(Color.black);
                        g.drawLine(d, c, d + b, c + a);
                        g.drawLine(d + b, c, d, c + a);
                        break;
                    }
                    default: {
                        log.warn("unsupported ROP code:" + Integer.toString(e, 16));
                        break;
                    }
                }
                break;
            }
            case 1574: {
                switch (this.params[0]) {
                    case 15: {
                        if (!log.isDebugEnabled()) break block2;
                        byte[] text = new byte[this.params[1]];
                        for (i = 0; i < this.params[1]; ++i) {
                            text[i] = i % 2 == 0 ? (byte)this.getLoByteVal(this.params[i / 2 + 2]) : (byte)this.getHiByteVal(this.params[i / 2 + 2]);
                            if (text[i] == 0) break;
                        }
                        String s = new String(text, 0);
                        log.debug("MetaEscape/MFCOMMENT: " + s);
                        break;
                    }
                    default: {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug("MetaEscape #" + this.params[0] + " " + (this.params[1] + 1 >>> 2) + " Words");
                        break;
                    }
                }
                break;
            }
            case 0: {
                return false;
            }
            default: {
                this.showparams(this.params, rdSize, rdFunc);
            }
        }
        return true;
    }

    private void drawOpaqePattern(Graphics g, Image im, int x1, int y1, int x2, int y2, ImageObserver fr) {
        int width = x2 - x1;
        int height = y2 - y1;
        Graphics g2 = g.create(x1 - x1 % 8, y1 - y1 % 8, width + 8, height + 8);
        g2.clipRect(x1 % 8, y1 % 8, width, height);
        for (int i = 0; i < width + 1; i += 8) {
            for (int j = 0; j < height + 1; j += 8) {
                g2.drawImage(im, i, j, fr);
            }
        }
        g2.dispose();
    }

    private int getHiByteVal(int hhh) {
        int b;
        if (hhh > 0) {
            b = hhh / 256;
        } else {
            int iii = ~hhh;
            b = (byte)(iii >>> 8);
            b = (byte)(-1 - b);
        }
        return b < 0 ? b + 256 : b;
    }

    private int getLoByteVal(int hhh) {
        int b;
        if (hhh > 0) {
            b = hhh % 256;
        } else {
            int iii = ~hhh;
            b = (byte)(iii & 0xFF);
            b = (byte)(-1 - b);
        }
        return b < 0 ? b + 256 : b;
    }

    private int transform(int param, int minsize) {
        int i = param;
        if (i < 0) {
            i = -i;
        }
        try {
            i = i * this.res / this.inch;
            if (i < minsize) {
                i = minsize;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return i / this.factor;
    }

    private void showparams(short[] params, int recSize, int Func) {
        log.debug("MetaRecord: " + Integer.toString(Func, 16) + " RecSize=" + recSize);
        log.debug("Data: ");
        for (int i = 0; i < recSize - 3; ++i) {
            if (i >= 16) continue;
            log.debug(Integer.toString(params[i], 16) + " ");
        }
    }

    private int add_handle(WmfDecObj x) {
        for (int i = 0; i < this.obj; ++i) {
            if (this.gdiObj[i] != null) continue;
            this.gdiObj[i] = x;
            if (log.isDebugEnabled()) {
                log.debug("Handle: " + i + "Obj: " + x);
            }
            return i;
        }
        return -1;
    }

    private int readInt32(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    private short readInt16(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    private int arcus(int ank, int geg) {
        int val = -((int)(Math.atan((float)geg / (float)ank) * 180.0 / Math.PI));
        if (ank < 0) {
            val += 180;
        } else if (geg >= 0) {
            val += 360;
        }
        return val;
    }

    private Image DIBBitmapImage(int off, short[] params) {
        int i;
        int width = params[off + 2];
        short height = params[off + 4];
        int size = width * height;
        short bpp = params[off + 7];
        int x = 0;
        if (params[off + 0] != 40 || params[off + 1] != 0) {
            log.warn("unsupported data format");
            return null;
        }
        if (params[off + 6] != 1) {
            log.warn("not supported: planes=" + params[off + 17]);
            return null;
        }
        if (bpp != 4 && bpp != 8 && bpp != 1 && bpp != 24) {
            log.warn("not supported: " + bpp + " bits per pixel");
            return null;
        }
        if (params[off + 8] != 0 || params[off + 9] != 0) {
            log.warn("not supported: RLE-compression");
            return null;
        }
        int colors = 0;
        int[] palette = null;
        if (bpp <= 8) {
            colors = params[off + 16] != 0 ? params[off + 16] : 1 << bpp;
            palette = new int[colors];
            i = 0;
            while (i < colors) {
                x = params[off + 21 + 2 * i];
                palette[i] = x << 16;
                x = this.getHiByteVal(params[off + 20 + 2 * i]);
                int n = i;
                palette[n] = palette[n] + (x << 8);
                x = this.getLoByteVal(params[off + 20 + 2 * i]);
                int n2 = i;
                palette[n2] = palette[n2] + x;
                int n3 = i++;
                palette[n3] = palette[n3] - 0x1000000;
            }
        }
        int startbitmap = 20 + off + 2 * colors;
        int[] pixels = new int[size];
        if (log.isDebugEnabled()) {
            log.debug("bpp = " + bpp);
        }
        switch (bpp) {
            case 1: {
                i = 0;
                for (int k = height - 1; k >= 0; --k) {
                    for (int l = 0; l < width; l += 16) {
                        int m;
                        if ((m = params[++i - 1 + startbitmap]) < 0) {
                            m += 65536;
                        }
                        m = m >> 8 | m << 8;
                        for (int j = 0; j + l < width && j < 16; ++j) {
                            pixels[k * width + l + j] = (m & 0x8000) == 0 ? -16777216 : -1;
                            m <<= 1;
                        }
                        if (i % 2 == 0) continue;
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                i = 0;
                for (int k = height - 1; k >= 0; --k) {
                    for (int l = 0; l < width; ++l) {
                        switch (l % 4) {
                            case 0: {
                                x = this.getLoByteVal(params[++i - 1 + startbitmap]) >>> 4;
                                break;
                            }
                            case 1: {
                                x = this.getLoByteVal(params[i - 1 + startbitmap]) & 0xF;
                                break;
                            }
                            case 2: {
                                x = this.getHiByteVal(params[i - 1 + startbitmap]) >>> 4;
                                break;
                            }
                            case 3: {
                                x = this.getHiByteVal(params[i - 1 + startbitmap]) & 0xF;
                            }
                        }
                        pixels[k * width + l] = palette[x];
                    }
                }
                break;
            }
            case 8: {
                i = 0;
                for (int k = height - 1; k >= 0; --k) {
                    for (int l = 0; l < width; ++l) {
                        switch (l % 2) {
                            case 0: {
                                x = this.getLoByteVal(params[++i - 1 + startbitmap]);
                                break;
                            }
                            case 1: {
                                x = this.getHiByteVal(params[i - 1 + startbitmap]);
                            }
                        }
                        pixels[k * width + l] = palette[x];
                    }
                    if (i % 2 == 0) continue;
                    ++i;
                }
                break;
            }
            case 24: {
                int ii = 4 - size * 3 % 4;
                if (ii == 4) {
                    ii = 0;
                }
                boolean low = true;
                int count = 0;
                for (int jj = height - 1; jj >= 0; --jj) {
                    for (int kk = 0; kk < width; ++kk) {
                        int k1;
                        int j1;
                        int ll;
                        if (low) {
                            ll = this.getLoByteVal(params[++count - 1 + startbitmap]);
                            low = false;
                        } else {
                            ll = this.getHiByteVal(params[count - 1 + startbitmap]);
                            low = true;
                        }
                        if (low) {
                            j1 = this.getLoByteVal(params[++count - 1 + startbitmap]);
                            low = false;
                        } else {
                            j1 = this.getHiByteVal(params[count - 1 + startbitmap]);
                            low = true;
                        }
                        if (low) {
                            k1 = this.getLoByteVal(params[++count - 1 + startbitmap]);
                            low = false;
                        } else {
                            k1 = this.getHiByteVal(params[count - 1 + startbitmap]);
                            low = true;
                        }
                        pixels[jj * width + kk] = k1 << 16 & 0xFF0000 | j1 << 8 & 0xFF00 | ll & 0xFF | 0xFF000000;
                    }
                    for (int i1 = 0; i1 < ii; ++i1) {
                        if (i1 % 2 != 0) continue;
                        ++count;
                        low = false;
                    }
                }
                break;
            }
        }
        Image im = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        log.info("*** Toolkit.getDefaultToolkit().createImage");
        pixels = null;
        return im;
    }

    private Image OldBitmapImage(int off, short[] params) {
        int width = params[off];
        int height = params[off + 1];
        if (params[off + 3] != 1 || params[off + 4] != 1) {
            log.warn("sorry, the only supported format is: planes=1,bpp=1");
            return null;
        }
        int[] pixels = new int[width * height];
        int i = 0;
        for (int k = 0; k < height; ++k) {
            for (int l = 0; l < width; l += 16) {
                int m;
                if ((m = params[off + 5 + i++]) < 0) {
                    m += 65536;
                }
                m = m >> 8 | m << 8;
                for (int j = 0; j + l < width && j < 16; ++j) {
                    pixels[k * width + l + j] = (m & 0x8000) == 0 ? -16777216 : -1;
                    m <<= 1;
                }
            }
        }
        Image im = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        log.info("*** Toolkit.getDefaultToolkit().createImage");
        pixels = null;
        return im;
    }
}

