/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.ooxml;

import com.adobe.granite.asset.api.AssetException;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.handler.standard.ooxml.OpenOfficeHandler;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.poi.sl.draw.binding.ObjectFactory;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(inherit=true, metatype=false)
@Service
public class MSPowerPointOOXMLHandler
extends OpenOfficeHandler {
    private static final String SUB_ASSET_PREFIX = "slide_";
    private static final String PPTX_EXT = ".pptx";
    private static final Logger log = LoggerFactory.getLogger(MSPowerPointOOXMLHandler.class);
    public static final String MIMETYPE_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String DEFAULT_PAGES_REGEX = "^slide_[0-9]*.pptx";
    @Property(name="cq.dam.pptx.pages.regex", value={"^slide_[0-9]*.pptx"}, label="pptx pages regex", description="Regex for identifying pages in subassets folder. The pages will be shown in assets page viewer")
    public static final String PAGES_REGEX = "cq.dam.pptx.pages.regex";
    private String pagesRegex;
    private DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{MIMETYPE_PPTX};
    }

    private void removeSubAssets(Asset asset, AssetManager assetManager) {
        Collection<Asset> subAssets = asset.getSubAssets();
        for (Asset subAsset : subAssets) {
            assetManager.removeAsset(subAsset.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets;
        block16: {
            subAssets = new ArrayList<String>();
            if (asset.isSubAsset()) {
                return subAssets;
            }
            InputStream is = null;
            File tempSlideShowFile = null;
            FileOutputStream tempSlideShowOS = null;
            try {
                is = asset.getOriginal().getStream();
                boolean oldBatchMode = asset.isBatchMode();
                asset.setBatchMode(true);
                AssetManager assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
                this.removeSubAssets(asset, assetManager);
                XMLSlideShow slideShow = new XMLSlideShow(is);
                tempSlideShowFile = File.createTempFile("tempSlideShow", PPTX_EXT);
                tempSlideShowOS = FileUtils.openOutputStream(tempSlideShowFile);
                IOUtils.copy(asset.getOriginal().getStream(), (OutputStream)tempSlideShowOS);
                tempSlideShowOS.close();
                int i = 0;
                for (XSLFSlide srcSlide : slideShow.getSlides()) {
                    int slideNumber = ++i;
                    XMLSlideShow extractedSlide = this.extractSlideByIndex(tempSlideShowFile, slideNumber);
                    FileOutputStream itout = null;
                    File pptTmpFile = null;
                    FileInputStream iis = null;
                    try {
                        pptTmpFile = File.createTempFile("pptx", ".tmp");
                        itout = FileUtils.openOutputStream(pptTmpFile);
                        extractedSlide.write(itout);
                        String fileName = SUB_ASSET_PREFIX + slideNumber + PPTX_EXT;
                        iis = FileUtils.openInputStream(pptTmpFile);
                        Asset subAsset = asset.addSubAsset(fileName, asset.getMimeType(), iis);
                        subAssets.add(subAsset.getPath());
                        extractedSlide.close();
                    }
                    catch (IOException e) {
                        block15: {
                            try {
                                log.warn("error extracting subassets from asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                                if (!log.isDebugEnabled()) break block15;
                                log.debug("Stack Trace", e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(iis);
                                IOUtils.closeQuietly(itout);
                                FileUtils.deleteQuietly(pptTmpFile);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly(itout);
                        FileUtils.deleteQuietly(pptTmpFile);
                        continue;
                    }
                    IOUtils.closeQuietly(iis);
                    IOUtils.closeQuietly(itout);
                    FileUtils.deleteQuietly(pptTmpFile);
                }
                asset.adaptTo(Node.class).getSession().save();
                asset.setBatchMode(oldBatchMode);
                IOUtils.closeQuietly(is);
            }
            catch (IOException e) {
                log.warn("error parsing asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Stack Trace", e);
                }
                break block16;
            }
            catch (RepositoryException e2) {
                log.warn("error parsing asset {0} reason {1}", (Object)asset.getPath(), (Object)e2.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Stack Trace", e2);
                }
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(tempSlideShowOS);
                FileUtils.deleteQuietly(tempSlideShowFile);
            }
            IOUtils.closeQuietly(tempSlideShowOS);
            FileUtils.deleteQuietly(tempSlideShowFile);
        }
        this.cleanup(asset);
        this.updatePageRelations(asset);
        return subAssets;
    }

    private void cleanup(Asset asset) {
        AssetManager assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
        com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
        try {
            graniteAsset.removeRelation("pages");
        }
        catch (AssetException ae) {
            log.debug("Exception occured while deleting pages relation", ae);
        }
    }

    private void updatePageRelations(Asset asset) {
        Collection<Asset> subAssets = asset.getSubAssets();
        int numPages = 0;
        if (!subAssets.isEmpty()) {
            com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
            for (Asset subAsset : subAssets) {
                if (!subAsset.getName().matches(this.pagesRegex)) continue;
                graniteAsset.addRelation("pages", subAsset.getPath());
                ++numPages;
            }
            if (numPages > 0) {
                ResourceResolver resolver = graniteAsset.getResourceResolver();
                Node assetNode = resolver.getResource(asset.getPath()).adaptTo(Node.class);
                try {
                    Node metadataNode = assetNode.getNode("jcr:content/metadata");
                    metadataNode.setProperty("dam:numPages", numPages);
                }
                catch (PathNotFoundException e) {
                    log.warn("Unable to set dam:numPages on " + asset.getPath());
                    log.debug("Exception while setting dam:numPages on " + asset.getPath(), e);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to set dam:numPages on " + asset.getPath());
                    log.debug("Exception while setting dam:numPages on " + asset.getPath(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMLSlideShow extractSlideByIndex(File slideShowFile, int slideNumber) {
        XMLSlideShow xMLSlideShow;
        FileInputStream is = null;
        try {
            is = new FileInputStream(slideShowFile);
            XMLSlideShow slideShow = new XMLSlideShow(is);
            for (int i = slideShow.getSlides().size(); i > 0; --i) {
                if (i == slideNumber) continue;
                slideShow.removeSlide(i - 1);
            }
            xMLSlideShow = slideShow;
        }
        catch (Exception e) {
            block5: {
                try {
                    log.warn("extractSlideByIndex : Error extracting explicit slide number " + Integer.toString(slideNumber) + " reason " + e.getMessage());
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Stack Trace", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(is);
            return new XMLSlideShow();
        }
        IOUtils.closeQuietly(is);
        return xMLSlideShow;
    }

    @Override
    public BufferedImage getImage(final Rendition rendition, final Dimension dim) throws IOException {
        try {
            return this.callWithThreadContextClassLoader(new Callable<BufferedImage>(){

                @Override
                public BufferedImage call() throws Exception {
                    return MSPowerPointOOXMLHandler.this.dogetImage(rendition, dim);
                }
            });
        }
        catch (Exception e) {
            log.error("getImage: Cannot read image from {}: {}", (Object)rendition.getPath(), (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage dogetImage(Rendition rendition, Dimension dim) throws IOException {
        InputStream is = rendition.getStream();
        XMLSlideShow slideShow = new XMLSlideShow(is);
        List<XSLFSlide> slides = slideShow.getSlides();
        if (slides != null && !slides.isEmpty()) {
            dim = slideShow.getPageSize();
            try {
                BufferedImage image = new BufferedImage(dim.width, dim.height, 1);
                Graphics2D graphics = image.createGraphics();
                slides.get(0).draw(graphics);
                BufferedImage bufferedImage = new Layer(image).getImage();
                return bufferedImage;
            }
            catch (Exception e) {
                log.warn("getImage: error while getting image for {} reason: {}", (Object)rendition.getPath(), (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Stack Trace", e);
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        IOUtils.closeQuietly(is);
        return null;
    }

    @Activate
    private void activate(Map<String, Object> config) throws IOException {
        this.pagesRegex = OsgiUtil.toString(config.get(PAGES_REGEX), DEFAULT_PAGES_REGEX);
    }

    private String getFormattedDate(Date dt) {
        return this.df.format(dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T callWithThreadContextClassLoader(Callable<T> callable) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ObjectFactory.class.getClassLoader());
        try {
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

