/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.pdf;

import com.adobe.granite.asset.api.AssetException;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.granite.asset.api.AssetRelation;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.LazyRandomAccessFileByteReader;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.rasterizer.PageRasterizer;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.security.SecurityKeyPassword;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetReferenceResolver;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.gibson.fontmanager.FontManagerService;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(inherit=true, metatype=true)
@Service
public class PdfHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfHandler.class);
    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected ContentAwareMimeTypeService mimeTypeService;
    @Property(boolValue={false}, name="raster.annotation")
    private static final String RASTER_ANNOTATION = "raster.annotation";
    public static final String CONTENT_MIMETYPE = "application/pdf";
    private static final String AI_MIMETYPE_1 = "application/postscript";
    private static final String AI_MIMETYPE_2 = "application/illustrator";
    private int SIZE_THRESHOLD = 0x6400000;
    private static final double PDF_UNITS_PER_INCH = 72.0;
    @Reference
    private FontManagerService fontManagerService;
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetReferenceResolver caRefResolver;
    protected boolean rasterAnn;
    protected int maxPages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata;
        block64: {
            File tmp;
            PDFDocument pdfDoc;
            ByteReader byteReader;
            InputStream is;
            block61: {
                metadata = new ExtractedMetadata();
                log.debug("extractMetadata: importing asset [{}]", (Object)asset.getPath());
                is = null;
                byteReader = null;
                pdfDoc = null;
                tmp = null;
                is = asset.getOriginal().getStream();
                if (asset.getOriginal().getSize() > (long)this.SIZE_THRESHOLD) {
                    tmp = this.getTmpFile(asset.getName(), is);
                    byteReader = new LazyRandomAccessFileByteReader(tmp);
                } else {
                    byteReader = new InputStreamByteReader(is);
                }
                pdfDoc = PDFDocument.newInstance(byteReader, PDFOpenOptions.newInstance());
                boolean canRead = true;
                if (pdfDoc.isEncrypted()) {
                    try {
                        this.unlock(pdfDoc);
                    }
                    catch (Exception e) {
                        log.warn("extractMetadata: unable to decrypt document [{}]: ", (Object)asset.getPath(), (Object)e);
                        canRead = false;
                    }
                }
                if (canRead) {
                    DocumentMetadata pdfMetadata = XMPService.getDocumentMetadata(pdfDoc);
                    try {
                        PDFRectangle cropBox;
                        PDFPageTree pdfPageTree = pdfDoc.requirePages();
                        int numPages = pdfPageTree.getNumPages();
                        metadata.setMetaDataProperty("numPages", numPages);
                        if (numPages > 0 && (cropBox = pdfPageTree.getPage(0).getCropBox()) != null && cropBox.width() > 0.0 && cropBox.height() > 0.0) {
                            metadata.setMetaDataProperty("Physical width in inches", cropBox.width() / 72.0);
                            metadata.setMetaDataProperty("Physical height in inches", cropBox.height() / 72.0);
                        }
                    }
                    catch (Exception e) {
                        log.error("extractMetadata: error extracting number of pages in the pdf ", (Object)asset.getPath(), (Object)e);
                    }
                    if (pdfMetadata.getAuthor() != null) {
                        metadata.setMetaDataProperty("Author", pdfMetadata.getAuthor());
                    }
                    if (pdfMetadata.getCreationDate() != null) {
                        metadata.setMetaDataProperty("CreationDate", pdfMetadata.getCreationDate());
                    }
                    if (pdfMetadata.getModificationDate() != null) {
                        metadata.setMetaDataProperty("ModificationDate", pdfMetadata.getModificationDate());
                    }
                    if (pdfMetadata.getProducer() != null) {
                        metadata.setMetaDataProperty("Producer", pdfMetadata.getProducer());
                    }
                    if (pdfMetadata.getSubject() != null) {
                        metadata.setMetaDataProperty("Subject", pdfMetadata.getSubject());
                    }
                    if (pdfMetadata.getTitle() != null) {
                        metadata.setMetaDataProperty("Title", pdfMetadata.getTitle());
                    }
                    if (pdfMetadata.getTrapped() != null) {
                        metadata.setMetaDataProperty("Trapped", pdfMetadata.getTrapped());
                    }
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        pdfMetadata.exportXMP(out);
                        metadata.setXmp(new ByteArrayInputStream(out.toByteArray()));
                    }
                    catch (Exception e) {
                        log.error("extractMetadata: cannot import embedded XMP data for document [{}]: ", (Object)asset.getPath(), (Object)e);
                        log.warn("Failed to set xmp metadata for the asset {}, trying to extract using DefaultFormatHandler", (Object)asset.getPath());
                        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
                    }
                }
                if (pdfDoc == null) break block61;
                try {
                    pdfDoc.close();
                }
                catch (Exception e) {
                    log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e);
                }
            }
            if (byteReader != null) {
                try {
                    byteReader.close();
                }
                catch (IOException e) {
                    log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e);
                }
            }
            if (tmp != null) {
                FileUtils.deleteQuietly(tmp);
            }
            break block64;
            catch (IOException e) {
                block62: {
                    log.warn("extractMetadata: error while extracting metadata from PDF [{}]: ", (Object)asset.getPath(), (Object)e);
                    if (pdfDoc == null) break block62;
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e2) {
                        log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e2);
                    }
                }
                if (byteReader != null) {
                    try {
                        byteReader.close();
                    }
                    catch (IOException e3) {
                        log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e3);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e4) {
                        log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e4);
                    }
                }
                if (tmp != null) {
                    FileUtils.deleteQuietly(tmp);
                }
            }
            catch (PDFException e2) {
                block63: {
                    log.warn("extractMetadata: error while extracting metadata from PDF [{}]: ", (Object)asset.getPath(), (Object)e2);
                    if (pdfDoc == null) break block63;
                    {
                        catch (Throwable throwable) {
                            if (pdfDoc != null) {
                                try {
                                    pdfDoc.close();
                                }
                                catch (Exception e5) {
                                    log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e5);
                                }
                            }
                            if (byteReader != null) {
                                try {
                                    byteReader.close();
                                }
                                catch (IOException e6) {
                                    log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e6);
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e7) {
                                    log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e7);
                                }
                            }
                            if (tmp != null) {
                                FileUtils.deleteQuietly(tmp);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e8) {
                        log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e8);
                    }
                }
                if (byteReader != null) {
                    try {
                        byteReader.close();
                    }
                    catch (IOException e9) {
                        log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e9);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e10) {
                        log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e10);
                    }
                }
                if (tmp != null) {
                    FileUtils.deleteQuietly(tmp);
                }
            }
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        Dictionary<String, Object> properties = componentContext.getProperties();
        this.rasterAnn = PropertiesUtil.toBoolean(properties.get(RASTER_ANNOTATION), false);
    }

    private void unlock(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncryptionType encryptionType = pdfDoc.getEncryptionType();
        if (encryptionType.equals(PDFEncryptionType.Password)) {
            SecurityKeyPassword defaultKey = SecurityKeyPassword.newInstance(pdfDoc);
            pdfDoc.unlock(defaultKey);
        }
    }

    private RandomAccessFile getRandomAccessFileForWriting(File file, boolean create) throws IOException {
        RandomAccessFile raf = null;
        if (create) {
            file.delete();
            if (file.exists()) {
                throw new IOException("Failed to delete pre-existing file: \"" + file.getAbsolutePath() + "\".");
            }
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
        raf = new RandomAccessFile(file, "rw");
        return raf;
    }

    public ByteWriter getRAFByteWriter(File file) throws IOException {
        RandomAccessFile raf = this.getRandomAccessFileForWriting(file, true);
        RandomAccessFileByteWriter byteWriter = new RandomAccessFileByteWriter(raf);
        return byteWriter;
    }

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets;
        block51: {
            subAssets = new ArrayList<String>();
            if (asset.isSubAsset()) {
                return subAssets;
            }
            InputStream is = null;
            PDFDocument pdfDoc = null;
            try {
                boolean oldBatchMode;
                block57: {
                    AssetManager assetManager;
                    block56: {
                        is = asset.getOriginal().getStream();
                        pdfDoc = PdfHandler.parseDocument(is);
                        boolean canRead = true;
                        if (pdfDoc.isEncrypted()) {
                            try {
                                this.unlock(pdfDoc);
                            }
                            catch (Exception e) {
                                log.warn("extractMetadata: unable to decrypt document [{}]: ", (Object)asset.getPath(), (Object)e);
                                canRead = false;
                            }
                        }
                        if (!canRead) break block51;
                        String mimeType = asset.getMimeType();
                        oldBatchMode = asset.isBatchMode();
                        asset.setBatchMode(true);
                        assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
                        if (!(StringUtils.equals(mimeType, AI_MIMETYPE_1) || StringUtils.equals(mimeType, AI_MIMETYPE_2)) && null != this.mimeTypeService) {
                            InputStream pdfContentStream = asset.getOriginal().getStream();
                            try {
                                mimeType = pdfContentStream.markSupported() ? this.mimeTypeService.getMimeType(asset.getName(), pdfContentStream) : this.mimeTypeService.getMimeType(asset.getName(), new BufferedInputStream(pdfContentStream));
                            }
                            finally {
                                IOUtils.closeQuietly(pdfContentStream);
                            }
                        }
                        if (!StringUtils.equals(mimeType, AI_MIMETYPE_1) && !StringUtils.equals(mimeType, AI_MIMETYPE_2)) break block56;
                        this.cleanup(asset, assetManager);
                        PDFFontSet fontSet = this.fontManagerService.getPdfFontSet();
                        RasterizationOptions options = new RasterizationOptions();
                        options.setFontSet(fontSet);
                        options.processAnnotations(this.rasterAnn);
                        PDFOCProperties ocProps = pdfDoc.requireCatalog().getOCProperties();
                        if (ocProps == null) break block57;
                        int layer = 1;
                        PageRasterizer rasterizer = new PageRasterizer(pdfDoc.requirePages(), options);
                        while (rasterizer.hasNext()) {
                            block53: {
                                FileOutputStream itout = null;
                                File imageTmpFile = null;
                                FileInputStream iis = null;
                                try {
                                    BufferedImage image = rasterizer.next();
                                    imageTmpFile = File.createTempFile("image", ".tmp");
                                    Layer layerImage = new Layer(image);
                                    String fileName = "layer" + layer + ".png";
                                    itout = FileUtils.openOutputStream(imageTmpFile);
                                    layerImage.write("image/png", 1.0, itout);
                                    iis = FileUtils.openInputStream(imageTmpFile);
                                    Asset subAsset = asset.addSubAsset(fileName, "image/png", iis);
                                    subAssets.add(subAsset.getPath());
                                    this.updatePageRelations(asset, subAsset.getPath());
                                    IOUtils.closeQuietly(iis);
                                }
                                catch (Exception e) {
                                    log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                                    break block53;
                                }
                                finally {
                                    IOUtils.closeQuietly(iis);
                                    IOUtils.closeQuietly(itout);
                                    FileUtils.deleteQuietly(imageTmpFile);
                                }
                                IOUtils.closeQuietly(itout);
                                FileUtils.deleteQuietly(imageTmpFile);
                            }
                            ++layer;
                        }
                        break block57;
                    }
                    PDFPageTree pages = pdfDoc.requirePages();
                    this.cleanup(asset, assetManager);
                    if (pages == null) {
                        List<String> options = Collections.emptyList();
                        return options;
                    }
                    Iterator<PDFPage> iter = pdfDoc.requirePages().iterator();
                    PMMService pmmService = new PMMService(pdfDoc);
                    int i = 0;
                    while (iter.hasNext()) {
                        block58: {
                            ByteWriter byteWriter;
                            FileInputStream fis;
                            File tmpFile;
                            PDFDocument document;
                            block54: {
                                document = pmmService.extractPages(iter.next(), 1, PMMOptions.newInstance(PMMOptions.AllOptions), PDFOpenOptions.newInstance());
                                String fileName = "page" + (i + 1) + ".pdf";
                                tmpFile = null;
                                fis = null;
                                byteWriter = null;
                                tmpFile = File.createTempFile(fileName, ".pdf");
                                byteWriter = this.getRAFByteWriter(tmpFile);
                                document.save(byteWriter, PDFSaveFullOptions.newInstance());
                                fis = new FileInputStream(tmpFile);
                                Asset subAsset = asset.addSubAsset(fileName, CONTENT_MIMETYPE, fis);
                                subAssets.add(subAsset.getPath());
                                this.updatePageRelations(asset, subAsset.getPath());
                                if (document == null) break block54;
                                try {
                                    document.close();
                                }
                                catch (Exception e) {
                                    log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e);
                                }
                            }
                            if (byteWriter != null) {
                                try {
                                    byteWriter.close();
                                }
                                catch (IOException e) {
                                    log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e);
                                }
                            }
                            IOUtils.closeQuietly(fis);
                            FileUtils.deleteQuietly(tmpFile);
                            break block58;
                            catch (Exception e) {
                                block55: {
                                    try {
                                        log.warn("createSubAsset: error while creating subasset [" + (i + 1) + "] for [{}]: ", (Object)asset.getPath(), (Object)e);
                                        if (document == null) break block55;
                                    }
                                    catch (Throwable throwable) {
                                        if (document != null) {
                                            try {
                                                document.close();
                                            }
                                            catch (Exception e2) {
                                                log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e2);
                                            }
                                        }
                                        if (byteWriter != null) {
                                            try {
                                                byteWriter.close();
                                            }
                                            catch (IOException e3) {
                                                log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e3);
                                            }
                                        }
                                        IOUtils.closeQuietly(fis);
                                        FileUtils.deleteQuietly(tmpFile);
                                        throw throwable;
                                    }
                                    try {
                                        document.close();
                                    }
                                    catch (Exception e4) {
                                        log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e4);
                                    }
                                }
                                if (byteWriter != null) {
                                    try {
                                        byteWriter.close();
                                    }
                                    catch (IOException e5) {
                                        log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e5);
                                    }
                                }
                                IOUtils.closeQuietly(fis);
                                FileUtils.deleteQuietly(tmpFile);
                            }
                        }
                        ++i;
                    }
                }
                asset.adaptTo(Node.class).getSession().save();
                asset.setBatchMode(oldBatchMode);
            }
            catch (Exception e) {
                log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
            }
            finally {
                if (pdfDoc != null) {
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e) {
                        log.warn("processSubAssets: error while closing parent pdf document [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
                IOUtils.closeQuietly(is);
            }
        }
        return subAssets;
    }

    private void updatePageRelations(Asset asset, String subAssetPath) {
        com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
        graniteAsset.addRelation("pages", subAssetPath);
    }

    private void cleanup(Asset asset, AssetManager assetManager) {
        ResourceResolver resolver = asset.adaptTo(Resource.class).getResourceResolver();
        Collection<Asset> subAssets = asset.getSubAssets();
        boolean saveReqd = !subAssets.isEmpty();
        for (Asset subAsset : subAssets) {
            assetManager.removeAsset(subAsset.getPath());
        }
        try {
            com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
            graniteAsset.removeRelation("pages");
            if (saveReqd) {
                resolver.commit();
            }
        }
        catch (AssetException ae) {
            log.debug("Exception occurred while deleting pages relation", ae);
        }
        catch (PersistenceException e) {
            log.debug("Exception occurred while removing subassets", e);
        }
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{CONTENT_MIMETYPE, AI_MIMETYPE_2};
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        RasterizationOptions rasterizationOptions = null;
        try {
            rasterizationOptions = new RasterizationOptions();
        }
        catch (Throwable e) {
            log.warn("getImage: unable to create rasterization option: ", (Object)rendition.getPath(), (Object)e);
            throw new IOException(e.getMessage());
        }
        try {
            PDFFontSet fontSet = null;
            fontSet = this.fontManagerService.getPdfFontSet();
            rasterizationOptions.setFontSet(fontSet);
        }
        catch (Exception e) {
            log.warn("exception: fontmanagerserviceimpl with [{}]", (Object)e.getMessage());
        }
        rasterizationOptions.ignoreErrors(true);
        rasterizationOptions.processAnnotations(this.rasterAnn);
        try {
            return this.getImage(rendition, rasterizationOptions, dim);
        }
        catch (Exception e) {
            log.warn("getImage: unable to generate image : ", (Object)rendition.getPath(), (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(Rendition rendition, RasterizationOptions rasterizationOptions, Dimension dim) throws Exception {
        File tmp;
        BufferedImage image;
        ByteReader byteReader;
        block17: {
            PDFDocument pdfDoc;
            block16: {
                byteReader = null;
                pdfDoc = null;
                image = null;
                tmp = null;
                try {
                    if (rendition.getSize() > (long)this.SIZE_THRESHOLD) {
                        tmp = this.getTmpFile(rendition.getAsset().getName(), rendition.getStream());
                        byteReader = new LazyRandomAccessFileByteReader(tmp);
                    } else {
                        byteReader = new InputStreamByteReader(rendition.getStream());
                    }
                    PDFOpenOptions openOptions = PDFOpenOptions.newInstance();
                    ArrayList<CustomDecodeFilter> filters = new ArrayList<CustomDecodeFilter>();
                    filters.add(new JPXDecodeFilter());
                    filters.add(new JBIG2CustomFilter());
                    openOptions.registerCustomFilters(filters);
                    pdfDoc = PDFDocument.newInstance(byteReader, openOptions);
                    if (!pdfDoc.isEncrypted()) break block16;
                    try {
                        this.unlock(pdfDoc);
                    }
                    catch (Exception e) {
                        log.warn("getImage: unable to decrypt document [{}]: ", (Object)rendition.getPath(), (Object)e);
                        BufferedImage bufferedImage = null;
                        if (pdfDoc != null) {
                            pdfDoc.close();
                        }
                        if (byteReader != null) {
                            byteReader.close();
                        }
                        if (tmp != null) {
                            FileUtils.deleteQuietly(tmp);
                        }
                        return bufferedImage;
                    }
                }
                catch (Throwable throwable) {
                    if (pdfDoc != null) {
                        pdfDoc.close();
                    }
                    if (byteReader != null) {
                        byteReader.close();
                    }
                    if (tmp != null) {
                        FileUtils.deleteQuietly(tmp);
                    }
                    throw throwable;
                }
            }
            PDFPageTree pages = pdfDoc.requirePages();
            PDFPage page = pages.getPage(0);
            Dimension d = this.calculateRasterizeDim(dim, page.getCropBox());
            rasterizationOptions.setWidth(d.width);
            rasterizationOptions.setHeight(d.height);
            PageRasterizer rasterizer = new PageRasterizer(pages, rasterizationOptions);
            if (rasterizer.hasNext() && (image = rasterizer.next()) != null) {
                Layer layer = new Layer(image);
                image = layer.getImage();
            }
            if (pdfDoc == null) break block17;
            pdfDoc.close();
        }
        if (byteReader != null) {
            byteReader.close();
        }
        if (tmp != null) {
            FileUtils.deleteQuietly(tmp);
        }
        return image;
    }

    private static PDFDocument parseDocument(InputStream input) throws IOException, PDFException {
        InputStreamByteReader byteReader = null;
        PDFDocument pdfDoc = null;
        byteReader = new InputStreamByteReader(input);
        try {
            pdfDoc = PDFDocument.newInstance(byteReader, PDFOpenOptions.newInstance());
        }
        catch (PDFException e) {
            log.warn("extractMetadata: error while reading PDF [{}]: ", e);
            throw e;
        }
        return pdfDoc;
    }

    private Dimension calculateRasterizeDim(Dimension dim, PDFRectangle cropBox) throws PDFException {
        double scale;
        if (dim == null || cropBox == null) {
            return new Dimension();
        }
        double cropWidth = cropBox.width();
        double cropHeight = cropBox.height();
        if (cropWidth == 0.0 || cropHeight == 0.0) {
            return new Dimension();
        }
        if (dim.getWidth() <= 0.0 && dim.getHeight() <= 0.0) {
            scale = 1.0;
        } else if (dim.getWidth() <= 0.0) {
            scale = dim.getHeight() / cropHeight;
        } else if (dim.getHeight() <= 0.0) {
            scale = dim.getWidth() / cropWidth;
        } else {
            double scaleX = dim.getWidth() / cropWidth;
            double scaleY = dim.getHeight() / cropHeight;
            scale = Math.min(scaleX, scaleY);
        }
        int width = (int)Math.round(scale * cropWidth);
        int height = (int)Math.round(scale * cropHeight);
        return new Dimension(width, height);
    }

    @Override
    public Iterator<? extends AssetRelation> processRelated(Asset asset) {
        if (!asset.isSubAsset()) {
            return this.caRefResolver.resolve(asset);
        }
        return super.processRelated(asset);
    }

    private File getTmpFile(String assetName, InputStream is) throws IOException {
        String extn = ".tmp";
        String nameWithoutExtn = assetName;
        int dotIdx = assetName.lastIndexOf(46);
        if (dotIdx > 0) {
            nameWithoutExtn = assetName.substring(0, dotIdx);
            extn = assetName.substring(dotIdx);
        }
        File tmp = File.createTempFile("cq5dam-" + nameWithoutExtn, extn);
        FileUtils.copyInputStreamToFile(is, tmp);
        return tmp;
    }

    protected void bindMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        this.mimeTypeService = contentAwareMimeTypeService;
    }

    protected void unbindMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        if (this.mimeTypeService == contentAwareMimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindFontManagerService(FontManagerService fontManagerService) {
        this.fontManagerService = fontManagerService;
    }

    protected void unbindFontManagerService(FontManagerService fontManagerService) {
        if (this.fontManagerService == fontManagerService) {
            this.fontManagerService = null;
        }
    }

    protected void bindCaRefResolver(AssetReferenceResolver assetReferenceResolver) {
        this.caRefResolver = assetReferenceResolver;
    }

    protected void unbindCaRefResolver(AssetReferenceResolver assetReferenceResolver) {
        if (this.caRefResolver == assetReferenceResolver) {
            this.caRefResolver = null;
        }
    }

    private static class JBIG2CustomFilter
    implements CustomDecodeFilter {
        private JBIG2CustomFilter() {
        }

        @Override
        public ASName getName() {
            return ASName.k_JBIG2Decode;
        }

        @Override
        public InputStream decode(InputStream in, FilterParams filterParams) throws CustomFilterException {
            JBIG2Decoder decoder = new JBIG2Decoder();
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            try {
                byte[] data;
                byte[] buff = new byte[8000];
                int bytesRead = 0;
                while ((bytesRead = in.read(buff)) != -1) {
                    bao.write(buff, 0, bytesRead);
                }
                byte[] b = bao.toByteArray();
                if (filterParams != null && filterParams.containsKey("JBIG2Globals") && (data = (byte[])filterParams.get("JBIG2Globals")) != null) {
                    decoder.setGlobalData(data);
                }
                decoder.decodeJBIG2(b);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decoder.getPageAsJBIG2Bitmap(0).getData(true));
                return byteArrayInputStream;
            }
            catch (IOException e) {
                throw new CustomFilterException("Could not decode using custom filter", e);
            }
            catch (JBIG2Exception e) {
                throw new CustomFilterException("Could not decode using custom filter", e);
            }
            finally {
                try {
                    bao.close();
                }
                catch (IOException e) {
                    log.error("Error closing the stream: ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private static class JPXDecodeFilter
    implements CustomDecodeFilter {
        private JPXDecodeFilter() {
        }

        @Override
        public ASName getName() {
            return ASName.k_JPXDecode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream decode(InputStream is, FilterParams filterParams) throws CustomFilterException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                BufferedImage bufImage = ImageIO.read(is);
                if (bufImage != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((DataBufferByte)bufImage.getData().getDataBuffer()).getData());
                    return byteArrayInputStream;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            catch (IOException e) {
                log.error("Error decoding the JPX: ", (Object)e.getMessage(), (Object)e);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error("Error closing the stream: ", (Object)e.getMessage(), (Object)e);
                }
            }
            return null;
        }
    }
}

