/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.word.extraction;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.indd.AbstractPageExtractionHandler;
import com.day.cq.dam.indd.PageBuilder;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.dam.indd.PageExtractionException;
import com.day.cq.dam.indd.PageExtractionHandler;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.PicturesTable;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component
@Service(value={PageExtractionHandler.class})
@Properties(value={@Property(name="extractionhandler.label", value={"Word Extraction Handler"}, propertyPrivate=true), @Property(name="extractionhandler.description", value={"Extraction Handler for a MS Word files."}, propertyPrivate=true)})
public class WordExtractionHandler
extends AbstractPageExtractionHandler {
    private static final Logger log = LoggerFactory.getLogger(WordExtractionHandler.class);
    private static final String TEXT_COMPONENT = "foundation/components/text";
    private static final String IMAGE_COMPONENT = "foundation/components/image";
    private static final String TEXT_IMAGE_COMPONENT = "foundation/components/textimage";
    private static final int JUSTIFICATION_RIGHT = 2;
    private static final int JUSTIFICATION_CENTER = 1;
    private static final short TEXT_TYPE = 0;
    private static final short IMAGE_TYPE = 1;
    private static final short TEXT_IMAGE_TYPE = 2;

    @Override
    public RenditionPicker getRenditionPicker() {
        return new RenditionPicker(){

            @Override
            public Rendition getRendition(Asset asset) {
                if (asset == null) {
                    return null;
                }
                String assetMime = asset.getMimeType();
                if (assetMime.matches("application.*msword") || assetMime.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return asset.getRendition("original");
                }
                return null;
            }
        };
    }

    @Override
    public Page extractPage(Rendition rend, String pageRoot, String pageName, String pageTitle, String pageTemplate, String pageDesign) throws PageExtractionException {
        String rendMime = rend.getAsset().getMimeType();
        if (rendMime.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return this.extractDocx(rend, pageRoot, pageName, pageTitle, pageTemplate, pageDesign);
        }
        if (rendMime.matches("application.*msword")) {
            return this.extractDoc(rend, pageRoot, pageName, pageTitle, pageTemplate, pageDesign);
        }
        String msg = "No appropriate extractor found for: " + rend.getAsset().getName();
        log.info(msg);
        throw new PageExtractionException(msg);
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    private Page extractDoc(Rendition rend, String pageRoot, String pageName, String pageTitle, String pageTemplate, String pageDesign) throws PageExtractionException {
        Page page;
        log.info("Beginning page extraction from: " + rend.getAsset().getPath());
        int textIndex = 0;
        int textImageIndex = 0;
        int imageIndex = 0;
        ResourceResolver resourceResolver = rend.getResourceResolver();
        PageBuilder pageBuilder = this.getPageBuilder(resourceResolver);
        PageComponent par = null;
        String subAssetPath = rend.getAsset().getPath() + "/subassets";
        log.debug("Images in the page will point to the appropriate subassets located at: " + subAssetPath);
        InputStream is = null;
        try {
            is = rend.getAsset().getOriginal().getStream();
            HWPFDocument doc = new HWPFDocument(is);
            if (pageBuilder != null) {
                par = this.createParComponent(pageBuilder);
                Paragraph[] paragraphs = this.getParagraphs(doc.getRange());
                log.debug("Found " + paragraphs.length + " paragraphs in the document.");
                block11: for (int i = 0; i < paragraphs.length; ++i) {
                    short type = this.getParagraphType(paragraphs[i], doc);
                    String nodeName = null;
                    switch (type) {
                        default: {
                            log.debug("Unknown paragraph type, will treat it as text only");
                        }
                        case 0: {
                            log.debug("Paragraph " + i + " contains only text.");
                            nodeName = "text_" + textIndex++;
                            PageComponent comp = this.createTextNode(paragraphs[i], pageBuilder, nodeName);
                            if (comp == null) continue block11;
                            par.getChildComponents().add(comp);
                            continue block11;
                        }
                        case 1: {
                            log.debug("Paragraph " + i + " contains only images.");
                            nodeName = "image_" + imageIndex++;
                            List<PageComponent> imageComps = this.createImageNode(paragraphs[i], pageBuilder, nodeName, subAssetPath, doc.getPicturesTable());
                            if (imageComps == null || imageComps.isEmpty()) continue block11;
                            par.getChildComponents().addAll(imageComps);
                            continue block11;
                        }
                        case 2: {
                            log.debug("Paragraph " + i + " contains both text and images.");
                            nodeName = "textImage_" + textImageIndex++;
                            List<PageComponent> textImageComps = this.createTextImageNode(paragraphs[i], pageBuilder, nodeName, subAssetPath, doc.getPicturesTable());
                            if (textImageComps == null || textImageComps.isEmpty()) continue block11;
                            par.getChildComponents().addAll(textImageComps);
                        }
                    }
                }
            }
            page = this.buildPage(rend, pageRoot, pageName, pageTitle, pageTemplate, pageDesign, pageBuilder, par);
        }
        catch (OLE2NotOfficeXmlFileException oe) {
            log.error("Error while page extraction from : " + rend.getAsset().getPath(), oe);
            IOUtils.closeQuietly(is);
        }
        catch (Throwable e) {
            throw new PageExtractionException(e.getMessage(), e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(is);
        return page;
        return null;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    private Page extractDocx(Rendition rend, String pageRoot, String pageName, String pageTitle, String pageTemplate, String pageDesign) throws PageExtractionException {
        Page page;
        log.info("Beginning page extraction from: " + rend.getAsset().getPath());
        int textIndex = 0;
        int textImageIndex = 0;
        int imageIndex = 0;
        ResourceResolver resourceResolver = rend.getResourceResolver();
        PageBuilder pageBuilder = this.getPageBuilder(resourceResolver);
        PageComponent par = null;
        String subAssetPath = rend.getAsset().getPath() + "/subassets";
        log.debug("Images in the page will point to the appropriate subassets located at: " + subAssetPath);
        InputStream is = null;
        try {
            is = rend.getAsset().getOriginal().getStream();
            XWPFDocument docx = new XWPFDocument(is);
            if (pageBuilder != null) {
                par = this.createParComponent(pageBuilder);
                Iterator<XWPFParagraph> paraIter = docx.getParagraphsIterator();
                while (paraIter.hasNext()) {
                    XWPFParagraph para = paraIter.next();
                    if (para.isEmpty()) {
                        log.debug("Empty paragraph found, ignoring.");
                        continue;
                    }
                    if (para.isPageBreak()) {
                        log.debug("Empty paragraph found, ignoring.");
                        continue;
                    }
                    short paraType = this.getParagraphType(para);
                    String nodeName = null;
                    switch (paraType) {
                        case 0: {
                            log.debug("Current paragraph contains only text.");
                            nodeName = "text_" + textIndex++;
                            PageComponent comp = this.createTextNode(para, pageBuilder, nodeName);
                            if (comp == null) break;
                            par.getChildComponents().add(comp);
                            break;
                        }
                        case 1: {
                            log.debug("Current paragraph contains only images.");
                            nodeName = "image_" + imageIndex++;
                            List<PageComponent> imageComps = this.createImageNode(para, pageBuilder, nodeName, subAssetPath);
                            if (imageComps == null || imageComps.isEmpty()) break;
                            par.getChildComponents().addAll(imageComps);
                            break;
                        }
                        case 2: {
                            log.debug("Current paragraph contains both text and images.");
                            nodeName = "textImage_" + textImageIndex++;
                            List<PageComponent> textImageComps = this.createTextImageNode(para, pageBuilder, nodeName, subAssetPath);
                            if (textImageComps == null || textImageComps.isEmpty()) break;
                            par.getChildComponents().addAll(textImageComps);
                        }
                    }
                }
            }
            page = this.buildPage(rend, pageRoot, pageName, pageTitle, pageTemplate, pageDesign, pageBuilder, par);
        }
        catch (OLE2NotOfficeXmlFileException oe) {
            log.error("Error while page extraction from : " + rend.getAsset().getPath(), oe);
            IOUtils.closeQuietly(is);
        }
        catch (Throwable e) {
            throw new PageExtractionException(e.getMessage(), e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(is);
        return page;
        return null;
    }

    private Page buildPage(Rendition rend, String pageRoot, String pageName, String pageTitle, String pageTemplate, String pageDesign, PageBuilder pageBuilder, PageComponent par) throws WCMException {
        ArrayList<PageComponent> pageComponents = new ArrayList<PageComponent>();
        pageComponents.add(par);
        Asset asset = rend.getAsset();
        String title = asset.getMetadataValue("dc:title");
        if (title != null && !title.trim().equalsIgnoreCase("")) {
            log.debug("Title found in the document metadata: " + title);
            pageTitle = title;
        } else {
            pageTitle = pageTitle + " (created: " + new Date() + ")";
            log.debug("No title found in the document metadata.  Using: " + pageTitle);
        }
        pageComponents.add(this.createTitleComponent(pageBuilder, pageTitle));
        Page page = pageBuilder.recreatePage(pageRoot, pageName, pageTitle, pageTemplate, pageDesign, pageComponents);
        log.info("Page extraction from: " + rend.getAsset().getPath() + " has completed successfully.");
        return page;
    }

    @Override
    protected PageComponent createTitleComponent(PageBuilder pageBuilder, String pageTitle) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("jcr:title", pageTitle);
        properties.put("type", "extralarge");
        return pageBuilder.createComponent("foundation/components/title", new ValueMapDecorator(properties));
    }

    private List<PageComponent> createTextImageNode(Paragraph para, PageBuilder pageBuilder, String name, String subAssetPath, PicturesTable picTable) {
        int imageCount = 1;
        ArrayList<PageComponent> imageList = new ArrayList<PageComponent>();
        for (int i = 0; i < para.numCharacterRuns(); ++i) {
            CharacterRun run = para.getCharacterRun(i);
            if (!picTable.hasPicture(run)) continue;
            Picture pic = picTable.extractPicture(run, false);
            String path = subAssetPath + "/" + pic.suggestFullFileName();
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("fileReference", path);
            if (imageList.isEmpty()) {
                imageList.add(pageBuilder.createComponent(IMAGE_COMPONENT, new ValueMapDecorator(props), "image"));
                continue;
            }
            imageList.add(pageBuilder.createComponent(IMAGE_COMPONENT, new ValueMapDecorator(props), "image_" + imageCount++));
        }
        log.debug("Found " + imageList.size() + " images.");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("textIsRich", true);
        props.put("text", this.renderParagraph(para));
        ArrayList<PageComponent> comps = new ArrayList<PageComponent>();
        if (!imageList.isEmpty()) {
            PageComponent textImageComp = pageBuilder.createComponent(TEXT_IMAGE_COMPONENT, new ValueMapDecorator(props), name);
            textImageComp.getChildComponents().add((PageComponent)imageList.get(0));
            comps.add(textImageComp);
            for (int i = 1; i < imageList.size(); ++i) {
                comps.add((PageComponent)imageList.get(i));
            }
        } else {
            comps.add(pageBuilder.createComponent(TEXT_COMPONENT, new ValueMapDecorator(props), name));
        }
        return comps;
    }

    private List<PageComponent> createTextImageNode(XWPFParagraph para, PageBuilder pageBuilder, String name, String subAssetPath) {
        int imageCount = 1;
        ArrayList<PageComponent> imageList = new ArrayList<PageComponent>();
        for (XWPFRun run : para.getRuns()) {
            if (run.getEmbeddedPictures().size() <= 0) continue;
            HashMap<String, Object> propsImage = new HashMap<String, Object>();
            Iterator<XWPFPicture> pics = run.getEmbeddedPictures().iterator();
            while (pics.hasNext()) {
                XWPFPictureData pic = pics.next().getPictureData();
                String path = subAssetPath + "/" + pic.getFileName();
                propsImage.put("fileReference", path);
                if (imageList.isEmpty()) {
                    imageList.add(pageBuilder.createComponent(IMAGE_COMPONENT, new ValueMapDecorator(propsImage), "image"));
                    continue;
                }
                imageList.add(pageBuilder.createComponent(IMAGE_COMPONENT, new ValueMapDecorator(propsImage), "image_" + imageCount++));
            }
        }
        String text = this.renderParagraph(para);
        log.debug("Found " + imageList.size() + " images.");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("textIsRich", true);
        if (text != null && !text.trim().equalsIgnoreCase("") && !text.trim().equalsIgnoreCase("null")) {
            props.put("text", text);
        }
        ArrayList<PageComponent> components = new ArrayList<PageComponent>();
        PageComponent textComp = pageBuilder.createComponent(TEXT_IMAGE_COMPONENT, new ValueMapDecorator(props), name);
        if (!imageList.isEmpty()) {
            PageComponent img = (PageComponent)imageList.get(0);
            textComp.getChildComponents().add(img);
            components.add(textComp);
            for (int i = 1; i < imageList.size(); ++i) {
                components.add((PageComponent)imageList.get(i));
            }
        } else {
            components.add(textComp);
        }
        return components;
    }

    private List<PageComponent> createImageNode(Paragraph para, PageBuilder pageBuilder, String name, String subAssetPath, PicturesTable picTable) {
        int count = 0;
        ArrayList<PageComponent> comps = new ArrayList<PageComponent>();
        for (int i = 0; i < para.numCharacterRuns(); ++i) {
            CharacterRun chars = para.getCharacterRun(i);
            if (!picTable.hasPicture(chars)) continue;
            Picture pic = picTable.extractPicture(chars, false);
            String path = subAssetPath + "/" + pic.suggestFullFileName();
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("fileReference", path);
            comps.add(pageBuilder.createComponent(IMAGE_COMPONENT, new ValueMapDecorator(props), name + "_" + count++));
        }
        log.debug("Created " + comps.size() + "image components.");
        return comps;
    }

    private List<PageComponent> createImageNode(XWPFParagraph para, PageBuilder pageBuilder, String name, String subAssetPath) {
        int count = 0;
        ArrayList<PageComponent> comps = new ArrayList<PageComponent>();
        for (XWPFRun run : para.getRuns()) {
            if (run.getEmbeddedPictures().size() <= 0) continue;
            Iterator<XWPFPicture> pics = run.getEmbeddedPictures().iterator();
            while (pics.hasNext()) {
                PageComponent comp = null;
                XWPFPictureData pic = pics.next().getPictureData();
                String path = subAssetPath + "/" + pic.getFileName();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("fileReference", path);
                comp = pageBuilder.createComponent(IMAGE_COMPONENT, new ValueMapDecorator(properties), name + "_" + count++);
                comps.add(comp);
            }
        }
        log.debug("Created " + comps.size() + "image components.");
        return comps;
    }

    private PageComponent createTextNode(Paragraph para, PageBuilder pageBuilder, String name) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("textIsRich", true);
        props.put("text", this.renderParagraph(para));
        return pageBuilder.createComponent(TEXT_COMPONENT, new ValueMapDecorator(props), name);
    }

    private PageComponent createTextNode(XWPFParagraph para, PageBuilder pageBuilder, String name) {
        PageComponent comp = null;
        if (para.getElementType() == BodyElementType.PARAGRAPH) {
            String text = this.renderParagraph(para);
            if (text != null && !text.trim().equalsIgnoreCase("") && !text.trim().equalsIgnoreCase("null")) {
                log.debug("Paragraph text is: " + text);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("textIsRich", true);
                properties.put("text", text);
                comp = pageBuilder.createComponent(TEXT_COMPONENT, new ValueMapDecorator(properties), name);
            }
        } else {
            log.warn("Non-PARAGRAPH type paragraph was found.  The type is: " + (Object)((Object)para.getElementType()) + ". Skipping.");
        }
        return comp;
    }

    private void addOpenStyleTags(XWPFRun run, StringBuilder builder) {
        if (run.isBold()) {
            builder.append("<b>");
        }
        if (run.isItalic()) {
            builder.append("<i>");
        }
        if (run.isStrike()) {
            builder.append("<del>");
        }
        if (run.getSubscript() == VerticalAlign.SUBSCRIPT) {
            builder.append("<sub>");
        }
        if (run.getSubscript() == VerticalAlign.SUPERSCRIPT) {
            builder.append("<sup>");
        }
    }

    private void addCloseStyleTags(XWPFRun run, StringBuilder builder) {
        if (run.isBold()) {
            builder.append("</b>");
        }
        if (run.isItalic()) {
            builder.append("</i>");
        }
        if (run.isStrike()) {
            builder.append("</del>");
        }
        if (run.getSubscript() == VerticalAlign.SUBSCRIPT) {
            builder.append("</sub>");
        }
        if (run.getSubscript() == VerticalAlign.SUPERSCRIPT) {
            builder.append("</sup>");
        }
    }

    private int checkStyle(XWPFParagraph para) {
        String style = para.getStyle();
        if (style != null) {
            if (style.toLowerCase().startsWith("heading")) {
                int headingNum = -1;
                try {
                    headingNum = Integer.parseInt(style.substring(style.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return headingNum;
            }
            return -1;
        }
        return -1;
    }

    private Paragraph[] getParagraphs(Range range) {
        Paragraph[] paragraphs = new Paragraph[range.numParagraphs()];
        for (int i = 0; i < paragraphs.length; ++i) {
            paragraphs[i] = range.getParagraph(i);
        }
        return paragraphs;
    }

    private short getParagraphType(XWPFParagraph para) {
        String paraText;
        boolean hasPictures = false;
        boolean hasText = false;
        for (XWPFRun run : para.getRuns()) {
            if (run.getEmbeddedPictures().size() <= 0) continue;
            hasPictures = true;
            break;
        }
        if ((paraText = para.getParagraphText()) != null && !paraText.trim().equals("") && !paraText.trim().startsWith("null")) {
            hasText = true;
        }
        if (hasPictures && hasText) {
            return 2;
        }
        if (hasPictures) {
            return 1;
        }
        return 0;
    }

    private short getParagraphType(Paragraph paragraph, HWPFDocument doc) {
        boolean hasPic = false;
        boolean hasText = false;
        for (int i = 0; i < paragraph.numCharacterRuns(); ++i) {
            CharacterRun characters = paragraph.getCharacterRun(i);
            if (doc.getPicturesTable().hasPicture(characters)) {
                hasPic = true;
                continue;
            }
            hasText |= paragraph.getCharacterRun(i).text() != null && paragraph.getCharacterRun(i).text().trim().length() > 0;
        }
        if (hasPic && !hasText) {
            return 1;
        }
        if (hasPic && hasText) {
            return 2;
        }
        return 0;
    }

    private String renderParagraph(Paragraph paragraph) {
        StringBuilder builder = new StringBuilder();
        if (paragraph.getJustification() == 2) {
            builder.append("<p style=\"text-align: right;\">");
        } else if (paragraph.getJustification() == 1) {
            builder.append("<p style=\"text-align: center;\">");
        } else {
            builder.append("<p>");
        }
        for (int i = 0; i < paragraph.numCharacterRuns(); ++i) {
            CharacterRun characters = paragraph.getCharacterRun(i);
            if (characters.isBold()) {
                builder.append("<b>");
            }
            if (characters.isItalic()) {
                builder.append("<i>");
            }
            for (char c : characters.text().toCharArray()) {
                if (c == '<') {
                    builder.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    builder.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    builder.append("&amp;");
                    continue;
                }
                builder.append(c);
            }
            if (characters.isItalic()) {
                builder.append("</i>");
            }
            if (!characters.isBold()) continue;
            builder.append("</b>");
        }
        builder.append("</p>");
        return builder.toString();
    }

    private String renderParagraph(XWPFParagraph para) {
        StringBuilder builder = new StringBuilder();
        if (log.isDebugEnabled()) {
            if (para.getText() == null) {
                log.debug("Para text is a null object");
            } else {
                log.debug("Para text is " + para.getText());
            }
        }
        if (para.getText() != null && !para.getText().trim().equalsIgnoreCase("") && !para.getText().trim().equalsIgnoreCase("null")) {
            builder.append("<p>");
            int style = this.checkStyle(para);
            if (style == -1 || style > 6) {
                for (XWPFRun run : para.getRuns()) {
                    if (run.getText(0) == null || run.getText(0).trim().equalsIgnoreCase("null")) continue;
                    this.addOpenStyleTags(run, builder);
                    builder.append(run.getText(0));
                    this.addCloseStyleTags(run, builder);
                }
            } else {
                builder.append("<H");
                builder.append(style);
                builder.append(">");
                builder.append(para.getText());
                builder.append("</H");
                builder.append(style);
                builder.append(">");
            }
            builder.append("</p>");
        }
        return builder.toString();
    }
}

