/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.emailprovider.impl.types;

import com.day.cq.mcm.emailprovider.types.PersonalizationInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PersonalizationInfoImpl
implements PersonalizationInfo {
    private Map<String, String> personalizationParams;
    private String prefixPattern;
    private String suffixPattern;

    public PersonalizationInfoImpl() {
    }

    public PersonalizationInfoImpl(String prefix, String suffix) {
        this.prefixPattern = prefix;
        this.suffixPattern = suffix;
    }

    @Override
    public void addMapping(String attributeName, String replacementText) {
        if (this.personalizationParams == null) {
            this.personalizationParams = new HashMap<String, String>();
        }
        String newText = replacementText;
        if (this.usePrefix()) {
            newText = this.prefixPattern + newText;
        }
        if (this.useSuffix()) {
            newText = newText + this.suffixPattern;
        }
        this.personalizationParams.put(attributeName, newText);
    }

    @Override
    public void removeMapping(String attributeName) {
        if (this.personalizationParams != null) {
            this.personalizationParams.remove(attributeName);
        }
    }

    @Override
    public String getMapping(String attributeName) {
        if (this.personalizationParams != null) {
            return this.personalizationParams.get(attributeName);
        }
        return null;
    }

    @Override
    public Map<String, String> getAllMappings() {
        return this.personalizationParams;
    }

    @Override
    public String getPrefixPattern() {
        return this.prefixPattern;
    }

    @Override
    public void setPrefixPattern(String prefixPattern) {
        this.prefixPattern = prefixPattern;
    }

    @Override
    public String getSuffixPattern() {
        return this.suffixPattern;
    }

    @Override
    public void setSuffixPattern(String suffixPattern) {
        this.suffixPattern = suffixPattern;
    }

    @Override
    public boolean usePrefix() {
        return !StringUtils.isEmpty(this.prefixPattern);
    }

    @Override
    public boolean useSuffix() {
        return !StringUtils.isEmpty(this.suffixPattern);
    }
}

