/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import com.adobe.granite.ui.components.ExpressionCustomizer;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.FilteringResourceWrapper;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class WCMFilteringResourceWrapper
extends FilteringResourceWrapper {
    private static ResourceResolver resourceResolver;

    public WCMFilteringResourceWrapper(Resource filteredResource, Resource contentResource, ExpressionResolver expressionResolver, SlingHttpServletRequest slingRequest) {
        super(filteredResource, expressionResolver, slingRequest);
        this.registerCustomVariables(contentResource, slingRequest);
    }

    private ValueMap getDesignProperties(Resource resource) {
        ValueMap design = ValueMap.EMPTY;
        PageManager pageManager = resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        if (page != null) {
            Template template = page.getTemplate();
            if (template != null && template.hasStructureSupport()) {
                ContentPolicyManager policyManager = resourceResolver.adaptTo(ContentPolicyManager.class);
                ContentPolicy policy = policyManager.getPolicy(resource);
                if (policy != null) {
                    Resource policyResource = policy.adaptTo(Resource.class);
                    design = policyResource.adaptTo(ValueMap.class);
                }
            } else {
                Designer designer = resourceResolver.adaptTo(Designer.class);
                design = designer.getStyle(resource);
            }
        }
        return design;
    }

    private void registerCustomVariables(Resource contentResource, SlingHttpServletRequest request) {
        if (contentResource == null || request == null) {
            return;
        }
        resourceResolver = contentResource.getResourceResolver();
        ValueMap designVM = this.getDesignProperties(contentResource);
        ExpressionCustomizer customizer = ExpressionCustomizer.from(request);
        customizer.setVariable("cqDesign", designVM);
    }
}

