/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.model.responsivegrid;

import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.model.responsivegrid.Breakpoint;
import com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveConfiguration;
import com.day.cq.wcm.foundation.model.responsivegrid.export.ResponsiveColumnExporter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.annotation.versioning.ProviderType;

@JsonSerialize(as=ResponsiveColumnExporter.class)
@ProviderType
public class ResponsiveColumn
extends AbstractResource
implements ResponsiveColumnExporter {
    private Resource wrappedResource;
    private ComponentExporter componentModel;
    private String classNames;
    private ResponsiveConfiguration responsiveConfiguration;
    private Set<String> columnOnlyBreakpointNames;
    private Map<String, Breakpoint> breakpoints;
    private Map<String, Breakpoint> gridBreakpoints;
    private SlingHttpServletRequest slingRequest;
    private ModelFactory modelFactory;

    public ResponsiveColumn(Resource resource, Map<String, Breakpoint> gridBreakpoints, String classNamePrefix) {
        this.wrappedResource = resource;
        Map<String, Breakpoint> breakpoints = this.getBreakpoints(this.wrappedResource, gridBreakpoints);
        this.classNames = this.createClassNames(this.wrappedResource, classNamePrefix + "Column", breakpoints, gridBreakpoints);
        this.gridBreakpoints = gridBreakpoints;
        this.responsiveConfiguration = new ResponsiveConfiguration(breakpoints);
    }

    public ResponsiveColumn(Resource resource, Map<String, Breakpoint> gridBreakpoints, String classNamePrefix, SlingHttpServletRequest slingRequest, ModelFactory modelFactory) {
        this.slingRequest = slingRequest;
        this.modelFactory = modelFactory;
        this.wrappedResource = resource;
        Map<String, Breakpoint> breakpoints = this.getBreakpoints(this.wrappedResource, gridBreakpoints);
        this.classNames = this.createClassNames(this.wrappedResource, classNamePrefix + "Column", breakpoints, gridBreakpoints);
        this.gridBreakpoints = gridBreakpoints;
        this.responsiveConfiguration = new ResponsiveConfiguration(breakpoints);
    }

    @Override
    public Map<String, Breakpoint> getBreakpoints() {
        return this.responsiveConfiguration != null ? this.responsiveConfiguration.getBreakpoints() : null;
    }

    @Override
    public String getColumnClassNames() {
        return this.classNames;
    }

    public String getCssClass() {
        return this.classNames;
    }

    public Set<String> getMissingBreakpointNames() {
        if (this.columnOnlyBreakpointNames == null) {
            this.columnOnlyBreakpointNames = new HashSet<String>();
            if (this.gridBreakpoints != null && !this.gridBreakpoints.isEmpty()) {
                ArrayList<String> missingBreakpointNames = new ArrayList<String>(this.breakpoints.keySet());
                missingBreakpointNames.removeAll(this.gridBreakpoints.keySet());
                this.columnOnlyBreakpointNames.addAll(missingBreakpointNames);
            } else {
                this.columnOnlyBreakpointNames.addAll(this.breakpoints.keySet());
            }
        }
        return this.columnOnlyBreakpointNames;
    }

    public Integer getColumnCount(String breakpointName) {
        return this.breakpoints.get(breakpointName).getWidth();
    }

    @Override
    @Nonnull
    public ComponentExporter getExportedComponent() {
        if (this.componentModel == null) {
            this.componentModel = this.modelFactory.getModelFromWrappedRequest(this.slingRequest, this.wrappedResource, ComponentExporter.class);
        }
        return this.componentModel;
    }

    @Override
    @Nonnull
    public String getExportedType() {
        return this.wrappedResource.getResourceType();
    }

    @Nonnull
    public Resource getResource() {
        return this.wrappedResource;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.wrappedResource.getPath();
    }

    @Override
    @Nonnull
    public String getResourceType() {
        return this.wrappedResource.getResourceType();
    }

    @Override
    public String getResourceSuperType() {
        return this.wrappedResource.getResourceSuperType();
    }

    @Override
    @Nonnull
    public ResourceMetadata getResourceMetadata() {
        return this.wrappedResource.getResourceMetadata();
    }

    @Override
    @Nonnull
    public ResourceResolver getResourceResolver() {
        return this.wrappedResource.getResourceResolver();
    }

    public ValueMap getProperties() {
        return this.wrappedResource.adaptTo(ValueMap.class);
    }

    private String createClassNames(Resource resource, String columnCssClassPrefix, Map<String, Breakpoint> columnBreakpoints, Map<String, Breakpoint> referenceBreakpoints) {
        StringBuilder cssClass = new StringBuilder(columnCssClassPrefix);
        Component component = WCMUtils.getComponent(resource);
        ValueMap componentProperties = null;
        if (component != null) {
            componentProperties = component.getProperties();
        }
        for (Breakpoint breakpoint : columnBreakpoints.values()) {
            String breakpointName = breakpoint.getName();
            int offset = breakpoint.getOffset();
            int width = breakpoint.getWidth();
            Breakpoint.ResponsiveBehavior behavior = breakpoint.getResponsiveBehavior();
            if (breakpoint.getWidth() > 0) {
                cssClass.append(" ").append(columnCssClassPrefix).append("--").append(breakpointName).append("--").append(width);
            }
            cssClass.append(" ").append(columnCssClassPrefix).append("--").append("offset").append("--").append(breakpointName).append("--").append(offset);
            cssClass.append(" ").append(columnCssClassPrefix).append("--").append(breakpointName).append("--").append((Object)behavior);
        }
        if (referenceBreakpoints != null && !referenceBreakpoints.isEmpty()) {
            ArrayList<String> missingGridBreakpointNames = new ArrayList<String>(referenceBreakpoints.keySet());
            missingGridBreakpointNames.removeAll(columnBreakpoints.keySet());
            for (String missingGridBreakpointName : missingGridBreakpointNames) {
                Breakpoint gridBreakPointVariant;
                int width = 0;
                int offset = 0;
                int gridWidth = 0;
                Breakpoint breakPointVariant = columnBreakpoints.get("default");
                if (breakPointVariant != null) {
                    width = breakPointVariant.getWidth();
                    offset = breakPointVariant.getOffset();
                }
                if ((gridBreakPointVariant = referenceBreakpoints.get(missingGridBreakpointName)) != null) {
                    gridWidth = gridBreakPointVariant.getWidth();
                }
                if (width == 0 || width + offset > gridWidth) {
                    width = gridWidth;
                    offset = 0;
                }
                if (width == 0 || width > 12) {
                    width = 12;
                }
                cssClass.append(" ").append(columnCssClassPrefix).append("--").append(missingGridBreakpointName).append("--").append(width);
                if (offset > 0) {
                    cssClass.append(" ").append(columnCssClassPrefix).append("--").append("offset").append("--").append(missingGridBreakpointName).append("--").append(width);
                }
                columnBreakpoints.put("default", new Breakpoint("default", width, offset, gridBreakPointVariant.getResponsiveBehavior()));
            }
        }
        if (!columnBreakpoints.keySet().contains("default")) {
            cssClass.append(" ").append(columnCssClassPrefix).append("--").append("default").append("--").append(12);
        }
        if (componentProperties != null) {
            cssClass.append(" ").append(componentProperties.get("cq:cssClass", ""));
        }
        return cssClass.toString().trim();
    }

    private Map<String, Breakpoint> getBreakpoints(Resource resource, Map<String, Breakpoint> referenceBreakpoints) {
        if (resource == null) {
            return null;
        }
        Resource responsiveCfg = resource.getChild("cq:responsive");
        this.breakpoints = new HashMap<String, Breakpoint>();
        if (responsiveCfg != null) {
            Iterator<Resource> resCfgIt = responsiveCfg.listChildren();
            while (resCfgIt.hasNext()) {
                Breakpoint gridBreakpoint;
                Resource resCfg = resCfgIt.next();
                String breakpointName = resCfg.getName();
                ValueMap cfg = resCfg.getValueMap();
                int width = cfg.get("width", 12);
                int offset = cfg.get("offset", 0);
                Breakpoint.ResponsiveBehavior behavior = Breakpoint.ResponsiveBehavior.valueOf(cfg.get("behavior", Breakpoint.ResponsiveBehavior.none.toString()));
                Breakpoint breakpoint = gridBreakpoint = referenceBreakpoints != null ? referenceBreakpoints.get(breakpointName) : null;
                if (gridBreakpoint != null && width + offset > gridBreakpoint.getWidth()) {
                    if (width > gridBreakpoint.getWidth()) {
                        width = gridBreakpoint.getWidth();
                        offset = 0;
                    } else if (offset < gridBreakpoint.getWidth()) {
                        width = gridBreakpoint.getWidth() - offset;
                    } else {
                        offset = 0;
                    }
                }
                this.breakpoints.put(breakpointName, new Breakpoint(breakpointName, width, offset, behavior));
            }
        }
        return this.breakpoints;
    }
}

