/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.packaging.gfx;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadResource {
    private static final Logger log = LoggerFactory.getLogger(DownloadResource.class);
    public static final String PN_REFERENCE = "fileReference";
    public static final String NN_FILE = "file";
    public static final String PN_FILE_NAME = "fileName";
    public static final String PN_TITLE = "{http://www.jcp.org/jcr/1.0}title";
    public static final String PN_DESCRIPTION = "{http://www.jcp.org/jcr/1.0}description";
    protected final Node node;
    private final Map<String, String> overlaid = new HashMap<String, String>();
    private String fileNodePath = null;
    private String source = null;
    private String extension = ".res";
    private String selector = "";
    private String suffix = null;
    protected Map<String, String> attrs;
    private Object innerHtml;
    private Property data;
    private Map<String, String> itemNames = new HashMap<String, String>();

    public DownloadResource(Node node) {
        this.node = node;
    }

    public String get(String name) {
        String value = this.overlaid.get(name);
        if (value == null) {
            try {
                value = this.node.getProperty(name).getString();
            }
            catch (RepositoryException e) {
                value = "";
            }
        }
        return value;
    }

    public int get(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.get(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void set(String name, String value) {
        this.overlaid.put(name, value);
    }

    public void addAttribute(String name, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(name, value);
    }

    public void addCssClass(String name) {
        if (this.attrs == null || !this.attrs.containsKey("class")) {
            this.addAttribute("class", name);
        } else {
            String prev = this.attrs.get("class");
            if (prev.length() == 0) {
                prev = name;
            } else if (!(prev.equals(name) || prev.contains(" " + name) || prev.contains(name + " "))) {
                prev = prev + " " + name;
            }
            this.attrs.put("class", prev);
        }
    }

    public void init() {
        if (this.source == null) {
            String fileName;
            if (this.fileNodePath == null) {
                this.fileNodePath = this.getItemName(NN_FILE);
            }
            if (this.fileNodePath.length() > 0 && this.fileNodePath.charAt(0) != '/') {
                try {
                    this.fileNodePath = this.node != null && this.node.hasNode(this.fileNodePath) ? this.node.getNode(this.fileNodePath).getPath() : "";
                }
                catch (RepositoryException e) {
                    this.fileNodePath = "";
                    log.warn("Error while accessing the repository.", e);
                }
            }
            if ((fileName = this.get(this.getItemName(PN_FILE_NAME))).length() == 0) {
                String fileRef = this.getFileReference();
                fileName = fileRef != null && fileRef.length() > 0 ? Text.getName(fileRef) : "";
                this.set(this.getItemName(PN_FILE_NAME), fileName);
            }
            if (this.suffix == null) {
                this.setSuffix(fileName);
            }
            if (this.selector.length() > 0) {
                this.source = this.getPath() + this.getSelector() + this.getExtension() + this.getSuffix();
            } else if (this.fileNodePath.length() > 0) {
                this.source = this.fileNodePath + this.getExtension() + this.getSuffix();
            } else if (this.getFileReference().length() > 0) {
                this.source = this.getFileReference();
            }
        }
    }

    public String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            return "";
        }
    }

    public String getItemName(String name) {
        return this.itemNames.containsKey(name) ? this.itemNames.get(name) : name;
    }

    public void setItemName(String key, String name) {
        this.itemNames.put(key, name);
    }

    public String getFileReference() {
        return this.get(this.getItemName(PN_REFERENCE));
    }

    public void setFileReference(String fileReference) {
        this.set(this.getItemName(PN_REFERENCE), fileReference);
    }

    public Object getInnerHtml() {
        return this.innerHtml;
    }

    public void setInnerHtml(Object innerHtml) {
        this.innerHtml = innerHtml;
    }

    public String getFileNodePath() {
        this.init();
        return this.fileNodePath;
    }

    public void setFileNodePath(String fileNodePath) {
        this.fileNodePath = fileNodePath;
    }

    public String getFileName() {
        this.init();
        return this.get(this.getItemName(PN_FILE_NAME));
    }

    public void setFileName(String fileName) {
        this.set(this.getItemName(PN_FILE_NAME), fileName);
    }

    public String getTitle() {
        return this.getTitle(false);
    }

    public String getTitle(boolean escape) {
        return escape ? StringEscapeUtils.escapeHtml4(this.get(this.getItemName(PN_TITLE))) : this.get(this.getItemName(PN_TITLE));
    }

    public void setTitle(String title) {
        this.set(this.getItemName(PN_TITLE), title);
    }

    public String getDescription() {
        return this.getDescription(false);
    }

    public String getDescription(boolean escape) {
        return escape ? StringEscapeUtils.escapeHtml4(this.get(this.getItemName(PN_DESCRIPTION))) : this.get(this.getItemName(PN_DESCRIPTION));
    }

    public void setDescription(String description) {
        this.set(this.getItemName(PN_DESCRIPTION), description);
    }

    public String getHref() {
        this.init();
        return this.source;
    }

    public void setHref(String href) {
        this.source = href;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension == null ? "" : (!extension.startsWith(".") ? "." + extension : extension);
    }

    public String getIconType() {
        String fileName = this.getFileName();
        if (fileName.lastIndexOf(46) > 0) {
            return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        }
        return "dat";
    }

    public String getIconPath() {
        return null;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (this.source != null) {
            log.warn("Illegal call to setSuffix() after source already calculated.");
        }
        this.suffix = suffix == null || suffix.length() == 0 ? "" : (!suffix.startsWith("/") ? "/" + suffix : suffix);
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        if (this.source != null) {
            log.warn("Illegal call to setSelector() after source already calculated.");
        }
        this.selector = selector == null ? "" : (!selector.startsWith(".") ? "." + selector : selector);
    }

    public boolean hasContent() {
        try {
            return this.getData() != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public void draw(Writer w) throws IOException {
        if (!this.hasContent()) {
            return;
        }
        PrintWriter out = new PrintWriter(w);
        out.printf("<a href=\"%s\" ", Text.escape(this.getHref(), '%', true));
        out.printf("title=\"%s\" ", this.getTitle(true));
        if (this.attrs != null) {
            for (Map.Entry<String, String> e : this.attrs.entrySet()) {
                out.printf("%s=\"%s\" ", StringEscapeUtils.escapeHtml4(e.getKey()), StringEscapeUtils.escapeHtml4(e.getValue()));
            }
        }
        out.print(">");
        out.print(this.innerHtml == null ? this.getFileName() : this.innerHtml);
        out.print("</a>");
    }

    public String getString() {
        StringWriter w = new StringWriter();
        try {
            this.draw(w);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w.getBuffer().toString();
    }

    public String getMimeType() throws RepositoryException {
        Property data = this.getData();
        if (data == null) {
            return null;
        }
        return data.getParent().getProperty("{http://www.jcp.org/jcr/1.0}mimeType").getString();
    }

    public Calendar getLastModified() throws RepositoryException {
        Property data = this.getData();
        if (data == null) {
            return null;
        }
        return data.getParent().getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Property getData() throws RepositoryException {
        Node fileNode;
        if (this.data != null) {
            return this.data;
        }
        if (this.node == null) {
            return null;
        }
        String ref = this.getFileReference();
        Session s = this.node.getSession();
        if (ref.length() > 0) {
            if (ref.charAt(0) != '/') {
                fileNode = s.getNodeByUUID(ref);
            } else {
                Node res = this.getReferencedNode(ref);
                if (res == null) return null;
                fileNode = res;
            }
        } else {
            if (!this.node.hasNode(this.getItemName(NN_FILE))) return null;
            fileNode = this.node.getNode(this.getItemName(NN_FILE));
        }
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            fileNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
        }
        if (!fileNode.hasProperty("{http://www.jcp.org/jcr/1.0}data")) return null;
        this.data = fileNode.getProperty("{http://www.jcp.org/jcr/1.0}data");
        return this.data;
    }

    protected Node getReferencedNode(String path) {
        try {
            return this.node.getSession().getNode(path);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public Map<String, String> getAttributes() {
        return this.attrs;
    }
}

