/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.packaging.gfx;

import com.day.image.Layer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageHelper {
    private static final Logger log = LoggerFactory.getLogger(ImageHelper.class);
    private static Map<String, String> typeFromExt = new HashMap<String, String>();
    private static Map<String, String> extFromType = new HashMap<String, String>();

    public static Rectangle getCropRect(String rectCSV, String path) {
        block4: {
            if (rectCSV != null && rectCSV.length() > 0) {
                try {
                    int ratioPos = rectCSV.indexOf("/");
                    if (ratioPos >= 0) {
                        rectCSV = rectCSV.substring(0, ratioPos);
                    }
                    String[] cords = rectCSV.split(",");
                    int x1 = Integer.parseInt(cords[0]);
                    int y1 = Integer.parseInt(cords[1]);
                    int x2 = Integer.parseInt(cords[2]);
                    int y2 = Integer.parseInt(cords[3]);
                    return new Rectangle(x1, y1, x2 - x1, y2 - y1);
                }
                catch (Exception e) {
                    if (path == null) break block4;
                    log.warn("cropRect at {} is not valid: {}", (Object)path, (Object)e.toString());
                }
            }
        }
        return null;
    }

    public static Layer createLayer(Node node, String imageName, String refName) throws RepositoryException, IOException {
        if (node.hasNode(imageName)) {
            return ImageHelper.createLayer(node.getNode(imageName));
        }
        String imageRef = node.hasProperty(refName) ? node.getProperty(refName).getString() : "";
        return ImageHelper.createLayer(node.getSession(), imageRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Layer createLayer(ClassLoader cl, String resource) {
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(resource);
            Layer layer = new Layer(in);
            return layer;
        }
        catch (IOException e) {
            log.error("Error while creating layer for {}", (Object)resource);
            Layer layer = null;
            return layer;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static Layer createLayer(Session session, String path) throws RepositoryException, IOException {
        if (path.length() > 0 && session.itemExists(path)) {
            return ImageHelper.createLayer(session.getItem(path));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Layer createLayer(Item item) throws RepositoryException, IOException {
        Node node;
        InputStream in = null;
        if (item.isNode()) {
            node = (Node)item;
            if (node.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
                node = node.getNode("{http://www.jcp.org/jcr/1.0}content");
            }
            if (node.hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
                in = node.getProperty("{http://www.jcp.org/jcr/1.0}data").getStream();
            }
        } else {
            in = ((Property)item).getStream();
        }
        try {
            if (in == null) {
                node = null;
                return node;
            }
            Layer layer = new Layer(in);
            if (layer.getImage() == null) {
                layer = null;
            }
            Layer layer2 = layer;
            return layer2;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int parseFontStyle(String ... styles) {
        int style = 0;
        for (String s : styles) {
            for (String st : s.split("[, |]+")) {
                if ("bold".equals(st = st.toLowerCase())) {
                    style |= 1;
                    continue;
                }
                if ("italic".equals(st)) {
                    style |= 2;
                    continue;
                }
                if ("underline".equals(st)) {
                    style |= 4;
                    continue;
                }
                if (!"strikeout".equals(st)) continue;
                style |= 8;
            }
        }
        return style;
    }

    public static Layer resize(Layer layer, Dimension d, Dimension min, Dimension max) {
        int maxHeight;
        int width = d == null ? 0 : (int)d.getWidth();
        int height = d == null ? 0 : (int)d.getHeight();
        int minWidth = min == null ? 0 : (int)min.getWidth();
        int minHeight = min == null ? 0 : (int)min.getHeight();
        int maxWidth = max == null ? 0 : (int)max.getWidth();
        int n = maxHeight = max == null ? 0 : (int)max.getHeight();
        if (maxWidth == 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        if (maxHeight == 0) {
            maxHeight = Integer.MAX_VALUE;
        }
        int ratioW = layer.getWidth();
        int ratioH = layer.getHeight();
        int loopProtect = 32;
        while (loopProtect-- > 0) {
            if (width == 0 && height == 0) {
                width = layer.getWidth();
                height = layer.getHeight();
                continue;
            }
            if (width == 0) {
                if (height < minHeight) {
                    height = minHeight;
                } else if (height > maxHeight) {
                    height = maxHeight;
                }
                width = height * ratioW / ratioH;
                continue;
            }
            if (height == 0) {
                if (width < minWidth) {
                    width = minWidth;
                } else if (width > maxWidth) {
                    width = maxWidth;
                }
                height = width * ratioH / ratioW;
                continue;
            }
            ratioW = width;
            ratioH = height;
            if (width < minWidth) {
                width = minWidth;
                height = 0;
                continue;
            }
            if (width > maxWidth) {
                width = maxWidth;
                height = 0;
                continue;
            }
            if (height < minHeight) {
                height = minHeight;
                width = 0;
                continue;
            }
            if (height <= maxHeight) break;
            height = maxHeight;
            width = 0;
        }
        if (loopProtect > 0 && (width != layer.getWidth() || height != layer.getHeight())) {
            layer.resize(width, height);
            return layer;
        }
        return null;
    }

    public static Color parseColor(String s) {
        try {
            int i = Integer.decode(s);
            return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, i >> 24 & 0xFF);
        }
        catch (NumberFormatException e) {
            return new Color(0, 0, 0, 0);
        }
    }

    public static Color parseColor(String s, int alpha) {
        try {
            int i = Integer.decode(s);
            return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, alpha);
        }
        catch (NumberFormatException e) {
            return new Color(0, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node saveLayer(Layer layer, String type, double quality, Node parent, String filename, boolean replace) throws RepositoryException, IOException {
        Node fileNode = null;
        if (parent.hasNode(filename)) {
            if (replace) {
                parent.getNode(filename).remove();
            } else {
                fileNode = parent.getNode(filename);
            }
        }
        if (fileNode == null) {
            fileNode = parent.addNode(filename, "{http://www.jcp.org/jcr/nt/1.0}file");
        }
        Node content = fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") ? fileNode.getNode("{http://www.jcp.org/jcr/1.0}content") : fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        content.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", type);
        content.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", Calendar.getInstance());
        FileOutputStream out = null;
        FileInputStream in = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("imgheler", "img");
            out = FileUtils.openOutputStream(tmpFile);
            layer.write(type, quality, out);
            ((OutputStream)out).close();
            out = null;
            in = FileUtils.openInputStream(tmpFile);
            content.setProperty("{http://www.jcp.org/jcr/1.0}data", in);
            parent.save();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(in);
            if (tmpFile != null) {
                tmpFile.delete();
            }
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(in);
        if (tmpFile != null) {
            tmpFile.delete();
        }
        return fileNode;
    }

    public static String getTypeFromExtension(String ext) {
        return ext == null ? null : typeFromExt.get(ext);
    }

    public static String getExtensionFromType(String type) {
        return type == null ? null : extFromType.get(type);
    }

    public static boolean handleIfModifiedSince(HttpServletRequest req, HttpServletResponse resp, Node node) {
        Calendar lastMod = null;
        try {
            while (node.getDepth() > 0 && lastMod == null) {
                if (node.hasProperty("{http://www.jcp.org/jcr/1.0}lastModified")) {
                    lastMod = node.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate();
                    continue;
                }
                node = node.getParent();
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while searching for last modified property: " + e);
            return false;
        }
        if (lastMod != null) {
            long ims;
            long modTime = lastMod.getTimeInMillis() / 1000L;
            if (modTime <= (ims = req.getDateHeader("if-modified-since") / 1000L)) {
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("last-modified", lastMod.getTimeInMillis());
        }
        return false;
    }

    static {
        typeFromExt.put("png", "image/png");
        extFromType.put("image/png", "png");
        typeFromExt.put("jpg", "image/jpg");
        typeFromExt.put("jpeg", "image/jpeg");
        extFromType.put("image/jpg", "jpg");
        extFromType.put("image/jpeg", "jpg");
        typeFromExt.put("gif", "image/gif");
        extFromType.put("image/gif", "gif");
    }
}

