/*
 * Decompiled with CFR 0.152.
 */
package com.day.durbo;

import com.day.durbo.DurboConstants;
import com.day.durbo.DurboNamespaceResolver;
import com.day.durbo.DurboValue;
import com.day.durbo.impl.DurboInputStream;
import com.day.durbo.io.RegionFileInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;

public class DurboInput
implements DurboConstants,
DurboNamespaceResolver {
    public static final int PROPERTY_TYPE_UNDEFINED = 0;
    public static final int PROPERTY_TYPE_STRING = 1;
    public static final int PROPERTY_TYPE_BINARY = 2;
    public static final int PROPERTY_TYPE_LONG = 3;
    public static final int PROPERTY_TYPE_DOUBLE = 4;
    public static final int PROPERTY_TYPE_DATE = 5;
    public static final int PROPERTY_TYPE_BOOLEAN = 6;
    public static final int PROPERTY_TYPE_NAME = 7;
    public static final int PROPERTY_TYPE_PATH = 8;
    public static final int PROPERTY_TYPE_REFERENCE = 9;
    private DurboInputStream in;
    private double version = 1.0;
    private String encoding = "";
    private String contentType = "";
    private Map<String, String> namespaceByPrefix = new HashMap<String, String>();
    private Map<String, String> namespaceByURI = new HashMap<String, String>();

    public DurboInput(File file) throws IOException {
        this(new RegionFileInputStream(file));
    }

    public DurboInput(InputStream inputStream) throws IOException {
        this.in = new DurboInputStream(inputStream);
        this.namespaceByPrefix.put("", "");
        this.namespaceByURI.put("", "");
        Element elem = this.read();
        if (elem == null) {
            throw new IOException("Protocol Header expected.");
        }
        if (!"DurboSer".equals(elem.name())) {
            throw new IOException("Wrong Protocol Header Property: " + elem.name());
        }
        this.version = ((Property)elem).getValues()[0].getDouble();
        if (this.version > 2.1) {
            throw new IOException("Wrong Protocol Version: " + elem.getString());
        }
        if (this.version >= 2.0) {
            elem = this.read();
            if (!"ContentType".equals(elem.name())) {
                throw new IOException("Wrong protocol. ContentType expected.");
            }
            this.contentType = ((Property)elem).getValues()[0].getString();
            elem = this.read();
            if (!"Encoding".equals(elem.name())) {
                throw new IOException("Wrong protocol. Encoding expected.");
            }
            this.encoding = ((Property)elem).getValues()[0].getString();
            if (this.encoding.equals("zip")) {
                this.in.enableDecompression();
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public double getVersion() {
        return this.version;
    }

    public Element read() throws IOException {
        int type = this.in.readType();
        if (type == -1) {
            return null;
        }
        if ((type & 0x10) > 0) {
            String name = this.in.readString();
            boolean isMulti = (type & 0x40) > 0;
            DurboValue[] values = isMulti ? new DurboValue[this.in.readInt()] : new DurboValue[1];
            type &= 0xF;
            block4: for (int i = 0; i < values.length; ++i) {
                switch (type) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        values[i] = new DurboValue(type, this.in.readBinary());
                        continue block4;
                    }
                    default: {
                        if (this.version >= 2.0) {
                            throw new IOException("unsupported type: " + type);
                        }
                        type = 2;
                    }
                    case 2: {
                        values[i] = this.in.readBinaryValue();
                    }
                }
            }
            return new Property(name, type, isMulti, values);
        }
        if (type == 32) {
            return new Node(this.in.readString());
        }
        if (type == 47) {
            return new Node();
        }
        if (type == 33) {
            String prefix = this.in.readString();
            String uri = this.in.readString();
            this.namespaceByPrefix.put(prefix, uri);
            this.namespaceByURI.put(uri, prefix);
            return this.read();
        }
        throw new IOException("Unknown element type: " + type);
    }

    public void skipNode() throws IOException {
        Element elem;
        while ((elem = this.read()) != null) {
            if (elem.isNodeStart()) {
                this.skipNode();
                continue;
            }
            if (!elem.isNodeEnd()) continue;
            return;
        }
        throw new EOFException("Unexpected end of input");
    }

    public String getURI(String prefix) {
        return this.namespaceByPrefix.get(prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        return this.namespaceByURI.get(uri);
    }

    public String[] getPrefixes() {
        return this.namespaceByPrefix.keySet().toArray(new String[this.namespaceByPrefix.size()]);
    }

    public String[] getURIs() {
        return this.namespaceByURI.keySet().toArray(new String[this.namespaceByURI.size()]);
    }

    public abstract class Element {
        private final String localName;
        private final String prefix;

        private Element(String name) {
            if (name == null) {
                this.localName = null;
                this.prefix = null;
            } else {
                int pos = name.indexOf(58);
                if (pos > 0) {
                    this.prefix = name.substring(0, pos);
                    this.localName = name.substring(pos + 1);
                } else {
                    this.prefix = null;
                    this.localName = name;
                }
            }
        }

        public String name() {
            return this.prefix == null ? this.localName : this.prefix + ":" + this.localName;
        }

        public String prefix() {
            return this.prefix;
        }

        public String uri() {
            return this.prefix == null ? null : DurboInput.this.getURI(this.prefix);
        }

        public String localName() {
            return this.localName;
        }

        public abstract boolean isProperty();

        public abstract boolean isNodeStart();

        public abstract boolean isNodeEnd();

        public abstract String getString();

        public String toString() {
            if (this.isProperty()) {
                return "Property(" + this.name() + ")";
            }
            if (this.isNodeStart()) {
                return "NodeStart(" + this.name() + ")";
            }
            return "NodeEnd()";
        }

        public abstract boolean wasBinary();

        public abstract boolean wasString();

        public abstract long size();
    }

    public class Node
    extends Element {
        private final boolean isStart;

        public Node(String name) {
            this(name, true);
        }

        public Node() {
            this(null, false);
        }

        public Node(String name, boolean isNodeStart) {
            super(name);
            this.isStart = isNodeStart;
        }

        public boolean isProperty() {
            return false;
        }

        public boolean isNodeStart() {
            return this.isStart;
        }

        public boolean isNodeEnd() {
            return !this.isStart;
        }

        public String getString() {
            return null;
        }

        public boolean wasBinary() {
            return false;
        }

        public boolean wasString() {
            return false;
        }

        public long size() {
            return 0L;
        }
    }

    public class Property
    extends Element {
        private final int type;
        private final boolean isMultiple;
        private final DurboValue[] values;

        public Property(String name, int type, boolean multiple, DurboValue[] values) {
            super(name);
            this.type = type;
            this.isMultiple = multiple;
            this.values = values;
        }

        public int getType() {
            return this.type;
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }

        public DurboValue[] getValues() {
            return this.values;
        }

        public Value[] getJcrValues(ValueFactory factory) throws IOException, RepositoryException {
            Value[] ret = new Value[this.values.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.values[i].toJcrValue(factory);
            }
            return ret;
        }

        public boolean isProperty() {
            return true;
        }

        public boolean isNodeStart() {
            return false;
        }

        public boolean isNodeEnd() {
            return false;
        }

        public String getString() {
            try {
                return this.values.length > 0 ? this.values[0].getString() : "";
            }
            catch (IOException e) {
                return null;
            }
        }

        public boolean wasBinary() {
            return this.type == 2;
        }

        public boolean wasString() {
            return this.type != 2;
        }

        public long size() {
            return 0L;
        }
    }
}

