/*
 * Decompiled with CFR 0.152.
 */
package com.day.io.file;

import com.day.io.file.FileUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempDirectory {
    private static final Logger log = LoggerFactory.getLogger(TempDirectory.class);
    private File tempDir = null;

    public TempDirectory(String name) throws IOException {
        this.createTempDir(name);
    }

    private void createTempDir(String name) throws IOException {
        log.debug("Starting createTempDir (name : " + name + " , " + ")");
        this.tempDir = new File(System.getProperty("java.io.tmpdir"), "tmp" + name);
        int i = 0;
        while (this.tempDir.exists()) {
            this.tempDir = new File(System.getProperty("java.io.tmpdir"), "tmp" + name + Integer.toString(++i));
        }
        if (!this.tempDir.mkdir()) {
            throw new IOException("Could not make temp directory " + this.tempDir.getPath());
        }
        this.empty();
    }

    public void empty() throws IOException {
        log.debug("Starting empty");
        File[] files = this.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].delete()) continue;
            throw new IOException("Cannot delete file " + files[i].getPath() + " in the temp directory");
        }
        if (!this.isEmpty()) {
            throw new IOException("Could not delete all files in the temp directory " + this.tempDir.getPath());
        }
    }

    public URL toURL() throws MalformedURLException {
        log.debug("Starting toURL");
        String path = this.tempDir.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && this.tempDir.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public File[] listFiles() {
        log.debug("Starting listFiles");
        String[] fileNames = this.tempDir.list();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(this.tempDir, fileNames[i]);
        }
        return files;
    }

    public File createTempFile(String fileName) throws IOException {
        log.debug("Starting createTempFile (fileName : " + fileName + " , " + ")");
        File tempFile = new File(this.tempDir, fileName);
        FileUtils.writeStringToFile(fileName, tempFile);
        return tempFile;
    }

    public File createEmptyTempFile(String fileName) throws IOException {
        log.debug("Starting createEmptyTempFile (fileName : " + fileName + " , " + ")");
        File tempFile = new File(this.tempDir, fileName);
        return tempFile;
    }

    public static byte[] getBinaryTestData(int howMuch) {
        log.debug("Starting getBinaryTestData (howMuch : " + howMuch + " , " + ")");
        byte[] testData = new byte[howMuch];
        for (int i = 0; i < testData.length; ++i) {
            testData[i] = (byte)(i % 255);
        }
        return testData;
    }

    public String toString() {
        log.debug("Starting toString");
        return this.tempDir.toString();
    }

    public File createTempBinaryFile(String fileName, int size) throws IOException {
        log.debug("Starting createTempBinaryFile (fileName : " + fileName + " , " + "size : " + size + " , " + ")");
        File tempFile = new File(this.tempDir, fileName);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(tempFile));
        out.write(TempDirectory.getBinaryTestData(size));
        out.flush();
        out.close();
        return tempFile;
    }

    public boolean isEmpty() {
        log.debug("Starting isEmpty");
        return this.listFiles().length == 0;
    }

    public void delete() throws IOException {
        log.debug("Starting delete");
        this.empty();
        this.tempDir.delete();
    }

    public File getDir() {
        log.debug("Starting getDir");
        return this.tempDir;
    }

    public boolean containsFileName(String fileName) {
        log.debug("Starting containsFileName (fileName : " + fileName + " , " + ")");
        String[] files = this.tempDir.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(fileName)) continue;
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        log.debug("Starting finalize");
    }
}

