/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.Conll03NameSampleStream;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

public class Conll03NameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, (String)"conll03", (ObjectStreamFactory)new Conll03NameSampleStreamFactory(Parameters.class));
    }

    protected <P> Conll03NameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<NameSample> create(String[] args) {
        Conll03NameSampleStream.LANGUAGE lang;
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        if ("en".equals(params.getLang())) {
            lang = Conll03NameSampleStream.LANGUAGE.EN;
            this.language = params.getLang();
        } else if ("de".equals(params.getLang())) {
            lang = Conll03NameSampleStream.LANGUAGE.DE;
            this.language = params.getLang();
        } else {
            throw new TerminateToolException(1, "Unsupported language: " + params.getLang());
        }
        int typesToGenerate = 0;
        if (params.getTypes().contains("per")) {
            typesToGenerate |= 1;
        }
        if (params.getTypes().contains("org")) {
            typesToGenerate |= 2;
        }
        if (params.getTypes().contains("loc")) {
            typesToGenerate |= 4;
        }
        if (params.getTypes().contains("misc")) {
            typesToGenerate |= 8;
        }
        try {
            return new Conll03NameSampleStream(lang, CmdLineUtil.createInputStreamFactory((File)params.getData()), typesToGenerate);
        }
        catch (IOException e) {
            throw CmdLineUtil.createObjectStreamError((IOException)e);
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="en|de")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,misc")
        public String getTypes();
    }
}

